/*
For general Sqliteman copyright and licensing information please refer
to the COPYING file provided with the program. Following this notice may exist
a copyright and/or license notice that predates the release of Sqliteman
for which a new license (GPL+exception) is in place.
*/

#ifndef DATAVIEWER_H
#define DATAVIEWER_H

#include <QMainWindow>
#include "ui_dataviewer.h"

class QAbstractItemModel;
class QTableView;
class QTextEdit;
class QToolBar;
class QAction;
class QSplitter;
class QSqlTableModel;


/*! \brief A Complex widget handling the database outputs and status messages.
\author Petr Vanek <petr@scribus.info>
*/
class DataViewer : public QMainWindow
{
		Q_OBJECT
	public:
		DataViewer(QWidget * parent = 0);
		~DataViewer(){};

		//! \brief Set data model. See Qt model/view documentation.
		void setTableModel(QAbstractItemModel * model);
		//! \brief Set text to the status widget.
		void setStatusText(const QString & text);
		//! \brief Show/hide status widget
		void showStatusText(bool show);
		//! \brief Show/hide action tools
		void showButtons(bool show);

		QSqlTableModel* tableData();
		QStringList tableHeader();

		QByteArray saveSplitter() { return ui.splitter->saveState(); };
		void restoreSplitter(QByteArray state) { ui.splitter->restoreState(state); };

	private:
		Ui::DataViewer ui;
		bool modified;

	private slots:
		void addRow();
		void removeRow();
		void truncateTable();
		void exportData();
		void commit();
		void rollback();
};

#endif
