/***************************************************************************
                          qthemeengine.cpp  -  description
                             -------------------
    begin                : ven oct 16 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef _WIN32
#pragma warning (disable : 4786)
#endif

#include <iostream>

#include <qwmatrix.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstring.h>

#include "qthemeengine.h"

#include "rand.h"

QThemeEngine::QThemeEngine(void) 
{
  QDir themesdir(DATA_DIR);
  if (!themesdir.cd("themes") ) {
    cerr << "The directory " << DATA_DIR << "/themes does not exist. "
      "Your installation is broken. Please reinstall your software.\n";
    exit(1);
  }
  const QFileInfoList *lst = themesdir.entryInfoList();
  QFileInfo *fi;                          // pointer for traversing
  for (QFileInfoListIterator it=*lst; (fi=it.current()) !=0; ++it) {
    QString filename = fi->fileName();
    if (filename != "." && filename != "..")
      themes.insert(filename);
  }

  visibleRandomGround=true;
  isometric=false;

  // Check if default theme (Deathwing is available)
  QString def;
  if (themes.find("Deathwing")!=themes.end())
    def = "Deathwing";
  else // Take anyone of them...
    def = *(themes.begin());
  setTheme(def);
}

QThemeEngine::~QThemeEngine(void) {}

QString QThemeEngine::getCurrentTheme(void) { return current; }
set<QString>* QThemeEngine::getAllThemes(void) { return &themes; }

void QThemeEngine::removeAll(void)
{
  grounds_42.clear();
  grounds_21.clear();
}

bool QThemeEngine::isIsometric(void) {return isometric; }

void QThemeEngine::setTheme(QString theme)
{
  if (themes.find(theme)==themes.end() || theme==current)
    return;
  current = theme;

  char dirname[255];
  sprintf(dirname,"%s%cthemes%c%s%c", DATA_DIR, DIR_DELIMITER, 
	  DIR_DELIMITER, current.latin1(), DIR_DELIMITER);
  QString dir = dirname;

  QWMatrix rot;
  rot.rotate(90);

  orientedExit = orientedEntry = false;
  isometric=false;
  additionalGrounds_42.clear();
  additionalGrounds_21.clear();
  cases.clear();
  grounds_42.clear();
  grounds_21.clear();
  vector<QString> addGrounds;
  QFile f(dir+"theme.cfg");
  if ( f.open(IO_ReadOnly) ) {    // file opened successfully
    QTextStream t( &f );        // use a text stream
    QString s;
    char attribut[255], value[255];
    while ( !t.eof() ) {        // until end of file...
      s = t.readLine();       // line of text excluding '\n'
      sscanf((const char *) s,"%s = %s", attribut, value);
      if (strcmp(attribut,"bgcolor")==0)
	bgcolor.setNamedColor(value);
      else if (strcmp(attribut,"fontcolor")==0) 
	fontcolor.setNamedColor(value);
      else if (strcmp(attribut,"orientedexit")==0)
	if (strcmp(value,"yes")==0) orientedExit = true;
	else orientedExit = false;
      else if (strcmp(attribut,"orientedentry")==0)
	if (strcmp(value,"yes")==0) orientedEntry = true;
	else orientedEntry = false;
      else if (strcmp(attribut,"additionalground")==0)
	addGrounds.push_back(value);
      else if (strcmp(attribut,"usedeadtiles")==0)
	if(strcmp(value,"yes")==0) useDeadTiles = true;
	else useDeadTiles = false;
      if (strcmp(attribut,"isometric")==0)
	if (strcmp(value,"yes")==0) isometric=true;
	else isometric=false;
    }
    f.close();
  }

  pixblip_42.load(dir+"blip_42.png");
  pixblip_21.load(dir+"blip_21.png");
  pixdoorclose_h_42.load(dir+"doorclose_h_42.png");
  pixdoorclose_h_21.load(dir+"doorclose_h_21.png");
  pixdoorclose_v_42 = pixdoorclose_h_42.xForm(rot);
  pixdoorclose_v_21 = pixdoorclose_h_21.xForm(rot);
  pixdooropen_h_42.load(dir+"dooropen_h_42.png");
  pixdooropen_h_21.load(dir+"dooropen_h_21.png");
  pixdooropen_v_42 = pixdooropen_h_42.xForm(rot);
  pixdooropen_v_21 = pixdooropen_h_21.xForm(rot);
  pixbulkclose_h_42.load(dir+"bulkclose_42.png");
  pixbulkclose_h_21.load(dir+"bulkclose_21.png");
  pixbulkclose_v_42 = pixbulkclose_h_42.xForm(rot);
  pixbulkclose_v_21 = pixbulkclose_h_21.xForm(rot);
  pixbulkopen_h_42.load(dir+"bulkopen_42.png");
  pixbulkopen_h_21.load(dir+"bulkopen_21.png");
  pixbulkopen_v_42 = pixbulkopen_h_42.xForm(rot);
  pixbulkopen_v_21 = pixbulkopen_h_21.xForm(rot);
  pixcat_42.load(dir+"cat_42.png");
  pixcat_21.load(dir+"cat_21.png");
  pixtoxinduct_42.load(dir+"toxinduct_42.png");
  pixtoxinduct_21.load(dir+"toxinduct_21.png");
  pixarchives_42.load(dir+"archives_42.png");
  pixarchives_21.load(dir+"archives_21.png");
  pixmachinery_42.load(dir+"machinery_42.png");
  pixmachinery_21.load(dir+"machinery_21.png");

  pixentryzone_42_n.load(dir+"entryzone_42.png");
  pixentryzone_21_n.load(dir+"entryzone_21.png");
  if (orientedEntry) {
    pixentryzone_42_e = pixentryzone_42_n.xForm(rot);
    pixentryzone_42_s = pixentryzone_42_e.xForm(rot);
    pixentryzone_42_w = pixentryzone_42_s.xForm(rot);
    pixentryzone_21_e = pixentryzone_21_n.xForm(rot);
    pixentryzone_21_s = pixentryzone_21_e.xForm(rot);
    pixentryzone_21_w = pixentryzone_21_s.xForm(rot);    
  }
  else {
    pixentryzone_42_e=pixentryzone_42_w=pixentryzone_42_s=pixentryzone_42_n;
    pixentryzone_21_e=pixentryzone_21_w=pixentryzone_21_s=pixentryzone_21_n;
  }

  pixexit_42_n.load(dir+"exit_42.png");
  pixexit_21_n.load(dir+"exit_21.png");
  if (orientedExit) {
    pixexit_42_e = pixexit_42_n.xForm(rot);
    pixexit_42_s = pixexit_42_e.xForm(rot);
    pixexit_42_w = pixexit_42_s.xForm(rot);
    pixexit_21_e = pixexit_21_n.xForm(rot);
    pixexit_21_s = pixexit_21_e.xForm(rot);
    pixexit_21_w = pixexit_21_s.xForm(rot);    
  }
  else {
    pixexit_42_e = pixexit_42_w = pixexit_42_s = pixexit_42_n;
    pixexit_21_e = pixexit_21_w = pixexit_21_s = pixexit_21_n;
  }

  pixflamer_42_n.load(dir + "flamer_42.png");
  pixflamer_42_e = pixflamer_42_n.xForm(rot);
  pixflamer_42_s = pixflamer_42_e.xForm(rot);
  pixflamer_42_w = pixflamer_42_s.xForm(rot);
  pixflamer_21_n.load(dir + "flamer_21.png");
  pixflamer_21_e = pixflamer_21_n.xForm(rot);
  pixflamer_21_s = pixflamer_21_e.xForm(rot);
  pixflamer_21_w = pixflamer_21_s.xForm(rot);

  pixgenestealer_42_n.load(dir + "genestealer_42.png");
  pixgenestealer_42_e = pixgenestealer_42_n.xForm(rot);
  pixgenestealer_42_s = pixgenestealer_42_e.xForm(rot);
  pixgenestealer_42_w = pixgenestealer_42_s.xForm(rot);
  pixgenestealer_21_n.load(dir + "genestealer_21.png");
  pixgenestealer_21_e = pixgenestealer_21_n.xForm(rot);
  pixgenestealer_21_s = pixgenestealer_21_e.xForm(rot);
  pixgenestealer_21_w = pixgenestealer_21_s.xForm(rot);

  pixmarine_42_n.load(dir+"marine_42.png");
  pixmarine_42_e = pixmarine_42_n.xForm(rot);
  pixmarine_42_s = pixmarine_42_e.xForm(rot);
  pixmarine_42_w = pixmarine_42_s.xForm(rot);
  pixmarine_21_n.load(dir+"marine_21.png");
  pixmarine_21_e = pixmarine_21_n.xForm(rot);
  pixmarine_21_s = pixmarine_21_e.xForm(rot);
  pixmarine_21_w = pixmarine_21_s.xForm(rot);

  pixsergeant_42_n.load(dir+"sergeant_42.png");
  pixsergeant_42_e = pixsergeant_42_n.xForm(rot);
  pixsergeant_42_s = pixsergeant_42_e.xForm(rot);
  pixsergeant_42_w = pixsergeant_42_s.xForm(rot);
  pixsergeant_21_n.load(dir+"sergeant_21.png");
  pixsergeant_21_e = pixsergeant_21_n.xForm(rot);
  pixsergeant_21_s = pixsergeant_21_e.xForm(rot);
  pixsergeant_21_w = pixsergeant_21_s.xForm(rot);

  pixflame_42.load(dir+"flame_42.png");
  pixflame_21.load(dir+"flame_21.png");

  pixcase_42.load(dir+"case_42.png");
  pixcase_21.load(dir+"case_21.png");

  for (vector<QString>::iterator it=addGrounds.begin(); 
       it!=addGrounds.end(); it++) {
    additionalGrounds_42.push_back(new QPixmap(dirname+*it+"_42.png"));
    additionalGrounds_21.push_back(new QPixmap(dirname+*it+"_21.png"));
  }

  if (useDeadTiles) {
    pixdeadmarine_42.load(dir+"deadmarine_42.png");
    pixdeadmarine_21.load(dir+"deadmarine_21.png");
    pixdeadgen_42.load(dir+"deadgen_42.png");
    pixdeadgen_21.load(dir+"deadgen_21.png");
  }
}

void QThemeEngine::setRandomGround(bool visible)
{
  visibleRandomGround = visible;
  cases.clear();
}

void QThemeEngine::setDeadTile(int caseId, bool isMarine)
{
  if (useDeadTiles) {
    if (isMarine) {
      cases[caseId] = -2;
      grounds_42[caseId] = &pixdeadmarine_42;
      grounds_21[caseId] = &pixdeadmarine_21;
    }
    else {
      cases[caseId] = -3;
      grounds_42[caseId] = &pixdeadgen_42;
      grounds_21[caseId] = &pixdeadgen_21;
    }
  }
}

QPixmap* QThemeEngine::getCase(bool big, int caseId) 
{
  map<int, int>::iterator it=cases.find(caseId);
  if (it == cases.end()) {
    int idx=-1;
    if (visibleRandomGround && additionalGrounds_42.size()!=0 && 
	Rand::simpleroll(10)>8)
	idx = Rand::simpleroll(additionalGrounds_42.size());
    cases[caseId] = idx;
    if (idx>=0) {
      grounds_42[caseId]=additionalGrounds_42[idx];
      grounds_21[caseId]=additionalGrounds_21[idx];
    }
    else {
      grounds_42[caseId]=&pixcase_42;
      grounds_21[caseId]=&pixcase_21;
    }
  }
  if (big)
    return grounds_42[caseId];
  else
    return grounds_21[caseId];
}

QPixmap* QThemeEngine::getBlip(bool big)
{
  if (big) return &(pixblip_42);
  else return &(pixblip_21);
}

QPixmap* QThemeEngine::getFlame(bool big)
{
  if (big) return &(pixflame_42);
  else return &(pixflame_21);
}

QPixmap* QThemeEngine::getEntryZone(bool big, Direction dir)
{
  if (big)
    switch(dir) {
    case NORTH: return &(pixentryzone_42_n);
    case SOUTH: return &(pixentryzone_42_s);
    case WEST: return &(pixentryzone_42_w);
    case EAST: return &(pixentryzone_42_e);
    default: return &(pixentryzone_42_n);
    }
  else
    switch(dir) {
    case NORTH: return &(pixentryzone_21_n);
    case SOUTH: return &(pixentryzone_21_s);
    case WEST: return &(pixentryzone_21_w);
    case EAST: return &(pixentryzone_21_e);
    default: return &(pixentryzone_21_n);
    }
}

QPixmap* QThemeEngine::getModuleCAT(bool big)
{
  if (big) return &(pixcat_42);
  else return &(pixcat_21);
}

QPixmap* QThemeEngine::getExit(bool big, Direction dir)
{
  if (big)
    switch(dir) {
    case NORTH: return &(pixexit_42_n);
    case SOUTH: return &(pixexit_42_s);
    case WEST: return &(pixexit_42_w);
    case EAST: return &(pixexit_42_e);
    default: return &(pixexit_42_n);
    }
  else
    switch(dir) {
    case NORTH: return &(pixexit_21_n);
    case SOUTH: return &(pixexit_21_s);
    case WEST: return &(pixexit_21_w);
    case EAST: return &(pixexit_21_e);
    default: return &(pixexit_21_n);
    }
}

QPixmap* QThemeEngine::getDoor(bool big, DoorState state, bool vertical)
{
  if (big) {
    if (vertical)
      switch (state) {
      case OPEN: return &(pixdooropen_v_42);
      case CLOSE: return &(pixdoorclose_v_42);
      }
    else
      switch (state) {
      case OPEN: return &(pixdooropen_h_42);
      case CLOSE: return &(pixdoorclose_h_42);
      }
  }
  else {
    if (vertical)
      switch (state) {
      case OPEN: return &(pixdooropen_v_21);
      case CLOSE: return &(pixdoorclose_v_21);
      }
    else 
      switch (state) {
      case OPEN: return &(pixdooropen_h_21);
      case CLOSE: return &(pixdoorclose_h_21);
      }
  }
  return 0; //We Should never get there. I put it to avoid an annoying warning.
}

QPixmap* QThemeEngine::getBulkhead(bool big, DoorState state, bool vertical)
{
  if (big) {
    if (vertical)
      switch (state) {
      case OPEN: return &(pixbulkopen_v_42);
      case CLOSE: return &(pixbulkclose_v_42);
      }
    else
      switch (state) {
      case OPEN: return &(pixbulkopen_h_42);
      case CLOSE: return &(pixbulkclose_h_42);
      }
  }
  else {
    if (vertical)
      switch (state) {
      case OPEN: return &(pixbulkopen_v_21);
      case CLOSE: return &(pixbulkclose_v_21);
      }
    else 
      switch (state) {
      case OPEN: return &(pixbulkopen_h_21);
      case CLOSE: return &(pixbulkclose_h_21);
      }
  }
  return 0; //We Should never get there. I put it to avoid an annoying warning.
}

QPixmap* QThemeEngine::getMarine(bool big, Direction dir)
{
  if (big)
    switch(dir) {
    case NORTH: return &(pixmarine_42_n);
    case SOUTH: return &(pixmarine_42_s);
    case WEST: return &(pixmarine_42_w);
    case EAST: return &(pixmarine_42_e);
    default: return &(pixmarine_42_n);
    }
  else
    switch(dir) {
    case NORTH: return &(pixmarine_21_n);
    case SOUTH: return &(pixmarine_21_s);
    case WEST: return &(pixmarine_21_w);
    case EAST: return &(pixmarine_21_e);
    default: return &(pixmarine_21_n);
    }
}

QPixmap* QThemeEngine::getFlamer(bool big, Direction dir)
{
  if (big)
    switch(dir) {
    case NORTH: return &(pixflamer_42_n);
    case SOUTH: return &(pixflamer_42_s);
    case WEST: return &(pixflamer_42_w);
    case EAST: return &(pixflamer_42_e);
    default: return &(pixflamer_42_n);
    }
  else
    switch(dir) {
    case NORTH: return &(pixflamer_21_n);
    case SOUTH: return &(pixflamer_21_s);
    case WEST: return &(pixflamer_21_w);
    case EAST: return &(pixflamer_21_e);
    default: return &(pixflamer_21_n);
    }
}

QPixmap* QThemeEngine::getSergeant(bool big, Direction dir)
{
  if (big)
    switch(dir) {
    case NORTH: return &(pixsergeant_42_n);
    case SOUTH: return &(pixsergeant_42_s);
    case WEST: return &(pixsergeant_42_w);
    case EAST: return &(pixsergeant_42_e);
    default: return &(pixsergeant_42_n);
    }
  else
    switch(dir) {
    case NORTH: return &(pixsergeant_21_n);
    case SOUTH: return &(pixsergeant_21_s);
    case WEST: return &(pixsergeant_21_w);
    case EAST: return &(pixsergeant_21_e);
    default: return &(pixsergeant_21_n);
    }
}

QPixmap* QThemeEngine::getGenestealer(bool big, Direction dir)
{
  if (big)
    switch(dir) {
    case NORTH: return &(pixgenestealer_42_n);
    case SOUTH: return &(pixgenestealer_42_s);
    case WEST: return &(pixgenestealer_42_w);
    case EAST: return &(pixgenestealer_42_e);
    default: return &(pixgenestealer_42_n);
    }
  else
    switch(dir) {
    case NORTH: return &(pixgenestealer_21_n);
    case SOUTH: return &(pixgenestealer_21_s);
    case WEST: return &(pixgenestealer_21_w);
    case EAST: return &(pixgenestealer_21_e);
    default: return &(pixgenestealer_21_n);
    }
}

QPixmap* QThemeEngine::getExtensible(bool big, QString &graphic)
{
  if (graphic == "toxinduct")
    if (big) return &(pixtoxinduct_42);
    else return &(pixtoxinduct_21);
  else if (graphic == "archives")
    if (big) return &(pixarchives_42);
    else return &(pixarchives_21);
  else if (graphic == "machinery")
    if (big) return &(pixmachinery_42);
    else return &(pixmachinery_21);
  return new QPixmap;
}

QColor* QThemeEngine::getBgColor(void) {
  return &bgcolor;
}

QColor* QThemeEngine::getFontColor(void) {
  return &fontcolor;
}

