/****************************************************************************
** $Id: qpixmapboard.cpp,v 1.23 2003/09/29 12:05:08 rom_vinot Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifdef _WIN32
#pragma warning (disable : 4786)
#endif



#include "qpixmapboard.h"

#include <cstdio>
#include <qscrollview.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qsizepolicy.h>
#include <qcolor.h>
#include <qpainter.h>

#include "gamemanager.h"
#include "creature.h"
#include "qcommandline.h"
#include "rand.h"

#ifdef _WIN32 // For windows : all elements are in the same directory.
#include "enrayer_42.xpm"
#include "enrayer_21.xpm"
#include "alert_42.xpm"
#include "alert_21.xpm"
#include "taken_42.xpm"
#include "taken_21.xpm"

#include "un_42.xpm"
#include "un_21.xpm"
#include "deux_42.xpm"
#include "deux_21.xpm"
#include "trois_42.xpm"
#include "trois_21.xpm"

#include "yellow_42.xpm"
#include "yellow_21.xpm"
#include "green_42.xpm"
#include "green_21.xpm"

#include "select_42.xpm"
#include "select_21.xpm"

#else

#include "data/pixmaps/enrayer_42.xpm"
#include "data/pixmaps/enrayer_21.xpm"
#include "data/pixmaps/alert_42.xpm"
#include "data/pixmaps/alert_21.xpm"
#include "data/pixmaps/taken_42.xpm"
#include "data/pixmaps/taken_21.xpm"

#include "data/pixmaps/un_42.xpm"
#include "data/pixmaps/un_21.xpm"
#include "data/pixmaps/deux_42.xpm"
#include "data/pixmaps/deux_21.xpm"
#include "data/pixmaps/trois_42.xpm"
#include "data/pixmaps/trois_21.xpm"

#include "data/pixmaps/yellow_42.xpm"
#include "data/pixmaps/yellow_21.xpm"
#include "data/pixmaps/green_42.xpm"
#include "data/pixmaps/green_21.xpm"

#include "data/pixmaps/select_42.xpm"
#include "data/pixmaps/select_21.xpm"
#endif

BoardScrollView::BoardScrollView(QWidget* parent, const char* name) :
  QScrollView(parent,name)
{
  pb = new QPixmapBoard(this);
  addChild(pb);
  setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding));
  connect( this, SIGNAL( contentsMoving(int,int) ), this, 
	   SLOT( alertContentsMoving(int,int) ) );

}

void BoardScrollView::boardUp(void) {
  int size = pb->getZoomSize();
  scrollBy(0,-size);
}
void BoardScrollView::boardDown(void) {
  int size = pb->getZoomSize();
  scrollBy(0,size);
}
void BoardScrollView::boardLeft(void) {
  int size = pb->getZoomSize();
  scrollBy(-size,0);
}
void BoardScrollView::boardRight(void) {
  int size = pb->getZoomSize();
  scrollBy(size,0);
}

void BoardScrollView::switchView(void)
{
  int size = pb->getZoomSize();
  int xcenter = (contentsX()+visibleWidth()/2)/size;
  int ycenter = (contentsY()+visibleHeight()/2)/size;
  pb->switchView();
  size = pb->getZoomSize();
  if (pb->getThemeEngine()->isIsometric())
    pb->resize((int) ((1+board->Xmax)*size+board->Ymax*0.857*size/2), 
	       (int) ((1+board->Ymax)*size*0.857));
  else pb->resize((1+board->Xmax)*size, (1+board->Ymax)*size);
  pb->update();
  center(xcenter*size, ycenter*size);
}

void BoardScrollView::alertContentsMoving(int x,int y)
{ pb->minimap->update(); }

void BoardScrollView::centerView(int caseId, bool force)
{
  int size = pb->getZoomSize();
  int xcenter = caseId%board->Xmax;
  int ycenter = caseId/board->Xmax;
  if (force || xcenter*size+size/2 < contentsX() 
      || xcenter*size+size/2 > contentsX()+visibleWidth()
      || ycenter*size+size/2 < contentsY()
      || ycenter*size+size/2 > contentsY()+visibleHeight())
    center(xcenter*size, ycenter*size);
}

QPixmapBoard::QPixmapBoard(QScrollView* par) :
  QFrame(par), GUIBoard(), parent(par), theme(), 
  bigpix(false), psize(21), isize(5), 
  pixjammed_42(enrayer_42), pixjammed_21(enrayer_21), 
  pixoverwatch_42(alert_42), pixoverwatch_21(alert_21),
  pixtaken_42(taken_42), pixtaken_21(taken_21),
  pixun_42(un_42), pixun_21(un_21), pixdeux_42(deux_42), 
  pixdeux_21(deux_21), pixtrois_42(trois_42), pixtrois_21(trois_21),
  pixselect_42(select_42), pixselect_21(select_21),
  pixyellow_42(yellow_42), pixyellow_21(yellow_21),
  pixgreen_42(green_42), pixgreen_21(green_21), yellowCases(0), greenCases(0)
{
  theme = new QThemeEngine();

  pixjammed = &pixjammed_21;
  pixoverwatch = &pixoverwatch_21;
  pixtaken = &pixtaken_21;
  pixun = &pixun_21;
  pixdeux = &pixdeux_21;
  pixtrois = &pixtrois_21;
  pixyellow = &pixyellow_21;
  pixgreen = &pixgreen_21;
  pixselect = &pixselect_21;

  setFrameStyle(QFrame::Plain);
  resize(800,600);
}

void QPixmapBoard::setCommandLine(QCommandLine *qc)
{ qcmd = qc; }
void QPixmapBoard::setMiniMap(QMiniMap *qmm)
{ minimap = qmm; }

void QPixmapBoard::Init()
{
  if (theme->isIsometric())
    qcmd->ResizeBoard((int) ((1+board->Xmax)*psize+board->Ymax*0.857*psize/2),
		      (int) ((1+board->Ymax)*psize*0.857));
  else qcmd->ResizeBoard((1+board->Xmax)*psize, (1+board->Ymax)*psize);
//  resize();
//  update();
}

QThemeEngine *QPixmapBoard::getThemeEngine(void) {return theme;}

int QPixmapBoard::getZoomSize()
{ return psize; }

void QPixmapBoard::switchView()
{
  if (bigpix) {
    psize=21;
    isize=5;
    bigpix=false;
    pixjammed = &pixjammed_21;
    pixoverwatch = &pixoverwatch_21;
    pixtaken = &pixtaken_21;
    pixun = &pixun_21;
    pixdeux = &pixdeux_21;
    pixtrois = &pixtrois_21;
    pixselect = &pixselect_21;
    pixyellow = &pixyellow_21;
    pixgreen = &pixgreen_21;
  }
  else {
    psize=42;
    isize=10;
    bigpix=true;
    pixjammed = &pixjammed_42;
    pixoverwatch = &pixoverwatch_42;
    pixtaken = &pixtaken_42;
    pixun = &pixun_42;
    pixdeux = &pixdeux_42;
    pixtrois = &pixtrois_42;
    pixselect = &pixselect_42;
    pixyellow = &pixyellow_42;
    pixgreen = &pixgreen_42;
  }
}

void QPixmapBoard::mouseReleaseEvent(QMouseEvent* e)
{
  clicked(e->x(), e->y(), e->button()==LeftButton);
}

void QPixmapBoard::clicked(int x, int y, bool isLeftButton)
{
  //  int caseId = x/psize-1 + (y/psize-1)*board->Xmax;
  qcmd->boardClick(x/psize-1, y/psize-1, isLeftButton);
}

void QPixmapBoard::printBoard(void)
{
  // Print the pixmap board !
  update();
  if (minimap)
    minimap->update();
}

void QPixmapBoard::drawContents(QPainter *p)
{
  // Prepare drawing : color and font.
  if (backgroundColor() != *(theme->getBgColor()))
    setBackgroundColor(*(theme->getBgColor()));
  if (p->pen().color() != *(theme->getFontColor()))
    p->setPen(*(theme->getFontColor()));
  
  if (bigpix)
    p->setFont(QFont("Times",20));
  else
    p->setFont(QFont("Times",10));

  if (theme->isIsometric()) {
    // draw the 3D here.
    drawIsometricContents(p);
    return;
  }
  
  // Draw the coordinate axis.
  char coords[5];
  for (int i=0; i<board->Xmax; i++) {
    sprintf(coords,"%d",i);
    p->drawText(i*psize+psize+isize,2*isize,coords);
  }
  for (int j=0; j<board->Ymax; j++) {
    sprintf(coords,"%d",j);
    p->drawText(isize,j*psize+psize+3*isize,coords);
  }

  int seed = Rand::seedvalue;
  
  // Draw each case.
  for (map<int, set<Object *> >::iterator it=board->cases.begin();
       it!=board->cases.end(); it++) {
    int x=it->first%board->Xmax;
    int y=it->first/board->Xmax;
    
    p->drawPixmap((x+1)*psize, (y+1)*psize, 
		  *(theme->getCase(bigpix,it->first)));
    
    map<int, Object *> all;
    for (set<Object *>::iterator iter=it->second.begin(); 
	 iter!=it->second.end(); iter++) {
      all[getPriority((*iter)->Type())] = *iter;
    }
    
    for (map<int, Object *>::iterator ite=all.begin(); ite!=all.end();ite++){
      Object *obj = ite->second;
      QPixmap *img = (QPixmap *) obj->getPixmap(bigpix);
      p->drawPixmap((x+1)*psize,(y+1)*psize,*img);
      
      // Draw the special icon : overwatch, jammed
      if (obj->isJammed())
	p->drawPixmap((x+2)*psize-isize, (y+1)*psize, *pixjammed);
      if (obj->onOverwatch())
	p->drawPixmap((x+2)*psize-isize, (y+2)*psize-isize, *pixoverwatch);
      if (obj->hasAnObject())
	p->drawPixmap((x+1)*psize, (y+1)*psize, *pixtaken);
      
      // Draw number of creatures in entryzone.
      if (obj->Type() == ENTRYZONE) {
	int count = 0;
	for(set<Object*>::iterator itnb = it->second.begin() ;
	    itnb != it->second.end() ; itnb++)
	  if((*itnb)->Type() == BLIP || (*itnb)->Type()==GENESTEALER)
	    count ++;
	  
	if (count==1)
	  p->drawPixmap((x+2)*psize-isize, (y+2)*psize-isize, *pixun);
	else if (count==2)
	  p->drawPixmap((x+2)*psize-isize, (y+2)*psize-isize, *pixdeux);
	else if (count>=3)
	  p->drawPixmap((x+2)*psize-isize, (y+2)*psize-isize, *pixtrois);
      }
    }
    
  }
  Rand::setSeed(seed);

  // Draw the green border of selected unit.
  Creature *sel = man->getSelected();
  if (sel) {
    int caseId = sel->getPosition();
    int x=caseId%board->Xmax;
    int y=caseId/board->Xmax;
    p->drawPixmap((x+1)*psize,(y+1)*psize,*pixselect);
  }

  set<int>::iterator ite;
  if (greenCases) {
    for(ite=greenCases->begin(); ite!=greenCases->end(); ite++) {
      int x=(*ite)%board->Xmax;
      int y=(*ite)/board->Xmax;
      p->drawPixmap((x+1)*psize,(y+1)*psize,*pixgreen);
    }
  }
  if (yellowCases)
    for(ite=yellowCases->begin(); ite!=yellowCases->end(); ite++) {
      int x=(*ite)%board->Xmax;
      int y=(*ite)/board->Xmax;
      p->drawPixmap((x+1)*psize,(y+1)*psize,*pixyellow);
    }
}

void QPixmapBoard::drawIsometricContents(QPainter *p)
{
  // Draw the coordinate axis.
  p->drawLine(psize,(int) (board->Ymax*0.857*psize+psize), 
	      (int) (board->Ymax*0.857/2*psize+psize), psize);
  p->drawLine((int) (board->Ymax*0.857/2*psize+psize), psize, 
	      (int) ((board->Ymax*0.857/2+board->Xmax)*psize+psize), psize);
  p->drawLine((int) ((board->Ymax*0.857/2+board->Xmax)*psize+psize), psize,
	      board->Xmax*psize+psize, (int) (board->Ymax*0.857*psize+psize));
  char coords[5];
  for (int i=0; i<board->Xmax; i++) {
    sprintf(coords,"%d",i);
    p->drawText((int) ((i+board->Ymax*0.857/2)*psize+psize+isize),
		3*isize,coords);
  }
  for (int j=0; j<board->Ymax; j++) {
    sprintf(coords,"%d",j);
    p->drawText((int) ((board->Ymax-j)*0.857/2*psize),
		(int) (j*0.857*psize+psize*0.857+3*isize),coords);
  }

  int seed = Rand::seedvalue;

  // Draw each case.
  for (map<int, set<Object *> >::iterator it=board->cases.begin();
       it!=board->cases.end(); it++) {
    int x=it->first%board->Xmax;
    int y=it->first/board->Xmax;
    
    p->drawPixmap((int) ((x+1+(board->Ymax-y)*0.857/2)*psize),
		  (int) ((y+1)*0.857*psize), 
		  *(theme->getCase(bigpix,it->first)));
        
    map<int, Object *> all;
    for (set<Object *>::iterator iter=it->second.begin(); 
	 iter!=it->second.end(); iter++) {
      all[getPriority((*iter)->Type())] = *iter;
    }
    
    for (map<int, Object *>::iterator ite=all.begin(); ite!=all.end();ite++){
      Object *obj = ite->second;
      QPixmap *img = (QPixmap *) obj->getPixmap(bigpix);
      p->drawPixmap((int) ((x+1+(board->Ymax-y)*0.857/2)*psize),
		    (int) ((y+1)*0.857*psize), *img);
      
      // Draw the special icon : overwatch, jammed
      /*
      if (obj->isJammed())
	p->drawPixmap((x+2)*psize-isize, (y+1)*psize, *pixjammed);
      if (obj->onOverwatch())
	p->drawPixmap((x+2)*psize-isize, (y+2)*psize-isize, *pixoverwatch);
      if (obj->hasAnObject())
	p->drawPixmap((x+1)*psize, (y+1)*psize, *pixtaken);
      
      // Draw number of creatures in entryzone.
      if (obj->Type() == ENTRYZONE) {
	int count = 0;
	for(set<Object*>::iterator itnb = it->second.begin() ;
	    itnb != it->second.end() ; itnb++)
	  if((*itnb)->Type() == BLIP || (*itnb)->Type()==GENESTEALER)
	    count ++;
	  
	if (count==1)
	  p->drawPixmap((x+2)*psize-isize, (y+2)*psize-isize, *pixun);
	else if (count==2)
	  p->drawPixmap((x+2)*psize-isize, (y+2)*psize-isize, *pixdeux);
	else if (count>=3)
	  p->drawPixmap((x+2)*psize-isize, (y+2)*psize-isize, *pixtrois);
      }
      */
    }
    
  }
  Rand::setSeed(seed);
  if (minimap)
    minimap->update();
  
}

void QPixmapBoard::setYellowCases(set<int> *cases) {yellowCases = cases;}
void QPixmapBoard::setYellowCasesFromEntryZone() 
{yellowCases = &board->entryzone;}
void QPixmapBoard::delYellowCases(void) {yellowCases = 0;}

void QPixmapBoard::setGreenCases(set<int> *cases) {greenCases = cases;}
void QPixmapBoard::delGreenCases(void) {greenCases = 0;}

void QPixmapBoard::setKilled(int caseId, bool isMarine) 
{theme->setDeadTile(caseId, isMarine);}

void QPixmapBoard::removeAll(void)
{
  greenCases=0;
  yellowCases=0;
  theme->removeAll();
}


QMiniMap::QMiniMap(QWidget *par, BoardScrollView* b)
  : QFrame(par), bsv(b)
{
  theme = bsv->pb->getThemeEngine();
}

void QMiniMap::mousePressEvent(QMouseEvent* e)
{
  int x = (e->x()-2)/4;
  int y = (e->y()-2)/4;
  bsv->centerView(y*board->Xmax+x,true);
  update();
}

void QMiniMap::mouseMoveEvent(QMouseEvent* e)
{
  int x = (e->x()-2)/4;
  int y = (e->y()-2)/4;
  bsv->centerView(y*board->Xmax+x,true);
  update();
}

void QMiniMap::drawContents(QPainter *p)
{
  p->fillRect(2,2,board->Xmax*4+1,board->Ymax*4+1,*(theme->getBgColor()));

  for (map<int, set<Object *> >::iterator it=board->cases.begin();
       it!=board->cases.end(); it++) {
    int x=it->first%board->Xmax;
    int y=it->first/board->Xmax;

    if (it->second.size()==0)
      p->fillRect(4*x+3,4*y+3,3,3,gray);
    else {
      map<int, Object *> all;
      for (set<Object *>::iterator iter=it->second.begin(); 
	   iter!=it->second.end(); iter++) {
	all[getPriority((*iter)->Type())] = *iter;
      }
      Object *show = all.rbegin()->second;
      switch(show->Type()) {
      case BOLTERMARINE: case SERGEANT: case FLAMER:
	p->fillRect(4*x+3,4*y+3,3,3,red); break;
      case BLIP:
	p->fillRect(4*x+3,4*y+3,3,3,darkCyan); break;
      case GENESTEALER:
	p->fillRect(4*x+3,4*y+3,3,3,blue); break;
      case CAT: case EXTENSIBLE:
	p->fillRect(4*x+3,4*y+3,3,3,darkMagenta); break;
      case EXIT:
	p->fillRect(4*x+3,4*y+3,3,3,white); break;
      case ENTRYZONE:
	p->fillRect(4*x+3,4*y+3,3,3,yellow); break;
      case BULKHEAD: 
	if (board->isEntryZoneCase(it->first))
	  p->fillRect(4*x+3,4*y+3,3,3,yellow);
	else
	  p->fillRect(4*x+3,4*y+3,3,3,darkGray);
	break;
      case DOOR:
	p->fillRect(4*x+3,4*y+3,3,3,darkGray); break;
      default:
	p->fillRect(4*x+3,4*y+3,3,3,gray);
      }
    }
  }

  set<int> *objs = man->getObjectiveCases();
  if (objs) {
    for (set<int>::iterator obj_it=objs->begin();obj_it!=objs->end();obj_it++){
      map<int, set<Object *> >::iterator ite = board->cases.find(*obj_it);
      if (ite->second.size()==0) {
	int x=(*obj_it)%board->Xmax;
	int y=(*obj_it)/board->Xmax;
	p->fillRect(4*x+3,4*y+3,3,3,green);
      }
    }
  }  


  int size = bsv->pb->getZoomSize();
  int xmin = bsv->contentsX()/size;
  int xmax = (bsv->contentsX()+bsv->visibleWidth())/size;
  int ymin = bsv->contentsY()/size;
  int ymax = (bsv->contentsY()+bsv->visibleHeight())/size;
  p->setPen(*(theme->getFontColor()));
  p->drawRect(xmin*4,ymin*4,(xmax-xmin)*4,(ymax-ymin)*4);
}
