#include <qlabel.h>
#include <qmultilineedit.h>

#include "qlevelinfoimpl.h"
/* 
 *  Constructs a QLevelInfoImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
QLevelInfoImpl::QLevelInfoImpl( QWidget* parent, QString &tit, QString &aut,
				QString &nar, QString &obj, QString &forc,
				QString &vic,
				const char* name, bool modal, WFlags fl )
    : QLevelInfo( parent, name, modal, fl )
{
  title->setText(tit);
  author->setText(aut);
  narration->insertLine(nar);
  objectives->insertLine(obj);
  forces->insertLine(forc);
  conditions->insertLine(vic);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
QLevelInfoImpl::~QLevelInfoImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

