#ifndef QINTERFACEIMPL_H
#define QINTERFACEIMPL_H

#include "qinterface.h"
#include "qmyevent.h"

class BoardScrollView;
class QPixmapBoard;
class QMiniMap;
class QCommandLine;

class QInterfaceImpl : public QInterface
{ 
    Q_OBJECT

public:
    QInterfaceImpl( QWidget* parent = 0,
		    const char* name = 0, WFlags fl = 0 );
    ~QInterfaceImpl();
    void drawContents(QPainter *p);
    
    void setCommandLine(QCommandLine *cmd);
    QPixmapBoard * getPixmapBoard();

    void switchView(void);
    void toggleMinimap(void);
    bool isMinimapVisible(void);
    void setObjectButtonsVisible(bool vis);
    void customEvent(QCustomEvent *e);
    
    void EnableDisableButtons(void);
    
public slots:
  void select(void); 
    
  void commandAttack();
  void commandClose();
  void commandEnter();
  void commandFire();
  void commandMoveEast();
  void commandMoveNorth();
  void commandMoveSouth();
  void commandMoveWest();
  void commandMoveNorthEast();
  void commandMoveNorthWest();
  void commandMoveSouthEast();
  void commandMoveSouthWest();
  void commandOpen();
  void commandOverwatch();
  void commandReload();
  void commandRevert();
  void commandShoot();
  void commandStop();
  void commandTurnNorth();
  void commandTurnEast();
  void commandTurnSouth();
  void commandTurnWest();
  void commandUnjam();
  void commandTakeOrDrop();
  void commandEndTurn();
public:
   BoardScrollView *bsv; 
   QMiniMap *minimap;
   QCommandLine *cmd;

};

#endif // QINTERFACEIMPL_H
