/***************************************************************************
                          qdatastoring.cpp  -  description
                             -------------------
    begin                : dim mar 17 16:56:00 CET 2003
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef _WIN32
#pragma warning (disable : 4786)
#endif

#include <qdom.h>
#include <qpopupmenu.h>
#include <qmessagebox.h>
#include <qapplication.h>

#include "qdatastoring.h"
#include "qpixmapboard.h"
#include "qthemeengine.h"
#include "qapplicationwindow.h"

QDataStoring::QDataStoring() 
{
  QString fn = homeDir + DIR_DELIMITER + "prefs.xml";
  QDomDocument doc( "Preferences" );
  QFile f( fn );
  if ( !f.open( IO_ReadOnly ) ) {
    // Store default value.
    checkDefaultPrefs();
    return;
  }
  if ( !doc.setContent( &f ) ) {
    // Store default value.
    f.close();
    checkDefaultPrefs();
    return;
  }
  f.close();  
  QDomElement current = doc.documentElement().firstChild().toElement();
  while (!current.isNull()) {
    QString att = current.attribute("attribute");
    QString val = current.attribute("value");
    prefs[att] = val;

    current = current.nextSibling().toElement();
  }
}

QDataStoring::~QDataStoring() {}

void QDataStoring::setBoard(QPixmapBoard *b) { qb = b; }
void QDataStoring::setApp(ApplicationWindow *aw) { main = aw; }

void QDataStoring::checkDefaultPrefs()
{
  prefs["window_size_width"] = "800";
  prefs["window_size_height"] = "600";
  prefs["window_maximized"] = "false";
  prefs["minimap"] = "visible";
  prefs["tiles_size"] = "small";
  prefs["with_random_ground"] = "true";
  prefs["theme"] = "Deathwing";
}

void QDataStoring::checkCurrentPrefs()
{
  QString msg = "You have saved your visual preferences for QSpaceHulk:\n";
  prefs["window_size_width"] = QString::number(main->width());
  msg += QString("window_size_width: ") + prefs["window_size_width"] + '\n';
  prefs["window_size_height"] = QString::number(main->height());
  msg += QString("window_size_height: ") + prefs["window_size_height"] + '\n';
  prefs["window_maximized"] = (main->isMaximized())?"true":"false";
  msg += QString("window_maximized: ") + prefs["window_maximized"] + '\n';
  prefs["minimap"] = (main->main->isMinimapVisible())?"visible":"hidden";
  msg += QString("minimap: ") + prefs["minimap"] + '\n';
  prefs["tiles_size"] = (qb->bigpix)?"big":"small";
  msg += QString("tiles_size: ") + prefs["tiles_size"] + '\n';
  prefs["with_random_ground"] = 
    (main->view->isItemChecked(main->buttonRandomGround))?"true":"false";
  msg += QString("with_random_ground: ") + prefs["with_random_ground"] + '\n';
  prefs["theme"] = qb->theme->current;
  msg += QString("theme: ") + prefs["theme"] + '\n';

  QMessageBox::about( qApp->activeWindow(), "QSpaceHulk - Message", msg);
}

void QDataStoring::SaveDeadTiles(QDomDocument &doc, QDomElement &liste)
{
  QDomElement deads = doc.createElement("dead_tiles");
  liste.appendChild(deads);
  QThemeEngine *th = qb->theme;
  for (map<int,int>::iterator it_theme=th->cases.begin();
       it_theme!=th->cases.end(); it_theme++) {
    if (it_theme->second==-2) {
      QDomElement dead = doc.createElement("dead_marine");
      dead.setAttribute("position",it_theme->first);
      deads.appendChild(dead);
    }
    else if (it_theme->second==-3) {
      QDomElement dead = doc.createElement("dead_genestealer");
      dead.setAttribute("position",it_theme->first);
      deads.appendChild(dead);
    }
  }
}
