#ifdef _WIN32
#pragma warning (disable : 4786)
#endif

#include "qapplicationwindow.h"
#include "qrulebook.h"

#include <qimage.h>
#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include <qaccel.h>

#include <qvariant.h>
#include <qframe.h>
#include <qlabel.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>

#ifdef _WIN32 // For windows : all elements are in the same directory.
#include "filesave.xpm"
#include "fileopen.xpm"

#else

#include "data/icons/filesave.xpm"
#include "data/icons/fileopen.xpm"
#endif

#include "variables.h"
#include "qpixmapboard.h"
#include "qcommandline.h"
#include "gamemanager.h"
#include "datastoring.h"
#include "sessionmanager.h"

ApplicationWindow::ApplicationWindow()
  : QMainWindow( 0, "Project Space Hulk", WDestructiveClose )
{
  main = new QInterfaceImpl(this);
  themeEngine = main->bsv->pb->getThemeEngine();
  
  QPixmap openIcon, saveIcon;
  openIcon = QPixmap( fileopen );
  saveIcon = QPixmap( filesave );
  
  QPopupMenu * file = new QPopupMenu( this );
  menuBar()->insertItem( "&File", file );

  int id;
  file->insertItem( "&New Game", this, SLOT(newGame()), CTRL+Key_N );
  file->insertItem("Connect to player", this,SLOT(connectPlayer()),CTRL+Key_R);
  id = file->insertItem( openIcon, "&Load", this, SLOT(load()), CTRL+Key_L );
  id = file->insertItem( saveIcon, "&Save", this, SLOT(save()), CTRL+Key_S );
  id = file->insertItem( "Quick Load", this, SLOT(quickload()), Key_F6 );
  id = file->insertItem( "Quick Save", this, SLOT(quicksave()), Key_F5 );
  file->insertSeparator();
  file->insertItem( "Save &Preferences", this, SLOT(savePrefs()), CTRL+Key_P );
  file->insertSeparator();
  file->insertItem( "&Quit", qApp, SLOT( closeAllWindows() ), CTRL+Key_Q );

  command = new QPopupMenu( this );
  menuBar()->insertItem( "&Command", command );
  command->insertItem( "Undo Previous Command", this, SLOT(undo()),CTRL+Key_U);
  command->insertItem( "Redo Previous Command", this, SLOT(redo()), Key_F1 );
  command->insertItem( "Add a message", this, SLOT(message()));
  buttonRecording = command->insertItem( "Record your actions",this,
					 SLOT(record()));
  
  view = new QPopupMenu ( this );
  menuBar()->insertItem(" &View", view);
  view->insertItem("&Mission description", this, SLOT(printLevelInfo()),
		    CTRL+Key_M);
  buttonObjective = view->insertItem( "Objective squares in green", this,
				      SLOT(viewObjective()),Key_F10);
  view->insertItem( "Z&oom in/out", this, SLOT(switchview()), CTRL+Key_O );
  view->insertItem("&Toggle Minimap",this, SLOT(toggleMinimap()), CTRL+Key_T );
  buttonRandomGround = view->insertItem( "Use random ground", this, SLOT(useRandomGround()) );
  view->setItemChecked(buttonRandomGround,true);
  view->insertItem( "Slower/Faster replay", this, SLOT(changeReplaySpeed()));
  
  view->insertSeparator();
  
  themes = new QPopupMenu (this);
  view->insertItem( "Themes", themes );
  set<QString> *ths = themeEngine->getAllThemes();
  for (set<QString>::iterator it=ths->begin(); it!=ths->end(); it++) {
    int id = themes->insertItem(*it, this, SLOT(changeTheme(int)));
    themes->setItemParameter(id, id);
    themesId[id] = *it;
    themesString[*it]=id;
  }
  themes->setItemChecked(themesString[themeEngine->getCurrentTheme()], true);
  
  menuBar()->insertSeparator();
  QPopupMenu * help = new QPopupMenu( this );
  menuBar()->insertItem( "&Help", help );

  help->insertItem( "&Rulebook", this, SLOT(rulebook()), CTRL+Key_H );
  help->insertSeparator();
  help->insertItem( "&About", this, SLOT(about()), Key_F12);
  help->insertItem( "About &Qt", this, SLOT(aboutQt()) );

  
  QAccel *acc = new QAccel( this );        // create accels for main window
  acc->connectItem( acc->insertItem(Key_Up), this, SLOT(boardUp()) );
  acc->connectItem( acc->insertItem(Key_Down), this, SLOT(boardDown()) );
  acc->connectItem( acc->insertItem(Key_Left), this, SLOT(boardLeft()) );
  acc->connectItem( acc->insertItem(Key_Right), this, SLOT(boardRight()) );


  setCentralWidget( main );

}


ApplicationWindow::~ApplicationWindow()
{}

QInterfaceImpl * ApplicationWindow::getMainWindow()
{ return main; }

void ApplicationWindow::newGame()
{ 
  if (main->cmd->getState()!=Q_NONE) {
    QMessageBox::about( this, "QSpaceHulk - Message",
			"You can't begin a new game now. You must choose your square before.");
    return;
  }
  main->cmd->getCommand("newgame"); 
}

void ApplicationWindow::connectPlayer()
{
  if (main->cmd->getState()!=Q_NONE) {
    QMessageBox::about(this,"QSpaceHulk - Message","You can't begin a new game"
		       "now. You must choose your square before.");
    return;
  }
  main->cmd->getCommand("connect");
}

void ApplicationWindow::load()
{
  QString fn = QFileDialog::getOpenFileName( homeDir+DIR_DELIMITER+"savegame",
					     "Savegame for spacehulk (*.sav *.pbem)",
					     this);
  if ( !fn.isEmpty() )
    load( fn );
}

void ApplicationWindow::quickload()
{ load(homeDir+DIR_DELIMITER+"savegame"+DIR_DELIMITER+"quicksave.sav"); }

void ApplicationWindow::quicksave()
{ save(homeDir+DIR_DELIMITER+"savegame"+DIR_DELIMITER+"quicksave.sav"); }

void ApplicationWindow::save()
{
  if (man->getGameType()==PBEM) {
    QMessageBox::about( main, "QSpaceHulk - Message",
			"You can't save during PBEM game.");
    return;
  }
  QString fn = QFileDialog::getSaveFileName(homeDir+DIR_DELIMITER+"savegame",
					    "Savegame for spacehulk (*.sav)",
					    this );
  if ( !fn.isEmpty() ) {
    if (fn.findRev(".sav")!=(int) fn.length()-4)
      fn += ".sav";
    save( fn );
  }
}

void ApplicationWindow::save(QString filename)
{
  if (main->cmd->getState()!=Q_NONE) {
    QMessageBox::about( this, "QSpaceHulk - Message",
			"You can't save the game now. You must choose your square before.");
    return;
  }
  QString com("save ");
  com += filename;
  main->cmd->getCommand(com.latin1());
}

void ApplicationWindow::load(QString filename)
{
  if (main->cmd->getState()!=Q_NONE) {
    QMessageBox::about( this, "QSpaceHulk - Message",
			"You can't load a game now. You must choose your square before.");
    return;
  }
  QString com("load ");
  com += filename;
  main->cmd->getCommand(com.latin1());
}

void ApplicationWindow::savePrefs(void)
{ store->savePrefs(); }

void ApplicationWindow::printLevelInfo(void)
{ main->cmd->getCommand("view missiondescription"); }

void ApplicationWindow::switchview(void)
{ main->switchView(); }

void ApplicationWindow::toggleMinimap(void)
{ main->toggleMinimap(); }

void ApplicationWindow::useRandomGround(void)
{
  if (view->isItemChecked(buttonRandomGround))
    view->setItemChecked(buttonRandomGround,false);
  else
    view->setItemChecked(buttonRandomGround,true);
  themeEngine->setRandomGround(view->isItemChecked(buttonRandomGround));
  main->cmd->DrawInterface();
}

void ApplicationWindow::viewObjective(void)
{
  if (man->isInGame()) {
    if (view->isItemChecked(buttonObjective)) {
      view->setItemChecked(buttonObjective,false);
      main->bsv->pb->delGreenCases();
    }
    else {
      view->setItemChecked(buttonObjective,true);
      main->bsv->pb->setGreenCases(man->getObjectiveCases());
      man->printMissionObjectives();
    }
    main->cmd->DrawInterface();
  }
}

void ApplicationWindow::changeReplaySpeed(void)
{ man->changeReplaySpeed(); }

void ApplicationWindow::changeTheme(int themeId)
{
  themes->setItemChecked(themesString[themeEngine->getCurrentTheme()], false);
  themeEngine->setTheme(themesId[themeId]);  
  themes->setItemChecked(themesString[themeEngine->getCurrentTheme()], true);
  main->cmd->DrawInterface();
}

void ApplicationWindow::closeEvent( QCloseEvent* ce )
{
  /* 
  if ( !e->edited() ) {
    ce->accept();
    return;
  }

  switch( QMessageBox::information( this, "Qt Application Example",
				    "The document has been changed since "
				    "the last save.",
				    "Save Now", "Cancel", "Leave Anyway",
				    0, 1 ) ) {
  case 0:
    save();
    ce->accept();
    break;
  case 1:
  default: // just for sanity
    ce->ignore();
    break;
  case 2:
    ce->accept();
    break;
    } 
  */
  if (session->Quit()) {
    main->cmd->endOfExecution();
    exit(0);
    ce->accept();
  }
}

void ApplicationWindow::rulebook()
{
  QRuleBook rule(this);
  rule.exec();
}

void ApplicationWindow::about()
{
  QMessageBox::about( this, "QSpaceHulk",
		      "<B>QSpacehulk 1.5-beta1</B><BR>"
		      "Conversion of the Space Hulk board game.<BR><BR>"
		      "Web site: <code>http://r.vinot.free.fr/spacehulk"
		      "</code><BR>"
		      "Main Author: Romain Vinot.");
}
    
void ApplicationWindow::aboutQt()
{ QMessageBox::aboutQt( this, "Qt is a multi-platform GUI library." ); }

void ApplicationWindow::redo()
{
  QString cmd = main->cmd->getPreviousCommand();
  main->cmd->getCommand(cmd);
}

void ApplicationWindow::undo()
{
  main->cmd->getCommand("undo");
}

void ApplicationWindow::message()
{
  if (man->isInRecordMode()) {
    QString msg;
    QMessageWindow qmsgwin(this,&msg);
    qmsgwin.exec();
    msg = "message " + msg;
    main->cmd->getCommand(msg.latin1());
  }
  else
    main->cmd->getCommand("message");    
}

void ApplicationWindow::record()
{
  if (!man->isInGame()) {
    main->cmd->Write("No command record is allowed before beginning of game.");
    return;
  }
  if (command->isItemChecked(buttonRecording)) {
    main->cmd->getCommand("record end");
    if (!man->isInRecordMode())
      command->setItemChecked(buttonRecording,false);
  }
  else {
    main->cmd->getCommand("record begin");
    if (man->isInRecordMode())
      command->setItemChecked(buttonRecording,true);
  }
}

void ApplicationWindow::boardUp() { main->bsv->boardUp(); }
void ApplicationWindow::boardDown() { main->bsv->boardDown(); }
void ApplicationWindow::boardLeft() { main->bsv->boardLeft(); }
void ApplicationWindow::boardRight() { main->bsv->boardRight(); }


QMessageWindow::QMessageWindow(QWidget* parent, QString *m )
  : QDialog( parent, "MessageWindow", true ), msg(m)
{
  setName( "MessageWindow" );
  resize( 300, 100 ); 
  setCaption( "Message Window" );
  msgLayout = new QVBoxLayout( this, 11, 6, "msgLayout"); 
  
  title = new QLabel( this, "title" );
  title->setText( tr( "Write your message" ) );
  msgLayout->addWidget( title );

  qmsg = new QMultiLineEdit(this, "qmsg");
  msgLayout->addWidget( qmsg );
  
  Layout3 = new QHBoxLayout( 0, 0, 6, "Layout3"); 
  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout3->addItem( spacer );
  
  ok = new QPushButton( this, "ok" );
  ok->setText( "Close" );
  Layout3->addWidget( ok );
  QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout3->addItem( spacer_2 );
  msgLayout->addLayout( Layout3 );
  
  // signals and slots connections
  connect( ok, SIGNAL( clicked() ), this, SLOT( finish() ) );
}

void QMessageWindow::finish(void)
{
  *msg = qmsg->text();
  accept();
}

QMessageWindow::~QMessageWindow()
{
  // no need to delete child widgets, Qt does it all for us
}
