// -*- c++ -*-
/***************************************************************************
                          gamemanager.h  -  description
                             -------------------
    begin                : lun mar 04 15:20:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _GAMEMANAGER_H_
#define _GAMEMANAGER_H_

#include <map>
#include <set>
#include <vector>
#include <list>
#include <qmutex.h>

#define XOR(a,b) (bool)((int)(a) ^ (int)(b))

#include "variables.h"
#include "creature.h"

class QString;

class Level;
class Board;
class Rand;
class NetworkInterface;
class PathFinderNode;

class GUICommandLine;
class GUICreature;
class GUIBoard;

struct UndoState {
  int caseId;
  Direction dir;
  int actionPts;
  int cmdPts;
};

class GameManager {
  friend class Level;
  friend class LevelAction;
  friend class DataStoring;
  friend class SessionManager;
  friend class Rand;
public:
  GameManager(GUICreature *guic, GUIBoard *guib,
	      GUICommandLine *guicmd, Turn t=MARINE_TURN);
  ~GameManager(void);
  
  Turn getTurn(void);
  int getTurnNumber();
  QString getEmail(void);
  QString getLevelMessage(void);
  void getLevelInfo(QString &title, QString &auth, QString &nar, QString &obj, 
		    QString &forc, QString &cond);
  gameType getGameType(void);
  bool isHeuristicTurn(void);
  void setReplayRecordMode(bool replay);

  bool InitChooseGameType(void);
  bool InitChooseLevel(void);
  void InitPlayerPlacement (void);
  void InitPBEM(void);
  void Init(void);
  void InitBlipCards(void);
  bool isInGame(void);
  bool isInReplayMode(void);
  bool isInRecordMode(void);
  bool Undo(void);
  void disableUndo(void);
  void initUndo();
  int getCurrentMaxId(void);
  void NewCreature(Creature *crea, bool force=false);
  void deleteCreature(Object *crea);
  void deleteCreature(int caseId);
  void informKilled(ObjectType ty, int caseId);
 
  QString chooseAction(int x, int y);

  void beginTurn();
  pair<bool,Turn> endTurn();

  bool isVisibleFromMarine(int caseId);
  bool isWaitingEntry(int caseId);
  void CheckNonVisibleBlip(void);
  int CaseIsVisibleFromMarine(int caseId);
  void CheckOverwatchTarget(void);
  void CheckExit(void);

  void RevertBlip(Blip *crea, bool isVoluntary, int viewedPos=0);
  bool areGenestealerInEntryZone(void);
  void deleteGenestealerInEntryZone(void);
  
  Creature * getCreature(int cId);
  bool selectCreature(Creature *c);
  bool selectCreature(int caseId);
  Creature * getSelected(void);

  int Attack(Creature *crea);
  int Shoot(Creature *crea, int caseId);
  bool ThrowFireDice(void);
  void turnDefenser(Object *, Creature *att, Direction dir);

  list<int> FindPath(int start,int end,bool isCreatureOriented, Direction dir);
  //list<QString>* getActionsFromPath(PathFinderNode *end);
  
  Flame * addFlame(int caseId);
  bool deleteFlame(void);
  void checkGenestealerInFlame(void);

  int nearestMarine(int caseid);

  const map<int, Creature *> *getList(void);
  const list<int>* getExitedUnits(ObjectType type);
  void printInterface(void);
  void printMissionObjectives(void);
  void printAllCreaturesInfo(void);
  void printSelectedCreature(void);
  void printOnViewCreature(void);
  bool onViewIsSelectable(void);
  void setOnView(int caseId);
  void selectOnView(void);

  set<int> * getObjectiveCases(void);

  void recordCommand(QString command);
  void removeLatestRecord(void);
  QString getRecord(void);

  void Replay(void);
  void changeReplaySpeed(void);
  void removeAll(void);
  void SavePBEM();

  void Connect(void);
  void setConnection(int socket);
private:
  GUICreature *guic;
  GUIBoard *guib;
  GUICommandLine *guicmd;

  bool inGame;
  gameType type;
  Level *level;
  Turn turn;
  int nbTurns;

  bool canUndo;
  UndoState previous;

  bool heuris;
  int cheatProtection; // Only useful for PBEM game.
  bool hasCheated; // To inform opponent player.

  map<ObjectType, list<int> > exitedUnits;

  Creature *selected;
  set<Object *> *onView;
  Object *selectableOnView;
  int previousView;
  bool listChanged;

  map<int, Creature *> liste;
  map<int, Flame *> flames;
  vector<int> blipCards;
  vector<int>::iterator currBlipCard;
  set<int> currentWaitingEntries;
  int maxCreaId;
  int cmdPts;

public:
  list<QString> replays;
  QMutex replaysMutex;
  NetworkInterface *net;
private:
  int replaySpeed;
  bool replayMode;
  bool recordMode;
  int pbemidMarine, pbemidGenestealer;
  QString email;
};

class PathFinderNode
{
public:
  PathFinderNode(int caseId,int fullCost,int futureCost,list<int>*path);
  ~PathFinderNode(void);

  int caseId;
  int fullCost;
  int futureCost;
  list<int> path;
};

extern GameManager *man;

#endif
