// -*- c++ -*-
/***************************************************************************
                       datastoring.h  -  description
                             -------------------
    begin                : dim feb 22 16:56:00 CET 2003
    copyright            : (C) 2003 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DATASTORING_H_
#define _DATASTORING_H_

/*
  DataStoring is the class to save and load game.
  It can save and load in a XML file.
*/

#include <vector>

#include "variables.h"
#include "creature.h"

class QDomElement;
class QDomDocument;

class DataStoring {
public:
  DataStoring();
  virtual ~DataStoring();

  virtual void checkDefaultPrefs()=0;
  virtual void checkCurrentPrefs()=0;
  QString getPref(QString att);
  void addPref(QString att, QString val);
  void savePrefs();
  void savePrefsOnFile();

  pair<int,Turn>* getPbemFromList(int pbemid);
  void addPbem(int gid, int turn, Turn tu);
  void updatePbem(int id, int turn, Turn tu);
  int getNewPbemId(void);
  void savePbemGameList();

  void Save(QDomDocument &doc);
  void SaveGameState(void);
  QDomDocument* SaveWithRecord(void);
  
  void SaveGameManager(QDomDocument &doc, QDomElement &xmlman);
  void SaveBoard(QDomDocument &doc, QDomElement &liste);
  virtual void SaveDeadTiles(QDomDocument &doc, QDomElement &liste)=0;
  void SaveObject(QDomDocument &doc, QDomElement &liste, Door *obj);
  void SaveObject(QDomDocument &doc, QDomElement &liste, Bulkhead *obj);
  void SaveObject(QDomDocument &doc, QDomElement &liste,ExtensibleObject *obj);
  void SaveObject(QDomDocument &doc, QDomElement &liste, EntryZone *obj);
  void SaveObject(QDomDocument &doc, QDomElement &liste, Exit *obj);
  void SaveObject(QDomDocument &doc, QDomElement &liste, Flame *obj);
  void SaveObject(QDomDocument &doc, QDomElement &liste, ModuleCAT *obj);
  void SaveObject(QDomDocument &doc, QDomElement &liste, Blip *obj);
  void SaveObject(QDomDocument &doc, QDomElement &liste, Genestealer *obj);
  void SaveObject(QDomDocument &doc, QDomElement &liste, BolterMarine *obj);
  void SaveObject(QDomDocument &doc, QDomElement &liste, Sergeant *obj);
  void SaveObject(QDomDocument &doc, QDomElement &liste, FlamerMarine *obj);

  void SaveLevel(QDomDocument &doc, QDomElement &xmllev);
  void CheckXMLLevel(QDomDocument &doc, QDomElement &xmllev);

  bool LoadFromFilename(const char *filename);
  bool LoadFromContent(const QString &content);
  void LoadGameManager(QDomElement &xmlman, float version);
  void LoadLevel(QDomElement &xmllev, float version);
  void LoadBoard(QDomElement &liste, float version);
  void LoadDeadTiles(QDomElement &liste);
  void LoadDoor(QDomElement &obj);
  void LoadBulkhead(QDomElement &obj);
  void LoadExtensible(QDomElement &obj);
  void LoadEntryzone(QDomElement &obj);
  void LoadExit(QDomElement &obj);
  void LoadFlame(QDomElement &obj);
  void LoadCat(QDomElement &obj);
  void LoadBlip(QDomElement &obj);
  void LoadGenestealer(QDomElement &obj);
  void LoadBolter(QDomElement &obj);
  void LoadSergeant(QDomElement &obj);
  void LoadFlamer(QDomElement &obj);
protected:
  GUICreature *guic;
  GUICommandLine *guicmd;

  map<QString,QString> prefs;
  map<int,pair<int,Turn> > pbems;

  vector<Creature *> hasTaken;
  vector<pair<FlamerMarine *,vector<int> > > flames;

  QDomDocument *savedoc;
};

extern DataStoring *store;

#endif
