/* Snownews - A lightweight console RSS newsreader
 * 
 * Copyright 2003 Oliver Feiler <kiza@kcore.de>
 * http://kiza.kcore.de/software/snownews/
 *
 * ui-support.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <ncurses.h>

#include "config.h"
#include "version.h"

/* Init the ncurses library. */
void InitCurses (void) {
	initscr();
	
	keypad (stdscr, TRUE);	/* Activate keypad so we can read function keys with getch. */
	
	cbreak();				/* No buffering. */
	noecho();				/* Do not echo typed chars onto the screen. */
	clear();
	curs_set(0);			/* Hide cursor. */
	refresh();
}

/* Print text in statusbar. */
void UIStatus (char * text, int delay) {
	int i;
			
	attron (WA_REVERSE);
	/* Clear statusbar. */
	for (i = 0; i < COLS-1; i++) {
		mvaddch (LINES-1, i, ' ');
	}
	
	mvaddnstr (LINES-1, 1, text, COLS-2);
	
	/* attroff is called here. If the calling function had it switched on,
	   switch it on again there! */
	attroff (WA_REVERSE);
	refresh();
	
	if (delay)
		sleep (delay);
}

/* Swap all pointers inside a feed struct.
   Should only swap next and prev pointers of two structs! */
void SwapPointers (struct feed * one, struct feed * two) {
	struct feed *tmp;
	
	tmp = malloc (sizeof(struct feed));
	
	tmp->feedurl = one->feedurl;
	tmp->feed = one->feed;
	tmp->title = one->title;
	tmp->link = one->link;
	tmp->description = one->description;
	tmp->items = one->items;
	tmp->override = one->override;
	tmp->original = one->original;
	tmp->feedcategories = one->feedcategories;
	
	one->feedurl = two->feedurl;
	one->feed = two->feed;
	one->title = two->title;
	one->link = two->link;
	one->description = two->description;
	one->items = two->items;
	one->override = two->override;
	one->original = two->original;
	one->feedcategories = two->feedcategories;
	
	two->feedurl = tmp->feedurl;
	two->feed = tmp->feed;
	two->title = tmp->title;
	two->link = tmp->link;
	two->description = tmp->description;
	two->items = tmp->items;
	two->override = tmp->override;
	two->original = tmp->original;
	two->feedcategories = tmp->feedcategories;
	
	free (tmp);
	
	/*
	tmp = one;
	one = two;
	two = tmp;
	*/
}

/* Sort the struct list alphabetically.
   Sorting criteria is struct feed->title */
void SnowSort (void) {
	int elements = 0;
	int i;
	struct feed * cur_ptr;

	for (cur_ptr = first_ptr; cur_ptr != NULL; cur_ptr = cur_ptr->next_ptr)
		elements++;
	
	for (i = 0; i <= elements; i++) {
		for (cur_ptr = first_ptr; cur_ptr->next_ptr != NULL; cur_ptr = cur_ptr->next_ptr) {
			if (strcasecmp (cur_ptr->title, cur_ptr->next_ptr->title) > 0)
				SwapPointers (cur_ptr, cur_ptr->next_ptr);	
		}	
	}
}

/* Draw a box with WA_REVERSE at coordinates x1y1/x2y2 */
void UISupportDrawBox (int x1, int y1, int x2, int y2) {
	int i, j;
	
	attron (WA_REVERSE);
	for (i = y1; i <= y2; i++) {
		for (j = x1; j <= x2; j++) {
				mvaddch (i, j, ' ');
		}	
	}
	attroff (WA_REVERSE);
}

/* Draw main program header. */
void UISupportDrawHeader (char * filterstring) {
	int i;
	
	attron (WA_REVERSE);
	for (i = 0; i < COLS; i++) {
		mvaddch (0, i, ' ');
	}
	mvprintw (0, 1, "* Snownews %s", VERSION);
	if (filterstring != NULL) {
		mvaddstr (0, COLS-strlen(filterstring)-1, filterstring);
	}
	attroff (WA_REVERSE);
}
