/* Snownews - A lightweight console RSS newsreader
 * 
 * Copyright 2003 Oliver Feiler <kiza@kcore.de>
 * http://kiza.kcore.de/software/snownews/
 *
 * ui-support.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"

/* Swap all pointers inside a feed struct. */
void SwapPointers (struct feed * one, struct feed * two) {
	struct feed *tmp;
	
	tmp = malloc (sizeof(struct feed));
	
	tmp->feedurl = one->feedurl;
	tmp->feed = one->feed;
	tmp->title = one->title;
	tmp->link = one->link;
	tmp->description = one->description;
	tmp->items = one->items;
	tmp->override = one->override;
	tmp->original = one->original;
	
	one->feedurl = two->feedurl;
	one->feed = two->feed;
	one->title = two->title;
	one->link = two->link;
	one->description = two->description;
	one->items = two->items;
	one->override = two->override;
	one->original = two->original;
	
	two->feedurl = tmp->feedurl;
	two->feed = tmp->feed;
	two->title = tmp->title;
	two->link = tmp->link;
	two->description = tmp->description;
	two->items = tmp->items;
	two->override = tmp->override;
	two->original = tmp->original;
	
	free (tmp);
	
	/*
	tmp = one;
	one = two;
	two = tmp;
	*/
}

/* Sort the struct list alphabetically.
   Sorting criteria is struct feed->title */
void SnowSort (void) {
	int elements = 0;
	int i;
	struct feed * cur_ptr;

	for (cur_ptr = first_ptr; cur_ptr != NULL; cur_ptr = cur_ptr->next_ptr)
		elements++;
	
	for (i = 0; i <= elements; i++) {
		for (cur_ptr = first_ptr; cur_ptr->next_ptr != NULL; cur_ptr = cur_ptr->next_ptr) {
			if (strcasecmp (cur_ptr->title, cur_ptr->next_ptr->title) > 0)
				SwapPointers (cur_ptr, cur_ptr->next_ptr);	
		}	
	}
}



