/* Snownews - A lightweight console RSS newsreader
 * 
 * Copyright 2003 Oliver Feiler <kiza@kcore.de>
 * http://kiza.kcore.de/software/snownews/
 *
 * config.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef CONFIG_H
#define CONFIG_H

#include "version.h"

/* Set your charset here. ISO-8859-1 should be the most commonly used. */
#define TARGET_CHARSET "ISO-8859-1"

/* Uncomment if you want the confirmation dialog before you quit Snownews. */
/* #define QUIT_CONFIRM */

struct feed {
	char * feedurl;							/* Non hashified URL */
	char * feed;							/* Raw XML */
	char * title;
	char * link;
	char * description;
	char * lastmodified;					/* Content of header as sent by the server. */
	struct newsitem * items;
	struct feed *next_ptr, *prev_ptr;
	int problem;							/* Set if there was a problem downloading the feed. */
	char *override;							/* Custom feed title. */
	char *original;							/* Original feed title. */
};

struct newsitem {
	struct newsitem * next_ptr, *prev_ptr;	/* Pointer to next/prev item in double linked list */
	int readstatus;							/* 0: read, 1: unread */
	char *title;
	char *link;
	char *description;
};

/* Global program keybindings. Loaded from main:Config() */
struct keybindings {
	char next;
	char prev;
	char quit;
	char addfeed;
	char deletefeed;
	char markread;
	char dfltbrowser;
	char moveup;
	char movedown;
	char feedinfo;
	char reload;
	char reloadall;
	char urljump;
	char changefeedname;
	char sortfeeds;
	char pdown;
	char pup;
};

extern struct feed *first_ptr;
extern int lasthttpstatus;					/* Global defs. Should be coded more cleanly. */

#ifdef LOCALEPATH
#	include <libintl.h>
#	include <locale.h>
#endif

#ifdef LOCALEPATH
#	define _(String) gettext (String)
#else
#	define _(String) (String)
#endif

#endif
