<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: Displays statistics on communication links (IP addresses) 
 *
 * Input GET/POST variables
 *   - caller
 *   - submit:
 */
?>
<?php  
  include ("acid_constants.inc");
  include ("acid_conf.php");
  include ("acid_include.inc");
  include_once ("acid_db_common.php");
  include_once ("acid_qry_common.php");
  include_once ("acid_stat_common.php");

  $et = new EventTiming($debug_time_mode);
  $cs = new CriteriaState("acid_stat_iplink.php");
  $cs->ReadState();

  $qs = new QueryState();
  $qs->AddCannedQuery("most_frequent", $freq_num_alerts, "Most Frequent Alerts", "occur_d"); 
  $qs->AddCannedQuery("last_alerts", $last_num_ualerts, "Last Alerts", "last_d");

  $submit = ImportHTTPVar("submit");
  $qs->MoveView($submit);             /* increment the view if necessary */

  $page_title = "IP Links";
  if ( $qs->isCannedQuery() )
     PrintACIDSubHeader($page_title.": ".$qs->GetCurrentCannedQueryDesc(),
                        $page_title.": ".$qs->GetCurrentCannedQueryDesc(), $cs->GetBackLink());
  else
     PrintACIDSubHeader($page_title, $page_title, $cs->GetBackLink());
  
  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidDBConnect($db_connect_method,
                     $alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  if ( $event_cache_auto_update == 1 )  UpdateAlertCache($db);

  $criteria_clauses = ProcessCriteria();  
  PrintCriteria("");

  $from = " FROM acid_event ".$criteria_clauses[0];
  $where = " WHERE ".$criteria_clauses[1];

  $qs->AddValidAction("ag_by_id");
  $qs->AddValidAction("ag_by_name");
  $qs->AddValidAction("del_alert");
  $qs->AddValidAction("email_alert");
  $qs->AddValidAction("email_alert2");
  $qs->AddValidAction("csv_alert");
  $qs->AddValidAction("archive_alert");
  $qs->AddValidAction("archive_alert2");

  $qs->AddValidActionOp("Selected");
  $qs->AddValidActionOp("ALL on Screen");

  $qs->SetActionSQL($from.$where);
  $et->Mark("Initialization");

  $qs->RunAction($submit, PAGE_STAT_IPLINK, $db);
  $et->Mark("Alert Action");

  /* create SQL to get Unique Alerts */
  //$cnt_sql = UniqueLinkCnt($db, $from, $where);

  /* Run the query to determine the number of rows (No LIMIT)*/
  //$qs->GetNumResultRows($cnt_sql, $db);
  $qs->current_view = 0;
  $qs->num_result_rows = UniqueLinkCnt($db, $criteria_clause[0], $criteria_clause[1]);
  $et->Mark("Counting Result size");

  /* Setup the Query Results Table */
  $qro = new QueryResultsOutput("acid_stat_iplink.php?caller=".$caller);

  $qro->AddTitle("Source FQDN"); 
  $qro->AddTitle("Source IP",
                 "sip_a", "", " ORDER BY ip_src ASC",
                 "sip_d", "", " ORDER BY ip_src DESC");
  $qro->AddTitle("Direction");
  $qro->AddTitle("Destination IP",
                 "dip_a", "", " ORDER BY ip_dst ASC",
                 "dip_d", "", " ORDER BY ip_dst DESC");
  $qro->AddTitle("Destination FQDN");
  $qro->AddTitle("Protocol");
  $qro->AddTitle("Unique Dst Ports");
  $qro->AddTitle("Unique Events");
  $qro->AddTitle("Total Events");

  $sort_sql = $qro->GetSortSQL($qs->GetCurrentSort(), $qs->GetCurrentCannedQuerySort());

  $sql = "SELECT DISTINCT acid_event.ip_src, acid_event.ip_dst, acid_event.ip_proto ".
         $sort_sql[0].$from.$where.$sort_sql[1];

  /* Run the Query again for the actual data (with the LIMIT) */
  $result = $qs->ExecuteOutputQuery($sql, $db);
  $et->Mark("Retrieve Query Data");

  if ( $debug_mode == 1 )
  {
     $qs->PrintCannedQueryList();
     $qs->DumpState();
     echo "$sql<BR>";
  }

  /* Print the current view number and # of rows */
  $qs->PrintResultCnt();

  echo '<FORM METHOD="post" NAME="PacketForm" ACTION="acid_stat_iplink.php">';
  
  $qro->PrintHeader();

  $i = 0;
  while ( ($myrow = $result->acidFetchRow()) && ($i < $qs->GetDisplayRowCnt()) )
  {
     $sip = $myrow[0];
     $dip = $myrow[1];
     $proto = $myrow[2];  

     $sip_fqdn = acidGetHostbyAddr(acidLong2IP($sip), $db, $dns_cache_lifetime);
     $dip_fqdn = acidGetHostbyAddr(acidLong2IP($dip), $db, $dns_cache_lifetime);

     /* Get stats on the link */
     if ( $sip && $dip )
     {
        $temp = "SELECT COUNT(DISTINCT layer4_dport), ".
                 "COUNT(acid_event.cid), COUNT(DISTINCT acid_event.signature)  ".
                 $from.$where." AND acid_event.ip_src=".$sip." AND acid_event.ip_dst=".$dip." AND acid_event.ip_proto=".$proto;

        $result2 = $db->acidExecute($temp);
        $row = $result2->acidFetchRow();
        $num_occurances = $row[1];
        $num_unique_dport = $row[0];
        $num_unique = $row[2];
        $result2->acidFreeRows(); 

        /* Print out */ 
        qroPrintEntryHeader($i);

        $tmp_ip_criteria = 
          '&ip_addr%5B0%5D%5B0%5D=+&ip_addr%5B0%5D%5B1%5D=ip_src&ip_addr%5B0%5D%5B2%5D=%3D'.
          '&ip_addr%5B0%5D%5B3%5D='.acidLong2IP($sip).
          '&ip_addr%5B0%5D%5B8%5D=+&ip_addr%5B0%5D%5B9%5D=AND'.
          '&ip_addr%5B1%5D%5B0%5D=+&ip_addr%5B1%5D%5B1%5D=ip_dst&ip_addr%5B1%5D%5B2%5D=%3D'.
          '&ip_addr%5B1%5D%5B3%5D='.acidLong2IP($dip).
          '&ip_addr%5B1%5D%5B8%5D=+&ip_addr%5B1%5D%5B9%5D=+'.
          '&ip_addr_cnt=2&layer4='.IPProto2str($proto);

        qroPrintEntry('<FONT>'.$sip_fqdn.'</FONT>');
        qroPrintEntry(BuildAddressLink(acidLong2IP($sip), 32).acidLong2IP($sip).'</A>');
        qroPrintEntry('-->');
        qroPrintEntry(BuildAddressLink(acidLong2IP($dip), 32).acidLong2IP($dip).'</A>');
        qroPrintEntry('<FONT>'.$dip_fqdn.'</FONT>');
        qroPrintEntry('<FONT>'.IPProto2str($proto).'</FONT>');

        $tmp = '<A HREF="acid_stat_ports.php?port_type=2&proto='.$proto.$tmp_ip_criteria.'">';
        qroPrintEntry($tmp.$num_unique_dport.'</A>');

        $tmp = '<A HREF="acid_stat_alerts.php?foo=1'.$tmp_ip_criteria.'">';
        qroPrintEntry($tmp.$num_unique.'</A>');

        $tmp = '<A HREF="acid_qry_main.php?new=1'.
                      '&num_result_rows=-1'.
                      '&submit=Query+DB&current_view=-1'.$tmp_ip_criteria.'">'; 
        qroPrintEntry($tmp.$num_occurances.'</A>');

        qroPrintEntryFooter();
     }
     $i++;
  }

  $result->acidFreeRows();

  $qro->PrintFooter();

  $qs->PrintBrowseButtons();
  $qs->PrintAlertActionButtons();
  $qs->SaveState();
  $et->Mark("Get Query Elements");
  $et->PrintTiming();

  echo "\n</FORM>\n";
  
  PrintACIDSubFooter();
?>
