/*
** Copyright (C) 1998-2002 Martin Roesch <roesch@sourcefire.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* $Id: sp_icmp_code_check.h,v 1.2.4.1 2002/03/15 14:42:31 chrisgreen Exp $ */
#ifndef __SP_ICMP_CODE_CHECK_H__
#define __SP_ICMP_CODE_CHECK_H__

#include "snort.h"

#define PLUGIN_ICMP_CODE  4

typedef struct _IcmpCodeCheckData
{
    /* the icmp code number */
    int icmp_code;

} IcmpCodeCheckData;

void SetupIcmpCodeCheck();
void IcmpCodeCheckInit(char *, OptTreeNode *, int);
void ParseIcmpCode(char *, OptTreeNode *);
int IcmpCodeCheck(Packet *, struct _OptTreeNode *, OptFpList *);

#endif  /* __SP_ICMP_CODE_CHECK_H__ */
