/* $Id: sp_reference.h,v 1.4 2001/04/26 03:34:07 cazz Exp $ */
/* sp_reference, Joe McAlerney, Silicon Defense, joey@silicondefense.com */
/*
** Copyright (C) 2000,2001 Joe McAlerney, 
**                         Silicon Defense <joey@silicondefense.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef __SP_REFERENCE_H__
#define __SP_REFERENCE_H__

#include "snort.h"

#define PLUGIN_REFERENCE_NUMBER    20

#define BUGTRAQ_URL_HEAD   "http://www.securityfocus.com/bid/"
#define CVE_URL_HEAD       "http://cve.mitre.org/cgi-bin/cvename.cgi?name="
#define ARACHNIDS_URL_HEAD "http://www.whitehats.com/info/IDS"
#define MCAFEE_URL_HEAD    "http://vil.nai.com/vil/dispVirus.asp?virus_k="
#define URL_HEAD           "http://"

typedef struct _ReferenceData
{
  char *system;
  char *id;
  char *url;
  struct _ReferenceData *next;

} ReferenceData;

void SetupReference();
void ReferenceInit(char *, OptTreeNode *, int);
void ReferenceRuleParseFunction(char *, OptTreeNode *);
void NewReferenceNode(OptTreeNode *);

#endif  /* __SP_REFERENCE_H__ */
