<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */
?>

<?php
  include("acid_conf.php");
  include("acid_db_common.php");
  include("acid_common.php");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <TITLE>ACID:      
      <?php if ( $addr_type == 1 ) 
              echo "Unique Source Address(es)";
           else if ( $addr_type == 2 )
              echo "Unique Destination Address(es)";
       ?> 
     </TITLE>
    <LINK rel="stylesheet" type="text/css" href="acid_style.css">
</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">
     <?php if ( $addr_type == 1 ) 
              echo "Unique Source Address(es)";
           else if ( $addr_type == 2 )
              echo "Unique Destination Address(es)";
     ?>
  </TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>
</TR>
</TABLE>
<P><P>

<?php
  /* Connect to the Alert database */
  $db=acid_mysql_connect($alert_host, $alert_port, $alert_user, $alert_password, $alert_dbname);
  mysql_select_db($alert_dbname, $db);

  $criteria = rawurldecode($criteria);
  $criteria_desc = rawurldecode($criteria_desc);  
  InputSafeSQL($criteria);
  InputSafeSQL($criteria_desc);


  if ( $num_result_rows == "" )
  {
     $num_result_rows = -1;
     $current_view = -1;
  }
  else if ( $num_result_rows > 0 && 
            ord($submit) >= ord("0") && ord($submit) <= ord("9") )
    $current_view = $submit;

  echo '<FONT>&nbsp<B>Queried DB on </B><FONT> : '.date("D F d, Y H:i:s",time()).'</FONT>';
  echo '<TABLE BORDER=1>
          <TR><TD CLASS="metatitle">Criteria</TD>
              <TD>'.$criteria_desc.'</TD></TR>
        </TABLE>

  <FORM METHOD="POST" ACTION="acid_stat_uaddr.php">';

  if ( $debug_mode == 1 )
     echo '<HR><TABLE BORDER=1>
             <TR><TD>submit</TD><TD>addr_type</TD><TD>criteria_desc</TD><TD>criteria</TD></TR>
             <TR><TD>'.$submit.'</TD><TD>'.$addr_type.'</TD>
                 <TD>'.$criteria_desc.'</TD><TD>'.$criteria.'</TD></TR>
           </TABLE>';

  $sql = $criteria;

  /* Run the query to determine the number of rows (No LIMIT)*/
  if ( $num_result_rows == -1 )
  {
     $current_view = 0;
     $result = mysql_query($sql, $db);
     if ( $result  )
     {
        $num_result_rows = mysql_num_rows($result);
        /* Check here for pre-processor generated events (e.g. portscan, mini-frag)
           that generate alerts but no packet information */
        $myrow = mysql_fetch_row($result);
        if ( $myrow[1] == "" )
        {
           echo '<CENTER><FONT>This type of alert did not log any IP addresses.  See this 
                 <A HREF="acid_app_faq.php#1">FAQ</A> for details</FONT></CENTER>';
           $num_result_rows = 0;
        }

        mysql_free_result($result);
     }
     else
        $num_result_rows = 0;
   }

   /* Run the Query again for the actual data (with the LIMIT */
 
  /* Check if a limit has already been enforced,
     e.g. from a last-x alerts */
  if ( strstr($sql, "LIMIT") == "" )
      $limit_tmp = " LIMIT ".($current_view * $show_rows).",".$show_rows;

   $result = mysql_query($sql.$limit_tmp, $db);

   echo '<P><HR>';


   $criteria2 = CriteriaFromSQL($criteria);
   if ( strstr($criteria2, " WHERE ") == "" )
      $criteria2 = $criteria2." WHERE ";
   else
      $criteria2 = $criteria2." AND ";

   if ( $debug_mode == 1 )
   {
      echo 'SQL with LIMIT: '.$sql.$limit_tmp.'<BR>
            Criteria2: '.$criteria2;
   }

   /* Print the current view number and # of rows */
   if ( $num_result_rows != 0 )
   {
      /* If printing Last-X alerts, just print all the IP addresses */
      if ( strstr($sql, "LIMIT") == "" )
         printf("<FONT><CENTER>Displaying IP addresses %d-%d of %d total<BR></CENTER></FONT><BR>\n", 
                ($current_view * $show_rows)+1, 
                (($current_view * $show_rows) + $show_rows-1) < $num_result_rows ? 
                (($current_view * $show_rows) + $show_rows) : $num_result_rows, 
                $num_result_rows);
      else
         echo '<FONT><CENTER>Displaying '.$num_result_rows.' IP addresses<BR></CENTER></FONT><BR>';

      echo '<TABLE BORDER=1 CELLSPACING=0 PADDING=10>
                <TR>
                 <TD CLASS="plfieldhdr">IP Address</TD>
                 <TD CLASS="plfieldhdr"># of <BR>Sensors</TD>
                 <TD CLASS="plfieldhdr"># of <BR>Occurances</TD>';
   }
   else
      printf("<P><CENTER><B>0 IP addresses were found</B></CENTER><P>\n");

   $i = 0;
   while ( ($myrow = mysql_fetch_row ($result)) && $num_result_rows != 0 )
   {
      echo '<TR BGCOLOR="'.((($i % 2) == 0) ? "DDDDDD" : "FFFFFF").'">
             <TD>&nbsp;&nbsp;';

      echo BuildAddressLink($myrow[1], $myrow[2], $myrow[3], $myrow[4], 32).
            $myrow[1].".".$myrow[2].".".$myrow[3].".".$myrow[4].'</A>';
 
      echo '&nbsp;&nbsp';
     
      /* Print # of Sensors */
      if ( $addr_type == 1 )
         $sql2 = "SELECT DISTINCTROW iphdr.sid ".$criteria2.
                      " ip_src0=$myrow[1] AND ip_src1=$myrow[2] AND ip_src2=$myrow[3] AND ip_src3=$myrow[4]";
      else if ( $addr_type == 2 )
         $sql2 = "SELECT DISTINCTROW iphdr.sid ".$criteria2.
                      " ip_dst0=$myrow[1] AND ip_dst1=$myrow[2] AND ip_dst2=$myrow[3] AND ip_dst3=$myrow[4]";

      $result2 = mysql_query($sql2, $db);
      
      echo '<TD ALIGN=CENTER>'.mysql_num_rows($result2);
      mysql_free_result($result2);

      /* Print # of Occurances */
      if ( $addr_type == 1 )
         $sql2 = "SELECT count(ip_src) ".$criteria2.
                      " ip_src0=$myrow[1] AND ip_src1=$myrow[2] AND ip_src2=$myrow[3] AND ip_src3=$myrow[4]";
      else if ( $addr_type == 2 )
         $sql2 = "SELECT count(ip_dst) ".$criteria2.
                      " ip_dst0=$myrow[1] AND ip_dst1=$myrow[2] AND ip_dst2=$myrow[3] AND ip_dst3=$myrow[4]";

      $result2 = mysql_query($sql2, $db);
      $myrow2 = mysql_fetch_row($result2);

      $tmp_iplookup = 'acid_pkt_main.php?sig%5B0%5D=%3D'.
                      '&num_result_rows=-1'.
                      '&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=+'.
                      '&submit=Query+DB&current_view=-1&ip_addr_cnt=1'.$criteria_form;

      echo '<TD ALIGN=CENTER>';
      if ( $addr_type == 1 )
         echo '<A HREF="'.$tmp_iplookup.BuildSrcIPFormVars($myrow[1], $myrow[2], $myrow[3], $myrow[4]).'">'.
                                $myrow2[0].'</A>';
      else if ( $addr_type == 2 )
         echo '<A HREF="'.$tmp_iplookup.BuildDstIPFormVars($myrow[1], $myrow[2], $myrow[3], $myrow[4]).'">'.
                                $myrow2[0].'</A>';

      mysql_free_result($result2);
      ++$i;
   }

   echo '</TABLE>';
   mysql_free_result($result);     

   /* Export shared state */
   echo '<INPUT TYPE="hidden" NAME="num_result_rows" VALUE="'.$num_result_rows.'">
         <INPUT TYPE="hidden" NAME="current_view" VALUE="'.$current_view.'">
         <INPUT TYPE="hidden" NAME="criteria" VALUE="'.rawurlencode($criteria).'">
         <INPUT TYPE="hidden" NAME="criteria_desc" VALUE="'.rawurlencode($criteria_desc).'">
         <INPUT TYPE="hidden" NAME="addr_type" VALUE="'.$addr_type.'">';

  /* ****** Print out Browsing Buttons ********************************************/
  if ( strstr($sql, "LIMIT") == "" )
     PrintBrowseButtons($num_result_rows, $show_rows, $max_scroll_buttons, $current_view);
?>

</FORM>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>




