<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Original Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 * Additions by Stuart Stock <stuarts@hushmail.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */
?>

<?php
  include ("acid_db_common.php");
  include ("acid_common.php");
  include ("acid_stat_common.php");
  include ("acid_conf.php");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <TITLE>SnortACID: Sensor Details</TITLE>
  <LINK rel="stylesheet" type="text/css" href="acid_style.css">

</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Sensor Details</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>

</TR>
</TABLE>
<P><P>

<?php

  /* Connect to the Alert database */
  $db=acid_mysql_connect($alert_host, $alert_port, $alert_user, $alert_password, $alert_dbname);
  mysql_select_db($alert_dbname, $db);

  /* Initialized Data */
  if ( $submit == "" )
  {
     $num_result_rows = -1;
     $current_view = 0;
  }
  /* Moving among the views */
  else
    $current_view = $submit;

  /* Get total number of events */
  $event_cnt = EventCnt($db);

  /* Grab sensor count and create SID array */
  $sensor_cnt = SensorCnt($db);
  $sensor_ids = GetSensorIDs($db);

  for( $i = 0; $i < $sensor_cnt; $i++) {
     	$raw_sensor_events[ $sensor_ids[$i] ] = EventCntBySensor($sensor_ids[$i], $db); 
  }

  for( $i = 0; $i < $sensor_cnt; $i++) {
	$unique_sensor_events[ $sensor_ids[$i] ] = UniqueCntBySensor($sensor_ids[$i], $db);
  }


  if( $debug_mode == 1 ){   
	for( $i = 0; $i < $sensor_cnt; $i++ ) {
		printf("i = %s: sensor %s raw events %s, unique events %s<BR>\n", $i, $sensor_ids[$i], $raw_sensor_events[ $sensor_ids[$i] ], $unique_sensor_events[ $sensor_ids[$i] ] );	
	}
  }


  $num_result_rows = $sensor_cnt;

  
  /* Run the Query again for the actual data (with the LIMIT */
  $limit_tmp = " LIMIT ".($current_view * $show_rows).",".$show_rows;

  if ( $debug_mode == 1 )
     echo $sql.$limit_tmp;

  $result = mysql_query($sql.$limit_tmp, $db);

  /* Print the current view number and # of rows */
  if ( $num_result_rows != 0 )
  {
     printf("<FONT><CENTER>Displaying sensors %d-%d of %d <BR> (Aggregating %d total events)</CENTER></FONT><BR>\n", 
            ($current_view * $show_rows)+1, 
            (($current_view * $show_rows) + $show_rows-1) < $num_result_rows ? 
            (($current_view * $show_rows) + $show_rows) : $num_result_rows, 
            $num_result_rows,
            $event_cnt);
  }
  else
     printf("<P><B>No Alerts were found.  Is the database empty?</B><P>\n");

  /* Print the Statistics on Each of the Unique Alerts */
  echo '<TABLE BORDER=1>
        <TR>
           <TD CLASS="plfieldhdr">Sensor</TD>
           <TD CLASS="plfieldhdr">Name</TD>
           <TD CLASS="plfieldhdr">Total<BR>Events</TD>
           <TD CLASS="plfieldhdr">Unique<BR>Events</TD>
           <TD CLASS="plfieldhdr">Unique<BR>Src. Addr</TD>
           <TD CLASS="plfieldhdr">Unique<BR>Dest. Addr</TD>
           <TD CLASS="plfieldhdr">First<BR>Occurance</TD>
           <TD CLASS="plfieldhdr">Last<BR>Occurance</TD>
        </TR>';


for ( $i = 0; $i < $sensor_cnt; $i++ )
{
     $num_src_ip = UniqueSrcAddrCntBySensor( $sensor_ids[$i], $db);
     $num_dst_ip = UniqueDestAddrCntBySensor( $sensor_ids[$i], $db);

     $start_time = MinDateBySensor( $sensor_ids[$i], $db );
     $stop_time = MaxDateBySensor( $sensor_ids[$i], $db );

     /* Print out */ 
     echo '<TR>';
     
     printf("<TD ALIGN=CENTER>%s", $sensor_ids[$i]);
     echo '<TD ALIGN=CENTER> '.GetSensorName($sensor_ids[$i], $db);
     echo '  <TD ALIGN=CENTER>
              <A HREF="acid_pkt_main.php?sensor='.$sensor_ids[$i].
                                        '&num_result_rows=-1'.
                                        '&submit=Query+DB">'.
              $raw_sensor_events[ $sensor_ids[$i] ].'</A>
              ('.(round($raw_sensor_events[ $sensor_ids[$i] ]/$event_cnt*100)).'%)';
     echo '  <TD ALIGN=CENTER>'.
                BuildUniqueAlertLink(" FROM event WHERE event.sid=".$sensor_ids[$i],
                                     "Sensor=[".$sensor_ids[$i]."] ".GetSensorName($sensor_ids[$i],$db),
                                     "&sensor=".$sensor_ids[$i]).
                          $unique_sensor_events[ $sensor_ids[$i] ].'</A>';
     echo '  <TD ALIGN=CENTER>'.
               BuildUniqueAddressLink("Sensor=[".$sensor_ids[$i]."] ".GetSensorName($sensor_ids[$i],$db), 1,
                                      "SELECT DISTINCTROW ip_src, ip_src0, ip_src1, ip_src2, ip_src3 ".
                                      "FROM event, iphdr ".
                                      "WHERE event.sid=iphdr.sid AND event.cid=iphdr.cid AND ".
                                      "event.sid=".$sensor_ids[$i]." ".
                                      "ORDER BY ip_src","").$num_src_ip.'</A>';
     echo '  <TD ALIGN=CENTER>'.
               BuildUniqueAddressLink("Sensor=[".$sensor_ids[$i]."] ".GetSensorName($sensor_ids[$i],$db), 2,
                                      "SELECT DISTINCTROW ip_dst, ip_dst0, ip_dst1, ip_dst2, ip_dst3 ".
                                      "FROM event, iphdr ".
                                      "WHERE event.sid=iphdr.sid AND event.cid=iphdr.cid AND ".
                                      "event.sid=".$sensor_ids[$i]." ".
                                      "ORDER BY ip_dst","").$num_dst_ip.'</A>';
     echo '  <TD ALIGN=CENTER>'.$start_time;
     echo '  <TD ALIGN=CENTER VALIGN=CENTER>'.$stop_time;
     echo '  </TR>';
}

echo "</TABLE>\n";

echo '<FORM ACTION="acid_stat_sensor.php" METHOD="POST">';
echo '<INPUT TYPE="hidden" NAME="num_result_rows" VALUE="'.$num_result_rows.'">';
echo '<INPUT TYPE="hidden" NAME="current_view" VALUE="'.$current_view.'">';

/* ****** Print out Browsing Buttons ********************************************/
PrintBrowseButtons($num_result_rows, $show_rows, $max_scroll_buttons, $current_view);
echo '</FORM>';

  mysql_close($db);
?>



<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>
