<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */
?>

<?php
  include("acid_conf.php");
  include("acid_db_common.php");
  include("acid_common.php");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <TITLE>ACID: Setup</TITLE>
    <LINK rel="stylesheet" type="text/css" href="acid_style.css">
</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Setup</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>
</TR>
</TABLE>
<P><P>

<FORM METHOD="POST"
      ACTION="acid_db_setup.php">

<?php
  /* Connect to the Alert database */
  $db=acid_mysql_connect($alert_host, $alert_port, $alert_user, $alert_password, $alert_dbname);
  mysql_select_db($alert_dbname, $db);

  $tblAcidAG_present = tblExists($db, "acid_ag");
  $tblAcidAGAlert_present = tblExists($db, "acid_ag_alert");
  $index_event_sig_present = indexExists($db, "event", "signature");
  $index_event_time_present = indexExists($db, "event", "timestamp");

  if ( $submit == "Create ACID AG" )
  {
     if ( !$tblAcidAG_present )
     {
         $sql = '
                CREATE TABLE acid_ag ( ag_id               INT           UNSIGNED NOT NULL AUTO_INCREMENT,
                                       ag_name             VARCHAR(40),
                                       ag_desc             TEXT, 
                                       ag_ctime            DATETIME,
                                       ag_ltime            DATETIME,

                                       PRIMARY KEY         (ag_id),
                                       INDEX               (ag_id))';
          mysql_query($sql, $db);
          if ( mysql_errno($db) > 0 )
             ErrorMessage("Unable to CREATE table 'acid_ag': ".mysql_error($db));
          else
             ErrorMessage("Successfully created 'acid_ag'");

          $tblAcidAG_present = tblExists($db, "acid_ag");
      }

      if ( !$tblAcidAGAlert_present )
      {
         $sql = '
                CREATE TABLE acid_ag_alert( ag_id               INT           UNSIGNED NOT NULL,
                                            ag_sid              INT           UNSIGNED NOT NULL,
                                            ag_cid              INT           UNSIGNED NOT NULL, 
                                            PRIMARY KEY         (ag_id, ag_sid, ag_cid),
                                            INDEX               (ag_id),
                                            INDEX               (ag_sid),
                                            INDEX               (ag_cid))';
          mysql_query($sql, $db);
          if ( mysql_errno($db) > 0 )
             ErrorMessage("Unable to CREATE table 'acid_ag_alert': ".mysql_error($db));
          else
             ErrorMessage("Successfully created 'acid_ag_alert'");
 
          $tblAcidAGAlert_present = tblExists($db, "acid_ag_alert");
      }
      echo '<HR><P>';
  }

  if ( $submit == "Create Indexes" )
  {
     if (!$index_event_sig_present)
        createDBIndex($db, "event", "signature", "signature_index");
     if (!$index_event_time_present)
        createDBIndex($db, "event", "timestamp", "timestamp_index");

     $index_event_sig_present = indexExists($db, "event", "signature");
     $index_event_time_present = indexExists($db, "event", "timestamp");
  }

  echo '
  <TABLE>
     <TR><TD CLASS="plfieldhdr">Operation
         <TD CLASS="plfieldhdr">Description
         <TD CLASS="plfieldhdr">Status
     <TR><TD><B>ACID tables</B>
         <TD>Adds tables to extend the Snort DB to support the ACID functionality
         <TD>';

  if ( $tblAcidAG_present && $tblAcidAGAlert_present)
     ErrorMessage("&nbsp;DONE&nbsp;");
  else
     echo '<INPUT TYPE="submit" NAME="submit" VALUE="Create ACID AG">'; 

  echo '
     <TR><TD><B>Search Indexes</B>
         <TD>(Optional) Adds indexes to the Snort DB to optimize the speed of the queries
         <TD>';

  if ( $index_event_sig_present && $index_event_time_present ) 
     ErrorMessage("&nbsp;DONE&nbsp;");
  else
     echo '<INPUT TYPE="submit" NAME="submit" VALUE="Create Indexes">';
  
  echo '
  </TABLE>';
  
  if ( $tblAcidAG_present && $tblAcidAGAlert_present )
     echo '<P>
           The underlying Alert DB is configured for usage with ACID.
           <P>
           <B>Additional DB permissions</B><BR>
           In order to support Alert purging (the selective ability to permantently delete
           alerts from the database), the DB user "'.$alert_user.'" must have the DELETE privilege
           on the database "'.$alert_dbname.'@'.$alert_host.'" 
           <P>
           Goto the <A HREF="acid_main.php">Main page</A> to use the application.'; 
?>
</FORM>

</BODY>

</HTML>
