/*
** Copyright (C) 1998,1999,2000 Martin Roesch <roesch@clark.net>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* $Id: plugbase.h,v 1.12 2000/03/16 02:58:44 roesch Exp $ */
#ifndef __PLUGBASE_H__
#define __PLUGBASE_H__

#include "rules.h"
#include "sp_pattern_match.h"
#include "sp_tcp_flag_check.h"
#include "sp_icmp_type_check.h"
#include "sp_icmp_code_check.h"
#include "sp_ttl_check.h"
#include "sp_ip_id_check.h"
#include "sp_tcp_ack_check.h"
#include "sp_tcp_seq_check.h"
#include "sp_dsize_check.h"
#include "sp_ipoption_check.h"
#include "sp_rpc_check.h"
#include "sp_icmp_id_check.h"
#include "sp_icmp_seq_check.h"
#include "sp_session.h"

#include "spp_http_decode.h"
#include "spp_minfrag.h"
#include "spp_portscan.h"

#include "spo_alert_syslog.h"
#include "spo_log_tcpdump.h"

#ifdef ENABLE_POSTGRESQL
    #include "spo_log_postgresql.h"
#endif

#define NT_OUTPUT_ALERT  0   /* output node type alert */
#define NT_OUTPUT_LOG    1   /* output node type log */

#define OUPUT_LEVEL_0     0
#define OUPUT_LEVEL_1     1
#define OUPUT_LEVEL_2     2
#define OUPUT_LEVEL_3     3
#define OUPUT_LEVEL_4     4

typedef struct _KeywordXlate
{
    char *keyword;
    void (*func)(char *, OptTreeNode *, int);
} KeywordXlate;



typedef struct _KeywordXlateList
{
    KeywordXlate entry;
    struct _KeywordXlateList *next;
} KeywordXlateList;


/* preprocessor data struct */
typedef struct _PreprocessKeywordNode
{
    char *keyword;
    void (*func)(char *);

} PreprocessKeywordNode;




typedef struct _PreprocessKeywordList
{
    PreprocessKeywordNode entry;
    struct _PreprocessKeywordList *next;

} PreprocessKeywordList;




typedef struct _PreprocessFuncNode
{
    void (*func)(Packet *);
    struct _PreprocessFuncNode *next;

} PreprocessFuncNode;


/*
 * Output data struct 
 */
typedef struct _OutputKeywordNode
{
    char *keyword;
    char node_type;
    void (*func)(char *);

} OutputKeywordNode;



typedef struct _OutputKeywordList
{
    OutputKeywordNode entry;
    struct _OutputKeywordList *next;

} OutputKeywordList;


typedef struct _OutputFuncNode
{
    void (*func)(Packet *, char *);
    struct _OutputFuncNode *next;

} OutputFuncNode;



void InitPlugIns();
void InitPreprocessors();
void InitOutputPlugins();
void RegisterPlugin(char *, void (*func)(char *, OptTreeNode *, int));
void DumpPlugIns();
void RegisterPreprocessor(char *, void (*func)(u_char *));
void DumpPreprocessors();
void RegisterOutputPlugin(char *, int, void (*func)(u_char *));
void DumpOutputPlugins();
int PacketIsIP(Packet *);
int PacketIsTCP(Packet *);
int PacketIsUDP(Packet *);
int PacketIsICMP(Packet *);
int DestinationIpIsHomenet(Packet *);
int SourceIpIsHomenet(Packet *);
int IsTcpSessionTraffic(Packet *);
int CheckNet(struct in_addr *, struct in_addr *);


#endif /* __PLUGBASE_H__ */

