#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "config.h"
#include "smurflog.h"
#include "hash.h"

extern struct hash hashtable[256];

inline char hashfunc(const char *ip)
{
   return (ip[0] ^ ip[1] ^ ip[2]);
}

void clear_collision(struct hash *hptr)
{
   if (hptr->next != NULL)
      clear_collision(hptr->next);
   free(hptr);
}

void clear_hash(void)
{
   int i;

   for(i=0;i<256;++i)
      if (hashtable[i].next != NULL)
         clear_collision(hashtable[i].next);

   memset(hashtable, 0, sizeof(hashtable));
}

inline int unnamed(u_long ip)
{
   u_char hashval;
   struct hash *hptr;

   hashval = hashfunc((u_char *) &ip);

   if (hashtable[hashval].network == 0) {
      hashtable[hashval].network = ip;
      return 1;
   }
   else {
      if (hashtable[hashval].network == ip)
         return 0;
      else {
         hptr = hashtable+hashval;
         while(hptr->next != NULL) {
            if (hptr->network == ip)
               return 0;
            hptr = hptr->next;
         }

         if ((hptr->next = malloc(sizeof(struct hash))) == NULL)
            return 0;
         hptr->next->network = ip;
         hptr->next->next = NULL;
      }
   }

   return 1;
}
