%{
/*	$Id: scan.l,v 1.8 2007/01/16 14:57:38 mbalmer Exp $ */

/*
 * Copyright (c) 2004 - 2007 Marc Balmer <marc@msys.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <string.h>

#include "y.tab.h"

%}

%option yylineno noyywrap nounput

%%

[ \t]+			/* ignore whitespace */ ;

host			{ return HOST; }
port			{ return PORT; }
local-socket		{ return LOCALSOCK; }
bind			{ return BIND; }
tries			{ return TRIES; }
timeout			{ return TIMEOUT; }
scantype		{ return SCANTYPE; }
option			{ return OPTION; }

filesystem		{ return FILESYSTEM; }
socket			{ return SOCKET; }
fildes			{ return FILDES; }

chroot-scanrealpath	{ return CHROOT_SCANREALPATH; }

[0-9]+			{ clamdlval.string = strdup(clamdtext); return NUMBER; }

#.*\n			/* ignore comments */ ;

[a-zA-Z0-9_\-:\.,/\*]+	{ clamdlval.string = strdup(clamdtext); return TEXT; }
\"([^"\n]*)["\n]	{
				clamdtext[clamdleng - 1] = 0;
				clamdleng -= 2;
				clamdlval.string = strdup(clamdtext + 1);
				return TEXT;
			}

=			{ return '='; }

\n			{ return '\n'; }
