%{
/*	$Id: scan.l,v 1.6 2006/02/08 16:37:04 mbalmer Exp $ */

/*
 * Copyright (c) 2005, 2006 Marc Balmer <marc@msys.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <string.h>

#if !defined(__FreeBSD__)
#include "y.tab.h"
#else
#include "parse.h"
#endif

%}

%option yylineno noyywrap nounput

%%

[ \t]+			/* ignore whitespace */ ;

case-sensitive			{ return CASE_SENSITIVE; }
unwanted-filename		{ return UNWANTED_FILENAME; }
unwanted-content-type		{ return UNWANTED_CONTENT; }
attachment-notification		{ return NOTIFICATION; }

true				{ return TRUE; }
false				{ return FALSE; }

[0-9]+				{
					attachmentlval.string = strdup(attachmenttext);
					return NUMBER;
				}

#.*\n				/* ignore comments */ ;

[a-zA-Z0-9_\-:\.,/\*]+		{
					attachmentlval.string = strdup(attachmenttext);
					return TEXT;
				}

\"([^"\n]*)["\n]		{
					attachmenttext[attachmentleng - 1] = 0;
					attachmentleng -= 2;
					attachmentlval.string = strdup(attachmenttext+1);
					return TEXT;
				}

=				{ return '='; }

\n				{ return '\n'; }
