/*	$Id: smtp-vilter.h,v 1.44 2006/02/05 13:55:55 mbalmer Exp $	*/

/*
 * Copyright (c) 2003-2006 Marc Balmer <marc@msys.ch>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/time.h>

#include <sys/cdefs.h>
#include <stdio.h>
#include <unistd.h>

#define	VERSION	"1.2.7"

#define MAJOR	5	/* Major and minor version number */
#define MINOR	1	/* of shared libs (backends) */

#if __OpenBSD__
#define ENABLE_PF
#endif

#if __FreeBSD__
#include <sys/param.h>
#if (__FreeBSD_version >= 600026)
#define ENABLE_PF
#endif
#endif

/*
 *	The following values define reasons why an email might be rejected.
 */

#define SCAN_OK		0	/* Message is acceptable */
#define SCAN_VIRUS	1	/* Message contains a virus */
#define SCAN_SPAM	2	/* Message is considered spam */
#define SCAN_UNWANTED	3	/* Unwanted content, eg. attachement */
				/* of a certain type */
#define SCAN_ERROR 	-1

enum strategies {
	STRATEGY_UNSET	= -1,
	STRATEGY_DISCARD,
	STRATEGY_MARK,
	STRATEGY_NOTIFY_RECIPIENT,
	STRATEGY_TEMPFAIL,
	STRATEGY_REJECT,
	STRATEGY_IGNORE
};

/* Backend capabilities */

#define BE_SCAN_VIRUS		0x0001
#define BE_SCAN_SPAM		0x0002
#define BE_SCAN_UNWANTED	0x0004
#define BE_SCAN_PER_RCPT	0x0008

struct be_data {
	struct syslog_data	*sdata;
	void			*priv;
};

struct backend {
	char	*name;
	char	*config_file;
	void	*dlhandle;
	int	 type;
	int	 (*be_init)(char *);	/* One time initialization */
	char	*(*be_name)(void);
	int	 (*be_type)(void);
	int	 (*be_new)(struct be_data *, char *, FILE *);	/* Per thread initializer */
	union {
		int (*be_scan_virus)(struct be_data *, char *, char *, char *, int);
		int (*be_scan_spam)(struct be_data *, char *, char *, double *, double *);
		int (*be_scan_unwanted)(struct be_data *, char *, char *, char *, int);
	} be_scan;
	int	 (*be_end)(struct be_data *priv);	/* Per thread finalizer */
	void	 (*be_exit)(void);
};

#define SOCK_BUFSIZE	1024

typedef struct _SOCK {
	int	 sock;	
	char	 buf[SOCK_BUFSIZE];
	int	 size;
	char	*pos;
} SOCK;

/* reactions */

enum reactions {
	REACTION_UNSET = -1,
	REACTION_ADDTBL,
	REACTION_DELTBL
};

extern int verbose;

__BEGIN_DECLS
extern SOCK *fdsock(int);
extern ssize_t to_recv(int, void *, size_t, int, struct timeval *);
extern ssize_t to_send(int, const char *, size_t, int, struct timeval *);
extern int to_readc(SOCK *, char *, struct timeval *);
extern ssize_t to_readln(char *, int, SOCK *, struct timeval *);
extern int *sputs(const char *, SOCK *, struct timeval *);
extern void sclose(SOCK *);
__END_DECLS
