%{
/*	$Id: scan.l,v 1.5 2005/08/28 08:01:40 mbalmer Exp $ */

#include <string.h>

#if !defined(__FreeBSD__)
#include "y.tab.h"
#else
#include "parse.h"
#endif

%}

%option yylineno noyywrap nounput

%%

[ \t]+			/* ignore whitespace */ ;

case-sensitive			{ return CASE_SENSITIVE; }
unwanted-filename		{ return UNWANTED_FILENAME; }
unwanted-content-type		{ return UNWANTED_CONTENT; }
attachment-notification		{ return NOTIFICATION; }

true				{ return TRUE; }
false				{ return FALSE; }

[0-9]+				{
					attachmentlval.string = strdup(attachmenttext);
					return NUMBER;
				}

#.*\n				/* ignore comments */ ;

[a-zA-Z0-9_\-:\.,/\*]+		{
					attachmentlval.string = strdup(attachmenttext);
					return TEXT;
				}

\"([^"\n]*)["\n]		{
					attachmenttext[attachmentleng - 1] = 0;
					attachmentleng -= 2;
					attachmentlval.string = strdup(attachmenttext+1);
					return TEXT;
				}

=				{ return '='; }

\n				{ return '\n'; }

