%{
/*	$Id: scan.l,v 1.4 2005/04/23 12:25:36 marc Exp $ */

#include <string.h>
#if !defined(__FreeBSD__)
#include "y.tab.h"
#else
#include "parse.h"
#endif

%}

%option yylineno noyywrap nounput

%%

[ \t]+			/* ignore whitespace */ ;

host			{ return HOST; }
port			{ return PORT; }
bind			{ return BIND; }
tries			{ return TRIES; }
timeout			{ return TIMEOUT; }
maxsize			{ return MAXSIZE; }

[0-9]+			{ spamdlval.string = strdup(spamdtext); return NUMBER; }

#.*\n			/* ignore comments */ ;

[a-zA-Z0-9_\-:\.,/\*]+	{ spamdlval.string = strdup(spamdtext); return TEXT; }
\"([^"\n]*)["\n]	{
				spamdtext[yyleng - 1] = 0;
				spamdleng -= 2;
				spamdlval.string = strdup(spamdtext+1);
				return TEXT;
			}

=			{ return '='; }

\n			{ return '\n'; }

