/*	$Id: vilter-savse.c,v 1.19 2005/04/24 11:24:23 marc Exp $	*/

/*
 * Copyright (c) 2003-2005 Marc Balmer <marc@msys.ch>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/stat.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <ctype.h>
#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <netdb.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>

#include "pathnames.h"
#include "smtp-vilter.h"

#ifdef __linux__
#include "strlfunc.h"
#endif

#define TIMEOUT 	60
#define MAXBUF		1024
#define MAXSTR		64
#define MAXTRIES	256

int	 savse_port;
char	*savse_host;
char	*bind_addr;
int	 savse_tries;
int	 savse_timeout;
int	 chroot_scanrealpath;

int
vilter_scan(struct be_data *priv, char *fn, char *chroot, char *virus, int namelen)
{
	int fd;
	int try;
	FILE *fp;
	struct sockaddr_in server_sockaddr;
	struct sockaddr_in bind_sockaddr;
	struct timeval tv;
	struct hostent *hostent;
	char buf[MAXBUF];
	int infection_count;

	if ((fd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {
		syslog(LOG_ERR, "savse: unable to obtain network");
		return SCAN_ERROR;
	}
 
 	if (bind_addr != NULL) {
		bzero((char *) &server_sockaddr, sizeof(server_sockaddr));
		bind_sockaddr.sin_family = AF_INET;

		if (inet_aton(bind_addr, &bind_sockaddr.sin_addr) == 0) {
			hostent = gethostbyname(bind_addr);
			if (!hostent) {
				syslog(LOG_ERR, "savse: unknown bind address: %s", bind_addr);
				close(fd);
				return SCAN_ERROR;
			}

			bind_sockaddr.sin_family = hostent->h_addrtype;
			memcpy(&bind_sockaddr.sin_addr, hostent->h_addr, hostent->h_length);
		}
		
		if (bind(fd, (struct sockaddr *) &bind_sockaddr, sizeof(bind_sockaddr))) {
			syslog(LOG_ERR, "savse: can't bind to address %s", bind_addr);
			close(fd);
			return SCAN_ERROR;
		}
	}
	bzero((char *) &server_sockaddr, sizeof(server_sockaddr));

	server_sockaddr.sin_family = AF_INET;
	server_sockaddr.sin_port = htons(savse_port);

	if (inet_aton(savse_host, &server_sockaddr.sin_addr) == 0) {
		hostent = gethostbyname(savse_host);
		if (!hostent) {
			syslog(LOG_ERR, "savse: unknown host: %s", savse_host);
			return SCAN_ERROR;
		}
		server_sockaddr.sin_family = hostent->h_addrtype;
		memcpy(&server_sockaddr.sin_addr, hostent->h_addr, hostent->h_length);
	}
	try = 0;
	while (connect(fd, (struct sockaddr *) &server_sockaddr, sizeof(server_sockaddr)) == -1) {
		++try;

		if (try == savse_tries) {
			syslog(LOG_ERR, "savse: unable to connect socket");
			return SCAN_ERROR;
		} else
			sleep(1);
	}
	if (savse_timeout > 0) {
		tv.tv_sec = savse_timeout;
		tv.tv_usec = 0;

		setsockopt(fd, SOL_SOCKET, SO_RCVTIMEO, &tv, sizeof(tv));
		setsockopt(fd, SOL_SOCKET, SO_SNDTIMEO, &tv, sizeof(tv));
	}	
	if (!(fp = fdopen(fd, "a+"))) {
		syslog(LOG_ERR, "savse: can't open output");
		return SCAN_ERROR;
	}
	if (!fgets(buf, sizeof(buf), fp)) {
		syslog(LOG_ERR, "savse: no response from savse");
		fclose(fp);
		return SCAN_ERROR;
	}
	if (strncmp(buf, "220", 3)) {
		syslog(LOG_ERR, "savse: savse not ready, %s", buf);
		fclose(fp);
		return SCAN_ERROR;
	}
	if (!fgets(buf, sizeof(buf), fp)) {
		syslog(LOG_ERR, "savse: no response from savse");
		fclose(fp);
		return -SCAN_ERROR;
	}
	if (buf[0] != '2') {
		syslog(LOG_ERR, "savse: savse version number mismatch");
		fclose(fp);
		return SCAN_ERROR;
	}
	if (chroot_scanrealpath && chroot != NULL)
		fprintf(fp, "Version 2\r\nAVSCANLOCAL\r\n%s/%s\r\n", chroot, *fn == '/' ? fn + 1 : fn);
	else
		fprintf(fp, "Version 2\r\nAVSCANLOCAL\r\n%s\r\n", fn);

	if (!fgets(buf, sizeof(buf), fp)) {
		syslog(LOG_ERR, "savse: no response from savse");
		fclose(fp);
		return SCAN_ERROR;
	}
	if (buf[0] != '2') {
		syslog(LOG_ERR, "savse: error, %s", buf);
		fclose(fp);
		return SCAN_ERROR;
	}
	if (!fgets(buf, sizeof(buf), fp)) {
		syslog(LOG_ERR, "savse: no response from savse");
		fclose(fp);
		return SCAN_ERROR;
	}

	/* Bad coding practice on the next 20 lines... */

	if (buf[0] != '0') {
		fgets(buf, sizeof(buf), fp);	/* definitons date */
		fgets(buf, sizeof(buf), fp);	/* definitions version */
		fgets(buf, sizeof(buf), fp);	/* infection count */

		infection_count = atoi(buf);

		if (infection_count > 0) {
			fgets(buf, sizeof(buf), fp);	/* filename */
			fgets(buf, sizeof(buf), fp);	/* virusname */
			buf[strlen(buf) -2] = '\0';

			/* ignore the rest... */

			strlcpy(virus, buf, namelen);
		}
		fclose(fp);
		return SCAN_VIRUS;
	}
	fclose(fp);
	return SCAN_OK;
}

char *
vilter_name(void)
{
	return "Symantec AntiVirus Scan Engine, native protocol (savse)";
}

int
vilter_type(void)
{
	return BE_SCAN_VIRUS;
}

void
vilter_exit(void)
{
	if (verbose)
		warnx("savse: vilter_exit()");

	free(savse_host);
}
