%{
/*	$Id: scan.l,v 1.4 2005/04/23 12:25:35 marc Exp $ */

#include <string.h>
#if !defined(__FreeBSD__)
#include "y.tab.h"
#else
#include "parse.h"
#endif

%}

%option yylineno noyywrap nounput

%%

[ \t]+			/* ignore whitespace */ ;

host			{ return HOST; }
port			{ return PORT; }
bind			{ return BIND; }
tries			{ return TRIES; }
timeout			{ return TIMEOUT; }
option			{ return OPTION; }

chroot-scanrealpath	{ return CHROOT_SCANREALPATH; }

[0-9]+			{ savselval.string = strdup(savsetext); return NUMBER; }

#.*\n			/* ignore comments */ ;

[a-zA-Z0-9_\-:\.,/\*]+	{ savselval.string = strdup(savsetext); return TEXT; }
\"([^"\n]*)["\n]	{
				savsetext[savseleng - 1] = 0;
				savseleng -= 2;
				savselval.string = strdup(savsetext+1);
				return TEXT;
			}

=			{ return '='; }

\n			{ return '\n'; }

