%{
/*	$Id: scan.l,v 1.5 2005/04/23 12:25:33 marc Exp $ */

#include <string.h>
#if !defined(__FreeBSD__)
#include "y.tab.h"
#else
#include "parse.h"
#endif

%}

%option yylineno noyywrap nounput

%%

[ \t]+			/* ignore whitespace */ ;

host			{ return HOST; }
port			{ return PORT; }
bind			{ return BIND; }
uri			{ return URI; }
query			{ return QUERY; }
tries			{ return TRIES; }
timeout			{ return TIMEOUT; }

[0-9]+			{ icaplval.string = strdup(icaptext); return NUMBER; }

#.*\n			/* ignore comments */ ;

[a-zA-Z0-9_\-:\.,/\*]+	{ icaplval.string = strdup(icaptext); return TEXT; }
\"([^"\n]*)["\n]	{
				icaptext[icapleng - 1] = 0;
				icapleng -= 2;
				icaplval.string = strdup(icaptext+1);
				return TEXT;
			}

=			{ return '='; }

\n			{ return '\n'; }

