/*
SMS Server Tools 3
Copyright (C) Keijo Kasvi
http://smstools3.kekekasvi.com/

Based on SMS Server Tools 2 from Stefan Frings
http://www.meinemullemaus.de/

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.
*/

#ifndef CHARSET_H
#define CHARSET_H

char logch_buffer[8192];

// Logging is not used externally, but it's placed to the end of source file.
void logch(char* format, ...);
char prch(char ch);

// Both functions return the size of the converted string
// max limits the number of characters to be written into
// destination
// size is the size of the source string
// max is the maximum size of the destination string
// The GSM character set contains 0x00 as a valid character

int gsm2iso(char* source, int size, char* destination, int max);

int iso_utf8_2gsm(char* source, int size, char* destination, int max);
int iso2utf8_file(FILE *fp, char *ascii, int userdatalength);

int iso2gsm(char* source, int size, char* destination, int max);

int unicode2sms(char* source, int size, char* destination, int max);
int decode_ucs2(char *buffer, int len);

#endif
