/*
 * sisctrl - SiS Display Control Panel
 * for the SiS XFree86/X.org driver
 *
 * Dock part (gtk)
 *
 * (C) 2003-2005 Thomas Winischhofer <thomas@winischhofer.net>
 *
 * Inspired by and based on the GAIM "docklet" plugin (gaim.sf.net)
 *
 * Using the eggtray library which is
 *    Copyright (C) 2002 Anders Carlsson <andersca@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "sisc.h"

#ifdef USE_STRAY

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk-pixbuf-xlib/gdk-pixbuf-xlib.h>

#include "eggtrayicon.h"

#define EMBED_TIMEOUT 3000

#define EMBED_NOT_EMBEDDED 0
#define EMBED_EMBEDDED 1
#define EMBED_BUSY 2

/* How many times we try to re-connect after we have been destroyed */
#define STRAY_RETRY_COUNT 200

gboolean stray_init(char *tooltiptext);
gboolean stray_uninit(void);

/* Forward declarations */
static void stray_create(int retrycount);
static void stray_remove(void);
static void stray_destroy(void);
static void stray_clicked(int button_type);

/* Callbacks to the gui module */
extern void gui_stray_being_removed(void);
extern GdkPixbuf *gui_stray_get_icon_pixbuf(void);
extern void gui_stray_left_mouse_button(void);
extern void gui_stray_right_mouse_button(void);
extern void gui_embedding_failed(void);

/* Global variables */
static EggTrayIcon *stray  = NULL;
static GtkWidget   *image  = NULL;
static GdkPixbuf   *pixbuf = NULL;
#if 0
static GtkWidget   *fixed = NULL;
#endif
#if 0
static GtkWidget   *bg_image = NULL;
#endif
GtkWidget *box;

char   straytooltiptext[100];
static int embed_timeout = 0;
static int embedded = 0;
static int create_retry_count = 0;

/**************************************************
 *                   Callbacks                    *
 **************************************************/

static gboolean
stray_create_callback()
{
    stray_create(create_retry_count);
    return FALSE;
}

static void
stray_embedded_callback(GtkWidget *widget, void *data)
{
#if 0
    EggTrayIcon *icon = EGG_TRAY_ICON(widget);
    XWindowAttributes wa;
    Window plugwindow;
    GdkPixbuf *bg_pixbuf;
    GdkWindow *gdkwin;
    Display *xdisplay;
    Window root, parent;
    Window *children;
    unsigned int nchildren, i;
    GList *list;
    GdkImage *gdkimage;
#endif

    g_source_remove(embed_timeout);
    embed_timeout = 0;
    embedded = EMBED_EMBEDDED;

#if 0
#if GTK_CHECK_VERSION(2,1,0)
    xdisplay = GDK_DISPLAY_XDISPLAY(gtk_widget_get_display (GTK_WIDGET (icon)));
#else
    xdisplay = gdk_display;
#endif

    plugwindow = gtk_plug_get_id(GTK_PLUG(&icon->parent_instance));

    XGetWindowAttributes(xdisplay, plugwindow, &wa);
    fprintf(stderr, "x %d y %d w %d h %d\n", wa.x, wa.y, wa.width, wa.height);

    XQueryTree(xdisplay, plugwindow, &root, &parent, &children, &nchildren);
    XGetWindowAttributes(xdisplay, parent, &wa);
    fprintf(stderr, "x %d y %d w %d h %d (kids %d)\n", wa.x, wa.y, wa.width, wa.height, nchildren);

    gtk_widget_hide(box);

    gtk_main_iteration_do(FALSE);
    gtk_main_iteration_do(FALSE);

    gdkimage = gdk_drawable_copy_to_image(gdk_window_foreign_new(parent),
    			NULL, wa.x, wa.y, 0, 0, wa.width, wa.height);

    bg_image = gtk_image_new_from_image(gdkimage, NULL);

    gtk_container_add(GTK_CONTAINER(box), bg_image);
    /* gdk_image_destroy(gdkimage); */

    gtk_widget_show_all(widget);
    gtk_main_iteration_do(FALSE);
    gtk_main_iteration_do(FALSE);


#if 0
    if(!(gdkwin = gdk_window_lookup(plugwindow))) {
       fprintf(stderr, "need new for plugwindow\n");
       gdkwin = gdk_window_foreign_new(plugwindow);
    }
    gdk_window_set_back_pixmap(gdkwin, NULL, TRUE);
    gdk_window_clear(gdkwin);
    if((list = gdk_window_peek_children(gdkwin))) {
       while(list) {
          fprintf(stderr, "kid\n");
          gdkwin = GDK_WINDOW(list->data);
          gdk_window_set_back_pixmap(gdkwin, NULL, TRUE);
          gdk_window_clear(gdkwin);
          list = list->next;
       }
    }
#endif

#if 0
    if(!(gdkwin = gdk_window_lookup(plugwindow))) {
       fprintf(stderr, "need new for plugwindow\n");
       gdkwin = gdk_window_foreign_new(plugwindow);
    }
    gdk_window_set_back_pixmap(gdkwin, NULL, TRUE);
    /* gdk_window_clear(gdkwin); */
    for(i = 0; i < nchildren; i++) {
       Bool didit = FALSE;
       if(!(gdkwin = gdk_window_lookup(children[i]))) {
          gdkwin = gdk_window_foreign_new(children[i]);
          fprintf(stderr, "need new for kid %d\n", i);
          didit = TRUE;
       }
       gdk_window_set_back_pixmap(gdkwin, NULL, TRUE);
       /* gdk_window_clear(gdkwin); */
       if(didit) g_object_unref(gdkwin);
    }

    /* gtk_widget_hide_all(widget); */

    gtk_widget_show_all(widget);
#endif

#if 0
    /* XSetWindowBackground(xdisplay, plugwindow, 0x0000ff00); */
    XSetWindowBackgroundPixmap(xdisplay, plugwindow, ParentRelative);
    XClearWindow(xdisplay, plugwindow);
    for(i = 0; i < nchildren; i++) {
       /* XSetWindowBackground(xdisplay, children[i], 0x0000ff00); */
       XSetWindowBackgroundPixmap(xdisplay, children[i], ParentRelative);
       XClearWindow(xdisplay, children[i]);
    }
    XFlush(xdisplay);
#endif

    if(nchildren) XFree(children);

#if 0
    /* bg_pixbuf = gdk_pixbuf_xlib_get_from_drawable(NULL, parent, 0, NULL, 0, 0, 0, 0, wa.width, wa.height); */
    gtk_image_set_from_pixbuf(GTK_IMAGE(bg_image), bg_pixbuf);
    g_object_unref(bg_pixbuf);
#endif
#endif
}

static void
stray_destroyed_callback(GtkWidget *widget, void *data)
{
    stray_remove();

    g_object_unref(G_OBJECT(stray));
    stray = NULL;

    create_retry_count = STRAY_RETRY_COUNT;
    g_idle_add(stray_create_callback, NULL);
}

static void
stray_clicked_callback(GtkWidget *button, GdkEventButton *event, void *data)
{
    if(event->type != GDK_BUTTON_PRESS) return;

    stray_clicked(event->button);
}

static gboolean
stray_embed_timeout_callback(void)
{
    stray_destroy();
    if(create_retry_count-- > 0) {
       g_idle_add(stray_create_callback, NULL);
    } else {
       gui_embedding_failed();
    }
    return FALSE;
}

/**************************************************
 *               Create/destroy stray              *
 **************************************************/

static void
stray_remove(void)
{
    gui_stray_being_removed();
}

static void
stray_destroy(void)
{
    if(!stray) return;

    stray_remove();

    g_signal_handlers_disconnect_by_func(G_OBJECT(stray), G_CALLBACK(stray_destroyed_callback), NULL);

    gtk_widget_destroy(GTK_WIDGET(stray));

    g_object_unref(G_OBJECT(stray));

    stray = NULL;

    image = NULL;

    embedded = EMBED_NOT_EMBEDDED;
}

static void
stray_create(int retrycount)
{
    /* GtkWidget *box; */
    GtkTooltips *mytooltips;

    embedded = EMBED_BUSY;

    /* If the tray icon - for some reason - already exists, destroy it first */
    if(stray) stray_destroy();

    stray = egg_tray_icon_new("SiSCtrl");

#if 0
    fixed = gtk_fixed_new();
    gtk_fixed_set_has_window(GTK_FIXED(fixed), TRUE);

    bg_image = gtk_image_new();
    gtk_fixed_put(GTK_FIXED(fixed), bg_image, 0, 0);
#endif

    box = gtk_event_box_new();
    if(!gtk_check_version(2,4,0)) {
       g_object_set(G_OBJECT(box), "visible-window", FALSE, NULL);
    } else {
       gtk_event_box_set_visible_window(GTK_EVENT_BOX(box), FALSE);
    }

    image = gtk_image_new();

    g_signal_connect(G_OBJECT(stray), "embedded", G_CALLBACK(stray_embedded_callback), NULL);
    g_signal_connect(G_OBJECT(stray), "destroy", G_CALLBACK(stray_destroyed_callback), NULL);
    g_signal_connect(G_OBJECT(box),  "button-press-event", G_CALLBACK(stray_clicked_callback), NULL);

    gtk_container_add(GTK_CONTAINER(box), image);

#if 0
    /* gtk_fixed_put(GTK_FIXED(fixed), box, 0, 0); */
    gtk_container_add(GTK_CONTAINER(fixed), box);
    gtk_container_add(GTK_CONTAINER(stray), fixed);
#else
    gtk_container_add(GTK_CONTAINER(stray), box);
#endif

    mytooltips = gtk_tooltips_new();
    gtk_tooltips_set_tip(GTK_TOOLTIPS(mytooltips), box, straytooltiptext, NULL);

    gtk_widget_show_all(GTK_WIDGET(stray));

    g_object_ref(G_OBJECT(stray));

    /* Now create the icon pixbuf and update the icon */
    pixbuf = gui_stray_get_icon_pixbuf();
    gtk_image_set_from_pixbuf(GTK_IMAGE(image), pixbuf);

    g_object_unref(G_OBJECT(pixbuf));
    pixbuf = NULL;

    /* Now connect a timeout within which we must be embedded; otherwise consider failure */
    create_retry_count = retrycount;
    embed_timeout = g_timeout_add(EMBED_TIMEOUT, (GSourceFunc)stray_embed_timeout_callback, NULL);
}

/**************************************************
 *            "clicked" signal handler            *
 **************************************************/

static void
stray_clicked(int button_type)
{
   switch (button_type) {
   case 1:
       gui_stray_left_mouse_button();
       break;
   case 3:
       gui_stray_right_mouse_button();
       break;
   }
}

gboolean
stray_is_embedded(void)
{
   return embedded ? TRUE : FALSE;
}

/* Menu position calculator: Calculates where
 * out pop-up menu should appear
 * Shamelessly copied from gaim docklet plugin.
 */
#if GTK_CHECK_VERSION(2,2,0)
void
stray_position_menu(GtkMenu *menu, int *x, int *y, gboolean *push_in,
						  gpointer user_data)
{
    GtkWidget *widget = GTK_WIDGET(stray);
    GtkRequisition req;
    gint menu_xpos, menu_ypos;

    gtk_widget_size_request(GTK_WIDGET(menu), &req);
    gdk_window_get_origin(widget->window, &menu_xpos, &menu_ypos);

    menu_xpos += widget->allocation.x;
    menu_ypos += widget->allocation.y;

    if(menu_ypos > gdk_screen_get_height(gtk_widget_get_screen(widget)) / 2)
       menu_ypos -= req.height;
    else
       menu_ypos += widget->allocation.height;

    *x = menu_xpos;
    *y = menu_ypos;

    *push_in = TRUE;
}
#endif

/**************************************************
 *                     main()                     *
 **************************************************/

gboolean
stray_init(char *straytooltipt)
{
   strncpy(straytooltiptext, straytooltipt, 100);
   stray_create(1);
   return TRUE;
}

gboolean
stray_uninit(void)
{
   stray_destroy();
   return TRUE;
}

#endif  /* USE_STRAY */




