/*   -*- c -*-
 *
 *  ----------------------------------------------------------------------
 *  Efficient list operations for structures with one link pointer.
 *  Functions that can be implemented also as macros.
 *  ----------------------------------------------------------------------
 *  Created	 : Wed Nov 22 13:53:13 1995 tri
 *  Last modified: Thu Jun 18 13:24:19 1998 tri
 *  ----------------------------------------------------------------------
 *  Copyright  1995-1998
 *  Timo J. Rinne <tri@iki.fi>
 *  All rights reserved.  See file COPYRIGHT for details.
 *
 *  Address: Cirion oy, PO-BOX 250, 00121 Helsinki, Finland
 *  ----------------------------------------------------------------------
 *  Any express or implied warranties are disclaimed.  In no event
 *  shall the author be liable for any damages caused (directly or
 *  otherwise) by the use of this software.
 *
 *  Please, send your patches to <tri@iki.fi>.
 *  ----------------------------------------------------------------------
 *
 * $Id: trq_list.c,v 1.1.1.1 2000/10/31 19:59:30 priikone Exp $
 *
 * $Log: trq_list.c,v $
 * Revision 1.1.1.1  2000/10/31 19:59:30  priikone
 * 	Imported TRQ and SilList and SilcDList API's.
 *
 * Revision 1.9  1998/06/22 07:15:32  tri
 * trq_list_member_p -> trq_list_member
 * trq_deque_member_p -> trq_deque_member
 * trq_list_pointer_valid_p -> trq_list_pointer_valid
 * trq_list_compatible_p -> trq_list_compatible
 * trq_deque_compatible_p -> trq_deque_compatible
 *
 * Revision 1.8  1998/06/21 15:26:25  tri
 * Changed symbol names of function versions of the trq_calls.
 *
 * Revision 1.7  1998/06/18 10:27:17  tri
 * Added trq_list_pointer_invalidate.
 *
 * Revision 1.6  1998/06/18 07:22:12  tri
 * Heavy rethinking of the concepts in the deque
 * and the list.  For now on both deque and list
 * start from `tail' and end to `head'.  Sorting
 * functions make order ascending from tail to head.
 * Moving list pointer forward, move it towards head
 * and moving it backwards move it towards tail.
 *
 * Terms head and tail are utilized also in lists
 * replacing old `first' and `last'.
 *
 * Now they should make sense.
 *
 * Revision 1.5  1998/04/23 14:07:56  tri
 * Made single TRQ_USE_FUNCTIONS instead of
 * separate one for lists and deques.
 *
 * Revision 1.4  1998/04/17 15:38:30  tri
 * Renamed trq_list_get_backward and trq_list_get_forward to
 * trq_list_get_bw and trq_list_get_fw accordingly.
 *
 * Revision 1.3  1998/04/17 13:28:16  tri
 * Removed func_trq_list_member.
 *
 * Revision 1.2  1998/04/17 08:51:57  tri
 * Types `deque' and `list' and constants `DEQUE_NO_ITEM'
 * and `LIST_NO_ITEM' prefixed with `trq_' and `TRQ_'
 * accordingly.
 *
 * Revision 1.1	 1998/04/16 14:39:42  tri
 * Initial revision
 *
 *
 */

#ifdef TRQ_USE_FUNCTIONS
#  undef TRQ_USE_FUNCTIONS
#endif
#define TRQ_USE_FUNCTIONS	0

#include <trq_list.h>

int trq_list_clear___func(trq_list *L)
{
    (void)trq_list_clear(L);
}

int trq_list_rewind___func(trq_list *L)
{
    return trq_list_rewind(L);
}

int trq_list_end___func(trq_list *L)
{
    return trq_list_end(L);
}

int trq_list_length___func(trq_list *L)
{
    return trq_list_length(L);
}

int trq_list_pointer_valid___func(trq_list *L)
{
    return trq_list_pointer_valid(L);
}

int trq_list_pointer_invalidate___func(trq_list *L)
{
    return trq_list_pointer_invalidate(L);
}

int trq_list_insert_head___func(trq_list *L, void *b)
{
    return trq_list_insert_head(L, b);
}

int trq_list_insert_tail___func(trq_list *L, void *b)
{
    return trq_list_insert_tail(L, b);
}

void *trq_list_get_head___func(trq_list *L)
{
    return trq_list_get_head(L);
}

void *trq_list_get_tail___func(trq_list *L)
{
    return trq_list_get_tail(L);
}

int trq_list_put_before___func(trq_list *L, void *b)
{
    return trq_list_put_before(L, b);
}

int trq_list_put_after___func(trq_list *L, void *b)
{
    return trq_list_put_after(L, b);
}

void *trq_list_get_fw___func(trq_list *L)
{
    return trq_list_get_fw(L);
}

void *trq_list_get_bw___func(trq_list *L)
{
    return trq_list_get_bw(L);
}

int trq_list_remove___func(trq_list *L, void *b)
{
    return trq_list_remove(L, b);
}

int trq_list_compatible___func(trq_list *L1, trq_list *L2)
{
    return trq_list_compatible(L1, L2);
}

void *trq_list_current___func(trq_list *L)
{
    return trq_list_current(L);
}

/* eof (trq_list.c) */
