#ifndef XPOSIX_H
#define XPOSIX_H

#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>

/* Get setmode() and O_BINARY if they are available. */
#if defined (_WIN32) || defined (__CYGWIN__)
#   include <io.h>
#   include <fcntl.h>
#endif


/* By default, Windows sets stdin and stdout to text-mode.  This
 * function lets you switch the streams to binary mode. */
#ifdef O_BINARY
    extern void x_setmode(int fd, int mode);
#else
#   define x_setmode(fd, mode)
#endif

extern int
xopen(const char* path, int flags, mode_t mode);

extern int
xclose(int fd);

extern ssize_t
xread(int fd, void* buf, size_t buf_size);

extern ssize_t
xwrite(int fd, const void* buf, size_t buf_size);

extern pid_t
xfork(void);

extern int
xpipe(int fds[2]);

extern int
xdup2(int src, int dst);

extern int
xselect(int n, fd_set* rset, fd_set* wset, fd_set* eset, struct timeval* t);

extern int
xsigemptyset(sigset_t* s);

extern int
xsigaction(int num, const struct sigaction* act, struct sigaction* oact);

extern int
xsigsuspend(const sigset_t* mask);

extern void*
xmalloc(size_t buffer_size);

extern void*
xcalloc(size_t count, size_t size_of_each);

extern void*
xrealloc(void* buffer, size_t buffer_size);

extern int
xsetenv(const char* name, const char* value, int overwrite);

extern const char*
xbasename(const char* path);

extern int
xgetchar(void);


#endif  /*  XPOSIX_H  */
