/*
 * This is an implementation of the znum interface.  It uses the
 * libcalc arbitrary precision library to make sure there are no
 * issues with overflow.  Unless you are building shunt for inclusion
 * on a disaster recovery floppy, you should enable the use of
 * libcalc.  You enable it by enabling the BUILD_SHUNT_USING_LIBCALC
 * macro in Config.mk.
 */

#include "../xposix/xposix.h"
#include "znum_calc_p.h"

extern void
znum_initialize(void)
{
    libcalc_call_me_first();
}

extern void
znum_finalize(void)
{
    libcalc_call_me_last();
}

extern znum_t
znum_new(void)
{
    znum_t zn = xcalloc(1, sizeof(*zn));
    zn->n = _zero_;
    return zn;
}

extern void
znum_delete(znum_t zn)
{
    zfree(zn->n);
    free(zn);
}

extern void
znum_increment(znum_t zn)
{
    ZVALUE tmp = _zero_;
    zcopy(zn->n, &tmp);
    zfree(zn->n);
    zadd(tmp, _one_, &zn->n);
    zfree(tmp);
}

extern const char*
znum_as_string(znum_t zn)
{
    const char* rv = NULL;
    math_divertio();
    zprintval(zn->n, 0, 0);
    rv = math_getdivertedio();
    return rv;
}

extern void
znum_delete_string(const char* s)
{
    freeh(s);
}
