#ifndef ZNUM_H
#define ZNUM_H

/*
 * This is the abstract class interface header for znum.  Current
 * concrete implementations of this class can be found in znum_*.c.
 * You should only have one of the implementations linked into your
 * binary.  You select the implementation via the macros in the
 * Config.mk file.
 */

typedef struct znum* znum_t;

/* You MUST call this exactly once before calling any of the other
 * methods below. */
extern void
znum_initialize(void);

/* You SHOULD call this exactly once after you are through will all
 * your znum instances. */
extern void
znum_finalize(void);

/* Return new opaque pointer to implementation object. */
extern znum_t
znum_new(void);

/* Free any memory allocated by the implementation. */
extern void
znum_delete(znum_t zn);

/* Add one to zn. */
extern void
znum_increment(znum_t zn);

/* Convert zn into a string.  The caller is responsible for calling
 * znum_delete_string() on the pointer returned. */
extern const char*
znum_as_string(znum_t zn);

/* Used to call the (possibly) implementation-dependent deallocation
 * function. */
extern void
znum_delete_string(const char* s);

#endif  /*  ZNUM_H  */
