#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include "strerr.h"
#include "buffer.h"
#include "open.h"
#include "readwrite.h"
#include "exit.h"
#include "auto_home.h"
#include "generic-conf.h"
#include "fmt.h"

#define FATAL "cgi-config: fatal: "

char strnum[FMT_ULONG];

void usage(void)
{
  strerr_die1x(100,"cgi-config: usage: cgi-config user loguser dir port child");
}

char *dir;
char *fn;
char buf[1024];
int fd;
buffer ss;

char *user;
char *port;
char *loguser;
struct passwd *pw;

main(int argc,char **argv)
{
  umask(022);
  
  user = argv[1];
  if (!user) usage();
  loguser = argv[2];
  if (!loguser) usage();
  dir = argv[3];
  if (!dir) usage();
  if (dir[0] != '/') usage();
  port = argv[4];
  if (!port) usage();
  if (!argv[5]) usage();

  pw = getpwnam(loguser);
  if (!pw)
    strerr_die3x(111,FATAL,"unknown account ",loguser);

  init(dir,FATAL);
  makelog(loguser,pw->pw_uid,pw->pw_gid);

  pw = getpwnam(user);
  if (!pw)
    strerr_die3x(111,FATAL,"unknown account ",loguser);

  start("run");
  outs("#!/bin/sh\nexec 2>&1\nexec envdir "); outs(dir);
  outs("/env softlimit -o20 -d50000 tcpserver -vDRHl0 -b50 -c100 0 ");
  outs(port); outs(" "); outs(auto_home); outs("/bin/cgi-httpd");
  argv += 5;
  for (;;) {
    if (!*argv) break;
    outs(" "); outs(*argv);
    ++argv;
  }
  outs("\n");
  finish();
  perm(0755);

  makedir("env");
  perm(02755);

  start("env/ROOT");
  outs(dir); outs("/root\n");
  finish();
  perm(0644);

  start("env/UID");
  out(strnum,fmt_ulong(strnum,pw->pw_uid));
  finish();
  perm(0644);

  start("env/GID");
  out(strnum,fmt_ulong(strnum,pw->pw_gid));
  finish();
  perm(0644);

  makedir("root");
  perm(02755);

  makedir("root/host");
  perm(02755);

  makedir("root/bin");
  perm(02755);

  _exit(0);
}
