#!/bin/sh

SHORTEN=../src/shorten

if [ ! -x "$SHORTEN" ]; then
  echo "*** $SHORTEN is missing, please build it ***"
  exit 1
fi

echo ""
echo "========================  General shorten tests  ========================="
echo ""

for dir in mono stereo; do

  echo "+ Running general shorten tests against $dir benchmark files..."

  if [ ! -f "$dir/test.shn" ] ||  [ ! -f "$dir/test.skt" ] ||  [ ! -f "$dir/test.wav" ]; then
    echo "*** Missing test files, cannot continue... ***"
    exit 1
  fi

  # sanity checks
  $SHORTEN -x $dir/test.shn tmp.wav || exit 1
  cmp $dir/test.wav tmp.wav || exit 1
  $SHORTEN -v2 $dir/test.wav tmp.shn || exit 1
  cmp $dir/test.shn tmp.shn || exit 1

  # miscellaneous option checks
  $SHORTEN -v2 -t wav tmp.wav - | cmp - $dir/test.shn || exit 1
  $SHORTEN -a2 -t s16 tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -a1024 -t s16x   tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -b1024 -t u16    tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -b 4   -t u16x   tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -m 0   -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -m 32  -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -v 0   -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -v 1   -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -v 2   -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -p1    -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -p16   -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -p16 -v2 -ts16hl tmp.wav -| $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tulaw  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -talaw  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -ts8    tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tu8    tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -ts16   tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tu16   tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tu16x  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -ts16hl tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tu16hl tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -ts16lh tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tu16lh tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -c2 -tulaw tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -c2 -talaw tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -a340 -c16 tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -c2 -p4 -tu16 -b5 tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -v2 -t ulaw tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -v2 -t alaw tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -q3 -v2 tmp.wav tmp_q3.shn || exit 1
  $SHORTEN -q3 < tmp.wav > tmp_q3.shn || exit 1
  $SHORTEN -x tmp_q3.shn - | $SHORTEN | cmp - tmp_q3.shn || exit 1
  $SHORTEN -x tmp_q3.shn - | $SHORTEN -q3 | cmp - tmp_q3.shn || exit 1
  $SHORTEN -r3 -v2 tmp.wav tmp_r3.shn || exit 1

  rm -f tmp_q3.shn tmp_r3.shn tmp.wav tmp.shn
done

exit 0
