#! /bin/sh

SHORTEN=../src/shorten

if [ ! -x "$SHORTEN" ]; then
  echo "*** $SHORTEN is missing, please build it ***"
  exit 1
fi

echo ""
echo "=======================  Seek table shorten tests  ======================="
echo ""

for dir in mono stereo; do

  echo "+ Running seek table tests against $dir benchmark files..."

  if [ ! -f "$dir/test.shn" ] ||  [ ! -f "$dir/test.skt" ] ||  [ ! -f "$dir/test.wav" ]; then
    echo "*** Missing test files, cannot continue... ***"
    exit 1
  fi

  $SHORTEN -Sseektest.skt $dir/test.shn || exit 1
  cmp seektest.skt $dir/test.skt || exit 1
  rm -f seektest.skt

  $SHORTEN $dir/test.wav seektest.shn || exit 1
  cmp seektest.shn $dir/seekable.shn || exit 1
  rm -f seektest.shn

done

exit 0
