/*
 * $Id: sipCommonCfgBase.c,v 1.2 2002/09/19 12:23:54 jku Rel $
 *
 * SNMP Module
 *
 * Note: this file originally auto-generated by mib2c using 
 * mib2c.sipdataset.conf 
 *
 * Copyright (C) 2001-2003 Fhg Fokus
 *
 * This file is part of ser, a free SIP server.
 *
 * ser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * For a license to use the ser software under conditions
 * other than those described here, or to purchase support for this
 * software, please contact iptel.org by e-mail at the following addresses:
 *    info@iptel.org
 *
 * ser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "snmp_mod.h"
#include <stdlib.h>

/* Table sipUriSupportedTable */
static netsnmp_table_data_set* sipUriSupportedTable;

static int initialize_table_sipUriSupportedTable();
static Netsnmp_Node_Handler sipUriSupportedTable_handler;

/* The dynamic handler table */
static struct sip_snmp_handler** sipUriSupportedTable_h;
/* The global handler (if owner decides to handle this table that way) */
static struct sip_snmp_handler* sipUriSupportedTable_gh;
/* The registration function and friends */
static int sipUriSupportedTable_reg(struct sip_snmp_handler *h, int op);
static int sipUriSupportedTable_addObj(struct sip_snmp_handler *h, int col);
static int sipUriSupportedTable_newRow(struct sip_snmp_handler *h);

/* Table sipFtrSupportedTable */
static netsnmp_table_data_set* sipFtrSupportedTable;

static int initialize_table_sipFtrSupportedTable();
static Netsnmp_Node_Handler sipFtrSupportedTable_handler;

/* The dynamic handler table */
static struct sip_snmp_handler** sipFtrSupportedTable_h;
/* The global handler (if owner decides to handle this table that way) */
static struct sip_snmp_handler* sipFtrSupportedTable_gh;
/* The registration function and friends */
static int sipFtrSupportedTable_reg(struct sip_snmp_handler *h, int op);
static int sipFtrSupportedTable_addObj(struct sip_snmp_handler *h, int col);
static int sipFtrSupportedTable_newRow(struct sip_snmp_handler *h);

/* Table sipPortTable */
static netsnmp_table_data_set* sipPortTable;

static int initialize_table_sipPortTable();
static Netsnmp_Node_Handler sipPortTable_handler;

/* The dynamic handler table */
static struct sip_snmp_handler** sipPortTable_h;
/* The global handler (if owner decides to handle this table that way) */
static struct sip_snmp_handler* sipPortTable_gh;
/* The registration function and friends */
static int sipPortTable_reg(struct sip_snmp_handler *h, int op);
static int sipPortTable_addObj(struct sip_snmp_handler *h, int col);
static int sipPortTable_newRow(struct sip_snmp_handler *h);

/** Initializes the sipCommonCfgBase module */
int init_sipCommonCfgBase()
{
	const char *func = "snmp_mod";
	/* here we initialize all the tables we're planning on supporting */
	if(initialize_table_sipUriSupportedTable() == -1) {
		LOG(L_ERR, "%s: Failed creating table sipUriSupportedTable\n", func);
		return -1;
	}
	if(initialize_table_sipFtrSupportedTable() == -1) {
		LOG(L_ERR, "%s: Failed creating table sipFtrSupportedTable\n", func);
		return -1;
	}
	if(initialize_table_sipPortTable() == -1) {
		LOG(L_ERR, "%s: Failed creating table sipPortTable\n", func);
		return -1;
	}
	return 0;
}

/** Initialize the sipUriSupportedTable table by defining it's contents and 
 * how it's structured */
static int initialize_table_sipUriSupportedTable()
{
	static oid sipUriSupportedTable_oid[] = {1,3,6,1,2,1,9990,1,1,3};
	size_t sipUriSupportedTable_oid_len = OID_LENGTH(sipUriSupportedTable_oid);
	const char *func = "snmp_mod";

	/* create the table structure itself */
	sipUriSupportedTable = netsnmp_create_table_data_set("sipUriSupportedTable");
	if(!sipUriSupportedTable) {
		LOG(L_ERR, "%s: Error creating table\n", func);
		return -1;
	}
	
	/***************************************************
	 * Adding indexes
	 */
	netsnmp_table_dataset_add_index(sipUriSupportedTable, ASN_INTEGER);
	netsnmp_table_dataset_add_index(sipUriSupportedTable, ASN_UNSIGNED);
	
	netsnmp_table_set_multi_add_default_row(
		sipUriSupportedTable,
		COLUMN_SIPURISUPPORTEDINDEX, ASN_UNSIGNED, 0, NULL, 0,
		COLUMN_SIPURISUPPORTED, ASN_OCTET_STR, 0, NULL, 0,
		0);
	
	/* registering the table with the master agent */
	/* note: if you don't need a subhandler to deal with any aspects
	 * of the request, change sipUriSupportedTable_handler to "NULL" */
	netsnmp_register_table_data_set(
			netsnmp_create_handler_registration(
				"sipUriSupportedTable", 
				sipUriSupportedTable_handler,
				sipUriSupportedTable_oid,
				sipUriSupportedTable_oid_len,
				HANDLER_CAN_RWRITE),
			sipUriSupportedTable, NULL);

	return 0;
}

/* Initializes the handler table. Returns the registration function for this 
 * table */
reg_handler init_sipUriSupportedTable_h()
{
	const char *func = "snmp_mod";
	sipUriSupportedTable_h = calloc(SIPURISUPPORTEDTABLE_COLUMNS+1,
		sizeof(struct sip_snmp_handler*));
	if(!sipUriSupportedTable_h) {
		LOG(L_ERR, "%s: Error initializing handler table: %s\n", 
			func, strerror(errno));
		return NULL;
	}

	return sipUriSupportedTable_reg;
}

/* Registration function. Called by snmp_register_handler() to register
 * objects belonging to this table. See snmp_handler.h for values of
 * op */
static int sipUriSupportedTable_reg(struct sip_snmp_handler *h, int op)
{
	const char *func = "snmp_mod";
	int col, i;
	static int first = 1;
	register struct sip_snmp_handler *c;

	if(!h) { 
		LOG(L_ERR, "%s: attemp to register invalid handler\n", func);
		return -1;
	}

	if(op == REG_OBJ) {
		if(!h->sip_obj || !h->sip_obj->value.voidp) {
			LOG(L_ERR, "%s: attemp to register invalid handler\n", func);
			return -1;
		}
		col = h->sip_obj->col; 
		if(col <1 || col > SIPURISUPPORTEDTABLE_COLUMNS) {
			LOG(L_ERR, "%s: attempt to register invalid column %d\n", 
				func, col);
			return -1;
		}

		/* add handler to table. We make copy to make everybody's life easier 
		 * (note that value is not copied) */
		if(!(sipUriSupportedTable_h[col] = snmp_clone_handler(h))) {
			LOG(L_ERR, "%s: Error registering handler: %s\n", func,
				strerror(errno));
			return -1;
		}

		if(sipUriSupportedTable_addObj(h, col) == -1) {
			LOG(L_ERR, "%s: Error adding new object to table\n", func);
			snmp_free_handler(sipUriSupportedTable_h[col]);
			sipUriSupportedTable_h[col] = NULL;
			return -1;
		}
	} else if(op == NEW_ROW) {
		if(!h->sip_obj || !h->sip_obj->value.voidp) {
			LOG(L_ERR, "%s: attemp to register invalid handler\n", func);
			return -1;
		}
		/* if there's global handler, no need to add the handlers */
		if(!sipUriSupportedTable_gh && first) {
			/* first time around, jump over indexes, and copy the handlers.
			 * (Indexes don't have handlers associated with them). The default
			 * index (e.g. applIndex) shouldn't be passed in, that's why
			 * we jump over one less index. */
			c = h;
			if(SIPURISUPPORTEDTABLE_INDEXES > 1) {
				for(i=1; i<SIPURISUPPORTEDTABLE_INDEXES; i++)
					c = c->next;
				col = 2;	/* 2nd or 3rd index will be at column 1 */
			} else
				col = 1;
			while(c) {
				/* if too many we ignore the rest */
				if(col > SIPURISUPPORTEDTABLE_COLUMNS) {
					LOG(L_ERR, "%s: Attempt to add too many objects to "
						"table row\n", func);
					return -1;
				}
				c->sip_obj->col = col;
				if(!(sipUriSupportedTable_h[col] = snmp_clone_handler(c))) {
					LOG(L_ERR, "%s: Error registering handler: %s\n", func,
						strerror(errno));
					return -1;
				}
				c = c->next;
				col++;
			}
			first = 0;
		}
		/* add the data */
		if(sipUriSupportedTable_newRow(h) == -1) {
			LOG(L_ERR, "%s: Error creating new table\n", func);
			return -1;
		}
	} else if(op == REG_TABLE) {
		if(!sipUriSupportedTable_gh)
			sipUriSupportedTable_gh = snmp_clone_handler(h);
		else
			memcpy(sipUriSupportedTable_gh, h, sizeof(struct sip_snmp_handler));
		if(!sipUriSupportedTable_gh) {
			LOG(L_ERR, "%s: Error registering table handler\n", func);
			return -1;
		}
		/* it's not necessary for the caller to create this, but we need
		 * it to pass info down to the handling function */
		if(!sipUriSupportedTable_gh->sip_obj) {
			sipUriSupportedTable_gh->sip_obj = calloc(1, 
					sizeof(struct sip_snmp_obj));
			if(!sipUriSupportedTable_gh->sip_obj) {
				LOG(L_ERR, "%s: Error registering table handler\n", func);
				free(sipUriSupportedTable_gh);
				sipUriSupportedTable_gh = NULL;
				return -1;
			}
		}
	} else {
		LOG(L_ERR, "%s: Invalid operation %d\n", func, op);
		return -1;
	}

	/* voila! */
	return 0;
}

/* Adds a new object to the table. If the row doesn't exist is created. 
 * Assumes all objects go to the same row, and all the objects are
 * new (replacing is done silently) */
static int sipUriSupportedTable_addObj(struct sip_snmp_handler *h, int col)
{
	static netsnmp_table_row *row = NULL;
	int applIndex;	/* Default index for most tables */
	int first = 0;
	const char *func = "snmp_mod";

	if(!row) {	/* First time. Create row and add indexes */
		/* Get index (applIndex). First since we don't need to undo it
		 * but it's still possible that it fails (e.g. if we get called 
		 * at the wrong time) */
		applIndex = ser_getApplIndex();
		if(applIndex == -1) {
			LOG(L_ERR, "%s: Failed getting table index\n", func);
			return -1;
		}
		/* XXX: If table has more indexes init them here and add
		 * a similar call to row_add_index() as below */

		/* Create the row */
		row = netsnmp_create_table_data_row();
		if(!row) {
			LOG(L_ERR, "%s: failed creating table row\n", func);
			return -1;
		}

		/* add the index(es) to the table */
		if(!netsnmp_table_row_add_index(row, ASN_INTEGER, &applIndex,
			sizeof(applIndex))) {
			LOG(L_ERR, "%s: Error adding index to row\n", func);
			netsnmp_table_data_delete_row(row);
			row = NULL;
			return -1;
		}

		first = 1;
	}

	/* sanity checks */
	if(col < 1 || col > SIPURISUPPORTEDTABLE_COLUMNS) {
		LOG(L_ERR, "%s: Invalid column %d to add new object\n", func, col);
		return -1;
	}
	if(!h || !h->sip_obj || !h->sip_obj->value.voidp) {
		LOG(L_ERR, "%s: Invalid object to add\n", func);
		return -1;
	}

	/* add object to row */
	if(netsnmp_set_row_column(row, col, ser_types[h->sip_obj->type], 
			h->sip_obj->value.voidp, h->sip_obj->val_len)
			!= SNMPERR_SUCCESS) {
		LOG(L_ERR, "%s: Error adding new object to table\n", func);
		return -1;
	}

	/* is it writable? */
	if(h->on_set)
		netsnmp_mark_row_column_writable(row, col, 1);

	/* If first time, add the row. Subsequent times don't need to do
	 * anything since the table just has a pointer to our local row.
	 * However, if indexes were to change then the row needs to be 
	 * replaced */
	if(first) {
		if(netsnmp_table_data_add_row(sipUriSupportedTable->table, row) != 
				SNMPERR_SUCCESS) {
			LOG(L_ERR, "%s: Error adding new row to table\n",func); 
			return -1;
		}
	}

	/* Fin */
	return 0;
}

/* Handles creation of new rows for the table */
static int sipUriSupportedTable_newRow(struct sip_snmp_handler *h)
{
	netsnmp_table_row *row;
	/* XXX: make sure applIndex is an index for your table */
	static int 	applIndex = -1;
	const char *func = "snmp_mod";
	register struct sip_snmp_handler *c;
	struct sip_snmp_obj *o;
	int i, col;

	/* get applIndex first */
	if(applIndex == -1) {
		applIndex = ser_getApplIndex();
		if(applIndex == -1) {
			LOG(L_ERR,"%s: Couldn't get application index, cannot create "
				"new row\n", func);
			return -1;
		}
	}

	/* create the row */
	row = netsnmp_create_table_data_row();
	if(!row) {
		LOG(L_ERR, "%s: Couldn't create new row, out of memory?\n", func);
		return -1;
	}

	/* add indexes */
	netsnmp_table_row_add_index(row, 
		ASN_INTEGER, &applIndex, sizeof(applIndex));
	c = h;
	for(i=1; i<SIPURISUPPORTEDTABLE_INDEXES; i++) {
		if(!c) {
			LOG(L_ERR, "%s: Not enought indexes passed, need %d\n", func,
				SIPURISUPPORTEDTABLE_INDEXES);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		if(!c->sip_obj || !c->sip_obj->value.voidp) {
			LOG(L_ERR, "%s: Invalid index passed\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}

		if(!netsnmp_table_row_add_index(row, ser_types[c->sip_obj->type],
			c->sip_obj->value.voidp, c->sip_obj->val_len)) {
			LOG(L_ERR, "%s: Error adding index to row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		c = c->next;
	}
	/* add the data. We start from the last index, all the way to the
	 * end of the linked list */
	c = h;
	for(i=2; i<SIPURISUPPORTEDTABLE_INDEXES; i++) 
		c = c->next;
	col = 1;
	while(c) {
		if(col > SIPURISUPPORTEDTABLE_COLUMNS) {
			LOG(L_ERR, "%s: Too many columns for new row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		o = c->sip_obj;
		if(!o || !o->value.voidp) {
			LOG(L_ERR, "%s: Invalid object to add to new row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		if(netsnmp_set_row_column(row, col, ser_types[o->type],
			o->value.voidp, o->val_len) != SNMPERR_SUCCESS) {
			LOG(L_ERR, "%s: Error adding object to row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		if(c->on_set)
			netsnmp_mark_row_column_writable(row, col, 1);

		/* next, please... */
		c = c->next;
		col++;
	}

	/* add the row to the table */
	if(netsnmp_table_data_add_row(sipUriSupportedTable->table, row) != 
			SNMPERR_SUCCESS) {
		LOG(L_ERR, "%s: Error adding new row to table\n", func);
		netsnmp_table_data_delete_row(row);
		return -1;
	}

	return 0;
}

/* only accepts read-only data */
int sipUriSupportedTable_replaceRow(
		struct sip_snmp_obj *idx,
		struct sip_snmp_obj *data)
{
	netsnmp_table_row *row;
	netsnmp_variable_list *idxs=NULL;
	struct sip_snmp_obj *o;
	int col;
	static int applIndex = -1;
	const char *func = "snmp_mod";

	if(applIndex == -1) {
		applIndex = ser_getApplIndex();
		if(applIndex == -1 ) {
			LOG(L_ERR, "%s: Error while looking for previous row\n", func);
			return -1;
		}
	}

	/* create index list */
	if(snmp_varlist_add_variable(&idxs, NULL, 0, ASN_INTEGER, 
			(u_char*)&applIndex, sizeof(applIndex)) == NULL) {
		LOG(L_ERR, "%s: Error while looking for previous row\n", func);
		return -1;
	}
	o = idx;
	while(o) {
		if(snmp_varlist_add_variable(&idxs, NULL, 0, ser_types[o->type],
			o->value.voidp, o->val_len) == NULL) {
			LOG(L_ERR, "%s: Error while looking for row to replace\n", func);
			snmp_free_var(idxs);
			return -1;
		}
		o = o->next;
	}

	/* find row */
	row = netsnmp_table_data_get(sipUriSupportedTable->table, idxs);
	if(!row) {
		LOG(L_ERR, "%s: Couldn't find row to replace\n", func);
		snmp_free_var(idxs);
		return -1;
	}
	snmp_free_var(idxs);

	/* add the data */
	o = data;
	col = 2;
	while(o) {
		if(col > SIPURISUPPORTEDTABLE_COLUMNS) {
			LOG(L_ERR, "%s: Too many columns to add\n", func);
			return -1;
		}
		if(!o->value.voidp) {
			LOG(L_ERR, "%s: Invalid object to add\n", func);
			return -1;
		}
		o->col = col;
		/* all previous objects are left in the row */
		if(netsnmp_set_row_column(row, col, ser_types[o->type],
			o->value.voidp, o->val_len) != SNMPERR_SUCCESS) {
			LOG(L_ERR, "%s: Error adding object to row\n", func);
			return -1;
		}
		o=o->next;
		col++;
	}

	return 0;
}

/** handles requests for the sipUriSupportedTable table.
 * For every request it checks the specified object to see if it has a
 * handler, and calls it */
static int sipUriSupportedTable_handler(
		netsnmp_mib_handler               *handler,
		netsnmp_handler_registration      *reginfo,
		netsnmp_agent_request_info        *reqinfo,
		netsnmp_request_info              *requests) 
{
	netsnmp_variable_list *var;
	netsnmp_table_request_info *table_info;
	struct sip_snmp_handler *h;
	struct sip_snmp_obj *o;
	const char *func = "snmp_mod";
	int res;
	void *tmp_val;
	size_t tmp_len;

	while(requests) {
		var = requests->requestvb;
		if(requests->processed != 0)
			goto next;
		table_info = netsnmp_extract_table_info(requests);
		if(!table_info)
			goto next;
		/* this is not an error, since table-walks work by trying to get
		 * things until we run off of it */
		if(table_info->colnum > SIPURISUPPORTEDTABLE_COLUMNS)
			goto next;

		/* Get the handler and its object */
		if(sipUriSupportedTable_gh) {
			h = sipUriSupportedTable_gh;
			/* sip_obj is valid since we create upon registration */
			h->sip_obj->opaque = (void*)sipUriSupportedTable_replaceRow;
		} else {
			h = sipUriSupportedTable_h[table_info->colnum];
			if(!h) 
				goto next;
		}
		o = h->sip_obj;
		if(!o) {	/* bad bad boy... */
			LOG(L_ERR, "%s: Found handler without an object!!!\n", func);
			goto next;
		}
		o->col = table_info->colnum;
		o->row = var->name[var->name_length-1];
		switch(reqinfo->mode) {
			case MODE_GET:
			case MODE_GETNEXT:
				if(!h->on_get) break;
				res = h->on_get(o, SER_GET);
				if(res == -1) {
					/* since we don't have a way of knowing what went wrong,
					 * just use a generic error code */
					netsnmp_set_request_error(reqinfo, requests,
							SNMP_ERR_RESOURCEUNAVAILABLE);
					break;
				} else if(res == 0)
					/* the handler has new value to pass back up */
					snmp_set_var_typed_value(var, ser_types[o->type],
							(u_char*)o->value.voidp, o->val_len);
				break;
			case MODE_SET_RESERVE1:
				/* NOTE: We don't require the handler for a on_reserve
				 * function since for our cases it seems that just
				 * checking the type is enough */

				/* First make sure handler wants SETs */
				if(!h->on_set) break;
				/* Check the type */
				if(requests->requestvb->type != ser_types[o->type]) {
					LOG(L_ERR, "%s: Wrong type on SET processing\n", func);
					netsnmp_set_request_error(reqinfo, requests,
							SNMP_ERR_WRONGTYPE);
					break;
				}
				break;
			case MODE_SET_ACTION: /* the real deal */
				if(!h->on_set) break;
				/* copy in the new value for the handler */
				tmp_val = o->value.voidp;
				tmp_len = o->val_len;
				o->value.voidp = requests->requestvb->val.string;
				o->val_len = requests->requestvb->val_len;
				if(h->on_set(o, SER_SET) == -1) {
					LOG(L_ERR, "%s: SET Handler for object failed\n", func);
					netsnmp_set_request_error(reqinfo, requests,
						SNMP_ERR_RESOURCEUNAVAILABLE);
					o->value.voidp = tmp_val;
					o->val_len = tmp_len;
					break;
				}
				o->value.voidp = tmp_val;
				o->val_len = tmp_len;
				break;
			case MODE_SET_UNDO:
				if(!h->on_end) {
					if(h->on_set) /*tsk, tsk, bad boy, gonna tell your mamma..*/
						LOG(L_ERR, "%s: Found object without UNDO handler\n",
							func);
					break;
				}
				/* no point in checking for errors since we're already on
				 * an error branch */
				h->on_end(o, SER_UNDO);
				break;
			case MODE_SET_COMMIT:
				/* Tell the handler is all good and it can safely free up
				 * any memory it may have allocated for UNDO */
				if(!h->on_end) 
					break;
				h->on_end(o, SER_COMMIT);
				break;
			case MODE_SET_FREE:
				/* We get here on failure from RESERVE1. Since there we only 
				 * chk for type correctness, there's nothing to do here */
				break;
		}
next:
		requests = requests->next;
	}
	return SNMP_ERR_NOERROR;
}
/** Initialize the sipFtrSupportedTable table by defining it's contents and 
 * how it's structured */
static int initialize_table_sipFtrSupportedTable()
{
	static oid sipFtrSupportedTable_oid[] = {1,3,6,1,2,1,9990,1,1,4};
	size_t sipFtrSupportedTable_oid_len = OID_LENGTH(sipFtrSupportedTable_oid);
	const char *func = "snmp_mod";

	/* create the table structure itself */
	sipFtrSupportedTable = netsnmp_create_table_data_set("sipFtrSupportedTable");
	if(!sipFtrSupportedTable) {
		LOG(L_ERR, "%s: Error creating table\n", func);
		return -1;
	}
	
	/***************************************************
	 * Adding indexes
	 */
	netsnmp_table_dataset_add_index(sipFtrSupportedTable, ASN_INTEGER);
	netsnmp_table_dataset_add_index(sipFtrSupportedTable, ASN_UNSIGNED);
	
	netsnmp_table_set_multi_add_default_row(
		sipFtrSupportedTable,
		COLUMN_SIPFTRSUPPORTEDINDEX, ASN_UNSIGNED, 0, NULL, 0,
		COLUMN_SIPFTRSUPPORTED, ASN_OCTET_STR, 0, NULL, 0,
		0);
	
	/* registering the table with the master agent */
	/* note: if you don't need a subhandler to deal with any aspects
	 * of the request, change sipFtrSupportedTable_handler to "NULL" */
	netsnmp_register_table_data_set(
			netsnmp_create_handler_registration(
				"sipFtrSupportedTable", 
				sipFtrSupportedTable_handler,
				sipFtrSupportedTable_oid,
				sipFtrSupportedTable_oid_len,
				HANDLER_CAN_RWRITE),
			sipFtrSupportedTable, NULL);

	return 0;
}

/* Initializes the handler table. Returns the registration function for this 
 * table */
reg_handler init_sipFtrSupportedTable_h()
{
	const char *func = "snmp_mod";
	sipFtrSupportedTable_h = calloc(SIPFTRSUPPORTEDTABLE_COLUMNS+1,
		sizeof(struct sip_snmp_handler*));
	if(!sipFtrSupportedTable_h) {
		LOG(L_ERR, "%s: Error initializing handler table: %s\n", 
			func, strerror(errno));
		return NULL;
	}

	return sipFtrSupportedTable_reg;
}

/* Registration function. Called by snmp_register_handler() to register
 * objects belonging to this table. See snmp_handler.h for values of
 * op */
static int sipFtrSupportedTable_reg(struct sip_snmp_handler *h, int op)
{
	const char *func = "snmp_mod";
	int col, i;
	static int first = 1;
	register struct sip_snmp_handler *c;

	if(!h) { 
		LOG(L_ERR, "%s: attemp to register invalid handler\n", func);
		return -1;
	}

	if(op == REG_OBJ) {
		if(!h->sip_obj || !h->sip_obj->value.voidp) {
			LOG(L_ERR, "%s: attemp to register invalid handler\n", func);
			return -1;
		}
		col = h->sip_obj->col; 
		if(col <1 || col > SIPFTRSUPPORTEDTABLE_COLUMNS) {
			LOG(L_ERR, "%s: attempt to register invalid column %d\n", 
				func, col);
			return -1;
		}

		/* add handler to table. We make copy to make everybody's life easier 
		 * (note that value is not copied) */
		if(!(sipFtrSupportedTable_h[col] = snmp_clone_handler(h))) {
			LOG(L_ERR, "%s: Error registering handler: %s\n", func,
				strerror(errno));
			return -1;
		}

		if(sipFtrSupportedTable_addObj(h, col) == -1) {
			LOG(L_ERR, "%s: Error adding new object to table\n", func);
			snmp_free_handler(sipFtrSupportedTable_h[col]);
			sipFtrSupportedTable_h[col] = NULL;
			return -1;
		}
	} else if(op == NEW_ROW) {
		if(!h->sip_obj || !h->sip_obj->value.voidp) {
			LOG(L_ERR, "%s: attemp to register invalid handler\n", func);
			return -1;
		}
		/* if there's global handler, no need to add the handlers */
		if(!sipFtrSupportedTable_gh && first) {
			/* first time around, jump over indexes, and copy the handlers.
			 * (Indexes don't have handlers associated with them). The default
			 * index (e.g. applIndex) shouldn't be passed in, that's why
			 * we jump over one less index. */
			c = h;
			if(SIPFTRSUPPORTEDTABLE_INDEXES > 1) {
				for(i=1; i<SIPFTRSUPPORTEDTABLE_INDEXES; i++)
					c = c->next;
				col = 2;	/* 2nd or 3rd index will be at column 1 */
			} else
				col = 1;
			while(c) {
				/* if too many we ignore the rest */
				if(col > SIPFTRSUPPORTEDTABLE_COLUMNS) {
					LOG(L_ERR, "%s: Attempt to add too many objects to "
						"table row\n", func);
					return -1;
				}
				c->sip_obj->col = col;
				if(!(sipFtrSupportedTable_h[col] = snmp_clone_handler(c))) {
					LOG(L_ERR, "%s: Error registering handler: %s\n", func,
						strerror(errno));
					return -1;
				}
				c = c->next;
				col++;
			}
			first = 0;
		}
		/* add the data */
		if(sipFtrSupportedTable_newRow(h) == -1) {
			LOG(L_ERR, "%s: Error creating new table\n", func);
			return -1;
		}
	} else if(op == REG_TABLE) {
		if(!sipFtrSupportedTable_gh)
			sipFtrSupportedTable_gh = snmp_clone_handler(h);
		else
			memcpy(sipFtrSupportedTable_gh, h, sizeof(struct sip_snmp_handler));
		if(!sipFtrSupportedTable_gh) {
			LOG(L_ERR, "%s: Error registering table handler\n", func);
			return -1;
		}
		/* it's not necessary for the caller to create this, but we need
		 * it to pass info down to the handling function */
		if(!sipFtrSupportedTable_gh->sip_obj) {
			sipFtrSupportedTable_gh->sip_obj = calloc(1, 
					sizeof(struct sip_snmp_obj));
			if(!sipFtrSupportedTable_gh->sip_obj) {
				LOG(L_ERR, "%s: Error registering table handler\n", func);
				free(sipFtrSupportedTable_gh);
				sipFtrSupportedTable_gh = NULL;
				return -1;
			}
		}
	} else {
		LOG(L_ERR, "%s: Invalid operation %d\n", func, op);
		return -1;
	}

	/* voila! */
	return 0;
}

/* Adds a new object to the table. If the row doesn't exist is created. 
 * Assumes all objects go to the same row, and all the objects are
 * new (replacing is done silently) */
static int sipFtrSupportedTable_addObj(struct sip_snmp_handler *h, int col)
{
	static netsnmp_table_row *row = NULL;
	int applIndex;	/* Default index for most tables */
	int first = 0;
	const char *func = "snmp_mod";

	if(!row) {	/* First time. Create row and add indexes */
		/* Get index (applIndex). First since we don't need to undo it
		 * but it's still possible that it fails (e.g. if we get called 
		 * at the wrong time) */
		applIndex = ser_getApplIndex();
		if(applIndex == -1) {
			LOG(L_ERR, "%s: Failed getting table index\n", func);
			return -1;
		}
		/* XXX: If table has more indexes init them here and add
		 * a similar call to row_add_index() as below */

		/* Create the row */
		row = netsnmp_create_table_data_row();
		if(!row) {
			LOG(L_ERR, "%s: failed creating table row\n", func);
			return -1;
		}

		/* add the index(es) to the table */
		if(!netsnmp_table_row_add_index(row, ASN_INTEGER, &applIndex,
			sizeof(applIndex))) {
			LOG(L_ERR, "%s: Error adding index to row\n", func);
			netsnmp_table_data_delete_row(row);
			row = NULL;
			return -1;
		}

		first = 1;
	}

	/* sanity checks */
	if(col < 1 || col > SIPFTRSUPPORTEDTABLE_COLUMNS) {
		LOG(L_ERR, "%s: Invalid column %d to add new object\n", func, col);
		return -1;
	}
	if(!h || !h->sip_obj || !h->sip_obj->value.voidp) {
		LOG(L_ERR, "%s: Invalid object to add\n", func);
		return -1;
	}

	/* add object to row */
	if(netsnmp_set_row_column(row, col, ser_types[h->sip_obj->type], 
			h->sip_obj->value.voidp, h->sip_obj->val_len)
			!= SNMPERR_SUCCESS) {
		LOG(L_ERR, "%s: Error adding new object to table\n", func);
		return -1;
	}

	/* is it writable? */
	if(h->on_set)
		netsnmp_mark_row_column_writable(row, col, 1);

	/* If first time, add the row. Subsequent times don't need to do
	 * anything since the table just has a pointer to our local row.
	 * However, if indexes were to change then the row needs to be 
	 * replaced */
	if(first) {
		if(netsnmp_table_data_add_row(sipFtrSupportedTable->table, row) != 
				SNMPERR_SUCCESS) {
			LOG(L_ERR, "%s: Error adding new row to table\n",func); 
			return -1;
		}
	}

	/* Fin */
	return 0;
}

/* Handles creation of new rows for the table */
static int sipFtrSupportedTable_newRow(struct sip_snmp_handler *h)
{
	netsnmp_table_row *row;
	/* XXX: make sure applIndex is an index for your table */
	static int 	applIndex = -1;
	const char *func = "snmp_mod";
	register struct sip_snmp_handler *c;
	struct sip_snmp_obj *o;
	int i, col;

	/* get applIndex first */
	if(applIndex == -1) {
		applIndex = ser_getApplIndex();
		if(applIndex == -1) {
			LOG(L_ERR,"%s: Couldn't get application index, cannot create "
				"new row\n", func);
			return -1;
		}
	}

	/* create the row */
	row = netsnmp_create_table_data_row();
	if(!row) {
		LOG(L_ERR, "%s: Couldn't create new row, out of memory?\n", func);
		return -1;
	}

	/* add indexes */
	netsnmp_table_row_add_index(row, 
		ASN_INTEGER, &applIndex, sizeof(applIndex));
	c = h;
	for(i=1; i<SIPFTRSUPPORTEDTABLE_INDEXES; i++) {
		if(!c) {
			LOG(L_ERR, "%s: Not enought indexes passed, need %d\n", func,
				SIPFTRSUPPORTEDTABLE_INDEXES);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		if(!c->sip_obj || !c->sip_obj->value.voidp) {
			LOG(L_ERR, "%s: Invalid index passed\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}

		if(!netsnmp_table_row_add_index(row, ser_types[c->sip_obj->type],
			c->sip_obj->value.voidp, c->sip_obj->val_len)) {
			LOG(L_ERR, "%s: Error adding index to row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		c = c->next;
	}
	/* add the data. We start from the last index, all the way to the
	 * end of the linked list */
	c = h;
	for(i=2; i<SIPFTRSUPPORTEDTABLE_INDEXES; i++) 
		c = c->next;
	col = 1;
	while(c) {
		if(col > SIPFTRSUPPORTEDTABLE_COLUMNS) {
			LOG(L_ERR, "%s: Too many columns for new row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		o = c->sip_obj;
		if(!o || !o->value.voidp) {
			LOG(L_ERR, "%s: Invalid object to add to new row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		if(netsnmp_set_row_column(row, col, ser_types[o->type],
			o->value.voidp, o->val_len) != SNMPERR_SUCCESS) {
			LOG(L_ERR, "%s: Error adding object to row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		if(c->on_set)
			netsnmp_mark_row_column_writable(row, col, 1);

		/* next, please... */
		c = c->next;
		col++;
	}

	/* add the row to the table */
	if(netsnmp_table_data_add_row(sipFtrSupportedTable->table, row) != 
			SNMPERR_SUCCESS) {
		LOG(L_ERR, "%s: Error adding new row to table\n", func);
		netsnmp_table_data_delete_row(row);
		return -1;
	}

	return 0;
}

/* only accepts read-only data */
int sipFtrSupportedTable_replaceRow(
		struct sip_snmp_obj *idx,
		struct sip_snmp_obj *data)
{
	netsnmp_table_row *row;
	netsnmp_variable_list *idxs=NULL;
	struct sip_snmp_obj *o;
	int col;
	static int applIndex = -1;
	const char *func = "snmp_mod";

	if(applIndex == -1) {
		applIndex = ser_getApplIndex();
		if(applIndex == -1 ) {
			LOG(L_ERR, "%s: Error while looking for previous row\n", func);
			return -1;
		}
	}

	/* create index list */
	if(snmp_varlist_add_variable(&idxs, NULL, 0, ASN_INTEGER, 
			(u_char*)&applIndex, sizeof(applIndex)) == NULL) {
		LOG(L_ERR, "%s: Error while looking for previous row\n", func);
		return -1;
	}
	o = idx;
	while(o) {
		if(snmp_varlist_add_variable(&idxs, NULL, 0, ser_types[o->type],
			o->value.voidp, o->val_len) == NULL) {
			LOG(L_ERR, "%s: Error while looking for row to replace\n", func);
			snmp_free_var(idxs);
			return -1;
		}
		o = o->next;
	}

	/* find row */
	row = netsnmp_table_data_get(sipFtrSupportedTable->table, idxs);
	if(!row) {
		LOG(L_ERR, "%s: Couldn't find row to replace\n", func);
		snmp_free_var(idxs);
		return -1;
	}
	snmp_free_var(idxs);

	/* add the data */
	o = data;
	col = 2;
	while(o) {
		if(col > SIPFTRSUPPORTEDTABLE_COLUMNS) {
			LOG(L_ERR, "%s: Too many columns to add\n", func);
			return -1;
		}
		if(!o->value.voidp) {
			LOG(L_ERR, "%s: Invalid object to add\n", func);
			return -1;
		}
		o->col = col;
		/* all previous objects are left in the row */
		if(netsnmp_set_row_column(row, col, ser_types[o->type],
			o->value.voidp, o->val_len) != SNMPERR_SUCCESS) {
			LOG(L_ERR, "%s: Error adding object to row\n", func);
			return -1;
		}
		o=o->next;
		col++;
	}

	return 0;
}

/** handles requests for the sipFtrSupportedTable table.
 * For every request it checks the specified object to see if it has a
 * handler, and calls it */
static int sipFtrSupportedTable_handler(
		netsnmp_mib_handler               *handler,
		netsnmp_handler_registration      *reginfo,
		netsnmp_agent_request_info        *reqinfo,
		netsnmp_request_info              *requests) 
{
	netsnmp_variable_list *var;
	netsnmp_table_request_info *table_info;
	struct sip_snmp_handler *h;
	struct sip_snmp_obj *o;
	const char *func = "snmp_mod";
	int res;
	void *tmp_val;
	size_t tmp_len;

	while(requests) {
		var = requests->requestvb;
		if(requests->processed != 0)
			goto next;
		table_info = netsnmp_extract_table_info(requests);
		if(!table_info)
			goto next;
		/* this is not an error, since table-walks work by trying to get
		 * things until we run off of it */
		if(table_info->colnum > SIPFTRSUPPORTEDTABLE_COLUMNS)
			goto next;

		/* Get the handler and its object */
		if(sipFtrSupportedTable_gh) {
			h = sipFtrSupportedTable_gh;
			/* sip_obj is valid since we create upon registration */
			h->sip_obj->opaque = (void*)sipFtrSupportedTable_replaceRow;
		} else {
			h = sipFtrSupportedTable_h[table_info->colnum];
			if(!h) 
				goto next;
		}
		o = h->sip_obj;
		if(!o) {	/* bad bad boy... */
			LOG(L_ERR, "%s: Found handler without an object!!!\n", func);
			goto next;
		}
		o->col = table_info->colnum;
		o->row = var->name[var->name_length-1];
		switch(reqinfo->mode) {
			case MODE_GET:
			case MODE_GETNEXT:
				if(!h->on_get) break;
				res = h->on_get(o, SER_GET);
				if(res == -1) {
					/* since we don't have a way of knowing what went wrong,
					 * just use a generic error code */
					netsnmp_set_request_error(reqinfo, requests,
							SNMP_ERR_RESOURCEUNAVAILABLE);
					break;
				} else if(res == 0)
					/* the handler has new value to pass back up */
					snmp_set_var_typed_value(var, ser_types[o->type],
							(u_char*)o->value.voidp, o->val_len);
				break;
			case MODE_SET_RESERVE1:
				/* NOTE: We don't require the handler for a on_reserve
				 * function since for our cases it seems that just
				 * checking the type is enough */

				/* First make sure handler wants SETs */
				if(!h->on_set) break;
				/* Check the type */
				if(requests->requestvb->type != ser_types[o->type]) {
					LOG(L_ERR, "%s: Wrong type on SET processing\n", func);
					netsnmp_set_request_error(reqinfo, requests,
							SNMP_ERR_WRONGTYPE);
					break;
				}
				break;
			case MODE_SET_ACTION: /* the real deal */
				if(!h->on_set) break;
				/* copy in the new value for the handler */
				tmp_val = o->value.voidp;
				tmp_len = o->val_len;
				o->value.voidp = requests->requestvb->val.string;
				o->val_len = requests->requestvb->val_len;
				if(h->on_set(o, SER_SET) == -1) {
					LOG(L_ERR, "%s: SET Handler for object failed\n", func);
					netsnmp_set_request_error(reqinfo, requests,
						SNMP_ERR_RESOURCEUNAVAILABLE);
					o->value.voidp = tmp_val;
					o->val_len = tmp_len;
					break;
				}
				o->value.voidp = tmp_val;
				o->val_len = tmp_len;
				break;
			case MODE_SET_UNDO:
				if(!h->on_end) {
					if(h->on_set) /*tsk, tsk, bad boy, gonna tell your mamma..*/
						LOG(L_ERR, "%s: Found object without UNDO handler\n",
							func);
					break;
				}
				/* no point in checking for errors since we're already on
				 * an error branch */
				h->on_end(o, SER_UNDO);
				break;
			case MODE_SET_COMMIT:
				/* Tell the handler is all good and it can safely free up
				 * any memory it may have allocated for UNDO */
				if(!h->on_end) 
					break;
				h->on_end(o, SER_COMMIT);
				break;
			case MODE_SET_FREE:
				/* We get here on failure from RESERVE1. Since there we only 
				 * chk for type correctness, there's nothing to do here */
				break;
		}
next:
		requests = requests->next;
	}
	return SNMP_ERR_NOERROR;
}
/** Initialize the sipPortTable table by defining it's contents and 
 * how it's structured */
static int initialize_table_sipPortTable()
{
	static oid sipPortTable_oid[] = {1,3,6,1,2,1,9990,1,1,2};
	size_t sipPortTable_oid_len = OID_LENGTH(sipPortTable_oid);
	const char *func = "snmp_mod";

	/* create the table structure itself */
	sipPortTable = netsnmp_create_table_data_set("sipPortTable");
	if(!sipPortTable) {
		LOG(L_ERR, "%s: Error creating table\n", func);
		return -1;
	}
	
	/***************************************************
	 * Adding indexes
	 */
	netsnmp_table_dataset_add_index(sipPortTable, ASN_INTEGER);
	netsnmp_table_dataset_add_index(sipPortTable, ASN_INTEGER);
	
	netsnmp_table_set_multi_add_default_row(
		sipPortTable,
		COLUMN_SIPPORT, ASN_INTEGER, 0, NULL, 0,
		COLUMN_SIPTRANSPORTRCV, ASN_OCTET_STR, 1, NULL, 0,
		COLUMN_SIPTRANSPORTSND, ASN_OCTET_STR, 1, NULL, 0,
		COLUMN_SIPPORTSTATUS, ASN_INTEGER, 1, NULL, 0,
		0);
	
	/* registering the table with the master agent */
	/* note: if you don't need a subhandler to deal with any aspects
	 * of the request, change sipPortTable_handler to "NULL" */
	netsnmp_register_table_data_set(
			netsnmp_create_handler_registration(
				"sipPortTable", 
				sipPortTable_handler,
				sipPortTable_oid,
				sipPortTable_oid_len,
				HANDLER_CAN_RWRITE),
			sipPortTable, NULL);

	return 0;
}

/* Initializes the handler table. Returns the registration function for this 
 * table */
reg_handler init_sipPortTable_h()
{
	const char *func = "snmp_mod";
	sipPortTable_h = calloc(SIPPORTTABLE_COLUMNS+1,
		sizeof(struct sip_snmp_handler*));
	if(!sipPortTable_h) {
		LOG(L_ERR, "%s: Error initializing handler table: %s\n", 
			func, strerror(errno));
		return NULL;
	}

	return sipPortTable_reg;
}

/* Registration function. Called by snmp_register_handler() to register
 * objects belonging to this table. See snmp_handler.h for values of
 * op */
static int sipPortTable_reg(struct sip_snmp_handler *h, int op)
{
	const char *func = "snmp_mod";
	int col, i;
	static int first = 1;
	register struct sip_snmp_handler *c;

	if(!h) { 
		LOG(L_ERR, "%s: attemp to register invalid handler\n", func);
		return -1;
	}

	if(op == REG_OBJ) {
		if(!h->sip_obj || !h->sip_obj->value.voidp) {
			LOG(L_ERR, "%s: attemp to register invalid handler\n", func);
			return -1;
		}
		col = h->sip_obj->col; 
		if(col <1 || col > SIPPORTTABLE_COLUMNS) {
			LOG(L_ERR, "%s: attempt to register invalid column %d\n", 
				func, col);
			return -1;
		}

		/* add handler to table. We make copy to make everybody's life easier 
		 * (note that value is not copied) */
		if(!(sipPortTable_h[col] = snmp_clone_handler(h))) {
			LOG(L_ERR, "%s: Error registering handler: %s\n", func,
				strerror(errno));
			return -1;
		}

		if(sipPortTable_addObj(h, col) == -1) {
			LOG(L_ERR, "%s: Error adding new object to table\n", func);
			snmp_free_handler(sipPortTable_h[col]);
			sipPortTable_h[col] = NULL;
			return -1;
		}
	} else if(op == NEW_ROW) {
		if(!h->sip_obj || !h->sip_obj->value.voidp) {
			LOG(L_ERR, "%s: attemp to register invalid handler\n", func);
			return -1;
		}
		/* if there's global handler, no need to add the handlers */
		if(!sipPortTable_gh && first) {
			/* first time around, jump over indexes, and copy the handlers.
			 * (Indexes don't have handlers associated with them). The default
			 * index (e.g. applIndex) shouldn't be passed in, that's why
			 * we jump over one less index. */
			c = h;
			if(SIPPORTTABLE_INDEXES > 1) {
				for(i=1; i<SIPPORTTABLE_INDEXES; i++)
					c = c->next;
				col = 2;	/* 2nd or 3rd index will be at column 1 */
			} else
				col = 1;
			while(c) {
				/* if too many we ignore the rest */
				if(col > SIPPORTTABLE_COLUMNS) {
					LOG(L_ERR, "%s: Attempt to add too many objects to "
						"table row\n", func);
					return -1;
				}
				c->sip_obj->col = col;
				if(!(sipPortTable_h[col] = snmp_clone_handler(c))) {
					LOG(L_ERR, "%s: Error registering handler: %s\n", func,
						strerror(errno));
					return -1;
				}
				c = c->next;
				col++;
			}
			first = 0;
		}
		/* add the data */
		if(sipPortTable_newRow(h) == -1) {
			LOG(L_ERR, "%s: Error creating new table\n", func);
			return -1;
		}
	} else if(op == REG_TABLE) {
		if(!sipPortTable_gh)
			sipPortTable_gh = snmp_clone_handler(h);
		else
			memcpy(sipPortTable_gh, h, sizeof(struct sip_snmp_handler));
		if(!sipPortTable_gh) {
			LOG(L_ERR, "%s: Error registering table handler\n", func);
			return -1;
		}
		/* it's not necessary for the caller to create this, but we need
		 * it to pass info down to the handling function */
		if(!sipPortTable_gh->sip_obj) {
			sipPortTable_gh->sip_obj = calloc(1, 
					sizeof(struct sip_snmp_obj));
			if(!sipPortTable_gh->sip_obj) {
				LOG(L_ERR, "%s: Error registering table handler\n", func);
				free(sipPortTable_gh);
				sipPortTable_gh = NULL;
				return -1;
			}
		}
	} else {
		LOG(L_ERR, "%s: Invalid operation %d\n", func, op);
		return -1;
	}

	/* voila! */
	return 0;
}

/* Adds a new object to the table. If the row doesn't exist is created. 
 * Assumes all objects go to the same row, and all the objects are
 * new (replacing is done silently) */
static int sipPortTable_addObj(struct sip_snmp_handler *h, int col)
{
	static netsnmp_table_row *row = NULL;
	int applIndex;	/* Default index for most tables */
	int first = 0;
	const char *func = "snmp_mod";

	if(!row) {	/* First time. Create row and add indexes */
		/* Get index (applIndex). First since we don't need to undo it
		 * but it's still possible that it fails (e.g. if we get called 
		 * at the wrong time) */
		applIndex = ser_getApplIndex();
		if(applIndex == -1) {
			LOG(L_ERR, "%s: Failed getting table index\n", func);
			return -1;
		}
		/* XXX: If table has more indexes init them here and add
		 * a similar call to row_add_index() as below */

		/* Create the row */
		row = netsnmp_create_table_data_row();
		if(!row) {
			LOG(L_ERR, "%s: failed creating table row\n", func);
			return -1;
		}

		/* add the index(es) to the table */
		if(!netsnmp_table_row_add_index(row, ASN_INTEGER, &applIndex,
			sizeof(applIndex))) {
			LOG(L_ERR, "%s: Error adding index to row\n", func);
			netsnmp_table_data_delete_row(row);
			row = NULL;
			return -1;
		}

		first = 1;
	}

	/* sanity checks */
	if(col < 1 || col > SIPPORTTABLE_COLUMNS) {
		LOG(L_ERR, "%s: Invalid column %d to add new object\n", func, col);
		return -1;
	}
	if(!h || !h->sip_obj || !h->sip_obj->value.voidp) {
		LOG(L_ERR, "%s: Invalid object to add\n", func);
		return -1;
	}

	/* add object to row */
	if(netsnmp_set_row_column(row, col, ser_types[h->sip_obj->type], 
			h->sip_obj->value.voidp, h->sip_obj->val_len)
			!= SNMPERR_SUCCESS) {
		LOG(L_ERR, "%s: Error adding new object to table\n", func);
		return -1;
	}

	/* is it writable? */
	if(h->on_set)
		netsnmp_mark_row_column_writable(row, col, 1);

	/* If first time, add the row. Subsequent times don't need to do
	 * anything since the table just has a pointer to our local row.
	 * However, if indexes were to change then the row needs to be 
	 * replaced */
	if(first) {
		if(netsnmp_table_data_add_row(sipPortTable->table, row) != 
				SNMPERR_SUCCESS) {
			LOG(L_ERR, "%s: Error adding new row to table\n",func); 
			return -1;
		}
	}

	/* Fin */
	return 0;
}

/* Handles creation of new rows for the table */
static int sipPortTable_newRow(struct sip_snmp_handler *h)
{
	netsnmp_table_row *row;
	/* XXX: make sure applIndex is an index for your table */
	static int 	applIndex = -1;
	const char *func = "snmp_mod";
	register struct sip_snmp_handler *c;
	struct sip_snmp_obj *o;
	int i, col;

	/* get applIndex first */
	if(applIndex == -1) {
		applIndex = ser_getApplIndex();
		if(applIndex == -1) {
			LOG(L_ERR,"%s: Couldn't get application index, cannot create "
				"new row\n", func);
			return -1;
		}
	}

	/* create the row */
	row = netsnmp_create_table_data_row();
	if(!row) {
		LOG(L_ERR, "%s: Couldn't create new row, out of memory?\n", func);
		return -1;
	}

	/* add indexes */
	netsnmp_table_row_add_index(row, 
		ASN_INTEGER, &applIndex, sizeof(applIndex));
	c = h;
	for(i=1; i<SIPPORTTABLE_INDEXES; i++) {
		if(!c) {
			LOG(L_ERR, "%s: Not enought indexes passed, need %d\n", func,
				SIPPORTTABLE_INDEXES);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		if(!c->sip_obj || !c->sip_obj->value.voidp) {
			LOG(L_ERR, "%s: Invalid index passed\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}

		if(!netsnmp_table_row_add_index(row, ser_types[c->sip_obj->type],
			c->sip_obj->value.voidp, c->sip_obj->val_len)) {
			LOG(L_ERR, "%s: Error adding index to row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		c = c->next;
	}
	/* add the data. We start from the last index, all the way to the
	 * end of the linked list */
	c = h;
	for(i=2; i<SIPPORTTABLE_INDEXES; i++) 
		c = c->next;
	col = 1;
	while(c) {
		if(col > SIPPORTTABLE_COLUMNS) {
			LOG(L_ERR, "%s: Too many columns for new row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		o = c->sip_obj;
		if(!o || !o->value.voidp) {
			LOG(L_ERR, "%s: Invalid object to add to new row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		if(netsnmp_set_row_column(row, col, ser_types[o->type],
			o->value.voidp, o->val_len) != SNMPERR_SUCCESS) {
			LOG(L_ERR, "%s: Error adding object to row\n", func);
			netsnmp_table_data_delete_row(row);
			return -1;
		}
		if(c->on_set)
			netsnmp_mark_row_column_writable(row, col, 1);

		/* next, please... */
		c = c->next;
		col++;
	}

	/* add the row to the table */
	if(netsnmp_table_data_add_row(sipPortTable->table, row) != 
			SNMPERR_SUCCESS) {
		LOG(L_ERR, "%s: Error adding new row to table\n", func);
		netsnmp_table_data_delete_row(row);
		return -1;
	}

	return 0;
}

/* only accepts read-only data */
int sipPortTable_replaceRow(
		struct sip_snmp_obj *idx,
		struct sip_snmp_obj *data)
{
	netsnmp_table_row *row;
	netsnmp_variable_list *idxs=NULL;
	struct sip_snmp_obj *o;
	int col;
	static int applIndex = -1;
	const char *func = "snmp_mod";

	if(applIndex == -1) {
		applIndex = ser_getApplIndex();
		if(applIndex == -1 ) {
			LOG(L_ERR, "%s: Error while looking for previous row\n", func);
			return -1;
		}
	}

	/* create index list */
	if(snmp_varlist_add_variable(&idxs, NULL, 0, ASN_INTEGER, 
			(u_char*)&applIndex, sizeof(applIndex)) == NULL) {
		LOG(L_ERR, "%s: Error while looking for previous row\n", func);
		return -1;
	}
	o = idx;
	while(o) {
		if(snmp_varlist_add_variable(&idxs, NULL, 0, ser_types[o->type],
			o->value.voidp, o->val_len) == NULL) {
			LOG(L_ERR, "%s: Error while looking for row to replace\n", func);
			snmp_free_var(idxs);
			return -1;
		}
		o = o->next;
	}

	/* find row */
	row = netsnmp_table_data_get(sipPortTable->table, idxs);
	if(!row) {
		LOG(L_ERR, "%s: Couldn't find row to replace\n", func);
		snmp_free_var(idxs);
		return -1;
	}
	snmp_free_var(idxs);

	/* add the data */
	o = data;
	col = 2;
	while(o) {
		if(col > SIPPORTTABLE_COLUMNS) {
			LOG(L_ERR, "%s: Too many columns to add\n", func);
			return -1;
		}
		if(!o->value.voidp) {
			LOG(L_ERR, "%s: Invalid object to add\n", func);
			return -1;
		}
		o->col = col;
		/* all previous objects are left in the row */
		if(netsnmp_set_row_column(row, col, ser_types[o->type],
			o->value.voidp, o->val_len) != SNMPERR_SUCCESS) {
			LOG(L_ERR, "%s: Error adding object to row\n", func);
			return -1;
		}
		o=o->next;
		col++;
	}

	return 0;
}

/** handles requests for the sipPortTable table.
 * For every request it checks the specified object to see if it has a
 * handler, and calls it */
static int sipPortTable_handler(
		netsnmp_mib_handler               *handler,
		netsnmp_handler_registration      *reginfo,
		netsnmp_agent_request_info        *reqinfo,
		netsnmp_request_info              *requests) 
{
	netsnmp_variable_list *var;
	netsnmp_table_request_info *table_info;
	struct sip_snmp_handler *h;
	struct sip_snmp_obj *o;
	const char *func = "snmp_mod";
	int res;
	void *tmp_val;
	size_t tmp_len;

	while(requests) {
		var = requests->requestvb;
		if(requests->processed != 0)
			goto next;
		table_info = netsnmp_extract_table_info(requests);
		if(!table_info)
			goto next;
		/* this is not an error, since table-walks work by trying to get
		 * things until we run off of it */
		if(table_info->colnum > SIPPORTTABLE_COLUMNS)
			goto next;

		/* Get the handler and its object */
		if(sipPortTable_gh) {
			h = sipPortTable_gh;
			/* sip_obj is valid since we create upon registration */
			h->sip_obj->opaque = (void*)sipPortTable_replaceRow;
		} else {
			h = sipPortTable_h[table_info->colnum];
			if(!h) 
				goto next;
		}
		o = h->sip_obj;
		if(!o) {	/* bad bad boy... */
			LOG(L_ERR, "%s: Found handler without an object!!!\n", func);
			goto next;
		}
		o->col = table_info->colnum;
		o->row = var->name[var->name_length-1];
		switch(reqinfo->mode) {
			case MODE_GET:
			case MODE_GETNEXT:
				if(!h->on_get) break;
				res = h->on_get(o, SER_GET);
				if(res == -1) {
					/* since we don't have a way of knowing what went wrong,
					 * just use a generic error code */
					netsnmp_set_request_error(reqinfo, requests,
							SNMP_ERR_RESOURCEUNAVAILABLE);
					break;
				} else if(res == 0)
					/* the handler has new value to pass back up */
					snmp_set_var_typed_value(var, ser_types[o->type],
							(u_char*)o->value.voidp, o->val_len);
				break;
			case MODE_SET_RESERVE1:
				/* NOTE: We don't require the handler for a on_reserve
				 * function since for our cases it seems that just
				 * checking the type is enough */

				/* First make sure handler wants SETs */
				if(!h->on_set) break;
				/* Check the type */
				if(requests->requestvb->type != ser_types[o->type]) {
					LOG(L_ERR, "%s: Wrong type on SET processing\n", func);
					netsnmp_set_request_error(reqinfo, requests,
							SNMP_ERR_WRONGTYPE);
					break;
				}
				break;
			case MODE_SET_ACTION: /* the real deal */
				if(!h->on_set) break;
				/* copy in the new value for the handler */
				tmp_val = o->value.voidp;
				tmp_len = o->val_len;
				o->value.voidp = requests->requestvb->val.string;
				o->val_len = requests->requestvb->val_len;
				if(h->on_set(o, SER_SET) == -1) {
					LOG(L_ERR, "%s: SET Handler for object failed\n", func);
					netsnmp_set_request_error(reqinfo, requests,
						SNMP_ERR_RESOURCEUNAVAILABLE);
					o->value.voidp = tmp_val;
					o->val_len = tmp_len;
					break;
				}
				o->value.voidp = tmp_val;
				o->val_len = tmp_len;
				break;
			case MODE_SET_UNDO:
				if(!h->on_end) {
					if(h->on_set) /*tsk, tsk, bad boy, gonna tell your mamma..*/
						LOG(L_ERR, "%s: Found object without UNDO handler\n",
							func);
					break;
				}
				/* no point in checking for errors since we're already on
				 * an error branch */
				h->on_end(o, SER_UNDO);
				break;
			case MODE_SET_COMMIT:
				/* Tell the handler is all good and it can safely free up
				 * any memory it may have allocated for UNDO */
				if(!h->on_end) 
					break;
				h->on_end(o, SER_COMMIT);
				break;
			case MODE_SET_FREE:
				/* We get here on failure from RESERVE1. Since there we only 
				 * chk for type correctness, there's nothing to do here */
				break;
		}
next:
		requests = requests->next;
	}
	return SNMP_ERR_NOERROR;
}
