/*
 * $Id: applTable.c,v 1.2 2002/09/19 12:23:54 jku Rel $
 * SNMP Module
 *
 * Note: this file originally auto-generated by mib2c using 
 * mib2c.sipdataset.conf 
 *
 * Copyright (C) 2001-2003 Fhg Fokus
 *
 * This file is part of ser, a free SIP server.
 *
 * ser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * For a license to use the ser software under conditions
 * other than those described here, or to purchase support for this
 * software, please contact iptel.org by e-mail at the following addresses:
 *    info@iptel.org
 *
 * ser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/* Works differently:
 * - First, the application registers with the table by calling 
 *   snmp_registerAppl(). This function returns the application
 *   index that it assigned in the table.
 * - Second, the rest of the objects are registered by calling
 *   applTable_reg(), which finds the correct row based on the
 *   passed index and adds the object to the table
 * - Doesn't allow a global handler, and to create new rows use
 *   snmp_registerAppl (registration function will fail on
 *   REG_TABLE and NEW_ROW)
 */

#include "snmp_mod.h"
#include <stdlib.h>

/* Table applTable */
static netsnmp_table_data_set* applTable;

static int initialize_table_applTable();
static Netsnmp_Node_Handler applTable_handler;

/* The dynamic handler table */
static struct sip_snmp_handler** applTable_h;
/* The registration function and friends */
static int applTable_reg(struct sip_snmp_handler *h, int op);
static int applTable_addObj(struct sip_snmp_handler *h, int col, int applIndex);

/** Initializes the applTable module */
int init_applTable()
{
	const char *func = "snmp_mod";
	/* here we initialize all the tables we're planning on supporting */
	if(initialize_table_applTable() == -1) {
		LOG(L_ERR, "%s: Failed creating table applTable\n", func);
		return -1;
	}
	return 0;
}

/** Initialize the applTable table by defining it's contents and 
 * how it's structured */
static int initialize_table_applTable()
{
	static oid applTable_oid[] = {1,3,6,1,2,1,27,1};
	size_t applTable_oid_len = OID_LENGTH(applTable_oid);
	const char *func = "snmp_mod";

	/* create the table structure itself */
	applTable = netsnmp_create_table_data_set("applTable");
	if(!applTable) {
		LOG(L_ERR, "%s: Error creating table\n", func);
		return -1;
	}
	
	/***************************************************
	 * Adding indexes
	 */
	netsnmp_table_dataset_add_index(applTable, ASN_INTEGER);
	
	netsnmp_table_set_multi_add_default_row(
		applTable,
		COLUMN_APPLINDEX, ASN_INTEGER, 0, NULL, 0,
		COLUMN_APPLNAME, ASN_OCTET_STR, 0, NULL, 0,
		COLUMN_APPLDIRECTORYNAME, ASN_OCTET_STR, 0, NULL, 0,
		COLUMN_APPLVERSION, ASN_OCTET_STR, 0, NULL, 0,
		COLUMN_APPLUPTIME, ASN_TIMETICKS, 0, NULL, 0,
		COLUMN_APPLOPERSTATUS, ASN_INTEGER, 0, NULL, 0,
		COLUMN_APPLLASTCHANGE, ASN_TIMETICKS, 0, NULL, 0,
		COLUMN_APPLINBOUNDASSOCIATIONS, ASN_GAUGE, 0, NULL, 0,
		COLUMN_APPLOUTBOUNDASSOCIATIONS, ASN_GAUGE, 0, NULL, 0,
		COLUMN_APPLACCUMULATEDINBOUNDASSOCIATIONS, ASN_COUNTER, 0, NULL, 0,
		COLUMN_APPLACCUMULATEDOUTBOUNDASSOCIATIONS, ASN_COUNTER, 0, NULL, 0,
		COLUMN_APPLLASTINBOUNDACTIVITY, ASN_TIMETICKS, 0, NULL, 0,
		COLUMN_APPLLASTOUTBOUNDACTIVITY, ASN_TIMETICKS, 0, NULL, 0,
		COLUMN_APPLREJECTEDINBOUNDASSOCIATIONS, ASN_COUNTER, 0, NULL, 0,
		COLUMN_APPLFAILEDOUTBOUNDASSOCIATIONS, ASN_COUNTER, 0, NULL, 0,
		COLUMN_APPLDESCRIPTION, ASN_OCTET_STR, 0, NULL, 0,
		COLUMN_APPLURL, ASN_OCTET_STR, 0, NULL, 0,
		0);
	
	/* registering the table with the master agent */
	/* note: if you don't need a subhandler to deal with any aspects
	 * of the request, change applTable_handler to "NULL" */
	netsnmp_register_table_data_set(
			netsnmp_create_handler_registration(
				"applTable", 
				applTable_handler,
				applTable_oid,
				applTable_oid_len,
				HANDLER_CAN_RWRITE),
			applTable, NULL);

	return 0;
}

int snmp_registerAppl(const char *applName)
{
	netsnmp_table_row *row;
	const char *func = "snmp_mod";
	static int idx = 0;
	int res;

	if(!applName) {
		LOG(L_ERR, "%s: Invalid application name\n", func);
		return -1;
	}

	row = netsnmp_create_table_data_row();
	if(!row) {
		LOG(L_ERR, "%s: Couldn't create new table row\n", func);
		return -1;
	}

	idx++;
	netsnmp_table_row_add_index(row, ASN_INTEGER, &idx, 
		sizeof(idx));

	if(netsnmp_set_row_column(row, COLUMN_APPLNAME, ASN_OCTET_STR,
		applName, strlen(applName)) != SNMPERR_SUCCESS) {
		LOG(L_ERR, "%s: Error registering new application: "
			"Couldn't add application name to new row\n", func);
		return -1;
	}

	/* add the row to the table */
	res = netsnmp_table_data_add_row(applTable->table, row);
	if(res != SNMPERR_SUCCESS) {
		LOG(L_ERR, "%s: Error registering new application: "
			"Error adding new row to table\n", func);
		return -1;
	}

	return idx;
}

/* Initializes the handler table. Returns the registration function for this 
 * table */
reg_handler init_applTable_h()
{
	const char *func = "snmp_mod";
	applTable_h = calloc(APPLTABLE_COLUMNS+1,
		sizeof(struct sip_snmp_handler*));
	if(!applTable_h) {
		LOG(L_ERR, "%s: Error initializing handler table: %s\n", 
			func, strerror(errno));
		return NULL;
	}

	return applTable_reg;
}

/* Registration function. Called by snmp_register_handler() to register
 * objects belonging to this table. See snmp_handler.h for values of
 * op */
static int applTable_reg(struct sip_snmp_handler *h, int op)
{
	const char *func = "snmp_mod";
	int col;
	int applIndex;

	if(op != REG_OBJ) {
		LOG(L_ERR, "%s: sorry, applTable only supports registering individual "
			"handlers\n", func);
		return -1;
	}

	if(!h || !h->sip_obj || !h->sip_obj->value.voidp) {
		LOG(L_ERR, "%s: attemp to register invalid handler\n", func);
		return -1;
	}

	col = h->sip_obj->col; 
	if(col <1 || col > APPLTABLE_COLUMNS) {
		LOG(L_ERR, "%s: attempt to register invalid column %d\n", 
			func, col);
		return -1;
	}
	
	applIndex = ser_getApplIndex();
	if(applIndex == -1) {
		LOG(L_ERR, "%s: attempt to register without an application index\n",
			func);
		return -1;
	}

	/* add handler to table. We make copy to make everybody's life easier 
	 * (note that value is not copied) */
	if(!(applTable_h[col] = snmp_clone_handler(h))) {
		LOG(L_ERR, "%s: Error registering handler: %s\n", func,
			strerror(errno));
		return -1;
	}

	if(applTable_addObj(h, col, applIndex) == -1) {
		LOG(L_ERR, "%s: Error adding new object to table\n", func);
		snmp_free_handler(applTable_h[col]);
		applTable_h[col] = NULL;
		return -1;
	}

	/* voila! */
	return 0;
}

/* Adds a new object to the table. If the row doesn't exist is created. 
 * Assumes all objects go to the same row, and all the objects are
 * new (replacing is done silently) */
static int applTable_addObj(struct sip_snmp_handler *h, int col, int applIndex)
{
	static netsnmp_table_row *row, *oldrow=NULL;
	const char *func = "snmp_mod";
	netsnmp_variable_list *idxs=NULL;
	static int prevIdx = -1;		/* a small optimization */
	int res;

	/* sanity checks */
	if(applIndex < 1) {
		LOG(L_ERR, "%s: Invalid application index\n", func);
		return -1;
	}
	if(col < 1 || col > APPLTABLE_COLUMNS) {
		LOG(L_ERR, "%s: Invalid column %d to add new object\n", func, col);
		return -1;
	}
	if(!h || !h->sip_obj) {
		LOG(L_ERR, "%s: Invalid object to add\n", func);
		return -1;
	}

	if(applIndex != prevIdx) {	/* different index or first time */
		/* find the row */
		if(snmp_varlist_add_variable(&idxs, NULL, 0, ASN_INTEGER, 
					(u_char*)&applIndex, sizeof(applIndex)) == NULL) {
			LOG(L_ERR, "%s: Error adding new object to table: "
				"Out of memory?\n", func);
			return -1;
		}
		
		row = netsnmp_table_data_get(applTable->table, idxs);
		if(!row) {
			LOG(L_ERR, "%s: Error: couldn't find row corresponding to "
				"application index %d\n", func, applIndex);
			goto error;
		}
		snmp_free_var(idxs);
		prevIdx = applIndex;
	}

	/* add new object to row */
	if(netsnmp_set_row_column(row, col, ser_types[h->sip_obj->type], 
			h->sip_obj->value.voidp, h->sip_obj->val_len) != SNMPERR_SUCCESS) {
		LOG(L_ERR, "%s: Error adding new object to table\n", func);
		goto error;
	}

	/* is it writable? */
	if(h->on_set)
		netsnmp_mark_row_column_writable(row, col, 1);

	oldrow = netsnmp_table_data_clone_row(row);
	if(!oldrow) {
		LOG(L_ERR, "%s: Error adding new object to table: "
				"Out of memory?\n", func);
		goto error;
	}

	/* replace the row */
	if(!netsnmp_table_data_remove_row(applTable->table, oldrow)){
		LOG(L_ERR, "%s: Error replacing current table row: "
			"Couldn't remove previous one\n", func);
		goto error;
	}
	res = netsnmp_table_data_add_row(applTable->table, row);
	if(res != SNMPERR_SUCCESS) {
		LOG(L_ERR, "%s: Error replacing current table row: %d\n",
			func, res);
		goto error;
	}

	/* el fin */
	return 0;

error:
	if(idxs) snmp_free_var(idxs);
	/* don't delete row, that's a pointer to the table!! */
	if(oldrow)
		netsnmp_table_data_delete_row(oldrow);
	prevIdx = -1;
	return -1;
}

/** handles requests for the applTable table.
 * For every request it checks the specified object to see if it has a
 * handler, and calls it */
static int applTable_handler(
		netsnmp_mib_handler               *handler,
		netsnmp_handler_registration      *reginfo,
		netsnmp_agent_request_info        *reqinfo,
		netsnmp_request_info              *requests) 
{
	netsnmp_variable_list *var;
	netsnmp_table_request_info *table_info;
	struct sip_snmp_handler *h;
	struct sip_snmp_obj *o;
	const char *func = "snmp_mod";
	int res;
	void *tmp_val;
	size_t tmp_len;

	while(requests) {
		var = requests->requestvb;
		if(requests->processed != 0)
			goto next;
		table_info = netsnmp_extract_table_info(requests);
		if(!table_info)
			goto next;
		/* this is not an error, since table-walks work by trying to get
		 * things until we run off of it */
		if(table_info->colnum > APPLTABLE_COLUMNS)
			goto next;

		/* Get the handler and its object */
		h = applTable_h[table_info->colnum];
		if(!h) 
			goto next;
		o = h->sip_obj;
		if(!o) {	/* bad bad boy... */
			LOG(L_ERR, "%s: Found handler without an object!!!\n", func);
			goto next;
		}
		o->col = table_info->colnum;
		o->row = var->name[var->name_length-1];
		switch(reqinfo->mode) {
			case MODE_GET:
			case MODE_GETNEXT:
				if(!h->on_get) break;
				res = h->on_get(o, SER_GET);
				if(res == -1) {
					/* since we don't have a way of knowing what went wrong,
					 * just use a generic error code */
					netsnmp_set_request_error(reqinfo, requests,
							SNMP_ERR_RESOURCEUNAVAILABLE);
					break;
				} else if(res == 0)
					/* the handler has new value to pass back up */
					snmp_set_var_typed_value(var, ser_types[o->type],
							(u_char*)o->value.voidp, o->val_len);
				break;
			case MODE_SET_RESERVE1:
				/* NOTE: We don't require the handler for a on_reserve
				 * function since for our cases it seems that just
				 * checking the type is enough */

				/* First make sure handler wants SETs */
				if(!h->on_set) break;
				/* Check the type */
				if(requests->requestvb->type != ser_types[o->type]) {
					LOG(L_ERR, "%s: Wrong type on SET processing\n", func);
					netsnmp_set_request_error(reqinfo, requests,
							SNMP_ERR_WRONGTYPE);
					break;
				}
				break;
			case MODE_SET_ACTION: /* the real deal */
				if(!h->on_set) break;
				/* copy in the new value for the handler */
				tmp_val = o->value.voidp;
				tmp_len = o->val_len;
				o->value.voidp = requests->requestvb->val.string;
				o->val_len = requests->requestvb->val_len;
				if(h->on_set(o, SER_SET) == -1) {
					LOG(L_ERR, "%s: SET Handler for object failed\n", func);
					netsnmp_set_request_error(reqinfo, requests,
						SNMP_ERR_RESOURCEUNAVAILABLE);
					o->value.voidp = tmp_val;
					o->val_len = tmp_len;
					break;
				}
				o->value.voidp = tmp_val;
				o->val_len = tmp_len;
				break;
			case MODE_SET_UNDO:
				if(!h->on_end) {
					if(h->on_set) /*tsk, tsk, bad boy, gonna tell your mamma..*/
						LOG(L_ERR, "%s: Found object without UNDO handler\n",
							func);
					break;
				}
				/* no point in checking for errors since we're already on
				 * an error branch */
				h->on_end(o, SER_UNDO);
				break;
			case MODE_SET_COMMIT:
				/* Tell the handler is all good and it can safely free up
				 * any memory it may have allocated for UNDO */
				if(!h->on_end) 
					break;
				h->on_end(o, SER_COMMIT);
				break;
			case MODE_SET_FREE:
				/* We get here on failure from RESERVE1. Since there we only 
				 * chk for type correctness, there's nothing to do here */
				break;
		}
next:
		requests = requests->next;
	}
	return SNMP_ERR_NOERROR;
}
