#include <sentinel.h>

pthread_mutex_t th_mutex;
pthread_mutex_t local_mutex;
int tag;

void thread_init();

void detect_promisc(struct sentinel *sentinel)
{
  int i, positive = 0;
  struct host_info *host_info;
  pthread_t th_pasv, th_actv;

  host_info = sentinel->head;

  printf("Scanning %d host(s) for promiscuous interfaces", sentinel->size);

  for(i = 0; i < sentinel->size; i++) {

    if(sentinel->method & ARP) { 
      thread_init();
      printf("\n  Testing '%s' with bogus ARP requests", host_info->ip);

      pthread_mutex_lock(&th_mutex);

      pthread_create(&th_pasv, NULL, (void *)arp_sniff, (void *)host_info);
      pthread_create(&th_actv, NULL, (void *)arp_send, (void *)host_info);

      pthread_join(th_actv, NULL);
      pthread_join(th_pasv, NULL);

      if(tag == 2) {
        host_info->methods |= ARP;
	positive++;
      }

      printf("completed");
    }

    if(sentinel->method & ETHERPING) {
      thread_init();
      printf("\n  Testing '%s' with bogus ICMP ECHO requests", host_info->ip);

      pthread_mutex_lock(&th_mutex);

      pthread_create(&th_pasv, NULL, (void *)icmp_sniff, (void *)host_info);
      pthread_create(&th_actv, NULL, (void *)icmp_send, (void *)host_info);

      pthread_join(th_pasv, NULL);
      pthread_join(th_actv, NULL);

      if(tag == 2) {
        host_info->methods |= ETHERPING;
	positive++;
      }

      printf("completed");
    }

    if(sentinel->method & DNS) {
      thread_init();
      printf("\n  Testing '%s' by flooding TCP packets", host_info->ip);

      pthread_mutex_lock(&th_mutex);

      pthread_create(&th_pasv, NULL, (void *)dns_sniff, (void *)host_info);
      pthread_create(&th_actv, NULL, (void *)dns_flood, NULL);

      pthread_join(th_pasv, NULL);
      pthread_join(th_actv, NULL);

      if(tag == 2) {
        host_info->methods |= DNS;
	positive++;
      }
     
      printf("completed");
    }

    if(sentinel->method & LATENCY) {
      putchar('\n');
      exit(-1);
    }

    if(positive)
      sentinel->positive++;

    host_info = host_info->next;
  }
  putchar('\n');
}

void report(struct sentinel *sentinel)
{
  int i;
  struct host_info *host_info;

  host_info = sentinel->head;

  printf("\nDiscovered %d host(s) in promiscuous mode", sentinel->positive);

  for(i = 0; i < sentinel->size; i++) {
    if(host_info->results) {
       printf("\n  %s tested positive to these test(s):\n", host_info->ip);
 
       if(host_info->methods & ARP)
         puts("    * ARP fake hardware address test");
       if(host_info->methods & ETHERPING)
         puts("    * ICMP ECHO fake hardware address test");
       if(host_info->methods & DNS)
         puts("    * DNS resolution test");
       if(host_info->methods & LATENCY)
         puts("    * ICMP ping latency test");
     }
    host_info = host_info->next;
  }
}

void thread_init()
{
  tag = 0;
  th_mutex = PTHREAD_MUTEX_INITIALIZER;
  local_mutex = PTHREAD_COND_INITIALIZER;
} 
