#include <sentinel.h>

extern pthread_mutex_t th_mutex;
extern pthread_mutex_t local_mutex;
extern int tag;

void arp_sniff(void *data)
{
  pcap_t *pd;
  unsigned char *pkt, filter[1024];
  struct in_addr addr;
  struct pcap_pkthdr pcap_h;
  struct libnet_arp_hdr *arp;
  struct host_info *host_info;

  host_info = (struct host_info *)data;
  addr.s_addr = host_info->ip_addr;

  memset(filter, 0, sizeof(filter));
  snprintf(filter, sizeof(filter), "arp src host %s", host_info->ip);

  pd = pcap_init(filter, 0);

  for(;;) {
    usleep(100);

    pthread_mutex_lock(&local_mutex);
    if(tag) 
      break;
    pthread_mutex_unlock(&local_mutex);

    pkt = (unsigned char *)pcap_next(pd, &pcap_h);
    if(!pkt)
      continue;

    arp = (struct libnet_arp_hdr *)(pkt + netinit.offset);

    if(ntohs(arp->ar_op) == 2) {
      host_info->results = 1;
      pthread_mutex_lock(&local_mutex);
      tag = 2;
      pthread_mutex_unlock(&local_mutex);
      break;
    } 
  }
  pcap_close(pd);
  pthread_exit(0);
}

void arp_send(void *data)
{
  int i;
  unsigned char *send_pkt, errbuf[1024];
  unsigned char fke_hwaddr[6] = { 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 };
  unsigned char def_hwaddr[6] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
  struct host_info *host_info;
  struct libnet_link_int *link_int;
  
  host_info = (struct host_info *)data;

  link_int = libnet_open_link_interface(netinit.iface, errbuf);
  if(!link_int) {
    puts("Error: Could not open link interface");
    exit(-1);
  }

  if(libnet_init_packet(LIBNET_ARP_H + LIBNET_ETH_H, &send_pkt) < 0) {
    puts("Error: Could not allocate memory for packet");
    exit(-1);
  }

  libnet_build_ethernet(fke_hwaddr, fke_hwaddr, ETHERTYPE_ARP,
    NULL, 0, send_pkt);

  libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, 6, 4, ARPOP_REQUEST, 
    (u_char *)&netinit.src_hwaddr, (u_char *)&netinit.src_ipaddr, def_hwaddr, 
    (u_char *)&host_info->ip_addr, NULL, 0, send_pkt + ETH_H);

  for(i = 0; i < netinit.num; i++) {
    putchar('.');
    usleep(100);

    pthread_mutex_lock(&local_mutex);
    if(tag)
      goto end;
    pthread_mutex_unlock(&local_mutex); 

    libnet_write_link_layer(link_int, netinit.iface, send_pkt, 
      LIBNET_ARP_H + LIBNET_ETH_H);
  }

  tag = 1;

end:
  libnet_destroy_packet(&send_pkt); 
  libnet_close_link_interface(link_int);
  pthread_exit(0);
}
