/* $Id: misc.c,v 1.3 2000/04/22 07:40:24 bind Exp $ */

#include "sentinel.h"

extern int tag;

void sighandler(int sig) { 
  tag = 1; 
}

pcap_t *pcap_init(char *filter)
{
  struct bpf_program prog;
  pcap_t *sock;

  pcap_lookupnet(device, &network, &netmask, errbuf);

  sock = pcap_open_live(device, 1000, 0, 10, errbuf);

  if(sock == NULL) {
    perror("pcap_open_live");
    exit(1);
  }

  if(pcap_compile(sock, &prog, filter, 0,netmask)<0)
  {
    perror("pcap_compile");
    exit(-1);
  }

  if(pcap_setfilter(sock, &prog) <0) {
    perror("pcap_setfilter");
    exit(-1);
  }

  return sock;
}

void result(char *method, int type)
{
  if(type == 1)
  printf("\n\nResults: %s tested positive to %s test.\n\n",dst,method);

  if(type == 0)
  printf("\n\nResults: %s tested negative to %s test.\n\n",dst,method);

}

