/* $Id: etherping.c,v 1.2 2000/04/22 07:12:52 bind Exp $ */

#include "sentinel.h"

#define SNAPLEN 128
#define TIMEOUT 1024
#define OPTIMIZE 0

u_char fakeaddr[6] = { 0xff, 0x00, 0x00, 0x00, 0x00, 0x00 };

void *icmp_sniff(void)
{
  pcap_t *socket;
  u_char *packet, *target;
  int temp = 0;
  struct pcap_pkthdr pcap_h;
  struct ip_header *ip;
  struct icmp_header *icmp;

  bzero(&pthread_mutex,sizeof(pthread_mutex));
  
  socket = pcap_init("icmp");

  while(1) {
    usleep(1000);

    packet = (u_char *) pcap_next(socket, &pcap_h);

    if(packet != NULL) {
      ip = (struct ip_header *) (packet + offset);
      icmp = (struct icmp_header *) (packet + offset + IPHDRSIZE);

      target = inet_ntoa(ip->ip_src);
      if(icmp->icmp_type == 0)
        if(strstr(target,dst) != NULL)
  	if(ntohs(icmp->icmp_hun.idseq.id) == 31337) {
          pthread_mutex_lock(&pthread_mutex);
	  tag = 1;
          pthread_mutex_unlock(&pthread_mutex);
	  pcap_close(socket);
          result("etherping",1);
          pthread_exit(0);
	}
    }  
    pthread_mutex_lock(&pthread_mutex);
    temp = tag;
    pthread_mutex_unlock(&pthread_mutex);
    if(temp == 2) break;
  }
  pcap_close(socket);
  result("etherping",0);
  pthread_exit(0);
}

void *icmp_send(void)
{
  u_char *pkt;
  int count, temp;
  struct libnet_link_int *link;

  count = temp = 0;

  link = libnet_open_link_interface(device, errbuf);

  if(!link) {
    fprintf(stderr, "libnet_open_link_interface: %s\n", errbuf);
    exit(1);
  }

  if(libnet_init_packet(LIBNET_ICMP_ECHO_H + LIBNET_ETH_H + 
                          LIBNET_IP_H, &pkt) < 0) {
    perror("libnet_init_packet");
    exit(1);
  }

  libnet_build_ethernet(fakeaddr, (u_char *)hwsource, ETHERTYPE_IP,NULL, 0, pkt);

  libnet_build_ip(LIBNET_ICMP_ECHO_H, 0, 100, 0, 64, IPPROTO_ICMP,
			source, dest, NULL, 0, pkt + LIBNET_ETH_H);

  libnet_build_icmp_echo(ICMP_ECHO, 0, 0x7a69, 1, NULL, 0, pkt +
			       LIBNET_IP_H + LIBNET_ETH_H);

  libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);
  libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_ICMP,LIBNET_ICMP_ECHO_H);

  while(1) { 
    count++;
    printf("."); fflush(stdout);
    sleep(1);
  
    libnet_write_link_layer(link, device, pkt, LIBNET_ICMP_H +
   			          LIBNET_IP_H + LIBNET_ETH_H + 4);

    pthread_mutex_lock(&pthread_mutex);
    temp = tag;
    pthread_mutex_unlock(&pthread_mutex);
  
    if(temp == 1) 
      break;  

    if(count == num) {
      pthread_mutex_lock(&pthread_mutex);
      tag = 2;
      pthread_mutex_unlock(&pthread_mutex);
      break;
    }
  }

  libnet_close_link_interface(link);
  libnet_destroy_packet(&pkt);
  pthread_exit(0);
}
