%{
/*	$Id: scan.l,v 1.2 2007/01/02 09:39:50 mbalmer Exp $ */

/*
 * Copyright (c) 2006 Marc Balmer <marc@msys.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <string.h>

#include "y.tab.h"

%}

%option yylineno noyywrap nounput

%%

vnd-device		{ return VND_DEV; }
vnd-partition		{ return VND_PART; }
vnd-type		{ return VND_TYPE; }
vnd-file		{ return VND_FILE; }
primary-mountpoint	{ return PRIMARY_MOUNTPOINT; }
secondary-mountpoint	{ return SECONDARY_MOUNTPOINT; }

[ \t]+			/* ignore whitespace */ ;

[0-9]+			{
				yylval.string = strdup(yytext);
				return NUMBER;
			}

#.*\n			/* ignore comments */ ;

[a-zA-Z0-9_\-:\.,/\*]+	{
				yylval.string = strdup(yytext);
				return TEXT;
			}

\"([^"\n]*)["\n]	{
				yytext[yyleng - 1] = 0;
				yyleng -= 2;
				yylval.string = strdup(yytext + 1);
				return TEXT;
			}

=			{ return '='; }

\n			{ return '\n'; }
