//
// Register Declarations for Microchip 16F916 Processor
//
//
// This header file was automatically generated by:
//
//	inc2h.pl V1.6
//
//	Copyright (c) 2002, Kevin L. Pauba, All Rights Reserved
//
//	SDCC is licensed under the GNU Public license (GPL) v2.  Note that
//	this license covers the code to the compiler and other executables,
//	but explicitly does not cover any code or objects generated by sdcc.
//	We have not yet decided on a license for the run time libraries, but
//	it will not put any requirements on code linked against it. See:
// 
//	http://www.gnu.org/copyleft/gpl/html
//
//	See http://sdcc.sourceforge.net/ for the latest information on sdcc.
//
// 
#ifndef P16F916_H
#define P16F916_H

//
// Register addresses.
//
#define INDF_ADDR	0x0000
#define TMR0_ADDR	0x0001
#define PCL_ADDR	0x0002
#define STATUS_ADDR	0x0003
#define FSR_ADDR	0x0004
#define PORTA_ADDR	0x0005
#define PORTB_ADDR	0x0006
#define PORTC_ADDR	0x0007
#define PORTE_ADDR	0x0009
#define PCLATH_ADDR	0x000A
#define INTCON_ADDR	0x000B
#define PIR1_ADDR	0x000C
#define PIR2_ADDR	0x000D
#define TMR1L_ADDR	0x000E
#define TMR1H_ADDR	0x000F
#define T1CON_ADDR	0x0010
#define TMR2_ADDR	0x0011
#define T2CON_ADDR	0x0012
#define SSPBUF_ADDR	0x0013
#define SSPCON_ADDR	0x0014
#define CCPR1L_ADDR	0x0015
#define CCPR1H_ADDR	0x0016
#define CCP1CON_ADDR	0x0017
#define RCSTA_ADDR	0x0018
#define TXREG_ADDR	0x0019
#define RCREG_ADDR	0x001A
#define ADRESH_ADDR	0x001E
#define ADCON0_ADDR	0x001F
#define OPTION_REG_ADDR	0x0081
#define TRISA_ADDR	0x0085
#define TRISB_ADDR	0x0086
#define TRISC_ADDR	0x0087
#define TRISE_ADDR	0x0089
#define PIE1_ADDR	0x008C
#define PIE2_ADDR	0x008D
#define PCON_ADDR	0x008E
#define OSCCON_ADDR	0x008F
#define OSCTUNE_ADDR	0x0090
#define ANSEL_ADDR	0x0091
#define PR2_ADDR	0x0092
#define SSPADD_ADDR	0x0093
#define SSPSTAT_ADDR	0x0094
#define WPUB_ADDR	0x0095
#define WPU_ADDR	0x0095
#define IOCB_ADDR	0x0096
#define IOC_ADDR	0x0096
#define CMCON1_ADDR	0x0097
#define TXSTA_ADDR	0x0098
#define SPBRG_ADDR	0x0099
#define CMCON0_ADDR	0x009C
#define VRCON_ADDR	0x009D
#define ADRESL_ADDR	0x009E
#define ADCON1_ADDR	0x009F
#define WDTCON_ADDR	0x0105
#define LCDCON_ADDR	0x0107
#define LCDPS_ADDR	0x0108
#define LVDCON_ADDR	0x0109
#define EEDATL_ADDR	0x010C
#define EEADRL_ADDR	0x010D
#define EEDATH_ADDR	0x010E
#define EEADRH_ADDR	0x010F
#define LCDDATA0_ADDR	0x0110
#define LCDDATA1_ADDR	0x0111
#define LCDDATA3_ADDR	0x0113
#define LCDDATA4_ADDR	0x0114
#define LCDDATA6_ADDR	0x0116
#define LCDDATA7_ADDR	0x0117
#define LCDDATA9_ADDR	0x0119
#define LCDDATA10_ADDR	0x011A
#define LCDSE0_ADDR	0x011C
#define LCDSE1_ADDR	0x011D
#define EECON1_ADDR	0x018C
#define EECON2_ADDR	0x018D

//
// Memory organization.
//

#pragma memmap INDF_ADDR INDF_ADDR SFR 0x000	// INDF
#pragma memmap TMR0_ADDR TMR0_ADDR SFR 0x000	// TMR0
#pragma memmap PCL_ADDR PCL_ADDR SFR 0x000	// PCL
#pragma memmap STATUS_ADDR STATUS_ADDR SFR 0x000	// STATUS
#pragma memmap FSR_ADDR FSR_ADDR SFR 0x000	// FSR
#pragma memmap PORTA_ADDR PORTA_ADDR SFR 0x000	// PORTA
#pragma memmap PORTB_ADDR PORTB_ADDR SFR 0x000	// PORTB
#pragma memmap PORTC_ADDR PORTC_ADDR SFR 0x000	// PORTC
#pragma memmap PORTE_ADDR PORTE_ADDR SFR 0x000	// PORTE
#pragma memmap PCLATH_ADDR PCLATH_ADDR SFR 0x000	// PCLATH
#pragma memmap INTCON_ADDR INTCON_ADDR SFR 0x000	// INTCON
#pragma memmap PIR1_ADDR PIR1_ADDR SFR 0x000	// PIR1
#pragma memmap PIR2_ADDR PIR2_ADDR SFR 0x000	// PIR2
#pragma memmap TMR1L_ADDR TMR1L_ADDR SFR 0x000	// TMR1L
#pragma memmap TMR1H_ADDR TMR1H_ADDR SFR 0x000	// TMR1H
#pragma memmap T1CON_ADDR T1CON_ADDR SFR 0x000	// T1CON
#pragma memmap TMR2_ADDR TMR2_ADDR SFR 0x000	// TMR2
#pragma memmap T2CON_ADDR T2CON_ADDR SFR 0x000	// T2CON
#pragma memmap SSPBUF_ADDR SSPBUF_ADDR SFR 0x000	// SSPBUF
#pragma memmap SSPCON_ADDR SSPCON_ADDR SFR 0x000	// SSPCON
#pragma memmap CCPR1L_ADDR CCPR1L_ADDR SFR 0x000	// CCPR1L
#pragma memmap CCPR1H_ADDR CCPR1H_ADDR SFR 0x000	// CCPR1H
#pragma memmap CCP1CON_ADDR CCP1CON_ADDR SFR 0x000	// CCP1CON
#pragma memmap RCSTA_ADDR RCSTA_ADDR SFR 0x000	// RCSTA
#pragma memmap TXREG_ADDR TXREG_ADDR SFR 0x000	// TXREG
#pragma memmap RCREG_ADDR RCREG_ADDR SFR 0x000	// RCREG
#pragma memmap ADRESH_ADDR ADRESH_ADDR SFR 0x000	// ADRESH
#pragma memmap ADCON0_ADDR ADCON0_ADDR SFR 0x000	// ADCON0
#pragma memmap OPTION_REG_ADDR OPTION_REG_ADDR SFR 0x000	// OPTION_REG
#pragma memmap TRISA_ADDR TRISA_ADDR SFR 0x000	// TRISA
#pragma memmap TRISB_ADDR TRISB_ADDR SFR 0x000	// TRISB
#pragma memmap TRISC_ADDR TRISC_ADDR SFR 0x000	// TRISC
#pragma memmap TRISE_ADDR TRISE_ADDR SFR 0x000	// TRISE
#pragma memmap PIE1_ADDR PIE1_ADDR SFR 0x000	// PIE1
#pragma memmap PIE2_ADDR PIE2_ADDR SFR 0x000	// PIE2
#pragma memmap PCON_ADDR PCON_ADDR SFR 0x000	// PCON
#pragma memmap OSCCON_ADDR OSCCON_ADDR SFR 0x000	// OSCCON
#pragma memmap OSCTUNE_ADDR OSCTUNE_ADDR SFR 0x000	// OSCTUNE
#pragma memmap ANSEL_ADDR ANSEL_ADDR SFR 0x000	// ANSEL
#pragma memmap PR2_ADDR PR2_ADDR SFR 0x000	// PR2
#pragma memmap SSPADD_ADDR SSPADD_ADDR SFR 0x000	// SSPADD
#pragma memmap SSPSTAT_ADDR SSPSTAT_ADDR SFR 0x000	// SSPSTAT
#pragma memmap WPUB_ADDR WPUB_ADDR SFR 0x000	// WPUB
#pragma memmap WPU_ADDR WPU_ADDR SFR 0x000	// WPU
#pragma memmap IOCB_ADDR IOCB_ADDR SFR 0x000	// IOCB
#pragma memmap IOC_ADDR IOC_ADDR SFR 0x000	// IOC
#pragma memmap CMCON1_ADDR CMCON1_ADDR SFR 0x000	// CMCON1
#pragma memmap TXSTA_ADDR TXSTA_ADDR SFR 0x000	// TXSTA
#pragma memmap SPBRG_ADDR SPBRG_ADDR SFR 0x000	// SPBRG
#pragma memmap CMCON0_ADDR CMCON0_ADDR SFR 0x000	// CMCON0
#pragma memmap VRCON_ADDR VRCON_ADDR SFR 0x000	// VRCON
#pragma memmap ADRESL_ADDR ADRESL_ADDR SFR 0x000	// ADRESL
#pragma memmap ADCON1_ADDR ADCON1_ADDR SFR 0x000	// ADCON1
#pragma memmap WDTCON_ADDR WDTCON_ADDR SFR 0x000	// WDTCON
#pragma memmap LCDCON_ADDR LCDCON_ADDR SFR 0x000	// LCDCON
#pragma memmap LCDPS_ADDR LCDPS_ADDR SFR 0x000	// LCDPS
#pragma memmap LVDCON_ADDR LVDCON_ADDR SFR 0x000	// LVDCON
#pragma memmap EEDATL_ADDR EEDATL_ADDR SFR 0x000	// EEDATL
#pragma memmap EEADRL_ADDR EEADRL_ADDR SFR 0x000	// EEADRL
#pragma memmap EEDATH_ADDR EEDATH_ADDR SFR 0x000	// EEDATH
#pragma memmap EEADRH_ADDR EEADRH_ADDR SFR 0x000	// EEADRH
#pragma memmap LCDDATA0_ADDR LCDDATA0_ADDR SFR 0x000	// LCDDATA0
#pragma memmap LCDDATA1_ADDR LCDDATA1_ADDR SFR 0x000	// LCDDATA1
#pragma memmap LCDDATA3_ADDR LCDDATA3_ADDR SFR 0x000	// LCDDATA3
#pragma memmap LCDDATA4_ADDR LCDDATA4_ADDR SFR 0x000	// LCDDATA4
#pragma memmap LCDDATA6_ADDR LCDDATA6_ADDR SFR 0x000	// LCDDATA6
#pragma memmap LCDDATA7_ADDR LCDDATA7_ADDR SFR 0x000	// LCDDATA7
#pragma memmap LCDDATA9_ADDR LCDDATA9_ADDR SFR 0x000	// LCDDATA9
#pragma memmap LCDDATA10_ADDR LCDDATA10_ADDR SFR 0x000	// LCDDATA10
#pragma memmap LCDSE0_ADDR LCDSE0_ADDR SFR 0x000	// LCDSE0
#pragma memmap LCDSE1_ADDR LCDSE1_ADDR SFR 0x000	// LCDSE1
#pragma memmap EECON1_ADDR EECON1_ADDR SFR 0x000	// EECON1
#pragma memmap EECON2_ADDR EECON2_ADDR SFR 0x000	// EECON2


//         LIST
// P16F916.INC  Standard Header File, Version 1.00    Microchip Technology, Inc.
//         NOLIST

// This header file defines configurations, registers, and other useful bits of
// information for the PIC16F916 microcontroller.
// These names are taken to match the data sheets as closely as possible.  

// Note that the processor must be selected before this file is 
// included.  The processor may be selected the following ways:

//       1. Command line switch:
//               C:\ MPASM MYFILE.ASM /PIC16F916
//       2. LIST directive in the source file
//               LIST   P=PIC16F916
//       3. Processor Type entry in the MPASM full-screen interface

//==========================================================================
//
//       Revision History
//
//==========================================================================

//Rev:   Date:    Reason:
//1.00   06/11/04 Initial Release 
//1.01	06/18/04 Corrected typo in 'bad ram' section
//1.02	08/16/04 Added EECON2

//==========================================================================
//
//       Verify Processor
//
//==========================================================================

//        IFNDEF __16F916
//            MESSG "Processor-header file mismatch.  Verify selected processor."
//         ENDIF

//==========================================================================
//
//       Register Definitions
//
//==========================================================================

#define W                    0x0000
#define F                    0x0001

//----- Register Files------------------------------------------------------

extern __data __at (INDF_ADDR) volatile char      INDF;
extern __sfr  __at (TMR0_ADDR)                    TMR0;
extern __data __at (PCL_ADDR) volatile char       PCL;
extern __sfr  __at (STATUS_ADDR)                  STATUS;
extern __sfr  __at (FSR_ADDR)                     FSR;
extern __sfr  __at (PORTA_ADDR)                   PORTA;
extern __sfr  __at (PORTB_ADDR)                   PORTB;
extern __sfr  __at (PORTC_ADDR)                   PORTC;
extern __sfr  __at (PORTE_ADDR)                   PORTE;
extern __sfr  __at (PCLATH_ADDR)                  PCLATH;
extern __sfr  __at (INTCON_ADDR)                  INTCON;
extern __sfr  __at (PIR1_ADDR)                    PIR1;
extern __sfr  __at (PIR2_ADDR)                    PIR2;
extern __sfr  __at (TMR1L_ADDR)                   TMR1L;
extern __sfr  __at (TMR1H_ADDR)                   TMR1H;
extern __sfr  __at (T1CON_ADDR)                   T1CON;
extern __sfr  __at (TMR2_ADDR)                    TMR2;
extern __sfr  __at (T2CON_ADDR)                   T2CON;
extern __sfr  __at (SSPBUF_ADDR)                  SSPBUF;
extern __sfr  __at (SSPCON_ADDR)                  SSPCON;
extern __sfr  __at (CCPR1L_ADDR)                  CCPR1L;
extern __sfr  __at (CCPR1H_ADDR)                  CCPR1H;
extern __sfr  __at (CCP1CON_ADDR)                 CCP1CON;
extern __sfr  __at (RCSTA_ADDR)                   RCSTA;
extern __sfr  __at (TXREG_ADDR)                   TXREG;
extern __sfr  __at (RCREG_ADDR)                   RCREG;
extern __sfr  __at (ADRESH_ADDR)                  ADRESH;
extern __sfr  __at (ADCON0_ADDR)                  ADCON0;

extern __sfr  __at (OPTION_REG_ADDR)              OPTION_REG;
extern __sfr  __at (TRISA_ADDR)                   TRISA;
extern __sfr  __at (TRISB_ADDR)                   TRISB;
extern __sfr  __at (TRISC_ADDR)                   TRISC;
extern __sfr  __at (TRISE_ADDR)                   TRISE;
extern __sfr  __at (PIE1_ADDR)                    PIE1;
extern __sfr  __at (PIE2_ADDR)                    PIE2;
extern __sfr  __at (PCON_ADDR)                    PCON;
extern __sfr  __at (OSCCON_ADDR)                  OSCCON;
extern __sfr  __at (OSCTUNE_ADDR)                 OSCTUNE;
extern __sfr  __at (ANSEL_ADDR)                   ANSEL;
extern __sfr  __at (PR2_ADDR)                     PR2;
extern __sfr  __at (SSPADD_ADDR)                  SSPADD;
extern __sfr  __at (SSPSTAT_ADDR)                 SSPSTAT;
extern __sfr  __at (WPUB_ADDR)                    WPUB;
extern __sfr  __at (WPU_ADDR)                     WPU;
extern __sfr  __at (IOCB_ADDR)                    IOCB;
extern __sfr  __at (IOC_ADDR)                     IOC;
extern __sfr  __at (CMCON1_ADDR)                  CMCON1;
extern __sfr  __at (TXSTA_ADDR)                   TXSTA;
extern __sfr  __at (SPBRG_ADDR)                   SPBRG;
extern __sfr  __at (CMCON0_ADDR)                  CMCON0;
extern __sfr  __at (VRCON_ADDR)                   VRCON;
extern __sfr  __at (ADRESL_ADDR)                  ADRESL;
extern __sfr  __at (ADCON1_ADDR)                  ADCON1;

extern __sfr  __at (WDTCON_ADDR)                  WDTCON;
extern __sfr  __at (LCDCON_ADDR)                  LCDCON;
extern __sfr  __at (LCDPS_ADDR)                   LCDPS;
extern __sfr  __at (LVDCON_ADDR)                  LVDCON;
extern __sfr  __at (EEDATL_ADDR)                  EEDATL;
extern __sfr  __at (EEADRL_ADDR)                  EEADRL;
extern __sfr  __at (EEDATH_ADDR)                  EEDATH;
extern __sfr  __at (EEADRH_ADDR)                  EEADRH;
extern __sfr  __at (LCDDATA0_ADDR)                LCDDATA0;
extern __sfr  __at (LCDDATA1_ADDR)                LCDDATA1;
extern __sfr  __at (LCDDATA3_ADDR)                LCDDATA3;
extern __sfr  __at (LCDDATA4_ADDR)                LCDDATA4;
extern __sfr  __at (LCDDATA6_ADDR)                LCDDATA6;
extern __sfr  __at (LCDDATA7_ADDR)                LCDDATA7;
extern __sfr  __at (LCDDATA9_ADDR)                LCDDATA9;
extern __sfr  __at (LCDDATA10_ADDR)               LCDDATA10;
extern __sfr  __at (LCDSE0_ADDR)                  LCDSE0;
extern __sfr  __at (LCDSE1_ADDR)                  LCDSE1;

extern __sfr  __at (EECON1_ADDR)                  EECON1;
extern __sfr  __at (EECON2_ADDR)                  EECON2;


//----- STATUS Bits --------------------------------------------------------


//----- INTCON Bits --------------------------------------------------------


//----- PIR1 Bits ----------------------------------------------------------


//----- PIR2 Bits ----------------------------------------------------------


//----- T1CON Bits ---------------------------------------------------------


//----- T2CON Bits ---------------------------------------------------------


//----- SSPCON Bits --------------------------------------------------------


//----- CCP1CON Bits -------------------------------------------------------


//----- RCSTA Bits ---------------------------------------------------------



//----- ADCON0 Bits --------------------------------------------------------


//----- OPTION Bits -----------------------------------------------------


//----- PIE1 Bits ----------------------------------------------------------


//----- PIE2 Bits ----------------------------------------------------------


//----- PCON Bits ----------------------------------------------------------


//----- OSCCON Bits -------------------------------------------------------


//----- OSCTUNE Bits -------------------------------------------------------



//----- ANSEL Bits ---------------------------------------------------------



//----- SSPSTAT Bits -------------------------------------------------------



//----- WPUB Bits -------------------------------------------------------


//----- WPU Bits -------------------------------------------------------



//----- IOCB Bits -------------------------------------------------------



//----- IOC Bits -------------------------------------------------------



//----- CMCON1 Bits --------------------------------------------------------


//----- TXSTA Bits ---------------------------------------------------------



//----- CMCON0 Bits ---------------------------------------------------------


//----- VRCON Bits --------------------------------------------------------


//----- ADCON1 Bits --------------------------------------------------------


//----- WDTCON Bits --------------------------------------------------------


//----- LCDCON Bits --------------------------------------------------------


//----- LCDPS Bits ---------------------------------------------------------


//----- LVDCON Bits --------------------------------------------------------


//----- LCDDATA0 Bits -------------------------------------------------------



//----- LCDDATA1 Bits -------------------------------------------------------




//----- LCDDATA3 Bits -------------------------------------------------------



//----- LCDDATA4 Bits -------------------------------------------------------




//----- LCDDATA6 Bits -------------------------------------------------------



//----- LCDDATA7 Bits -------------------------------------------------------




//----- LCDDATA9 Bits -------------------------------------------------------



//----- LCDDATA10 Bits -------------------------------------------------------




//----- LCDSE0 Bits --------------------------------------------------------



//----- LCDSE1 Bits --------------------------------------------------------




//----- EECON1 Bits --------------------------------------------------------



//==========================================================================
//
//       RAM Definition
//
//==========================================================================

//         __MAXRAM H'1FF'
//         __BADRAM H'08', H'1B'-H'1D'
//         __BADRAM H'88', H'9A'-H'9B'
//         __BADRAM H'112', H'115', H'118', H'11B',H'11E'-H'11F'
//         __BADRAM H'185', H'187'-H'189', H'18D'-H'18F'

//==========================================================================
//
//       Configuration Bits
//
//==========================================================================

#define _CONFIG              0x2007

//Configuration Byte 1 Options
#define _DEBUG_ON            0x2FFF
#define _DEBUG_OFF           0x3FFF
#define _FCMEN_ON            0x3FFF
#define _FCMEN_OFF           0x37FF
#define _IESO_ON             0x3FFF
#define _IESO_OFF            0x3BFF
#define _BOD_ON              0x3FFF
#define _BOD_NSLEEP          0x3EFF
#define _BOD_SBODEN          0x3DFF
#define _BOD_OFF             0x3CFF
#define _CPD_ON              0x3F7F
#define _CPD_OFF             0x3FFF
#define _CP_ON               0x3FBF
#define _CP_OFF              0x3FFF
#define _MCLRE_ON            0x3FFF
#define _MCLRE_OFF           0x3FDF
#define _PWRTE_ON            0x3FEF
#define _PWRTE_OFF           0x3FFF
#define _WDT_ON              0x3FFF
#define _WDT_OFF             0x3FF7
#define _LP_OSC              0x3FF8
#define _XT_OSC              0x3FF9
#define _HS_OSC              0x3FFA
#define _EC_OSC              0x3FFB
#define _INTRC_OSC_NOCLKOUT  0x3FFC
#define _INTRC_OSC_CLKOUT    0x3FFD
#define _EXTRC_OSC_NOCLKOUT  0x3FFE
#define _EXTRC_OSC_CLKOUT    0x3FFF
#define _INTOSCIO            0x3FFC
#define _INTOSC              0x3FFD
#define _EXTRCIO             0x3FFE
#define _EXTRC               0x3FFF


//         LIST

// ----- ADCON0 bits --------------------
typedef union {
  struct {
    unsigned char ADON:1;
    unsigned char NOT_DONE:1;
    unsigned char CHS0:1;
    unsigned char CHS1:1;
    unsigned char CHS2:1;
    unsigned char VCFG0:1;
    unsigned char VCFG1:1;
    unsigned char ADFM:1;
  };
  struct {
    unsigned char :1;
    unsigned char GO_DONE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __ADCON0_bits_t;
extern volatile __ADCON0_bits_t __at(ADCON0_ADDR) ADCON0_bits;

#define ADON                 ADCON0_bits.ADON
#define NOT_DONE             ADCON0_bits.NOT_DONE
#define GO_DONE              ADCON0_bits.GO_DONE
#define CHS0                 ADCON0_bits.CHS0
#define CHS1                 ADCON0_bits.CHS1
#define CHS2                 ADCON0_bits.CHS2
#define VCFG0                ADCON0_bits.VCFG0
#define VCFG1                ADCON0_bits.VCFG1
#define ADFM                 ADCON0_bits.ADFM

// ----- ADCON1 bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char ADCS0:1;
    unsigned char ADCS1:1;
    unsigned char ADCS2:1;
    unsigned char :1;
  };
} __ADCON1_bits_t;
extern volatile __ADCON1_bits_t __at(ADCON1_ADDR) ADCON1_bits;

#define ADCS0                ADCON1_bits.ADCS0
#define ADCS1                ADCON1_bits.ADCS1
#define ADCS2                ADCON1_bits.ADCS2

// ----- ANSEL bits --------------------
typedef union {
  struct {
    unsigned char AN0:1;
    unsigned char AN1:1;
    unsigned char AN2:1;
    unsigned char AN3:1;
    unsigned char AN4:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __ANSEL_bits_t;
extern volatile __ANSEL_bits_t __at(ANSEL_ADDR) ANSEL_bits;

#define AN0                  ANSEL_bits.AN0
#define AN1                  ANSEL_bits.AN1
#define AN2                  ANSEL_bits.AN2
#define AN3                  ANSEL_bits.AN3
#define AN4                  ANSEL_bits.AN4

// ----- CCP1CON bits --------------------
typedef union {
  struct {
    unsigned char CCP1M0:1;
    unsigned char CCP1M1:1;
    unsigned char CCP1M2:1;
    unsigned char CCP1M3:1;
    unsigned char CCP1Y:1;
    unsigned char CCP1X:1;
    unsigned char :1;
    unsigned char :1;
  };
} __CCP1CON_bits_t;
extern volatile __CCP1CON_bits_t __at(CCP1CON_ADDR) CCP1CON_bits;

#define CCP1M0               CCP1CON_bits.CCP1M0
#define CCP1M1               CCP1CON_bits.CCP1M1
#define CCP1M2               CCP1CON_bits.CCP1M2
#define CCP1M3               CCP1CON_bits.CCP1M3
#define CCP1Y                CCP1CON_bits.CCP1Y
#define CCP1X                CCP1CON_bits.CCP1X

// ----- CMCON0 bits --------------------
typedef union {
  struct {
    unsigned char CM0:1;
    unsigned char CM1:1;
    unsigned char CM2:1;
    unsigned char CIS:1;
    unsigned char C1INV:1;
    unsigned char C2INV:1;
    unsigned char C1OUT:1;
    unsigned char C2OUT:1;
  };
} __CMCON0_bits_t;
extern volatile __CMCON0_bits_t __at(CMCON0_ADDR) CMCON0_bits;

#define CM0                  CMCON0_bits.CM0
#define CM1                  CMCON0_bits.CM1
#define CM2                  CMCON0_bits.CM2
#define CIS                  CMCON0_bits.CIS
#define C1INV                CMCON0_bits.C1INV
#define C2INV                CMCON0_bits.C2INV
#define C1OUT                CMCON0_bits.C1OUT
#define C2OUT                CMCON0_bits.C2OUT

// ----- CMCON1 bits --------------------
typedef union {
  struct {
    unsigned char C2SYNC:1;
    unsigned char T1GSS:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __CMCON1_bits_t;
extern volatile __CMCON1_bits_t __at(CMCON1_ADDR) CMCON1_bits;

#define C2SYNC               CMCON1_bits.C2SYNC
#define T1GSS                CMCON1_bits.T1GSS

// ----- EECON1 bits --------------------
typedef union {
  struct {
    unsigned char RD:1;
    unsigned char WR:1;
    unsigned char WREN:1;
    unsigned char WRERR:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char EEPGD:1;
  };
  struct {
    unsigned char EERD:1;
    unsigned char EEWR:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __EECON1_bits_t;
extern volatile __EECON1_bits_t __at(EECON1_ADDR) EECON1_bits;

#define RD                   EECON1_bits.RD
#define EERD                 EECON1_bits.EERD
#define WR                   EECON1_bits.WR
#define EEWR                 EECON1_bits.EEWR
#define WREN                 EECON1_bits.WREN
#define WRERR                EECON1_bits.WRERR
#define EEPGD                EECON1_bits.EEPGD

// ----- INTCON bits --------------------
typedef union {
  struct {
    unsigned char RBIF:1;
    unsigned char INTF:1;
    unsigned char T0IF:1;
    unsigned char RBIE:1;
    unsigned char INTE:1;
    unsigned char T0IE:1;
    unsigned char PEIE:1;
    unsigned char GIE:1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char TMR0IF:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char TMR0IE:1;
    unsigned char :1;
    unsigned char :1;
  };
} __INTCON_bits_t;
extern volatile __INTCON_bits_t __at(INTCON_ADDR) INTCON_bits;

#define RBIF                 INTCON_bits.RBIF
#define INTF                 INTCON_bits.INTF
#define T0IF                 INTCON_bits.T0IF
#define TMR0IF               INTCON_bits.TMR0IF
#define RBIE                 INTCON_bits.RBIE
#define INTE                 INTCON_bits.INTE
#define T0IE                 INTCON_bits.T0IE
#define TMR0IE               INTCON_bits.TMR0IE
#define PEIE                 INTCON_bits.PEIE
#define GIE                  INTCON_bits.GIE

// ----- IOC bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char IOC4:1;
    unsigned char IOC5:1;
    unsigned char IOC6:1;
    unsigned char IOC7:1;
  };
} __IOC_bits_t;
extern volatile __IOC_bits_t __at(IOC_ADDR) IOC_bits;

#define IOC4                 IOC_bits.IOC4
#define IOC5                 IOC_bits.IOC5
#define IOC6                 IOC_bits.IOC6
#define IOC7                 IOC_bits.IOC7

// ----- IOCB bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char IOCB4:1;
    unsigned char IOCB5:1;
    unsigned char IOCB6:1;
    unsigned char IOCB7:1;
  };
} __IOCB_bits_t;
extern volatile __IOCB_bits_t __at(IOCB_ADDR) IOCB_bits;

#define IOCB4                IOCB_bits.IOCB4
#define IOCB5                IOCB_bits.IOCB5
#define IOCB6                IOCB_bits.IOCB6
#define IOCB7                IOCB_bits.IOCB7

// ----- LCDCON bits --------------------
typedef union {
  struct {
    unsigned char LMUX0:1;
    unsigned char LMUX1:1;
    unsigned char CS0:1;
    unsigned char CS1:1;
    unsigned char VLCDEN:1;
    unsigned char WERR:1;
    unsigned char SLPEN:1;
    unsigned char LCDEN:1;
  };
} __LCDCON_bits_t;
extern volatile __LCDCON_bits_t __at(LCDCON_ADDR) LCDCON_bits;

#define LMUX0                LCDCON_bits.LMUX0
#define LMUX1                LCDCON_bits.LMUX1
#define CS0                  LCDCON_bits.CS0
#define CS1                  LCDCON_bits.CS1
#define VLCDEN               LCDCON_bits.VLCDEN
#define WERR                 LCDCON_bits.WERR
#define SLPEN                LCDCON_bits.SLPEN
#define LCDEN                LCDCON_bits.LCDEN

// ----- LCDDATA0 bits --------------------
typedef union {
  struct {
    unsigned char SEG0COM0:1;
    unsigned char SEG1COM0:1;
    unsigned char SEG2COM0:1;
    unsigned char SEG3COM0:1;
    unsigned char SEG4COM0:1;
    unsigned char SEG5COM0:1;
    unsigned char SEG6COM0:1;
    unsigned char SEG7COM0:1;
  };
  struct {
    unsigned char S0C0:1;
    unsigned char S1C0:1;
    unsigned char S2C0:1;
    unsigned char S3C0:1;
    unsigned char S4C0:1;
    unsigned char S5C0:1;
    unsigned char S6C0:1;
    unsigned char S7C0:1;
  };
} __LCDDATA0_bits_t;
extern volatile __LCDDATA0_bits_t __at(LCDDATA0_ADDR) LCDDATA0_bits;

#define SEG0COM0             LCDDATA0_bits.SEG0COM0
#define S0C0                 LCDDATA0_bits.S0C0
#define SEG1COM0             LCDDATA0_bits.SEG1COM0
#define S1C0                 LCDDATA0_bits.S1C0
#define SEG2COM0             LCDDATA0_bits.SEG2COM0
#define S2C0                 LCDDATA0_bits.S2C0
#define SEG3COM0             LCDDATA0_bits.SEG3COM0
#define S3C0                 LCDDATA0_bits.S3C0
#define SEG4COM0             LCDDATA0_bits.SEG4COM0
#define S4C0                 LCDDATA0_bits.S4C0
#define SEG5COM0             LCDDATA0_bits.SEG5COM0
#define S5C0                 LCDDATA0_bits.S5C0
#define SEG6COM0             LCDDATA0_bits.SEG6COM0
#define S6C0                 LCDDATA0_bits.S6C0
#define SEG7COM0             LCDDATA0_bits.SEG7COM0
#define S7C0                 LCDDATA0_bits.S7C0

// ----- LCDDATA1 bits --------------------
typedef union {
  struct {
    unsigned char SEG8COM0:1;
    unsigned char SEG9COM0:1;
    unsigned char SEG10COM0:1;
    unsigned char SEG11COM0:1;
    unsigned char SEG12COM0:1;
    unsigned char SEG13COM0:1;
    unsigned char SEG14COM0:1;
    unsigned char SEG15COM0:1;
  };
  struct {
    unsigned char S8C0:1;
    unsigned char S9C0:1;
    unsigned char S10C0:1;
    unsigned char S11C0:1;
    unsigned char S12C0:1;
    unsigned char S13C0:1;
    unsigned char S14C0:1;
    unsigned char S15C0:1;
  };
} __LCDDATA1_bits_t;
extern volatile __LCDDATA1_bits_t __at(LCDDATA1_ADDR) LCDDATA1_bits;

#define SEG8COM0             LCDDATA1_bits.SEG8COM0
#define S8C0                 LCDDATA1_bits.S8C0
#define SEG9COM0             LCDDATA1_bits.SEG9COM0
#define S9C0                 LCDDATA1_bits.S9C0
#define SEG10COM0            LCDDATA1_bits.SEG10COM0
#define S10C0                LCDDATA1_bits.S10C0
#define SEG11COM0            LCDDATA1_bits.SEG11COM0
#define S11C0                LCDDATA1_bits.S11C0
#define SEG12COM0            LCDDATA1_bits.SEG12COM0
#define S12C0                LCDDATA1_bits.S12C0
#define SEG13COM0            LCDDATA1_bits.SEG13COM0
#define S13C0                LCDDATA1_bits.S13C0
#define SEG14COM0            LCDDATA1_bits.SEG14COM0
#define S14C0                LCDDATA1_bits.S14C0
#define SEG15COM0            LCDDATA1_bits.SEG15COM0
#define S15C0                LCDDATA1_bits.S15C0

// ----- LCDDATA10 bits --------------------
typedef union {
  struct {
    unsigned char SEG8COM3:1;
    unsigned char SEG9COM3:1;
    unsigned char SEG10COM3:1;
    unsigned char SEG11COM3:1;
    unsigned char SEG12COM3:1;
    unsigned char SEG13COM3:1;
    unsigned char SEG14COM3:1;
    unsigned char SEG15COM3:1;
  };
  struct {
    unsigned char S8C3:1;
    unsigned char S9C3:1;
    unsigned char S10C3:1;
    unsigned char S11C3:1;
    unsigned char S12C3:1;
    unsigned char S13C3:1;
    unsigned char S14C3:1;
    unsigned char S15C3:1;
  };
} __LCDDATA10_bits_t;
extern volatile __LCDDATA10_bits_t __at(LCDDATA10_ADDR) LCDDATA10_bits;

#define SEG8COM3             LCDDATA10_bits.SEG8COM3
#define S8C3                 LCDDATA10_bits.S8C3
#define SEG9COM3             LCDDATA10_bits.SEG9COM3
#define S9C3                 LCDDATA10_bits.S9C3
#define SEG10COM3            LCDDATA10_bits.SEG10COM3
#define S10C3                LCDDATA10_bits.S10C3
#define SEG11COM3            LCDDATA10_bits.SEG11COM3
#define S11C3                LCDDATA10_bits.S11C3
#define SEG12COM3            LCDDATA10_bits.SEG12COM3
#define S12C3                LCDDATA10_bits.S12C3
#define SEG13COM3            LCDDATA10_bits.SEG13COM3
#define S13C3                LCDDATA10_bits.S13C3
#define SEG14COM3            LCDDATA10_bits.SEG14COM3
#define S14C3                LCDDATA10_bits.S14C3
#define SEG15COM3            LCDDATA10_bits.SEG15COM3
#define S15C3                LCDDATA10_bits.S15C3

// ----- LCDDATA3 bits --------------------
typedef union {
  struct {
    unsigned char SEG0COM1:1;
    unsigned char SEG1COM1:1;
    unsigned char SEG2COM1:1;
    unsigned char SEG3COM1:1;
    unsigned char SEG4COM1:1;
    unsigned char SEG5COM1:1;
    unsigned char SEG6COM1:1;
    unsigned char SEG7COM1:1;
  };
  struct {
    unsigned char S0C1:1;
    unsigned char S1C1:1;
    unsigned char S2C1:1;
    unsigned char S3C1:1;
    unsigned char S4C1:1;
    unsigned char S5C1:1;
    unsigned char S6C1:1;
    unsigned char S7C1:1;
  };
} __LCDDATA3_bits_t;
extern volatile __LCDDATA3_bits_t __at(LCDDATA3_ADDR) LCDDATA3_bits;

#define SEG0COM1             LCDDATA3_bits.SEG0COM1
#define S0C1                 LCDDATA3_bits.S0C1
#define SEG1COM1             LCDDATA3_bits.SEG1COM1
#define S1C1                 LCDDATA3_bits.S1C1
#define SEG2COM1             LCDDATA3_bits.SEG2COM1
#define S2C1                 LCDDATA3_bits.S2C1
#define SEG3COM1             LCDDATA3_bits.SEG3COM1
#define S3C1                 LCDDATA3_bits.S3C1
#define SEG4COM1             LCDDATA3_bits.SEG4COM1
#define S4C1                 LCDDATA3_bits.S4C1
#define SEG5COM1             LCDDATA3_bits.SEG5COM1
#define S5C1                 LCDDATA3_bits.S5C1
#define SEG6COM1             LCDDATA3_bits.SEG6COM1
#define S6C1                 LCDDATA3_bits.S6C1
#define SEG7COM1             LCDDATA3_bits.SEG7COM1
#define S7C1                 LCDDATA3_bits.S7C1

// ----- LCDDATA4 bits --------------------
typedef union {
  struct {
    unsigned char SEG8COM1:1;
    unsigned char SEG9COM1:1;
    unsigned char SEG10COM1:1;
    unsigned char SEG11COM1:1;
    unsigned char SEG12COM1:1;
    unsigned char SEG13COM1:1;
    unsigned char SEG14COM1:1;
    unsigned char SEG15COM1:1;
  };
  struct {
    unsigned char S8C1:1;
    unsigned char S9C1:1;
    unsigned char S10C1:1;
    unsigned char S11C1:1;
    unsigned char S12C1:1;
    unsigned char S13C1:1;
    unsigned char S14C1:1;
    unsigned char S15C1:1;
  };
} __LCDDATA4_bits_t;
extern volatile __LCDDATA4_bits_t __at(LCDDATA4_ADDR) LCDDATA4_bits;

#define SEG8COM1             LCDDATA4_bits.SEG8COM1
#define S8C1                 LCDDATA4_bits.S8C1
#define SEG9COM1             LCDDATA4_bits.SEG9COM1
#define S9C1                 LCDDATA4_bits.S9C1
#define SEG10COM1            LCDDATA4_bits.SEG10COM1
#define S10C1                LCDDATA4_bits.S10C1
#define SEG11COM1            LCDDATA4_bits.SEG11COM1
#define S11C1                LCDDATA4_bits.S11C1
#define SEG12COM1            LCDDATA4_bits.SEG12COM1
#define S12C1                LCDDATA4_bits.S12C1
#define SEG13COM1            LCDDATA4_bits.SEG13COM1
#define S13C1                LCDDATA4_bits.S13C1
#define SEG14COM1            LCDDATA4_bits.SEG14COM1
#define S14C1                LCDDATA4_bits.S14C1
#define SEG15COM1            LCDDATA4_bits.SEG15COM1
#define S15C1                LCDDATA4_bits.S15C1

// ----- LCDDATA6 bits --------------------
typedef union {
  struct {
    unsigned char SEG0COM2:1;
    unsigned char SEG1COM2:1;
    unsigned char SEG2COM2:1;
    unsigned char SEG3COM2:1;
    unsigned char SEG4COM2:1;
    unsigned char SEG5COM2:1;
    unsigned char SEG6COM2:1;
    unsigned char SEG7COM2:1;
  };
  struct {
    unsigned char S0C2:1;
    unsigned char S1C2:1;
    unsigned char S2C2:1;
    unsigned char S3C2:1;
    unsigned char S4C2:1;
    unsigned char S5C2:1;
    unsigned char S6C2:1;
    unsigned char S7C2:1;
  };
} __LCDDATA6_bits_t;
extern volatile __LCDDATA6_bits_t __at(LCDDATA6_ADDR) LCDDATA6_bits;

#define SEG0COM2             LCDDATA6_bits.SEG0COM2
#define S0C2                 LCDDATA6_bits.S0C2
#define SEG1COM2             LCDDATA6_bits.SEG1COM2
#define S1C2                 LCDDATA6_bits.S1C2
#define SEG2COM2             LCDDATA6_bits.SEG2COM2
#define S2C2                 LCDDATA6_bits.S2C2
#define SEG3COM2             LCDDATA6_bits.SEG3COM2
#define S3C2                 LCDDATA6_bits.S3C2
#define SEG4COM2             LCDDATA6_bits.SEG4COM2
#define S4C2                 LCDDATA6_bits.S4C2
#define SEG5COM2             LCDDATA6_bits.SEG5COM2
#define S5C2                 LCDDATA6_bits.S5C2
#define SEG6COM2             LCDDATA6_bits.SEG6COM2
#define S6C2                 LCDDATA6_bits.S6C2
#define SEG7COM2             LCDDATA6_bits.SEG7COM2
#define S7C2                 LCDDATA6_bits.S7C2

// ----- LCDDATA7 bits --------------------
typedef union {
  struct {
    unsigned char SEG8COM2:1;
    unsigned char SEG9COM2:1;
    unsigned char SEG10COM2:1;
    unsigned char SEG11COM2:1;
    unsigned char SEG12COM2:1;
    unsigned char SEG13COM2:1;
    unsigned char SEG14COM2:1;
    unsigned char SEG15COM2:1;
  };
  struct {
    unsigned char S8C2:1;
    unsigned char S9C2:1;
    unsigned char S10C2:1;
    unsigned char S11C2:1;
    unsigned char S12C2:1;
    unsigned char S13C2:1;
    unsigned char S14C2:1;
    unsigned char S15C2:1;
  };
} __LCDDATA7_bits_t;
extern volatile __LCDDATA7_bits_t __at(LCDDATA7_ADDR) LCDDATA7_bits;

#define SEG8COM2             LCDDATA7_bits.SEG8COM2
#define S8C2                 LCDDATA7_bits.S8C2
#define SEG9COM2             LCDDATA7_bits.SEG9COM2
#define S9C2                 LCDDATA7_bits.S9C2
#define SEG10COM2            LCDDATA7_bits.SEG10COM2
#define S10C2                LCDDATA7_bits.S10C2
#define SEG11COM2            LCDDATA7_bits.SEG11COM2
#define S11C2                LCDDATA7_bits.S11C2
#define SEG12COM2            LCDDATA7_bits.SEG12COM2
#define S12C2                LCDDATA7_bits.S12C2
#define SEG13COM2            LCDDATA7_bits.SEG13COM2
#define S13C2                LCDDATA7_bits.S13C2
#define SEG14COM2            LCDDATA7_bits.SEG14COM2
#define S14C2                LCDDATA7_bits.S14C2
#define SEG15COM2            LCDDATA7_bits.SEG15COM2
#define S15C2                LCDDATA7_bits.S15C2

// ----- LCDDATA9 bits --------------------
typedef union {
  struct {
    unsigned char SEG0COM3:1;
    unsigned char SEG1COM3:1;
    unsigned char SEG2COM3:1;
    unsigned char SEG3COM3:1;
    unsigned char SEG4COM3:1;
    unsigned char SEG5COM3:1;
    unsigned char SEG6COM3:1;
    unsigned char SEG7COM3:1;
  };
  struct {
    unsigned char S0C3:1;
    unsigned char S1C3:1;
    unsigned char S2C3:1;
    unsigned char S3C3:1;
    unsigned char S4C3:1;
    unsigned char S5C3:1;
    unsigned char S6C3:1;
    unsigned char S7C3:1;
  };
} __LCDDATA9_bits_t;
extern volatile __LCDDATA9_bits_t __at(LCDDATA9_ADDR) LCDDATA9_bits;

#define SEG0COM3             LCDDATA9_bits.SEG0COM3
#define S0C3                 LCDDATA9_bits.S0C3
#define SEG1COM3             LCDDATA9_bits.SEG1COM3
#define S1C3                 LCDDATA9_bits.S1C3
#define SEG2COM3             LCDDATA9_bits.SEG2COM3
#define S2C3                 LCDDATA9_bits.S2C3
#define SEG3COM3             LCDDATA9_bits.SEG3COM3
#define S3C3                 LCDDATA9_bits.S3C3
#define SEG4COM3             LCDDATA9_bits.SEG4COM3
#define S4C3                 LCDDATA9_bits.S4C3
#define SEG5COM3             LCDDATA9_bits.SEG5COM3
#define S5C3                 LCDDATA9_bits.S5C3
#define SEG6COM3             LCDDATA9_bits.SEG6COM3
#define S6C3                 LCDDATA9_bits.S6C3
#define SEG7COM3             LCDDATA9_bits.SEG7COM3
#define S7C3                 LCDDATA9_bits.S7C3

// ----- LCDPS bits --------------------
typedef union {
  struct {
    unsigned char LP0:1;
    unsigned char LP1:1;
    unsigned char LP2:1;
    unsigned char LP3:1;
    unsigned char WA:1;
    unsigned char LCDA:1;
    unsigned char BIASMD:1;
    unsigned char WFT:1;
  };
} __LCDPS_bits_t;
extern volatile __LCDPS_bits_t __at(LCDPS_ADDR) LCDPS_bits;

#define LP0                  LCDPS_bits.LP0
#define LP1                  LCDPS_bits.LP1
#define LP2                  LCDPS_bits.LP2
#define LP3                  LCDPS_bits.LP3
#define WA                   LCDPS_bits.WA
#define LCDA                 LCDPS_bits.LCDA
#define BIASMD               LCDPS_bits.BIASMD
#define WFT                  LCDPS_bits.WFT

// ----- LCDSE0 bits --------------------
typedef union {
  struct {
    unsigned char SE0:1;
    unsigned char SE1:1;
    unsigned char SE2:1;
    unsigned char SE3:1;
    unsigned char SE4:1;
    unsigned char SE5:1;
    unsigned char SE6:1;
    unsigned char SE7:1;
  };
  struct {
    unsigned char SEGEN0:1;
    unsigned char SEGEN1:1;
    unsigned char SEGEN2:1;
    unsigned char SEGEN3:1;
    unsigned char SEGEN4:1;
    unsigned char SEGEN5:1;
    unsigned char SEGEN6:1;
    unsigned char SEGEN7:1;
  };
} __LCDSE0_bits_t;
extern volatile __LCDSE0_bits_t __at(LCDSE0_ADDR) LCDSE0_bits;

#define SE0                  LCDSE0_bits.SE0
#define SEGEN0               LCDSE0_bits.SEGEN0
#define SE1                  LCDSE0_bits.SE1
#define SEGEN1               LCDSE0_bits.SEGEN1
#define SE2                  LCDSE0_bits.SE2
#define SEGEN2               LCDSE0_bits.SEGEN2
#define SE3                  LCDSE0_bits.SE3
#define SEGEN3               LCDSE0_bits.SEGEN3
#define SE4                  LCDSE0_bits.SE4
#define SEGEN4               LCDSE0_bits.SEGEN4
#define SE5                  LCDSE0_bits.SE5
#define SEGEN5               LCDSE0_bits.SEGEN5
#define SE6                  LCDSE0_bits.SE6
#define SEGEN6               LCDSE0_bits.SEGEN6
#define SE7                  LCDSE0_bits.SE7
#define SEGEN7               LCDSE0_bits.SEGEN7

// ----- LCDSE1 bits --------------------
typedef union {
  struct {
    unsigned char SE8:1;
    unsigned char SE9:1;
    unsigned char SE10:1;
    unsigned char SE11:1;
    unsigned char SE12:1;
    unsigned char SE13:1;
    unsigned char SE14:1;
    unsigned char SE15:1;
  };
  struct {
    unsigned char SEGEN8:1;
    unsigned char SEGEN9:1;
    unsigned char SEGEN10:1;
    unsigned char SEGEN11:1;
    unsigned char SEGEN12:1;
    unsigned char SEGEN13:1;
    unsigned char SEGEN14:1;
    unsigned char SEGEN15:1;
  };
} __LCDSE1_bits_t;
extern volatile __LCDSE1_bits_t __at(LCDSE1_ADDR) LCDSE1_bits;

#define SE8                  LCDSE1_bits.SE8
#define SEGEN8               LCDSE1_bits.SEGEN8
#define SE9                  LCDSE1_bits.SE9
#define SEGEN9               LCDSE1_bits.SEGEN9
#define SE10                 LCDSE1_bits.SE10
#define SEGEN10              LCDSE1_bits.SEGEN10
#define SE11                 LCDSE1_bits.SE11
#define SEGEN11              LCDSE1_bits.SEGEN11
#define SE12                 LCDSE1_bits.SE12
#define SEGEN12              LCDSE1_bits.SEGEN12
#define SE13                 LCDSE1_bits.SE13
#define SEGEN13              LCDSE1_bits.SEGEN13
#define SE14                 LCDSE1_bits.SE14
#define SEGEN14              LCDSE1_bits.SEGEN14
#define SE15                 LCDSE1_bits.SE15
#define SEGEN15              LCDSE1_bits.SEGEN15

// ----- LVDCON bits --------------------
typedef union {
  struct {
    unsigned char LVDL0:1;
    unsigned char LVDL1:1;
    unsigned char LVDL2:1;
    unsigned char :1;
    unsigned char LVDEN:1;
    unsigned char IRVST:1;
    unsigned char :1;
    unsigned char :1;
  };
} __LVDCON_bits_t;
extern volatile __LVDCON_bits_t __at(LVDCON_ADDR) LVDCON_bits;

#define LVDL0                LVDCON_bits.LVDL0
#define LVDL1                LVDCON_bits.LVDL1
#define LVDL2                LVDCON_bits.LVDL2
#define LVDEN                LVDCON_bits.LVDEN
#define IRVST                LVDCON_bits.IRVST

// ----- OPTION_REG bits --------------------
typedef union {
  struct {
    unsigned char PS0:1;
    unsigned char PS1:1;
    unsigned char PS2:1;
    unsigned char PSA:1;
    unsigned char T0SE:1;
    unsigned char T0CS:1;
    unsigned char INTEDG:1;
    unsigned char NOT_RBPU:1;
  };
} __OPTION_REG_bits_t;
extern volatile __OPTION_REG_bits_t __at(OPTION_REG_ADDR) OPTION_REG_bits;

#define PS0                  OPTION_REG_bits.PS0
#define PS1                  OPTION_REG_bits.PS1
#define PS2                  OPTION_REG_bits.PS2
#define PSA                  OPTION_REG_bits.PSA
#define T0SE                 OPTION_REG_bits.T0SE
#define T0CS                 OPTION_REG_bits.T0CS
#define INTEDG               OPTION_REG_bits.INTEDG
#define NOT_RBPU             OPTION_REG_bits.NOT_RBPU

// ----- OSCCON bits --------------------
typedef union {
  struct {
    unsigned char SCS:1;
    unsigned char LTS:1;
    unsigned char HTS:1;
    unsigned char OSTS:1;
    unsigned char IRCF0:1;
    unsigned char IRCF1:1;
    unsigned char IRCF2:1;
    unsigned char :1;
  };
} __OSCCON_bits_t;
extern volatile __OSCCON_bits_t __at(OSCCON_ADDR) OSCCON_bits;

#define SCS                  OSCCON_bits.SCS
#define LTS                  OSCCON_bits.LTS
#define HTS                  OSCCON_bits.HTS
#define OSTS                 OSCCON_bits.OSTS
#define IRCF0                OSCCON_bits.IRCF0
#define IRCF1                OSCCON_bits.IRCF1
#define IRCF2                OSCCON_bits.IRCF2

// ----- OSCTUNE bits --------------------
typedef union {
  struct {
    unsigned char TUN0:1;
    unsigned char TUN1:1;
    unsigned char TUN2:1;
    unsigned char TUN3:1;
    unsigned char TUN4:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __OSCTUNE_bits_t;
extern volatile __OSCTUNE_bits_t __at(OSCTUNE_ADDR) OSCTUNE_bits;

#define TUN0                 OSCTUNE_bits.TUN0
#define TUN1                 OSCTUNE_bits.TUN1
#define TUN2                 OSCTUNE_bits.TUN2
#define TUN3                 OSCTUNE_bits.TUN3
#define TUN4                 OSCTUNE_bits.TUN4

// ----- PCON bits --------------------
typedef union {
  struct {
    unsigned char NOT_BO:1;
    unsigned char NOT_POR:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char SBOREN:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char NOT_BOR:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __PCON_bits_t;
extern volatile __PCON_bits_t __at(PCON_ADDR) PCON_bits;

#define NOT_BO               PCON_bits.NOT_BO
#define NOT_BOR              PCON_bits.NOT_BOR
#define NOT_POR              PCON_bits.NOT_POR
#define SBOREN               PCON_bits.SBOREN

// ----- PIE1 bits --------------------
typedef union {
  struct {
    unsigned char TMR1IE:1;
    unsigned char TMR2IE:1;
    unsigned char CCP1IE:1;
    unsigned char SSPIE:1;
    unsigned char TXIE:1;
    unsigned char RCIE:1;
    unsigned char ADIE:1;
    unsigned char EEIE:1;
  };
} __PIE1_bits_t;
extern volatile __PIE1_bits_t __at(PIE1_ADDR) PIE1_bits;

#define TMR1IE               PIE1_bits.TMR1IE
#define TMR2IE               PIE1_bits.TMR2IE
#define CCP1IE               PIE1_bits.CCP1IE
#define SSPIE                PIE1_bits.SSPIE
#define TXIE                 PIE1_bits.TXIE
#define RCIE                 PIE1_bits.RCIE
#define ADIE                 PIE1_bits.ADIE
#define EEIE                 PIE1_bits.EEIE

// ----- PIE2 bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char LVDIE:1;
    unsigned char :1;
    unsigned char LCDIE:1;
    unsigned char C1IE:1;
    unsigned char C2IE:1;
    unsigned char OSFIE:1;
  };
} __PIE2_bits_t;
extern volatile __PIE2_bits_t __at(PIE2_ADDR) PIE2_bits;

#define LVDIE                PIE2_bits.LVDIE
#define LCDIE                PIE2_bits.LCDIE
#define C1IE                 PIE2_bits.C1IE
#define C2IE                 PIE2_bits.C2IE
#define OSFIE                PIE2_bits.OSFIE

// ----- PIR1 bits --------------------
typedef union {
  struct {
    unsigned char TMR1IF:1;
    unsigned char TMR2IF:1;
    unsigned char CCP1IF:1;
    unsigned char SSPIF:1;
    unsigned char TXIF:1;
    unsigned char RCIF:1;
    unsigned char ADIF:1;
    unsigned char EEIF:1;
  };
} __PIR1_bits_t;
extern volatile __PIR1_bits_t __at(PIR1_ADDR) PIR1_bits;

#define TMR1IF               PIR1_bits.TMR1IF
#define TMR2IF               PIR1_bits.TMR2IF
#define CCP1IF               PIR1_bits.CCP1IF
#define SSPIF                PIR1_bits.SSPIF
#define TXIF                 PIR1_bits.TXIF
#define RCIF                 PIR1_bits.RCIF
#define ADIF                 PIR1_bits.ADIF
#define EEIF                 PIR1_bits.EEIF

// ----- PIR2 bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char LVDIF:1;
    unsigned char :1;
    unsigned char LCDIF:1;
    unsigned char C1IF:1;
    unsigned char C2IF:1;
    unsigned char OSFIF:1;
  };
} __PIR2_bits_t;
extern volatile __PIR2_bits_t __at(PIR2_ADDR) PIR2_bits;

#define LVDIF                PIR2_bits.LVDIF
#define LCDIF                PIR2_bits.LCDIF
#define C1IF                 PIR2_bits.C1IF
#define C2IF                 PIR2_bits.C2IF
#define OSFIF                PIR2_bits.OSFIF

// ----- RCSTA bits --------------------
typedef union {
  struct {
    unsigned char RX9D:1;
    unsigned char OERR:1;
    unsigned char FERR:1;
    unsigned char ADDEN:1;
    unsigned char CREN:1;
    unsigned char SREN:1;
    unsigned char RX9:1;
    unsigned char SPEN:1;
  };
  struct {
    unsigned char RCD8:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char RC9:1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_RC8:1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char RC8_9:1;
    unsigned char :1;
  };
} __RCSTA_bits_t;
extern volatile __RCSTA_bits_t __at(RCSTA_ADDR) RCSTA_bits;

#define RX9D                 RCSTA_bits.RX9D
#define RCD8                 RCSTA_bits.RCD8
#define OERR                 RCSTA_bits.OERR
#define FERR                 RCSTA_bits.FERR
#define ADDEN                RCSTA_bits.ADDEN
#define CREN                 RCSTA_bits.CREN
#define SREN                 RCSTA_bits.SREN
#define RX9                  RCSTA_bits.RX9
#define RC9                  RCSTA_bits.RC9
#define NOT_RC8              RCSTA_bits.NOT_RC8
#define RC8_9                RCSTA_bits.RC8_9
#define SPEN                 RCSTA_bits.SPEN

// ----- SSPCON bits --------------------
typedef union {
  struct {
    unsigned char SSPM0:1;
    unsigned char SSPM1:1;
    unsigned char SSPM2:1;
    unsigned char SSPM3:1;
    unsigned char CKP:1;
    unsigned char SSPEN:1;
    unsigned char SSPOV:1;
    unsigned char WCOL:1;
  };
} __SSPCON_bits_t;
extern volatile __SSPCON_bits_t __at(SSPCON_ADDR) SSPCON_bits;

#define SSPM0                SSPCON_bits.SSPM0
#define SSPM1                SSPCON_bits.SSPM1
#define SSPM2                SSPCON_bits.SSPM2
#define SSPM3                SSPCON_bits.SSPM3
#define CKP                  SSPCON_bits.CKP
#define SSPEN                SSPCON_bits.SSPEN
#define SSPOV                SSPCON_bits.SSPOV
#define WCOL                 SSPCON_bits.WCOL

// ----- SSPSTAT bits --------------------
typedef union {
  struct {
    unsigned char BF:1;
    unsigned char UA:1;
    unsigned char R:1;
    unsigned char S:1;
    unsigned char P:1;
    unsigned char D:1;
    unsigned char CKE:1;
    unsigned char SMP:1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char I2C_READ:1;
    unsigned char I2C_START:1;
    unsigned char I2C_STOP:1;
    unsigned char I2C_DATA:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_W:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_A:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_WRITE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_ADDRESS:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char R_W:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char D_A:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char READ_WRITE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char DATA_ADDRESS:1;
    unsigned char :1;
    unsigned char :1;
  };
} __SSPSTAT_bits_t;
extern volatile __SSPSTAT_bits_t __at(SSPSTAT_ADDR) SSPSTAT_bits;

#define BF                   SSPSTAT_bits.BF
#define UA                   SSPSTAT_bits.UA
#define R                    SSPSTAT_bits.R
#define I2C_READ             SSPSTAT_bits.I2C_READ
#define NOT_W                SSPSTAT_bits.NOT_W
#define NOT_WRITE            SSPSTAT_bits.NOT_WRITE
#define R_W                  SSPSTAT_bits.R_W
#define READ_WRITE           SSPSTAT_bits.READ_WRITE
#define S                    SSPSTAT_bits.S
#define I2C_START            SSPSTAT_bits.I2C_START
#define P                    SSPSTAT_bits.P
#define I2C_STOP             SSPSTAT_bits.I2C_STOP
#define D                    SSPSTAT_bits.D
#define I2C_DATA             SSPSTAT_bits.I2C_DATA
#define NOT_A                SSPSTAT_bits.NOT_A
#define NOT_ADDRESS          SSPSTAT_bits.NOT_ADDRESS
#define D_A                  SSPSTAT_bits.D_A
#define DATA_ADDRESS         SSPSTAT_bits.DATA_ADDRESS
#define CKE                  SSPSTAT_bits.CKE
#define SMP                  SSPSTAT_bits.SMP

// ----- STATUS bits --------------------
typedef union {
  struct {
    unsigned char C:1;
    unsigned char DC:1;
    unsigned char Z:1;
    unsigned char NOT_PD:1;
    unsigned char NOT_TO:1;
    unsigned char RP0:1;
    unsigned char RP1:1;
    unsigned char IRP:1;
  };
} __STATUS_bits_t;
extern volatile __STATUS_bits_t __at(STATUS_ADDR) STATUS_bits;

#define C                    STATUS_bits.C
#define DC                   STATUS_bits.DC
#define Z                    STATUS_bits.Z
#define NOT_PD               STATUS_bits.NOT_PD
#define NOT_TO               STATUS_bits.NOT_TO
#define RP0                  STATUS_bits.RP0
#define RP1                  STATUS_bits.RP1
#define IRP                  STATUS_bits.IRP

// ----- T1CON bits --------------------
typedef union {
  struct {
    unsigned char TMR1ON:1;
    unsigned char TMR1CS:1;
    unsigned char NOT_T1SYNC:1;
    unsigned char T1OSCEN:1;
    unsigned char T1CKPS0:1;
    unsigned char T1CKPS1:1;
    unsigned char T1GE:1;
    unsigned char T1GINV:1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char T1INSYNC:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char T1SYNC:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __T1CON_bits_t;
extern volatile __T1CON_bits_t __at(T1CON_ADDR) T1CON_bits;

#define TMR1ON               T1CON_bits.TMR1ON
#define TMR1CS               T1CON_bits.TMR1CS
#define NOT_T1SYNC           T1CON_bits.NOT_T1SYNC
#define T1INSYNC             T1CON_bits.T1INSYNC
#define T1SYNC               T1CON_bits.T1SYNC
#define T1OSCEN              T1CON_bits.T1OSCEN
#define T1CKPS0              T1CON_bits.T1CKPS0
#define T1CKPS1              T1CON_bits.T1CKPS1
#define T1GE                 T1CON_bits.T1GE
#define T1GINV               T1CON_bits.T1GINV

// ----- T2CON bits --------------------
typedef union {
  struct {
    unsigned char T2CKPS0:1;
    unsigned char T2CKPS1:1;
    unsigned char TMR2ON:1;
    unsigned char TOUTPS0:1;
    unsigned char TOUTPS1:1;
    unsigned char TOUTPS2:1;
    unsigned char TOUTPS3:1;
    unsigned char :1;
  };
} __T2CON_bits_t;
extern volatile __T2CON_bits_t __at(T2CON_ADDR) T2CON_bits;

#define T2CKPS0              T2CON_bits.T2CKPS0
#define T2CKPS1              T2CON_bits.T2CKPS1
#define TMR2ON               T2CON_bits.TMR2ON
#define TOUTPS0              T2CON_bits.TOUTPS0
#define TOUTPS1              T2CON_bits.TOUTPS1
#define TOUTPS2              T2CON_bits.TOUTPS2
#define TOUTPS3              T2CON_bits.TOUTPS3

// ----- TXSTA bits --------------------
typedef union {
  struct {
    unsigned char TX9D:1;
    unsigned char TRMT:1;
    unsigned char BRGH:1;
    unsigned char :1;
    unsigned char SYNC:1;
    unsigned char TXEN:1;
    unsigned char TX9:1;
    unsigned char CSRC:1;
  };
  struct {
    unsigned char TXD8:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_TX8:1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char TX8_9:1;
    unsigned char :1;
  };
} __TXSTA_bits_t;
extern volatile __TXSTA_bits_t __at(TXSTA_ADDR) TXSTA_bits;

#define TX9D                 TXSTA_bits.TX9D
#define TXD8                 TXSTA_bits.TXD8
#define TRMT                 TXSTA_bits.TRMT
#define BRGH                 TXSTA_bits.BRGH
#define SYNC                 TXSTA_bits.SYNC
#define TXEN                 TXSTA_bits.TXEN
#define TX9                  TXSTA_bits.TX9
#define NOT_TX8              TXSTA_bits.NOT_TX8
#define TX8_9                TXSTA_bits.TX8_9
#define CSRC                 TXSTA_bits.CSRC

// ----- VRCON bits --------------------
typedef union {
  struct {
    unsigned char VR0:1;
    unsigned char VR1:1;
    unsigned char VR2:1;
    unsigned char VR3:1;
    unsigned char :1;
    unsigned char VRR:1;
    unsigned char :1;
    unsigned char VREN:1;
  };
} __VRCON_bits_t;
extern volatile __VRCON_bits_t __at(VRCON_ADDR) VRCON_bits;

#define VR0                  VRCON_bits.VR0
#define VR1                  VRCON_bits.VR1
#define VR2                  VRCON_bits.VR2
#define VR3                  VRCON_bits.VR3
#define VRR                  VRCON_bits.VRR
#define VREN                 VRCON_bits.VREN

// ----- WDTCON bits --------------------
typedef union {
  struct {
    unsigned char SWDTEN:1;
    unsigned char WDTPS0:1;
    unsigned char WDTPS1:1;
    unsigned char WDTPS2:1;
    unsigned char WDTPS3:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char SWDTE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __WDTCON_bits_t;
extern volatile __WDTCON_bits_t __at(WDTCON_ADDR) WDTCON_bits;

#define SWDTEN               WDTCON_bits.SWDTEN
#define SWDTE                WDTCON_bits.SWDTE
#define WDTPS0               WDTCON_bits.WDTPS0
#define WDTPS1               WDTCON_bits.WDTPS1
#define WDTPS2               WDTCON_bits.WDTPS2
#define WDTPS3               WDTCON_bits.WDTPS3

// ----- WPU bits --------------------
typedef union {
  struct {
    unsigned char WPU0:1;
    unsigned char WPU1:1;
    unsigned char WPU2:1;
    unsigned char WPU3:1;
    unsigned char WPU4:1;
    unsigned char WPU5:1;
    unsigned char WPU6:1;
    unsigned char WPU7:1;
  };
} __WPU_bits_t;
extern volatile __WPU_bits_t __at(WPU_ADDR) WPU_bits;

#define WPU0                 WPU_bits.WPU0
#define WPU1                 WPU_bits.WPU1
#define WPU2                 WPU_bits.WPU2
#define WPU3                 WPU_bits.WPU3
#define WPU4                 WPU_bits.WPU4
#define WPU5                 WPU_bits.WPU5
#define WPU6                 WPU_bits.WPU6
#define WPU7                 WPU_bits.WPU7

// ----- WPUB bits --------------------
typedef union {
  struct {
    unsigned char WPUB0:1;
    unsigned char WPUB1:1;
    unsigned char WPUB2:1;
    unsigned char WPUB3:1;
    unsigned char WPUB4:1;
    unsigned char WPUB5:1;
    unsigned char WPUB6:1;
    unsigned char WPUB7:1;
  };
} __WPUB_bits_t;
extern volatile __WPUB_bits_t __at(WPUB_ADDR) WPUB_bits;

#define WPUB0                WPUB_bits.WPUB0
#define WPUB1                WPUB_bits.WPUB1
#define WPUB2                WPUB_bits.WPUB2
#define WPUB3                WPUB_bits.WPUB3
#define WPUB4                WPUB_bits.WPUB4
#define WPUB5                WPUB_bits.WPUB5
#define WPUB6                WPUB_bits.WPUB6
#define WPUB7                WPUB_bits.WPUB7

#endif
