/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://scummvm.svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-0-11-0/engines/touche/staticres.cpp $
 * $Id: staticres.cpp 30459 2008-01-12 23:07:51Z sev $
 *
 */



#include "touche/graphics.h"
#include "touche/touche.h"
#include "touche/midi.h"

namespace Touche {

const uint8 ToucheEngine::_directionsTable[NUM_DIRECTIONS] = {
	0x7F, 0x7F, 0x7F, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x02, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x02, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x02,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00
};

const uint16 Graphics::_engFontOffs[] = {
	0x0000, 0x0007, 0x0024, 0x0043, 0x0072, 0x00AD, 0x00E0, 0x0113, 0x0124, 0x0141,
	0x015E, 0x0191, 0x01C4, 0x01E3, 0x01F8, 0x0215, 0x0232, 0x0269, 0x0286, 0x02BD,
	0x02F4, 0x032B, 0x0362, 0x0399, 0x03D0, 0x0407, 0x043E, 0x045B, 0x047C, 0x0495,
	0x04C0, 0x04D9, 0x0510, 0x054B, 0x0582, 0x05B9, 0x05F0, 0x0627, 0x065E, 0x0695,
	0x06CC, 0x0703, 0x0720, 0x0757, 0x078E, 0x07C5, 0x07FC, 0x0833, 0x086A, 0x08A1,
	0x08D8, 0x090F, 0x0946, 0x097D, 0x09B4, 0x09EB, 0x0A3C, 0x0A73, 0x0AAA, 0x0AE1,
	0x0B00, 0x0B1D, 0x0B3C, 0x0B77, 0x0BAA, 0x0BBB, 0x0BF2, 0x0C29, 0x0C60, 0x0C97,
	0x0CCE, 0x0CEB, 0x0D2E, 0x0D65, 0x0D82, 0x0DA5, 0x0DDC, 0x0DF9, 0x0E30, 0x0E67,
	0x0E9E, 0x0EE1, 0x0F24, 0x0F41, 0x0F78, 0x0F95, 0x0FCC, 0x1003, 0x103A, 0x1071,
	0x10B4, 0x10EB, 0x110A, 0x112B, 0x114A, 0x116D, 0x1178, 0x11BB, 0x11F2, 0x1229,
	0x1260, 0x1297, 0x12CE, 0x1305, 0x1348, 0x137F, 0x13B6, 0x13ED, 0x1424, 0x1441,
	0x145E, 0x149D, 0x14A8, 0x14B3, 0x14EA, 0x14F5, 0x152C, 0x1563, 0x159A, 0x15D1,
	0x1608, 0x1613, 0x161E, 0x1629, 0x1634, 0x163F, 0x164A, 0x1655, 0x1660, 0x1697,
	0x16B4, 0x16EB, 0x1722, 0x1759, 0x1764, 0x176F, 0x177A, 0x17B1, 0x17BC, 0x17C7,
	0x17D2, 0x17DD
};

const int Graphics::_engFontSize = ARRAYSIZE(Graphics::_engFontOffs);

const uint8 Graphics::_engFontData[] = {
	0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0D, 0x05, 0x3C, 0x03, 0xD7, 0x0D, 0xD7, 0xCD,
	0xD7, 0xCD, 0xD7, 0xCD, 0xD7, 0xC3, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0xD7, 0x00, 0xD7, 0xC0,
	0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x07, 0x09, 0x3C, 0x3C, 0x00, 0x0C, 0xD7, 0xD7, 0x00, 0x37, 0xD7,
	0xD7, 0xC0, 0xF7, 0xD7, 0xD7, 0xC3, 0x55, 0xD7, 0xD7, 0xC0, 0xDF, 0x3F, 0xFF, 0xC3, 0xDF, 0x0F,
	0x0F, 0x0D, 0x55, 0x02, 0x0B, 0x0B, 0x00, 0xC3, 0x00, 0x03, 0x03, 0x7D, 0xC0, 0x0D, 0x0F, 0x7D,
	0xF0, 0x0D, 0x35, 0x55, 0x70, 0x35, 0x0D, 0xF7, 0xFC, 0xDD, 0x3D, 0xF7, 0xF0, 0xDD, 0xD5, 0x55,
	0xC0, 0x35, 0x37, 0xDF, 0xF0, 0x3D, 0x37, 0xDF, 0xC0, 0xDD, 0x0F, 0xFF, 0x00, 0x35, 0x03, 0x0C,
	0x00, 0x0D, 0x02, 0x0E, 0x09, 0x03, 0x00, 0x00, 0xF0, 0x0D, 0xC0, 0x03, 0x5C, 0x0D, 0xF0, 0x0D,
	0xF7, 0x35, 0x5C, 0x0D, 0xF7, 0xDD, 0xF7, 0x03, 0x5F, 0xDD, 0xFF, 0xC0, 0xFD, 0x35, 0x5F, 0x00,
	0x37, 0x3D, 0xF7, 0x00, 0xDF, 0xDD, 0xF7, 0xC3, 0x7F, 0x35, 0x5F, 0xC0, 0xFC, 0x0D, 0xFF, 0x00,
	0x30, 0x0D, 0xFC, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x02, 0x0C, 0x0C,
	0x0F, 0x00, 0x00, 0x00, 0x35, 0xC0, 0xC0, 0x00, 0xDF, 0x73, 0x70, 0x03, 0xDF, 0x7D, 0xFC, 0x0D,
	0x35, 0xF7, 0xF0, 0x37, 0x0F, 0xDF, 0xC0, 0x37, 0x03, 0x7D, 0x70, 0x0D, 0x0D, 0xF7, 0xDC, 0x37,
	0x37, 0xF7, 0xDF, 0x37, 0x0F, 0xCD, 0x7F, 0x0D, 0x03, 0x03, 0xFC, 0x03, 0x00, 0x00, 0xF0, 0x00,
	0x02, 0x0C, 0x0B, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xC0, 0x00, 0xD7, 0x35,
	0x70, 0x00, 0xD7, 0xDF, 0xDC, 0x00, 0xD7, 0xDF, 0xFF, 0xC0, 0xFF, 0x35, 0x7D, 0x70, 0x3F, 0xDF,
	0xF7, 0xFC, 0x00, 0xDF, 0xDF, 0xF0, 0x00, 0x35, 0x7F, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x03,
	0xF0, 0x00, 0x00, 0x01, 0x07, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC3, 0xD7, 0xC3, 0xD7, 0xCD,
	0xFF, 0xCD, 0x3F, 0x0D, 0x01, 0x0D, 0x06, 0x03, 0x00, 0x0D, 0xC3, 0x37, 0xF0, 0x37, 0xC0, 0xDF,
	0xC0, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC3, 0x03, 0xF0, 0x00,
	0xC0, 0x01, 0x0D, 0x06, 0x30, 0x00, 0xDC, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC0, 0x0D, 0xF0,
	0x0D, 0xF3, 0x0D, 0xF0, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x02, 0x0C,
	0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x03, 0x0F, 0x7C, 0x00,
	0x0D, 0x37, 0x77, 0x00, 0x0D, 0x3D, 0x5F, 0xC0, 0xFD, 0xD5, 0xD5, 0xC3, 0x55, 0x3D, 0x5F, 0xF0,
	0xFD, 0x37, 0x77, 0xC0, 0x3D, 0x0F, 0x7F, 0xC0, 0x0D, 0x03, 0xFF, 0x00, 0x03, 0x00, 0x30, 0x00,
	0x00, 0x02, 0x0C, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00,
	0x03, 0x70, 0x00, 0x00, 0x03, 0x7C, 0x00, 0x00, 0x3F, 0x7F, 0x00, 0x00, 0xD5, 0x55, 0xC0, 0x00,
	0x3F, 0x7F, 0xF0, 0x00, 0x0F, 0x7F, 0xC0, 0x3C, 0x03, 0x7C, 0x00, 0xD7, 0x00, 0xFC, 0x00, 0xD7,
	0x00, 0x30, 0x03, 0x5F, 0x01, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x0F, 0x00, 0x35, 0xC0, 0x35, 0xF0, 0xD7, 0xF0, 0x3F,
	0xC0, 0x0F, 0x00, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3F, 0xC0, 0xD5, 0x70, 0x3F, 0xFC, 0x0F, 0xF0, 0x01, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3C, 0x03, 0xD7, 0x0D, 0xD7,
	0xCD, 0x3F, 0xC3, 0x0F, 0x00, 0x01, 0x0D, 0x08, 0x00, 0x00, 0x00, 0x30, 0x00, 0xDC, 0x03, 0x7F,
	0x03, 0x7C, 0x0D, 0xFC, 0x0D, 0xF0, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0, 0xDF, 0x00, 0x3F, 0x00,
	0x0C, 0x00, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0xF5, 0xD7, 0xD7, 0x03,
	0x55, 0xD7, 0xD7, 0xC0, 0xF5, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0,
	0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x5F, 0xC0,
	0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x01, 0x0D, 0x07, 0x03, 0xC0, 0x3D, 0x70,
	0xD5, 0x7C, 0x3D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C,
	0x0D, 0x7C, 0x03, 0xFC, 0x00, 0xF0, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00,
	0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0x3F, 0xD7, 0xC0, 0x0F, 0x0F, 0x5F, 0xC0,
	0x0D, 0x0D, 0x7F, 0x00, 0x03, 0x35, 0xFC, 0x00, 0x00, 0xD7, 0xF0, 0x00, 0x3C, 0xD7, 0xFC, 0x00,
	0xD7, 0xD5, 0x57, 0x00, 0x35, 0x3F, 0xFF, 0xC0, 0x0F, 0x0F, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09,
	0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x03, 0x3F, 0xD7, 0xC0, 0x0D,
	0x0F, 0xD7, 0xC0, 0x0D, 0x0D, 0x5F, 0xC0, 0x35, 0x03, 0xD7, 0x00, 0x35, 0x00, 0xD7, 0xC0, 0xD7,
	0x3C, 0xD7, 0xC0, 0xD5, 0xD7, 0xD7, 0xC0, 0x3F, 0x35, 0x5F, 0xC0, 0x0F, 0x0F, 0xFF, 0x00, 0x00,
	0x03, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x3F, 0x00, 0xD7, 0x00, 0xD5, 0x03,
	0x57, 0xC0, 0xD7, 0x0D, 0x57, 0xC0, 0xD7, 0x0D, 0x57, 0xC0, 0xD7, 0x35, 0xD7, 0xC0, 0xD5, 0x35,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xD5, 0x57, 0xC0, 0x3F, 0x3F, 0xD7, 0xC0, 0xD7, 0x0F,
	0xD7, 0xC0, 0x35, 0x00, 0x3F, 0xC0, 0x0F, 0x00, 0x0F, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x3F, 0xFC,
	0x00, 0x0F, 0xD5, 0x57, 0x00, 0x35, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF, 0x00, 0xD7, 0xD7, 0xF0,
	0x00, 0xD7, 0xD5, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x00, 0xD7, 0x3F, 0xD7, 0xC0, 0xD7, 0x3F, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC,
	0x00, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x00,
	0x3F, 0xD7, 0xFF, 0xC0, 0x0F, 0xD7, 0xFF, 0x00, 0x03, 0xD5, 0x5C, 0x00, 0x0D, 0xD7, 0xD7, 0x00,
	0x0D, 0xD7, 0xD7, 0xC0, 0x0D, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x5F, 0xC0,
	0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x3F, 0xFC, 0x00, 0x0F,
	0xD5, 0x57, 0x00, 0x35, 0x3F, 0xD7, 0xC0, 0xD7, 0x0F, 0x5F, 0xC0, 0xD7, 0x03, 0x5F, 0x00, 0xD7,
	0x0D, 0x7F, 0x00, 0x35, 0x0D, 0x7C, 0x00, 0xD7, 0x0D, 0x7C, 0x00, 0xD7, 0x35, 0xFC, 0x00, 0xD7,
	0x35, 0xF0, 0x00, 0xD7, 0x35, 0xF0, 0x00, 0x35, 0x0F, 0xF0, 0x00, 0x0F, 0x03, 0xC0, 0x00, 0x03,
	0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0xD7, 0xD7, 0x00, 0x35, 0xD7,
	0xD7, 0xC0, 0x0F, 0xD7, 0xD7, 0xC0, 0x3F, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F,
	0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C,
	0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0xF0, 0xD7, 0xD7,
	0xC3, 0x5C, 0x35, 0x57, 0xC3, 0x5F, 0x0F, 0xD7, 0xC0, 0xFF, 0x3F, 0xD7, 0xC0, 0xFC, 0xD7, 0xD7,
	0xC3, 0x5C, 0x35, 0x5F, 0xC3, 0x5F, 0x0F, 0xFF, 0x00, 0xFF, 0x03, 0xFC, 0x00, 0x3C, 0x01, 0x0D,
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0xD7, 0x03, 0xD7, 0xC3, 0x3F,
	0xC0, 0x3F, 0x00, 0xD7, 0x03, 0xD7, 0xC3, 0x3F, 0xC0, 0x0F, 0x03, 0x01, 0x0F, 0x05, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0x3F, 0xC0, 0x3F, 0x00,
	0xD7, 0x00, 0xD7, 0xC0, 0x37, 0xC0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x01, 0x0B, 0x07, 0x00,
	0x00, 0x00, 0xC0, 0x03, 0x70, 0x0D, 0xFC, 0x37, 0xF0, 0xDF, 0xC0, 0x37, 0x00, 0x0D, 0xC0, 0x03,
	0x70, 0x00, 0xFC, 0x00, 0x30, 0x02, 0x0A, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0,
	0x00, 0x00, 0x03, 0x70, 0x3F, 0xFC, 0x00, 0xDC, 0xD5, 0x57, 0x00, 0x37, 0x3F, 0xFF, 0xC0, 0x0D,
	0x3F, 0xFF, 0x00, 0x37, 0xD5, 0x57, 0x00, 0xDF, 0x3F, 0xFF, 0xC3, 0x7F, 0x0F, 0xFF, 0x00, 0xFC,
	0x01, 0x0B, 0x07, 0x00, 0x00, 0x30, 0x00, 0xDC, 0x00, 0x37, 0x00, 0x0D, 0xC0, 0x03, 0x70, 0x0D,
	0xFC, 0x37, 0xF0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x00,
	0x35, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x3F, 0xD7, 0xC0, 0x00,
	0x0F, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00,
	0x0D, 0x70, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00,
	0x02, 0x0E, 0x0D, 0x03, 0xFF, 0xC0, 0x00, 0x0D, 0x55, 0x70, 0x00, 0x37, 0xFF, 0xDC, 0x00, 0xDF,
	0xFF, 0xF7, 0x00, 0xDF, 0xD5, 0xF7, 0xC0, 0xDF, 0x7D, 0xF7, 0xC0, 0xDF, 0x7D, 0xF7, 0xC0, 0xDF,
	0x7D, 0xF7, 0xC0, 0xDF, 0x75, 0xDF, 0xC0, 0xDF, 0xDD, 0x7F, 0x00, 0x37, 0xFF, 0xFC, 0x00, 0x0D,
	0x5C, 0xF0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x00, 0xF0,
	0x00, 0x3F, 0x03, 0x5C, 0x00, 0xD5, 0x03, 0x5F, 0x00, 0xD7, 0x0D, 0x57, 0x00, 0xD7, 0x0D, 0x57,
	0xC0, 0xD7, 0x0D, 0xF7, 0xC0, 0xD5, 0x35, 0xF5, 0xC0, 0xD7, 0x35, 0xF5, 0xF0, 0xD7, 0x35, 0x55,
	0xF0, 0xD7, 0xD7, 0xFD, 0x70, 0xD7, 0xD7, 0xFD, 0x7C, 0xD5, 0x3F, 0xC3, 0xFC, 0x3F, 0x0F, 0x00,
	0xF0, 0x0F, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0x00, 0x03, 0xD5, 0x55, 0xC0, 0x0D, 0xD7, 0xFD, 0x70,
	0x35, 0xD7, 0xFD, 0x7C, 0xD7, 0xD7, 0xFD, 0x7C, 0xD7, 0xD5, 0x55, 0xFC, 0xD7, 0xD7, 0xFD, 0x70,
	0xD7, 0xD7, 0xFD, 0x7C, 0xD7, 0xD7, 0xCD, 0x7C, 0xD7, 0xD7, 0xFD, 0x7C, 0x35, 0xD5, 0x55, 0xFC,
	0x0D, 0x3F, 0xFF, 0xF0, 0x03, 0x0F, 0xFF, 0xC0, 0x00, 0x02, 0x0D, 0x0A, 0x03, 0xFC, 0x00, 0x0F,
	0x0D, 0x57, 0x00, 0x35, 0x35, 0xF5, 0xC0, 0x35, 0xD7, 0xFD, 0xF0, 0x35, 0xD7, 0xC3, 0xF0, 0x35,
	0xD7, 0xC0, 0xC0, 0x35, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xC3, 0x00, 0x35, 0xD7, 0xCD, 0xC0, 0x35,
	0x35, 0xF5, 0xF0, 0x35, 0x0D, 0x57, 0xF0, 0x35, 0x03, 0xFF, 0xC0, 0x0F, 0x00, 0xFF, 0x00, 0x03,
	0x02, 0x0D, 0x0B, 0x3F, 0xFC, 0x00, 0x03, 0xD5, 0x57, 0x00, 0x0D, 0xD7, 0xF5, 0xC0, 0x0D, 0xD7,
	0xFD, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xF5, 0xFC, 0x0D, 0xD5, 0x57, 0xF0, 0x0D, 0x3F,
	0xFF, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0A, 0x3F, 0xFF, 0x00, 0x0F, 0xD5, 0x55,
	0xC0, 0x35, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xFC, 0x00, 0x35, 0xD5, 0x57,
	0x00, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xFF, 0x00, 0x35, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xFF,
	0x00, 0x35, 0xD5, 0x55, 0xC0, 0x35, 0x3F, 0xFF, 0xF0, 0x0F, 0x0F, 0xFF, 0xC0, 0x03, 0x02, 0x0D,
	0x0A, 0x3F, 0xFF, 0x00, 0x03, 0xD5, 0x55, 0xC0, 0x0D, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0,
	0xD7, 0xD7, 0xFC, 0x00, 0xD7, 0xD5, 0x57, 0x00, 0xD7, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF, 0x00,
	0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xC0, 0x00, 0x0D, 0x3F, 0xC0, 0x00,
	0x03, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFF, 0x00, 0x03, 0x0D, 0x55, 0xC0, 0x0D,
	0x35, 0xFD, 0x70, 0x0D, 0xD7, 0xFF, 0x7C, 0x0D, 0xD7, 0xC0, 0xFC, 0x0D, 0xD7, 0xFF, 0xF0, 0x0D,
	0xD7, 0xD5, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x35, 0xFD, 0x7C, 0x0D,
	0x0D, 0x57, 0x7C, 0x0D, 0x03, 0xFF, 0xFC, 0x03, 0x00, 0xFF, 0x30, 0x00, 0x02, 0x0D, 0x0B, 0x3C,
	0x03, 0xC0, 0x03, 0xD7, 0x0D, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xFD, 0x7C, 0x0D, 0xD5, 0x55, 0x7C, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x3F, 0xC3, 0xFC, 0x03, 0x0F,
	0x00, 0xF0, 0x00, 0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC3, 0xD7, 0xC3, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00,
	0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0x00,
	0xD7, 0xC0, 0xD7, 0x00, 0xD7, 0xC0, 0xD5, 0x00, 0xD7, 0xC0, 0xD5, 0x00, 0xD7, 0xC0, 0xD5, 0x3C,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0x0F,
	0xFF, 0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x0B, 0x3C, 0x0F, 0x00, 0x0F, 0xD7, 0x35,
	0xC0, 0x35, 0xD7, 0xD7, 0xF0, 0x35, 0xD7, 0x5F, 0xC0, 0x35, 0xD5, 0x7F, 0x00, 0x35, 0xD5, 0xFC,
	0x00, 0x35, 0xD5, 0x70, 0x00, 0x35, 0xD7, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0x35, 0xD7, 0xF5,
	0xC0, 0x35, 0xD7, 0xCD, 0x70, 0x35, 0x3F, 0xC3, 0xFC, 0x0F, 0x0F, 0x00, 0xF0, 0x03, 0x02, 0x0D,
	0x0A, 0x3C, 0x00, 0x00, 0x3C, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00,
	0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00,
	0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xFF, 0x00, 0xD7, 0xD5, 0x55, 0xC0, 0xD7, 0x3F, 0xFF, 0xF0,
	0x3F, 0x0F, 0xFF, 0xC0, 0x0F, 0x02, 0x0D, 0x0D, 0x3C, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0x00,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD5, 0xC3, 0x57, 0xC0, 0xD5, 0xF3, 0x57, 0xC0, 0xD5, 0x7D, 0x57, 0xC0,
	0xD5, 0x7D, 0x57, 0xC0, 0xD7, 0x55, 0xD7, 0xC0, 0xD7, 0x55, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xFF, 0xFF, 0xC0, 0x0F, 0x0F, 0x0F, 0x00, 0x02, 0x0D, 0x0B, 0x3C,
	0x03, 0xC0, 0x00, 0xD7, 0x0D, 0x70, 0x00, 0xD5, 0xCD, 0x7C, 0x03, 0xD5, 0x7D, 0x7C, 0x0D, 0xD5,
	0x7D, 0x7C, 0x0D, 0xD7, 0x5D, 0x7C, 0x0D, 0xD7, 0x5D, 0x7C, 0x0D, 0xD7, 0xD5, 0x7C, 0x0D, 0xD7,
	0xD5, 0x7C, 0x0D, 0xD7, 0xF5, 0x7C, 0x03, 0xD7, 0xCD, 0x7C, 0x00, 0x3F, 0xC3, 0xFC, 0x00, 0x0F,
	0x00, 0xF0, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFC, 0x00, 0x03, 0x0D, 0x57, 0x00, 0x0D, 0x35, 0xF5,
	0xC0, 0x0D, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD,
	0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x35, 0xF5, 0xFC, 0x0D, 0x0D, 0x57,
	0xF0, 0x0D, 0x03, 0xFF, 0xC0, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0x00,
	0x00, 0xD5, 0x55, 0xC0, 0x03, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x35, 0xD7, 0xCD, 0x7C,
	0x35, 0xD7, 0xFD, 0x7C, 0x35, 0xD5, 0x55, 0xFC, 0x35, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0,
	0x35, 0xD7, 0xC0, 0x00, 0x0D, 0xD7, 0xC0, 0x00, 0x03, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00, 0x00,
	0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFC, 0x00, 0x00, 0x0D, 0x57, 0x00, 0x00, 0x35, 0xF5, 0xC0, 0x00,
	0xD7, 0xFD, 0x70, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00,
	0xD7, 0xFD, 0x7C, 0x00, 0xD7, 0xD5, 0x7C, 0x00, 0x35, 0xF5, 0xFC, 0x00, 0x0D, 0x55, 0x70, 0x00,
	0x03, 0xFF, 0xFC, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x02, 0x0D, 0x0C, 0x3F, 0xFF, 0x00, 0x00, 0xD5,
	0x55, 0xC0, 0x03, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xFD, 0x7C, 0x03, 0xD5, 0x55, 0xFC, 0x00, 0xD7, 0xFD, 0x70, 0x03, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xC3, 0x5C, 0x03, 0x3F, 0xC0, 0xFF, 0x00, 0x0F, 0x00, 0x3C, 0x00, 0x02,
	0x0D, 0x0A, 0x0F, 0xFC, 0x00, 0x3F, 0x35, 0x57, 0x00, 0xD5, 0xD7, 0xF5, 0xC0, 0x3F, 0xD7, 0xF5,
	0xF0, 0x0F, 0xD7, 0xCF, 0xF0, 0x03, 0x35, 0x7F, 0xC0, 0x03, 0x0F, 0x57, 0x00, 0x03, 0x3F, 0xF5,
	0xC0, 0x03, 0xD7, 0x35, 0xF0, 0x03, 0xD7, 0xF5, 0xF0, 0x03, 0x35, 0x57, 0xF0, 0x03, 0x0F, 0xFF,
	0xC0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0xC0, 0x0F, 0xD5, 0x55, 0x70,
	0x35, 0x3F, 0x5F, 0xFC, 0x35, 0x0F, 0x5F, 0xF0, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00,
	0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00,
	0x0D, 0x03, 0x5F, 0x00, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x02, 0x0D, 0x0B,
	0x3C, 0x03, 0xC0, 0x0F, 0xD7, 0x0D, 0x70, 0x35, 0xD7, 0xCD, 0x7C, 0x35, 0xD7, 0xCD, 0x7C, 0x0D,
	0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x03, 0xD7, 0xCD, 0x7C, 0x03,
	0xD7, 0xCD, 0x7C, 0x03, 0x35, 0xF5, 0xFC, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0xFF, 0xC0, 0x00,
	0x00, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3C, 0x03, 0xC0, 0x3C, 0xD7, 0x0D, 0x70, 0xD7, 0xD7,
	0xCD, 0x7C, 0xD7, 0x35, 0xF5, 0xFC, 0xD7, 0x35, 0xF5, 0xF0, 0x35, 0x35, 0xF5, 0xF0, 0x35, 0x0D,
	0xF7, 0xF0, 0x0D, 0x0D, 0x57, 0xC0, 0x0D, 0x0D, 0x57, 0xC0, 0x03, 0x03, 0x5F, 0xC0, 0x03, 0x03,
	0x5F, 0x00, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x03, 0x0D, 0x11, 0x3C, 0x03,
	0xC0, 0x3C, 0x03, 0xC0, 0xD7, 0x0D, 0x70, 0xD7, 0x0D, 0x70, 0xD7, 0xCD, 0x7C, 0xD7, 0xCD, 0x7C,
	0xD7, 0xCD, 0x7C, 0xD7, 0xC3, 0x5C, 0x35, 0xF5, 0x5F, 0x5F, 0xC0, 0xD7, 0x35, 0xF5, 0x5F, 0x5F,
	0x00, 0x35, 0x0D, 0x77, 0xDD, 0x7F, 0x00, 0x35, 0x0D, 0x57, 0xD5, 0x7C, 0x00, 0xD7, 0x03, 0x5F,
	0xF5, 0xFC, 0x03, 0x5F, 0x03, 0x5F, 0x35, 0xF0, 0x0D, 0x7F, 0x03, 0x5F, 0x35, 0xF0, 0x0D, 0x7C,
	0x00, 0xFF, 0x0F, 0xF0, 0x03, 0xFC, 0x00, 0x3C, 0x03, 0xC0, 0x00, 0xF0, 0x02, 0x0D, 0x0C, 0x3C,
	0x00, 0xF0, 0x0F, 0xD7, 0x03, 0x5C, 0x35, 0xD7, 0xC3, 0x5F, 0x35, 0x35, 0xCD, 0x7F, 0x0D, 0x0D,
	0x75, 0xFC, 0x03, 0x03, 0x57, 0xF0, 0x00, 0x03, 0x57, 0xC0, 0x00, 0x0D, 0x75, 0xC0, 0x00, 0x35,
	0xFD, 0x70, 0x00, 0xD7, 0xF3, 0x5C, 0x00, 0xD7, 0xC3, 0x5F, 0x00, 0x3F, 0xC0, 0xFF, 0x00, 0x0F,
	0x00, 0x3C, 0x00, 0x02, 0x0D, 0x0D, 0x3C, 0x00, 0x3C, 0x03, 0xD7, 0x00, 0xD7, 0x0D, 0xD7, 0xC0,
	0xD7, 0xC3, 0x35, 0xC3, 0x5F, 0xC0, 0x0D, 0x7D, 0x7F, 0x00, 0x03, 0x55, 0xFC, 0x00, 0x00, 0xD7,
	0xF0, 0x00, 0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xC0, 0x03, 0x00, 0xD7, 0xC0, 0x0D, 0x00, 0xD7,
	0xC0, 0x0D, 0x00, 0x3F, 0xC0, 0x03, 0x00, 0x0F, 0x00, 0x00, 0x02, 0x0D, 0x0C, 0x3F, 0xFF, 0xF0,
	0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0x5F, 0x00, 0x0F, 0xFD, 0x7F, 0x00, 0x00, 0x35, 0xFC,
	0x00, 0x00, 0xD7, 0xF0, 0x00, 0x03, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x35, 0xFC, 0x00,
	0x00, 0xD7, 0xFF, 0xF0, 0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFC,
	0x00, 0x01, 0x0E, 0x06, 0x3F, 0x00, 0xD5, 0xC3, 0xDF, 0xF3, 0xDF, 0xC0, 0xDF, 0x00, 0xDF, 0x00,
	0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xD5, 0xC0, 0x3F, 0xF0, 0x0F, 0xC0,
	0x01, 0x0D, 0x08, 0x30, 0x00, 0xDC, 0x00, 0xDF, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC0, 0x0D,
	0xF0, 0x03, 0x70, 0x03, 0x7C, 0x00, 0xDC, 0x00, 0xDF, 0x00, 0x3F, 0x00, 0x0C, 0x01, 0x0E, 0x06,
	0x3F, 0x00, 0xD5, 0xC0, 0x3D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0,
	0x0D, 0xF0, 0x0D, 0xF0, 0x3D, 0xF0, 0xD5, 0xF0, 0x3F, 0xF0, 0x0F, 0xC0, 0x02, 0x0E, 0x0A, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x00, 0x00, 0x0D,
	0x5C, 0x00, 0x03, 0x37, 0x77, 0x00, 0x0D, 0xDF, 0x7D, 0xC0, 0x35, 0x3F, 0x7F, 0xF0, 0x0D, 0x0F,
	0x7C, 0xC0, 0x03, 0x03, 0x7C, 0x00, 0x00, 0x03, 0x7C, 0x00, 0x00, 0x03, 0x7C, 0x00, 0x00, 0x00,
	0xFC, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x02, 0x0C, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x00, 0x00, 0x0D, 0xFC, 0x00, 0x00, 0x37, 0xFF,
	0xC0, 0x00, 0xD5, 0x55, 0x70, 0x00, 0x37, 0xFF, 0xFC, 0x00, 0x0D, 0xFF, 0xF0, 0x00, 0x03, 0x70,
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x01, 0x07, 0x04, 0x0C, 0x00, 0x37,
	0x00, 0xD7, 0x00, 0xD7, 0x00, 0xD7, 0x03, 0xDC, 0x0D, 0x30, 0x03, 0x02, 0x0D, 0x09, 0x00, 0x00,
	0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xF0, 0x00, 0xD7, 0x35, 0x5C,
	0x00, 0xD5, 0xD7, 0xD7, 0x00, 0xD7, 0x3D, 0x57, 0xC0, 0xD7, 0x35, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD5, 0x0F, 0xFF, 0xC0, 0x3F, 0x03, 0xFF,
	0x00, 0x0F, 0x02, 0x0D, 0x09, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD7, 0xC0, 0x00,
	0x00, 0xD7, 0xF0, 0x00, 0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD5, 0x5F, 0xC0,
	0x35, 0x3F, 0xFF, 0x00, 0x0F, 0x0F, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5,
	0xD7, 0xD7, 0x03, 0x5F, 0xD7, 0xFF, 0xC3, 0x5F, 0xD7, 0xCF, 0x03, 0x5F, 0xD7, 0xFC, 0x03, 0x5F,
	0xD7, 0xD7, 0x03, 0x5F, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F,
	0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD7, 0xC0, 0x00, 0x0F,
	0xD7, 0xC0, 0x0F, 0x35, 0x57, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD5, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0x35, 0x0F,
	0xFF, 0xC0, 0x0F, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00,
	0x00, 0x35, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xF0, 0x00, 0xD7, 0x35, 0x5C, 0x03, 0x55, 0xD7, 0xD7,
	0x00, 0xD7, 0xD5, 0x57, 0xC0, 0xD7, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF, 0x00, 0xD7, 0xD7, 0xD7,
	0x00, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0x0F, 0xFF, 0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F, 0x01, 0x0D,
	0x07, 0x03, 0xC0, 0x0D, 0x70, 0x35, 0xFC, 0x35, 0xF0, 0xD5, 0x70, 0x35, 0xFC, 0x35, 0xF0, 0x35,
	0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x0F, 0xF0, 0x03, 0xC0, 0x02, 0x10, 0x09, 0x00, 0x00,
	0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xFC, 0x00, 0xD7, 0x35, 0x57,
	0x00, 0xD5, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD7, 0x3F, 0xD7, 0xC0, 0x3F, 0xD7, 0xD7,
	0xC0, 0x0F, 0x35, 0x5F, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x02, 0x0D,
	0x09, 0x3C, 0x00, 0x00, 0x3C, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xF0, 0x00,
	0x3F, 0xD5, 0x5C, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x3F, 0xFF, 0xC0,
	0x3F, 0x0F, 0x0F, 0x00, 0x0F, 0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0x3F, 0xC0,
	0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0,
	0x0F, 0x00, 0x01, 0x10, 0x06, 0x0F, 0x00, 0x35, 0xC0, 0x35, 0xF0, 0x0F, 0xF0, 0x35, 0xC0, 0x35,
	0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0xD7,
	0xF0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x3C, 0x00, 0x00, 0xF0, 0xD7, 0x00, 0x03, 0x5C,
	0xD7, 0xC0, 0x03, 0x5F, 0xD7, 0xFC, 0x03, 0x5F, 0xD7, 0xD7, 0x03, 0x5F, 0xD7, 0x5F, 0xC3, 0x5F,
	0xD5, 0x7F, 0x03, 0x5F, 0xD5, 0xFC, 0x03, 0x5F, 0xD5, 0x70, 0x03, 0x5F, 0xD7, 0x5C, 0x03, 0x5F,
	0xD7, 0xD7, 0x03, 0x5F, 0x3F, 0xFF, 0xC0, 0xFF, 0x0F, 0x0F, 0x00, 0x3C, 0x01, 0x0D, 0x05, 0x3C,
	0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7,
	0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x0D, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, 0x00, 0xD5, 0x55, 0x5C, 0x00,
	0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xFF, 0xFF, 0xC0, 0x0F, 0x0F, 0x0F, 0x00,
	0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F,
	0xF0, 0x00, 0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x35, 0x3F,
	0xFF, 0xC0, 0x0F, 0x0F, 0x0F, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7,
	0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7,
	0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0xD7, 0x03, 0xFC, 0x00, 0xD7, 0x02, 0x10,
	0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00,
	0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD5, 0x5F, 0xC0, 0x35, 0xD7, 0xFF, 0x00,
	0x0F, 0xD7, 0xFC, 0x00, 0x03, 0xD7, 0xC0, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00, 0x00,
	0x00, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xFC, 0x00, 0x3F, 0x35, 0x57, 0x00, 0xD5, 0xD7, 0xD7, 0xC0, 0xD5, 0xD7, 0xD7, 0xC0, 0xD7,
	0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD7,
	0x0F, 0xD7, 0xC0, 0x3F, 0x03, 0xD7, 0xC0, 0x0F, 0x00, 0xD7, 0xC0, 0x00, 0x00, 0x3F, 0xC0, 0x00,
	0x00, 0x0F, 0x00, 0x00, 0x01, 0x0D, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0xD5,
	0x70, 0xD5, 0xFC, 0xD7, 0xF0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F,
	0x00, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7,
	0x0F, 0xF0, 0x00, 0xD7, 0x35, 0x5C, 0x03, 0x55, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xFF, 0xC0, 0xD7,
	0x35, 0x5F, 0x00, 0xD7, 0x3F, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35,
	0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x01, 0x0D, 0x07, 0x00, 0x00, 0x0F, 0x00, 0x35,
	0xC0, 0x35, 0xF0, 0xD5, 0x70, 0x35, 0xFC, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x0D,
	0x70, 0x03, 0xFC, 0x00, 0xF0, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0xF0, 0xD7, 0xD7, 0x03, 0x5C, 0xD7, 0xD7, 0xC3, 0x5F,
	0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x0D,
	0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF, 0xC0, 0x03, 0x03, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x03, 0xC0, 0x3C, 0xD7,
	0x0D, 0x70, 0xD7, 0xD7, 0xCD, 0x7C, 0xD7, 0x35, 0xF5, 0xFC, 0x35, 0x35, 0xF5, 0xF0, 0x35, 0x0D,
	0x57, 0xF0, 0x35, 0x03, 0x5F, 0xC0, 0x0D, 0x03, 0x5F, 0x00, 0x0D, 0x00, 0xFF, 0x00, 0x03, 0x00,
	0x3C, 0x00, 0x00, 0x02, 0x0D, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x00, 0x3C, 0x03, 0xD7, 0x3C, 0xD7, 0x0D, 0xD7, 0xD7, 0xD7, 0xC3, 0x35, 0xD7,
	0x5F, 0xC0, 0x35, 0xD7, 0x5F, 0x00, 0x35, 0x55, 0x5F, 0x00, 0x0D, 0x7D, 0x7F, 0x03, 0x0D, 0x7D,
	0x7C, 0x0D, 0x03, 0xFF, 0xFC, 0x03, 0x00, 0xF0, 0xF0, 0x00, 0x02, 0x0D, 0x0B, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x03, 0xC0, 0x3C, 0xD7, 0x0D, 0x70,
	0xD7, 0x35, 0xF5, 0xFC, 0xD7, 0x0D, 0x57, 0xF0, 0x35, 0x03, 0x5F, 0xC0, 0x35, 0x0D, 0x57, 0x00,
	0x0D, 0x35, 0xF5, 0xC0, 0x0D, 0xD7, 0xFD, 0x70, 0x03, 0x3F, 0xC3, 0xFC, 0x03, 0x0F, 0x00, 0xF0,
	0x0D, 0x02, 0x10, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3C, 0x03, 0xC0, 0x0F, 0xD7, 0x0D, 0x70, 0x35, 0xD7, 0xCD, 0x7C, 0x0F, 0x35, 0xF5, 0xFC, 0x03,
	0x35, 0xF5, 0xF0, 0x03, 0x0D, 0x57, 0xF0, 0x0D, 0x0D, 0x57, 0xC0, 0x35, 0x03, 0x5F, 0xC0, 0x35,
	0x03, 0x5F, 0x00, 0x0F, 0x0D, 0x7F, 0x00, 0x03, 0x35, 0xFC, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
	0x03, 0xC0, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0xD5, 0x57, 0x00, 0x00, 0x3F, 0xD7, 0xC0, 0x00, 0x0F,
	0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x35, 0xFC, 0x00, 0x00, 0xD7, 0xFC, 0x00, 0x00, 0xD5,
	0x57, 0x00, 0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x01, 0x0E, 0x07, 0x00, 0x00,
	0x03, 0xC0, 0x0D, 0x70, 0x37, 0xFC, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0, 0xDF, 0x00, 0x37, 0x00,
	0x37, 0xC0, 0x37, 0xC0, 0x0D, 0x70, 0x03, 0xFC, 0x00, 0xF0, 0x01, 0x0F, 0x04, 0x30, 0x00, 0xDC,
	0x0F, 0xDF, 0x35, 0xDF, 0x0F, 0xDF, 0x03, 0xDF, 0x03, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x03, 0xDF,
	0x03, 0xDF, 0x0F, 0xDF, 0x35, 0xDF, 0x0F, 0x3F, 0x03, 0x0C, 0x00, 0x01, 0x0E, 0x07, 0x00, 0x00,
	0x3C, 0x00, 0xD7, 0x00, 0x3D, 0xC0, 0x0D, 0xF0, 0x0D, 0xF0, 0x03, 0x70, 0x03, 0x7C, 0x0D, 0xFC,
	0x0D, 0xF0, 0x3D, 0xF0, 0xD7, 0xF0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x08, 0x0A, 0x00, 0x00, 0x00,
	0xC0, 0x00, 0x00, 0x03, 0x70, 0x0F, 0x00, 0x03, 0x70, 0x35, 0xC3, 0x00, 0xC0, 0xDF, 0x7D, 0xC0,
	0x00, 0x3F, 0xD7, 0xF0, 0x00, 0x0C, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x01, 0x04, 0x03,
	0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x10, 0x0A, 0x03, 0xFC, 0x00, 0x00, 0x0D,
	0x57, 0x00, 0x00, 0x35, 0xF5, 0xC0, 0x00, 0xD7, 0xFD, 0xF0, 0x00, 0xD7, 0xC3, 0xF0, 0x00, 0xD7,
	0xC0, 0xC0, 0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xC3, 0x00, 0x00, 0xD7, 0xCD, 0xC0, 0x00, 0x35,
	0xF5, 0xF0, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0x7F, 0xC0, 0x00, 0x03, 0xDF, 0x00, 0x00, 0x01,
	0xDF, 0x00, 0x00, 0x03, 0x7C, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x0C, 0x0C,
	0x00, 0x00, 0x37, 0x37, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x03, 0x3F, 0xFF, 0xC0, 0x00, 0x3F, 0x3F,
	0x00, 0x03, 0xD7, 0xD7, 0x00, 0x0D, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7,
	0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF, 0xC0, 0x03, 0x03, 0xFF,
	0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x03, 0x03, 0xDC, 0x00, 0x0D, 0x0D, 0x7F, 0x00,
	0x37, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00,
	0xD7, 0xD5, 0x57, 0xC0, 0x3D, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0x35, 0x5F, 0xC0,
	0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00, 0x03,
	0x0D, 0x70, 0x00, 0x0D, 0x37, 0xDC, 0x00, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x0F, 0xFC, 0x00, 0x03,
	0x35, 0x5C, 0x00, 0x0D, 0xD7, 0xD7, 0x00, 0x35, 0x3D, 0x57, 0xC0, 0x0F, 0x35, 0xD7, 0xC0, 0x0D,
	0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF, 0xC0, 0x03, 0x03, 0xFF, 0x00, 0x00,
	0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x0C, 0x37, 0x37, 0x00, 0x37, 0xD7, 0xD7, 0xC0, 0x0D, 0x3F,
	0xFF, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x03, 0x5F, 0x3D,
	0x57, 0xC0, 0xF5, 0x35, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC3, 0x5F, 0x35, 0x57, 0xC0, 0xD5, 0x0F,
	0xFF, 0xC0, 0x3F, 0x03, 0xFF, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x03, 0x00, 0x00, 0x00, 0x0D, 0xF0,
	0x00, 0x03, 0x03, 0x5C, 0x00, 0x0D, 0x00, 0xFF, 0x00, 0x03, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C,
	0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0x3D, 0x57, 0xC0, 0x3D, 0x35, 0xD7, 0xC0, 0x35, 0xD7, 0xD7,
	0xC0, 0xD7, 0x35, 0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x0D,
	0x09, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x00, 0x00, 0x0D, 0xDC, 0x00, 0x00, 0x03, 0x7F, 0x00,
	0x03, 0x0F, 0xFC, 0x00, 0x0D, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0x35, 0x3D, 0x57, 0xC0,
	0x35, 0x35, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF, 0xC0,
	0x03, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x00, 0x00, 0x00, 0x0D, 0x0F, 0xF0, 0x00, 0x03, 0x35, 0x5C, 0x00, 0x03, 0xD7, 0xD7, 0x00, 0x0D,
	0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xCF, 0x00, 0x35, 0xD7, 0xFC, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0x35,
	0x35, 0x5F, 0xC0, 0x0D, 0x0D, 0xFF, 0x00, 0x03, 0x0F, 0x7C, 0x00, 0x00, 0x07, 0x7C, 0x00, 0x00,
	0x0D, 0xF0, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00, 0x0C, 0x0D,
	0x70, 0x00, 0x37, 0x37, 0xDC, 0x00, 0xD7, 0x0F, 0xFF, 0x00, 0x3F, 0x0F, 0xFC, 0x00, 0x0F, 0x35,
	0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD5, 0x57, 0xC0, 0xD5, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7,
	0xD7, 0x00, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02,
	0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x03, 0x37, 0x37, 0x00, 0x0D, 0xD7, 0xD7, 0xC0, 0x03, 0x3F, 0xFF,
	0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x03, 0x35, 0x5C, 0x00, 0x0D, 0xD7, 0xD7, 0x00, 0x35, 0xD5, 0x57,
	0xC0, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xD7, 0x00, 0x35, 0x35, 0x5F, 0xC0, 0x0D, 0x0F, 0xFF,
	0x00, 0x03, 0x03, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x0C, 0x00, 0x00, 0x03, 0x37, 0xC0, 0x00,
	0x0D, 0x0D, 0x70, 0x00, 0x35, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00, 0x03, 0x35, 0x5C, 0x00,
	0x03, 0xD7, 0xD7, 0x00, 0x03, 0xD5, 0x57, 0xC0, 0x03, 0xD7, 0xFF, 0xC0, 0x03, 0xD7, 0xD7, 0x00,
	0x03, 0x35, 0x5F, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x09,
	0x0C, 0x0C, 0x00, 0x03, 0x37, 0x37, 0x00, 0x0D, 0xD7, 0xD7, 0xC0, 0x37, 0x3F, 0xFF, 0xC0, 0x0F,
	0x0F, 0xCF, 0x00, 0x0F, 0x0D, 0x70, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D,
	0x0D, 0x7C, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D, 0x03, 0xFC, 0x00, 0x03,
	0x00, 0xF0, 0x00, 0x00, 0x01, 0x0D, 0x07, 0x0F, 0x00, 0x35, 0xC0, 0xDF, 0x70, 0x3F, 0xFC, 0x3F,
	0x30, 0x35, 0xC0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x0F, 0xF0, 0x03,
	0xC0, 0x01, 0x0D, 0x06, 0x30, 0x00, 0xDF, 0x00, 0x35, 0xC0, 0x0F, 0xF0, 0x3C, 0x00, 0xD7, 0x00,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0F,
	0x0F, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x37, 0x37, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x3F, 0xFF,
	0xC0, 0x00, 0xFF, 0xFF, 0xC0, 0x00, 0xD5, 0x57, 0xF0, 0x00, 0xDF, 0x57, 0xC0, 0x00, 0xDF, 0x77,
	0xC0, 0x00, 0x3D, 0x57, 0xC0, 0x30, 0x0D, 0xF7, 0xC0, 0xDC, 0xF7, 0xF7, 0x70, 0xD7, 0x5F, 0xF5,
	0x7C, 0x3D, 0xFF, 0x0F, 0xFC, 0x0F, 0xFC, 0x03, 0xF0, 0x00, 0xC0, 0x00, 0x00, 0x01, 0x04, 0x03,
	0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC,
	0x00, 0x30, 0x0F, 0x02, 0x0D, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0F, 0xF0, 0x3F, 0xC0, 0x35, 0x5C, 0xD5, 0x70, 0xD7, 0xD7, 0x5F, 0x5C, 0x3D, 0x57,
	0x55, 0x5F, 0x35, 0xD7, 0x5F, 0xFF, 0xD7, 0xD7, 0x5F, 0xFC, 0xD7, 0xD7, 0x5F, 0x5C, 0x35, 0x55,
	0x55, 0x7F, 0x0F, 0xFF, 0xFF, 0xFC, 0x03, 0xFF, 0xFF, 0xF0, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC,
	0x03, 0xDC, 0x0D, 0x30, 0x03, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00, 0x30, 0x0D, 0x70, 0x00, 0xDC,
	0x37, 0xDC, 0x03, 0x5F, 0x0F, 0xFF, 0x00, 0xFF, 0x0F, 0xFC, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5,
	0xD7, 0xD7, 0x03, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F,
	0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x0C,
	0x0C, 0x00, 0x0C, 0x37, 0x37, 0x00, 0x37, 0xD7, 0xD7, 0xC0, 0x0D, 0x3F, 0xFF, 0xC0, 0x03, 0x0F,
	0xFF, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03,
	0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0C, 0x00, 0x00, 0x03, 0x37, 0xC0, 0x00, 0x0D, 0x0D, 0x70,
	0x00, 0x37, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD7, 0xD7, 0xD7,
	0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F,
	0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00,
	0x0C, 0x0D, 0x70, 0x00, 0x37, 0x37, 0xDC, 0x00, 0x0D, 0x0F, 0xFF, 0x00, 0x03, 0x3F, 0x3C, 0x00,
	0x3C, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF, 0x00,
	0x03, 0x02, 0x0D, 0x09, 0x0C, 0x00, 0x00, 0x03, 0x37, 0xC0, 0x00, 0x0D, 0x0D, 0x70, 0x00, 0x0D,
	0x03, 0xFC, 0x00, 0x03, 0x3C, 0x3C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00,
	0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x35, 0x57, 0xC0, 0x00,
	0x0F, 0xFF, 0xC0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC,
	0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04,
	0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x03,
	0xDC, 0x03, 0x30, 0x00, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01,
	0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC,
	0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00,
	0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x03, 0x03, 0xDC, 0x00, 0x3D, 0x0D, 0x7F, 0x00, 0xD7, 0x03,
	0xFC, 0x00, 0x3F, 0x0F, 0xF0, 0x00, 0x3C, 0x35, 0x5C, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0x3D,
	0x57, 0xC0, 0xD7, 0x35, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD7, 0x0F,
	0xFF, 0xC0, 0x3F, 0x03, 0xFF, 0x00, 0x0F, 0x01, 0x0D, 0x06, 0x03, 0x00, 0x3D, 0xC0, 0xD7, 0xF0,
	0x3F, 0xC0, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0,
	0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x00, 0x03, 0xDC, 0x00, 0x0F, 0x0D,
	0x7F, 0x00, 0x35, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00, 0xF0, 0x35, 0x5C, 0x03, 0x5F, 0xD7,
	0xD7, 0x03, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0x35,
	0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x00, 0x30,
	0x00, 0x03, 0x03, 0xDC, 0x00, 0x0D, 0x0D, 0x7F, 0x00, 0x37, 0x03, 0xFC, 0x00, 0x0F, 0x3C, 0x3C,
	0x00, 0x0F, 0xD7, 0xD7, 0x00, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7,
	0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF,
	0x00, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0x0C, 0x00, 0x00, 0x35, 0xF7, 0x00, 0x00, 0xDF, 0x5F, 0xC0,
	0x00, 0x3F, 0xFF, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0xD5, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00,
	0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0,
	0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x0F, 0x0F, 0x00, 0x00, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC,
	0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01,
	0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00,
	0x00, 0x0D, 0x70, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x0D, 0x70, 0x00,
	0x00, 0x0D, 0x7C, 0x00, 0x00, 0x35, 0xFC, 0x00, 0x00, 0xD7, 0xFC, 0x00, 0x00, 0xD7, 0xD7, 0x00,
	0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x35, 0x5F, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00,
	0x00, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30,
	0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC,
	0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x01, 0x0F, 0x06,
	0x00, 0x00, 0x03, 0x00, 0x0D, 0xC0, 0x35, 0xF0, 0x37, 0xF0, 0x0F, 0xC0, 0x0D, 0xC0, 0x35, 0xF0,
	0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0xD5, 0xF0, 0xD7, 0xF0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0F,
	0x0C, 0x0F, 0xFF, 0xC0, 0x00, 0x35, 0x55, 0x70, 0x00, 0xD7, 0xDF, 0x5C, 0x00, 0xDF, 0x5F, 0x5F,
	0x00, 0x3F, 0x5F, 0x5F, 0x00, 0x0F, 0x5D, 0x7F, 0x00, 0x03, 0x5D, 0x5C, 0x00, 0x03, 0x5F, 0x5F,
	0x00, 0x0D, 0x57, 0x5F, 0x00, 0x0D, 0x75, 0x7F, 0x00, 0x0D, 0x7F, 0xFC, 0x00, 0x0D, 0xFF, 0xF0,
	0x00, 0x35, 0xF0, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00
};

const uint16 Graphics::_freGerFontOffs[] = {
	0x0000, 0x0007, 0x0024, 0x0043, 0x0072, 0x00AD, 0x00E0, 0x0113, 0x0124, 0x0141,
	0x015E, 0x0191, 0x01C4, 0x01E3, 0x01F8, 0x0215, 0x0232, 0x0269, 0x0286, 0x02BD,
	0x02F4, 0x032B, 0x0362, 0x0399, 0x03D0, 0x0407, 0x043E, 0x045B, 0x047C, 0x0495,
	0x04C0, 0x04D9, 0x0510, 0x054B, 0x0582, 0x05B9, 0x05F0, 0x0627, 0x065E, 0x0695,
	0x06CC, 0x0703, 0x0720, 0x0757, 0x078E, 0x07C5, 0x07FC, 0x0833, 0x086A, 0x08A1,
	0x08D8, 0x090F, 0x0946, 0x097D, 0x09B4, 0x09EB, 0x0A3C, 0x0A73, 0x0AAA, 0x0AE1,
	0x0B00, 0x0B1D, 0x0B3C, 0x0B77, 0x0BAE, 0x0BBF, 0x0BF6, 0x0C2D, 0x0C64, 0x0C9B,
	0x0CD2, 0x0CEF, 0x0D32, 0x0D69, 0x0D86, 0x0DA9, 0x0DE0, 0x0DFD, 0x0E34, 0x0E6B,
	0x0EA2, 0x0EE5, 0x0F28, 0x0F45, 0x0F7C, 0x0F99, 0x0FD0, 0x1007, 0x103E, 0x1075,
	0x10B8, 0x10EF, 0x110E, 0x112F, 0x114E, 0x1171, 0x117C, 0x11BF, 0x11F6, 0x122D,
	0x1264, 0x129B, 0x12D2, 0x1309, 0x134C, 0x1383, 0x13BA, 0x13F1, 0x1428, 0x1445,
	0x1462, 0x1499, 0x14A4, 0x14DB, 0x1512, 0x1549, 0x1580, 0x15B7, 0x15EE, 0x1625,
	0x165C, 0x1667, 0x169E, 0x16D5, 0x16E0, 0x16EB, 0x1722, 0x172D, 0x1730, 0x1767,
	0x1784, 0x17BB, 0x17F2, 0x1829, 0x1834, 0x183F, 0x184A, 0x1881, 0x188C, 0x1897,
	0x18A2, 0x18AD, 0x18CA, 0x18F5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x1920
};

const int Graphics::_freGerFontSize = ARRAYSIZE(Graphics::_freGerFontOffs);

const uint8 Graphics::_freGerFontData[] = {
	0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0D, 0x05, 0x3C, 0x03, 0xD7, 0x0D, 0xD7, 0xCD,
	0xD7, 0xCD, 0xD7, 0xCD, 0xD7, 0xC3, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0xD7, 0x00, 0xD7, 0xC0,
	0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x07, 0x09, 0x3C, 0x3C, 0x00, 0x0C, 0xD7, 0xD7, 0x00, 0x37, 0xD7,
	0xD7, 0xC0, 0xF7, 0xD7, 0xD7, 0xC3, 0x55, 0xD7, 0xD7, 0xC0, 0xDF, 0x3F, 0xFF, 0xC3, 0xDF, 0x0F,
	0x0F, 0x0D, 0x55, 0x02, 0x0B, 0x0B, 0x00, 0xC3, 0x00, 0x03, 0x03, 0x7D, 0xC0, 0x0D, 0x0F, 0x7D,
	0xF0, 0x0D, 0x35, 0x55, 0x70, 0x35, 0x0D, 0xF7, 0xFC, 0xDD, 0x3D, 0xF7, 0xF0, 0xDD, 0xD5, 0x55,
	0xC0, 0x35, 0x37, 0xDF, 0xF0, 0x3D, 0x37, 0xDF, 0xC0, 0xDD, 0x0F, 0xFF, 0x00, 0x35, 0x03, 0x0C,
	0x00, 0x0D, 0x02, 0x0E, 0x09, 0x03, 0x00, 0x00, 0xF0, 0x0D, 0xC0, 0x03, 0x5C, 0x0D, 0xF0, 0x0D,
	0xF7, 0x35, 0x5C, 0x0D, 0xF7, 0xDD, 0xF7, 0x03, 0x5F, 0xDD, 0xFF, 0xC0, 0xFD, 0x35, 0x5F, 0x00,
	0x37, 0x3D, 0xF7, 0x00, 0xDF, 0xDD, 0xF7, 0xC3, 0x7F, 0x35, 0x5F, 0xC0, 0xFC, 0x0D, 0xFF, 0x00,
	0x30, 0x0D, 0xFC, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x02, 0x0C, 0x0C,
	0x0F, 0x00, 0x00, 0x00, 0x35, 0xC0, 0xC0, 0x00, 0xDF, 0x73, 0x70, 0x03, 0xDF, 0x7D, 0xFC, 0x0D,
	0x35, 0xF7, 0xF0, 0x37, 0x0F, 0xDF, 0xC0, 0x37, 0x03, 0x7D, 0x70, 0x0D, 0x0D, 0xF7, 0xDC, 0x37,
	0x37, 0xF7, 0xDF, 0x37, 0x0F, 0xCD, 0x7F, 0x0D, 0x03, 0x03, 0xFC, 0x03, 0x00, 0x00, 0xF0, 0x00,
	0x02, 0x0C, 0x0B, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xC0, 0x00, 0xD7, 0x35,
	0x70, 0x00, 0xD7, 0xDF, 0xDC, 0x00, 0xD7, 0xDF, 0xFF, 0xC0, 0xFF, 0x35, 0x7D, 0x70, 0x3F, 0xDF,
	0xF7, 0xFC, 0x00, 0xDF, 0xDF, 0xF0, 0x00, 0x35, 0x7F, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x03,
	0xF0, 0x00, 0x00, 0x01, 0x07, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC3, 0xD7, 0xC3, 0xD7, 0xCD,
	0xFF, 0xCD, 0x3F, 0x0D, 0x01, 0x0D, 0x06, 0x03, 0x00, 0x0D, 0xC3, 0x37, 0xF0, 0x37, 0xC0, 0xDF,
	0xC0, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC3, 0x03, 0xF0, 0x00,
	0xC0, 0x01, 0x0D, 0x06, 0x30, 0x00, 0xDC, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC0, 0x0D, 0xF0,
	0x0D, 0xF3, 0x0D, 0xF0, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x02, 0x0C,
	0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x03, 0x0F, 0x7C, 0x00,
	0x0D, 0x37, 0x77, 0x00, 0x0D, 0x3D, 0x5F, 0xC0, 0xFD, 0xD5, 0xD5, 0xC3, 0x55, 0x3D, 0x5F, 0xF0,
	0xFD, 0x37, 0x77, 0xC0, 0x3D, 0x0F, 0x7F, 0xC0, 0x0D, 0x03, 0xFF, 0x00, 0x03, 0x00, 0x30, 0x00,
	0x00, 0x02, 0x0C, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00,
	0x03, 0x70, 0x00, 0x00, 0x03, 0x7C, 0x00, 0x00, 0x3F, 0x7F, 0x00, 0x00, 0xD5, 0x55, 0xC0, 0x00,
	0x3F, 0x7F, 0xF0, 0x00, 0x0F, 0x7F, 0xC0, 0x3C, 0x03, 0x7C, 0x00, 0xD7, 0x00, 0xFC, 0x00, 0xD7,
	0x00, 0x30, 0x03, 0x5F, 0x01, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x0F, 0x00, 0x35, 0xC0, 0x35, 0xF0, 0xD7, 0xF0, 0x3F,
	0xC0, 0x0F, 0x00, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3F, 0xC0, 0xD5, 0x70, 0x3F, 0xFC, 0x0F, 0xF0, 0x01, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3C, 0x03, 0xD7, 0x0D, 0xD7,
	0xCD, 0x3F, 0xC3, 0x0F, 0x00, 0x01, 0x0D, 0x08, 0x00, 0x00, 0x00, 0x30, 0x00, 0xDC, 0x03, 0x7F,
	0x03, 0x7C, 0x0D, 0xFC, 0x0D, 0xF0, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0, 0xDF, 0x00, 0x3F, 0x00,
	0x0C, 0x00, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0xF5, 0xD7, 0xD7, 0x03,
	0x55, 0xD7, 0xD7, 0xC0, 0xF5, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0,
	0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x5F, 0xC0,
	0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x01, 0x0D, 0x07, 0x03, 0xC0, 0x3D, 0x70,
	0xD5, 0x7C, 0x3D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C,
	0x0D, 0x7C, 0x03, 0xFC, 0x00, 0xF0, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00,
	0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0x3F, 0xD7, 0xC0, 0x0F, 0x0F, 0x5F, 0xC0,
	0x0D, 0x0D, 0x7F, 0x00, 0x03, 0x35, 0xFC, 0x00, 0x00, 0xD7, 0xF0, 0x00, 0x3C, 0xD7, 0xFC, 0x00,
	0xD7, 0xD5, 0x57, 0x00, 0x35, 0x3F, 0xFF, 0xC0, 0x0F, 0x0F, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09,
	0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x03, 0x3F, 0xD7, 0xC0, 0x0D,
	0x0F, 0xD7, 0xC0, 0x0D, 0x0D, 0x5F, 0xC0, 0x35, 0x03, 0xD7, 0x00, 0x35, 0x00, 0xD7, 0xC0, 0xD7,
	0x3C, 0xD7, 0xC0, 0xD5, 0xD7, 0xD7, 0xC0, 0x3F, 0x35, 0x5F, 0xC0, 0x0F, 0x0F, 0xFF, 0x00, 0x00,
	0x03, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x3F, 0x00, 0xD7, 0x00, 0xD5, 0x03,
	0x57, 0xC0, 0xD7, 0x0D, 0x57, 0xC0, 0xD7, 0x0D, 0x57, 0xC0, 0xD7, 0x35, 0xD7, 0xC0, 0xD5, 0x35,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xD5, 0x57, 0xC0, 0x3F, 0x3F, 0xD7, 0xC0, 0xD7, 0x0F,
	0xD7, 0xC0, 0x35, 0x00, 0x3F, 0xC0, 0x0F, 0x00, 0x0F, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x3F, 0xFC,
	0x00, 0x0F, 0xD5, 0x57, 0x00, 0x35, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF, 0x00, 0xD7, 0xD7, 0xF0,
	0x00, 0xD7, 0xD5, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x00, 0xD7, 0x3F, 0xD7, 0xC0, 0xD7, 0x3F, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC,
	0x00, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x00,
	0x3F, 0xD7, 0xFF, 0xC0, 0x0F, 0xD7, 0xFF, 0x00, 0x03, 0xD5, 0x5C, 0x00, 0x0D, 0xD7, 0xD7, 0x00,
	0x0D, 0xD7, 0xD7, 0xC0, 0x0D, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x5F, 0xC0,
	0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x3F, 0xFC, 0x00, 0x0F,
	0xD5, 0x57, 0x00, 0x35, 0x3F, 0xD7, 0xC0, 0xD7, 0x0F, 0x5F, 0xC0, 0xD7, 0x03, 0x5F, 0x00, 0xD7,
	0x0D, 0x7F, 0x00, 0x35, 0x0D, 0x7C, 0x00, 0xD7, 0x0D, 0x7C, 0x00, 0xD7, 0x35, 0xFC, 0x00, 0xD7,
	0x35, 0xF0, 0x00, 0xD7, 0x35, 0xF0, 0x00, 0x35, 0x0F, 0xF0, 0x00, 0x0F, 0x03, 0xC0, 0x00, 0x03,
	0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0xD7, 0xD7, 0x00, 0x35, 0xD7,
	0xD7, 0xC0, 0x0F, 0xD7, 0xD7, 0xC0, 0x3F, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F,
	0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C,
	0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0xF0, 0xD7, 0xD7,
	0xC3, 0x5C, 0x35, 0x57, 0xC3, 0x5F, 0x0F, 0xD7, 0xC0, 0xFF, 0x3F, 0xD7, 0xC0, 0xFC, 0xD7, 0xD7,
	0xC3, 0x5C, 0x35, 0x5F, 0xC3, 0x5F, 0x0F, 0xFF, 0x00, 0xFF, 0x03, 0xFC, 0x00, 0x3C, 0x01, 0x0D,
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0xD7, 0x03, 0xD7, 0xC3, 0x3F,
	0xC0, 0x3F, 0x00, 0xD7, 0x03, 0xD7, 0xC3, 0x3F, 0xC0, 0x0F, 0x03, 0x01, 0x0F, 0x05, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0x3F, 0xC0, 0x3F, 0x00,
	0xD7, 0x00, 0xD7, 0xC0, 0x37, 0xC0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x01, 0x0B, 0x07, 0x00,
	0x00, 0x00, 0xC0, 0x03, 0x70, 0x0D, 0xFC, 0x37, 0xF0, 0xDF, 0xC0, 0x37, 0x00, 0x0D, 0xC0, 0x03,
	0x70, 0x00, 0xFC, 0x00, 0x30, 0x02, 0x0A, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0,
	0x00, 0x00, 0x03, 0x70, 0x3F, 0xFC, 0x00, 0xDC, 0xD5, 0x57, 0x00, 0x37, 0x3F, 0xFF, 0xC0, 0x0D,
	0x3F, 0xFF, 0x00, 0x37, 0xD5, 0x57, 0x00, 0xDF, 0x3F, 0xFF, 0xC3, 0x7F, 0x0F, 0xFF, 0x00, 0xFC,
	0x01, 0x0B, 0x07, 0x00, 0x00, 0x30, 0x00, 0xDC, 0x00, 0x37, 0x00, 0x0D, 0xC0, 0x03, 0x70, 0x0D,
	0xFC, 0x37, 0xF0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x00,
	0x35, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x3F, 0xD7, 0xC0, 0x00,
	0x0F, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00,
	0x0D, 0x70, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00,
	0x02, 0x0E, 0x0D, 0x03, 0xFF, 0xC0, 0x00, 0x0D, 0x55, 0x70, 0x00, 0x37, 0xFF, 0xDC, 0x00, 0xDF,
	0xFF, 0xF7, 0x00, 0xDF, 0xD5, 0xF7, 0xC0, 0xDF, 0x7D, 0xF7, 0xC0, 0xDF, 0x7D, 0xF7, 0xC0, 0xDF,
	0x7D, 0xF7, 0xC0, 0xDF, 0x75, 0xDF, 0xC0, 0xDF, 0xDD, 0x7F, 0x00, 0x37, 0xFF, 0xFC, 0x00, 0x0D,
	0x5C, 0xF0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x00, 0xF0,
	0x00, 0x3F, 0x03, 0x5C, 0x00, 0xD5, 0x03, 0x5F, 0x00, 0xD7, 0x0D, 0x57, 0x00, 0xD7, 0x0D, 0x57,
	0xC0, 0xD7, 0x0D, 0xF7, 0xC0, 0xD5, 0x35, 0xF5, 0xC0, 0xD7, 0x35, 0xF5, 0xF0, 0xD7, 0x35, 0x55,
	0xF0, 0xD7, 0xD7, 0xFD, 0x70, 0xD7, 0xD7, 0xFD, 0x7C, 0xD5, 0x3F, 0xC3, 0xFC, 0x3F, 0x0F, 0x00,
	0xF0, 0x0F, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0x00, 0x03, 0xD5, 0x55, 0xC0, 0x0D, 0xD7, 0xFD, 0x70,
	0x35, 0xD7, 0xFD, 0x7C, 0xD7, 0xD7, 0xFD, 0x7C, 0xD7, 0xD5, 0x55, 0xFC, 0xD7, 0xD7, 0xFD, 0x70,
	0xD7, 0xD7, 0xFD, 0x7C, 0xD7, 0xD7, 0xCD, 0x7C, 0xD7, 0xD7, 0xFD, 0x7C, 0x35, 0xD5, 0x55, 0xFC,
	0x0D, 0x3F, 0xFF, 0xF0, 0x03, 0x0F, 0xFF, 0xC0, 0x00, 0x02, 0x0D, 0x0A, 0x03, 0xFC, 0x00, 0x0F,
	0x0D, 0x57, 0x00, 0x35, 0x35, 0xF5, 0xC0, 0x35, 0xD7, 0xFD, 0xF0, 0x35, 0xD7, 0xC3, 0xF0, 0x35,
	0xD7, 0xC0, 0xC0, 0x35, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xC3, 0x00, 0x35, 0xD7, 0xCD, 0xC0, 0x35,
	0x35, 0xF5, 0xF0, 0x35, 0x0D, 0x57, 0xF0, 0x35, 0x03, 0xFF, 0xC0, 0x0F, 0x00, 0xFF, 0x00, 0x03,
	0x02, 0x0D, 0x0B, 0x3F, 0xFC, 0x00, 0x03, 0xD5, 0x57, 0x00, 0x0D, 0xD7, 0xF5, 0xC0, 0x0D, 0xD7,
	0xFD, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xF5, 0xFC, 0x0D, 0xD5, 0x57, 0xF0, 0x0D, 0x3F,
	0xFF, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0A, 0x3F, 0xFF, 0x00, 0x0F, 0xD5, 0x55,
	0xC0, 0x35, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xFC, 0x00, 0x35, 0xD5, 0x57,
	0x00, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xFF, 0x00, 0x35, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xFF,
	0x00, 0x35, 0xD5, 0x55, 0xC0, 0x35, 0x3F, 0xFF, 0xF0, 0x0F, 0x0F, 0xFF, 0xC0, 0x03, 0x02, 0x0D,
	0x0A, 0x3F, 0xFF, 0x00, 0x03, 0xD5, 0x55, 0xC0, 0x0D, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0,
	0xD7, 0xD7, 0xFC, 0x00, 0xD7, 0xD5, 0x57, 0x00, 0xD7, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF, 0x00,
	0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xC0, 0x00, 0x0D, 0x3F, 0xC0, 0x00,
	0x03, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFF, 0x00, 0x03, 0x0D, 0x55, 0xC0, 0x0D,
	0x35, 0xFD, 0x70, 0x0D, 0xD7, 0xFF, 0x7C, 0x0D, 0xD7, 0xC0, 0xFC, 0x0D, 0xD7, 0xFF, 0xF0, 0x0D,
	0xD7, 0xD5, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x35, 0xFD, 0x7C, 0x0D,
	0x0D, 0x57, 0x7C, 0x0D, 0x03, 0xFF, 0xFC, 0x03, 0x00, 0xFF, 0x30, 0x00, 0x02, 0x0D, 0x0B, 0x3C,
	0x03, 0xC0, 0x03, 0xD7, 0x0D, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xFD, 0x7C, 0x0D, 0xD5, 0x55, 0x7C, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x3F, 0xC3, 0xFC, 0x03, 0x0F,
	0x00, 0xF0, 0x00, 0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC3, 0xD7, 0xC3, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00,
	0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0x00,
	0xD7, 0xC0, 0xD7, 0x00, 0xD7, 0xC0, 0xD5, 0x00, 0xD7, 0xC0, 0xD5, 0x00, 0xD7, 0xC0, 0xD5, 0x3C,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0x0F,
	0xFF, 0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x0B, 0x3C, 0x0F, 0x00, 0x0F, 0xD7, 0x35,
	0xC0, 0x35, 0xD7, 0xD7, 0xF0, 0x35, 0xD7, 0x5F, 0xC0, 0x35, 0xD5, 0x7F, 0x00, 0x35, 0xD5, 0xFC,
	0x00, 0x35, 0xD5, 0x70, 0x00, 0x35, 0xD7, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0x35, 0xD7, 0xF5,
	0xC0, 0x35, 0xD7, 0xCD, 0x70, 0x35, 0x3F, 0xC3, 0xFC, 0x0F, 0x0F, 0x00, 0xF0, 0x03, 0x02, 0x0D,
	0x0A, 0x3C, 0x00, 0x00, 0x3C, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00,
	0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00,
	0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xFF, 0x00, 0xD7, 0xD5, 0x55, 0xC0, 0xD7, 0x3F, 0xFF, 0xF0,
	0x3F, 0x0F, 0xFF, 0xC0, 0x0F, 0x02, 0x0D, 0x0D, 0x3C, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0x00,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD5, 0xC3, 0x57, 0xC0, 0xD5, 0xF3, 0x57, 0xC0, 0xD5, 0x7D, 0x57, 0xC0,
	0xD5, 0x7D, 0x57, 0xC0, 0xD7, 0x55, 0xD7, 0xC0, 0xD7, 0x55, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xFF, 0xFF, 0xC0, 0x0F, 0x0F, 0x0F, 0x00, 0x02, 0x0D, 0x0B, 0x3C,
	0x03, 0xC0, 0x00, 0xD7, 0x0D, 0x70, 0x00, 0xD5, 0xCD, 0x7C, 0x03, 0xD5, 0x7D, 0x7C, 0x0D, 0xD5,
	0x7D, 0x7C, 0x0D, 0xD7, 0x5D, 0x7C, 0x0D, 0xD7, 0x5D, 0x7C, 0x0D, 0xD7, 0xD5, 0x7C, 0x0D, 0xD7,
	0xD5, 0x7C, 0x0D, 0xD7, 0xF5, 0x7C, 0x03, 0xD7, 0xCD, 0x7C, 0x00, 0x3F, 0xC3, 0xFC, 0x00, 0x0F,
	0x00, 0xF0, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFC, 0x00, 0x03, 0x0D, 0x57, 0x00, 0x0D, 0x35, 0xF5,
	0xC0, 0x0D, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD,
	0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x35, 0xF5, 0xFC, 0x0D, 0x0D, 0x57,
	0xF0, 0x0D, 0x03, 0xFF, 0xC0, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0x00,
	0x00, 0xD5, 0x55, 0xC0, 0x03, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x35, 0xD7, 0xCD, 0x7C,
	0x35, 0xD7, 0xFD, 0x7C, 0x35, 0xD5, 0x55, 0xFC, 0x35, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0,
	0x35, 0xD7, 0xC0, 0x00, 0x0D, 0xD7, 0xC0, 0x00, 0x03, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00, 0x00,
	0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFC, 0x00, 0x00, 0x0D, 0x57, 0x00, 0x00, 0x35, 0xF5, 0xC0, 0x00,
	0xD7, 0xFD, 0x70, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00,
	0xD7, 0xFD, 0x7C, 0x00, 0xD7, 0xD5, 0x7C, 0x00, 0x35, 0xF5, 0xFC, 0x00, 0x0D, 0x55, 0x70, 0x00,
	0x03, 0xFF, 0xFC, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x02, 0x0D, 0x0C, 0x3F, 0xFF, 0x00, 0x00, 0xD5,
	0x55, 0xC0, 0x03, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xFD, 0x7C, 0x03, 0xD5, 0x55, 0xFC, 0x00, 0xD7, 0xFD, 0x70, 0x03, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xC3, 0x5C, 0x03, 0x3F, 0xC0, 0xFF, 0x00, 0x0F, 0x00, 0x3C, 0x00, 0x02,
	0x0D, 0x0A, 0x0F, 0xFC, 0x00, 0x3F, 0x35, 0x57, 0x00, 0xD5, 0xD7, 0xF5, 0xC0, 0x3F, 0xD7, 0xF5,
	0xF0, 0x0F, 0xD7, 0xCF, 0xF0, 0x03, 0x35, 0x7F, 0xC0, 0x03, 0x0F, 0x57, 0x00, 0x03, 0x3F, 0xF5,
	0xC0, 0x03, 0xD7, 0x35, 0xF0, 0x03, 0xD7, 0xF5, 0xF0, 0x03, 0x35, 0x57, 0xF0, 0x03, 0x0F, 0xFF,
	0xC0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0xC0, 0x0F, 0xD5, 0x55, 0x70,
	0x35, 0x3F, 0x5F, 0xFC, 0x35, 0x0F, 0x5F, 0xF0, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00,
	0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00,
	0x0D, 0x03, 0x5F, 0x00, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x02, 0x0D, 0x0B,
	0x3C, 0x03, 0xC0, 0x0F, 0xD7, 0x0D, 0x70, 0x35, 0xD7, 0xCD, 0x7C, 0x35, 0xD7, 0xCD, 0x7C, 0x0D,
	0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x03, 0xD7, 0xCD, 0x7C, 0x03,
	0xD7, 0xCD, 0x7C, 0x03, 0x35, 0xF5, 0xFC, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0xFF, 0xC0, 0x00,
	0x00, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3C, 0x03, 0xC0, 0x3C, 0xD7, 0x0D, 0x70, 0xD7, 0xD7,
	0xCD, 0x7C, 0xD7, 0x35, 0xF5, 0xFC, 0xD7, 0x35, 0xF5, 0xF0, 0x35, 0x35, 0xF5, 0xF0, 0x35, 0x0D,
	0xF7, 0xF0, 0x0D, 0x0D, 0x57, 0xC0, 0x0D, 0x0D, 0x57, 0xC0, 0x03, 0x03, 0x5F, 0xC0, 0x03, 0x03,
	0x5F, 0x00, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x03, 0x0D, 0x11, 0x3C, 0x03,
	0xC0, 0x3C, 0x03, 0xC0, 0xD7, 0x0D, 0x70, 0xD7, 0x0D, 0x70, 0xD7, 0xCD, 0x7C, 0xD7, 0xCD, 0x7C,
	0xD7, 0xCD, 0x7C, 0xD7, 0xC3, 0x5C, 0x35, 0xF5, 0x5F, 0x5F, 0xC0, 0xD7, 0x35, 0xF5, 0x5F, 0x5F,
	0x00, 0x35, 0x0D, 0x77, 0xDD, 0x7F, 0x00, 0x35, 0x0D, 0x57, 0xD5, 0x7C, 0x00, 0xD7, 0x03, 0x5F,
	0xF5, 0xFC, 0x03, 0x5F, 0x03, 0x5F, 0x35, 0xF0, 0x0D, 0x7F, 0x03, 0x5F, 0x35, 0xF0, 0x0D, 0x7C,
	0x00, 0xFF, 0x0F, 0xF0, 0x03, 0xFC, 0x00, 0x3C, 0x03, 0xC0, 0x00, 0xF0, 0x02, 0x0D, 0x0C, 0x3C,
	0x00, 0xF0, 0x0F, 0xD7, 0x03, 0x5C, 0x35, 0xD7, 0xC3, 0x5F, 0x35, 0x35, 0xCD, 0x7F, 0x0D, 0x0D,
	0x75, 0xFC, 0x03, 0x03, 0x57, 0xF0, 0x00, 0x03, 0x57, 0xC0, 0x00, 0x0D, 0x75, 0xC0, 0x00, 0x35,
	0xFD, 0x70, 0x00, 0xD7, 0xF3, 0x5C, 0x00, 0xD7, 0xC3, 0x5F, 0x00, 0x3F, 0xC0, 0xFF, 0x00, 0x0F,
	0x00, 0x3C, 0x00, 0x02, 0x0D, 0x0D, 0x3C, 0x00, 0x3C, 0x03, 0xD7, 0x00, 0xD7, 0x0D, 0xD7, 0xC0,
	0xD7, 0xC3, 0x35, 0xC3, 0x5F, 0xC0, 0x0D, 0x7D, 0x7F, 0x00, 0x03, 0x55, 0xFC, 0x00, 0x00, 0xD7,
	0xF0, 0x00, 0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xC0, 0x03, 0x00, 0xD7, 0xC0, 0x0D, 0x00, 0xD7,
	0xC0, 0x0D, 0x00, 0x3F, 0xC0, 0x03, 0x00, 0x0F, 0x00, 0x00, 0x02, 0x0D, 0x0C, 0x3F, 0xFF, 0xF0,
	0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0x5F, 0x00, 0x0F, 0xFD, 0x7F, 0x00, 0x00, 0x35, 0xFC,
	0x00, 0x00, 0xD7, 0xF0, 0x00, 0x03, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x35, 0xFC, 0x00,
	0x00, 0xD7, 0xFF, 0xF0, 0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFC,
	0x00, 0x01, 0x0E, 0x06, 0x3F, 0x00, 0xD5, 0xC3, 0xDF, 0xF3, 0xDF, 0xC0, 0xDF, 0x00, 0xDF, 0x00,
	0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xD5, 0xC0, 0x3F, 0xF0, 0x0F, 0xC0,
	0x01, 0x0D, 0x08, 0x30, 0x00, 0xDC, 0x00, 0xDF, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC0, 0x0D,
	0xF0, 0x03, 0x70, 0x03, 0x7C, 0x00, 0xDC, 0x00, 0xDF, 0x00, 0x3F, 0x00, 0x0C, 0x01, 0x0E, 0x06,
	0x3F, 0x00, 0xD5, 0xC0, 0x3D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0,
	0x0D, 0xF0, 0x0D, 0xF0, 0x3D, 0xF0, 0xD5, 0xF0, 0x3F, 0xF0, 0x0F, 0xC0, 0x02, 0x0E, 0x0A, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x00, 0x00, 0x0D,
	0x5C, 0x00, 0x00, 0x37, 0x77, 0x00, 0x00, 0xDF, 0x7D, 0xC0, 0x00, 0x3F, 0x7F, 0xF0, 0x00, 0x0F,
	0x7C, 0xC0, 0x00, 0x03, 0x7C, 0x00, 0x03, 0x03, 0x7C, 0x00, 0x0D, 0x03, 0x7C, 0x00, 0x03, 0x00,
	0xFC, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x02, 0x0D, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF,
	0xF0, 0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x01, 0x07,
	0x04, 0x0C, 0x00, 0x37, 0x00, 0xD7, 0x00, 0xD7, 0x00, 0xD7, 0x03, 0xDC, 0x0D, 0x30, 0x03, 0x02,
	0x0D, 0x09, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xF0,
	0x00, 0xD7, 0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x00, 0xD7, 0x3D, 0x57, 0xC0, 0xD7, 0x35, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD5, 0x0F, 0xFF,
	0xC0, 0x3F, 0x03, 0xFF, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00,
	0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xF0, 0x00, 0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD5, 0x5F, 0xC0, 0x35, 0x3F, 0xFF, 0x00, 0x0F, 0x0F, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x0F, 0xF0, 0x00, 0x3F,
	0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x03, 0x5F, 0xD7, 0xFF, 0xC3, 0x5F, 0xD7, 0xCF, 0x03, 0x5F,
	0xD7, 0xFC, 0x03, 0x5F, 0xD7, 0xD7, 0x03, 0x5F, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0x3F,
	0x03, 0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00,
	0xD7, 0xC0, 0x00, 0x0F, 0xD7, 0xC0, 0x0F, 0x35, 0x57, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD5, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35,
	0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0x00,
	0x00, 0x0F, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xF0, 0x00, 0xD7, 0x35, 0x5C,
	0x03, 0x55, 0xD7, 0xD7, 0x00, 0xD7, 0xD5, 0x57, 0xC0, 0xD7, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF,
	0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0x0F, 0xFF, 0x00, 0x3F, 0x03, 0xFC,
	0x00, 0x0F, 0x01, 0x0D, 0x07, 0x03, 0xC0, 0x0D, 0x70, 0x35, 0xFC, 0x35, 0xF0, 0xD5, 0x70, 0x35,
	0xFC, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x0F, 0xF0, 0x03, 0xC0, 0x02,
	0x10, 0x09, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xFC,
	0x00, 0xD7, 0x35, 0x57, 0x00, 0xD5, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD7, 0x3F, 0xD7,
	0xC0, 0x3F, 0xD7, 0xD7, 0xC0, 0x0F, 0x35, 0x5F, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC,
	0x00, 0x00, 0x02, 0x0D, 0x09, 0x3C, 0x00, 0x00, 0x3C, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00,
	0xD7, 0xD7, 0xF0, 0x00, 0x3F, 0xD5, 0x5C, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0x3F, 0xFF, 0xC0, 0x3F, 0x0F, 0x0F, 0x00, 0x0F, 0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00,
	0xD7, 0xC0, 0x3F, 0xC0, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0,
	0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x01, 0x10, 0x06, 0x0F, 0x00, 0x35, 0xC0, 0x35, 0xF0, 0x0F,
	0xF0, 0x35, 0xC0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35,
	0xF0, 0x35, 0xF0, 0xD7, 0xF0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x3C, 0x00, 0x00, 0xF0,
	0xD7, 0x00, 0x03, 0x5C, 0xD7, 0xC0, 0x03, 0x5F, 0xD7, 0xFC, 0x03, 0x5F, 0xD7, 0xD7, 0x03, 0x5F,
	0xD7, 0x5F, 0xC3, 0x5F, 0xD5, 0x7F, 0x03, 0x5F, 0xD5, 0xFC, 0x03, 0x5F, 0xD5, 0x70, 0x03, 0x5F,
	0xD7, 0x5C, 0x03, 0x5F, 0xD7, 0xD7, 0x03, 0x5F, 0x3F, 0xFF, 0xC0, 0xFF, 0x0F, 0x0F, 0x00, 0x3C,
	0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7,
	0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x0D,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, 0x00,
	0xD5, 0x55, 0x5C, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xFF, 0xFF, 0xC0,
	0x0F, 0x0F, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, 0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7,
	0xD7, 0xC0, 0x35, 0x3F, 0xFF, 0xC0, 0x0F, 0x0F, 0x0F, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C,
	0x00, 0xD5, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0xD7, 0x03, 0xFC,
	0x00, 0xD7, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3F, 0xF0, 0x00, 0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD5, 0x5F, 0xC0,
	0x35, 0xD7, 0xFF, 0x00, 0x0F, 0xD7, 0xFC, 0x00, 0x03, 0xD7, 0xC0, 0x00, 0x00, 0x3F, 0xC0, 0x00,
	0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x3F, 0x35, 0x57, 0x00, 0xD5, 0xD7, 0xD7, 0xC0, 0xD5,
	0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7,
	0x35, 0x57, 0xC0, 0xD7, 0x0F, 0xD7, 0xC0, 0x3F, 0x03, 0xD7, 0xC0, 0x0F, 0x00, 0xD7, 0xC0, 0x00,
	0x00, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x01, 0x0D, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3F, 0xC0, 0xD5, 0x70, 0xD5, 0xFC, 0xD7, 0xF0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7,
	0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C,
	0x00, 0x00, 0x00, 0xD7, 0x0F, 0xF0, 0x00, 0xD7, 0x35, 0x5C, 0x03, 0x55, 0xD7, 0xD7, 0x00, 0xD7,
	0xD7, 0xFF, 0xC0, 0xD7, 0x35, 0x5F, 0x00, 0xD7, 0x3F, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7,
	0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x01, 0x0D, 0x07, 0x00,
	0x00, 0x0F, 0x00, 0x35, 0xC0, 0x35, 0xF0, 0xD5, 0x70, 0x35, 0xFC, 0x35, 0xF0, 0x35, 0xF0, 0x35,
	0xF0, 0x35, 0xF0, 0x0D, 0x70, 0x03, 0xFC, 0x00, 0xF0, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0xF0, 0xD7, 0xD7, 0x03, 0x5C,
	0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x35,
	0xD7, 0xD7, 0xC0, 0x0D, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF, 0xC0, 0x03, 0x03, 0xFF, 0x00, 0x00,
	0x02, 0x0D, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C,
	0x03, 0xC0, 0x3C, 0xD7, 0x0D, 0x70, 0xD7, 0xD7, 0xCD, 0x7C, 0xD7, 0x35, 0xF5, 0xFC, 0x35, 0x35,
	0xF5, 0xF0, 0x35, 0x0D, 0x57, 0xF0, 0x35, 0x03, 0x5F, 0xC0, 0x0D, 0x03, 0x5F, 0x00, 0x0D, 0x00,
	0xFF, 0x00, 0x03, 0x00, 0x3C, 0x00, 0x00, 0x02, 0x0D, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x3C, 0x03, 0xD7, 0x3C, 0xD7, 0x0D, 0xD7, 0xD7,
	0xD7, 0xC3, 0x35, 0xD7, 0x5F, 0xC0, 0x35, 0xD7, 0x5F, 0x00, 0x35, 0x55, 0x5F, 0x00, 0x0D, 0x7D,
	0x7F, 0x03, 0x0D, 0x7D, 0x7C, 0x0D, 0x03, 0xFF, 0xFC, 0x03, 0x00, 0xF0, 0xF0, 0x00, 0x02, 0x0D,
	0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x03, 0xC0,
	0x3C, 0xD7, 0x0D, 0x70, 0xD7, 0x35, 0xF5, 0xFC, 0xD7, 0x0D, 0x57, 0xF0, 0x35, 0x03, 0x5F, 0xC0,
	0x35, 0x0D, 0x57, 0x00, 0x0D, 0x35, 0xF5, 0xC0, 0x0D, 0xD7, 0xFD, 0x70, 0x03, 0x3F, 0xC3, 0xFC,
	0x03, 0x0F, 0x00, 0xF0, 0x0D, 0x02, 0x10, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3C, 0x03, 0xC0, 0x0F, 0xD7, 0x0D, 0x70, 0x35, 0xD7, 0xCD, 0x7C, 0x0F,
	0x35, 0xF5, 0xFC, 0x03, 0x35, 0xF5, 0xF0, 0x03, 0x0D, 0x57, 0xF0, 0x0D, 0x0D, 0x57, 0xC0, 0x35,
	0x03, 0x5F, 0xC0, 0x35, 0x03, 0x5F, 0x00, 0x0F, 0x0D, 0x7F, 0x00, 0x03, 0x35, 0xFC, 0x00, 0x00,
	0x0F, 0xF0, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0xD5, 0x57, 0x00, 0x00, 0x3F,
	0xD7, 0xC0, 0x00, 0x0F, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x35, 0xFC, 0x00, 0x00, 0xD7,
	0xFC, 0x00, 0x00, 0xD5, 0x57, 0x00, 0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x01,
	0x0E, 0x07, 0x00, 0x00, 0x03, 0xC0, 0x0D, 0x70, 0x37, 0xFC, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0,
	0xDF, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x37, 0xC0, 0x0D, 0x70, 0x03, 0xFC, 0x00, 0xF0, 0x01, 0x0F,
	0x04, 0x30, 0x00, 0xDC, 0x0F, 0xDF, 0x35, 0xDF, 0x0F, 0xDF, 0x03, 0xDF, 0x03, 0xDF, 0x00, 0xDF,
	0x00, 0xDF, 0x03, 0xDF, 0x03, 0xDF, 0x0F, 0xDF, 0x35, 0xDF, 0x0F, 0x3F, 0x03, 0x0C, 0x00, 0x01,
	0x0E, 0x07, 0x00, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0x3D, 0xC0, 0x0D, 0xF0, 0x0D, 0xF0, 0x03, 0x70,
	0x03, 0x7C, 0x0D, 0xFC, 0x0D, 0xF0, 0x3D, 0xF0, 0xD7, 0xF0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x08,
	0x0A, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x0F, 0x00, 0x03, 0x70, 0x35, 0xC3, 0x00,
	0xC0, 0xDF, 0x7D, 0xC0, 0x00, 0x3F, 0xD7, 0xF0, 0x00, 0x0C, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00,
	0x00, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x10, 0x0A, 0x03,
	0xFC, 0x00, 0x00, 0x0D, 0x57, 0x00, 0x00, 0x35, 0xF5, 0xC0, 0x00, 0xD7, 0xFD, 0xF0, 0x00, 0xD7,
	0xC3, 0xF0, 0x00, 0xD7, 0xC0, 0xC0, 0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xC3, 0x00, 0x00, 0xD7,
	0xCD, 0xC0, 0x00, 0x35, 0xF5, 0xF0, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0x7F, 0xC0, 0x00, 0x03,
	0xDF, 0x00, 0x00, 0x01, 0xDF, 0x00, 0x00, 0x03, 0x7C, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x02,
	0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x00, 0x37, 0x37, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x03, 0x3F, 0xFF,
	0xC0, 0x00, 0x3F, 0x3F, 0x00, 0x03, 0xD7, 0xD7, 0x00, 0x0D, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7,
	0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF,
	0xC0, 0x03, 0x03, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x03, 0x03, 0xDC, 0x00,
	0x0D, 0x0D, 0x7F, 0x00, 0x37, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00,
	0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD5, 0x57, 0xC0, 0x3D, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xD7, 0x00,
	0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09,
	0x03, 0xC0, 0x00, 0x03, 0x0D, 0x70, 0x00, 0x0D, 0x37, 0xDC, 0x00, 0x35, 0x0F, 0xFF, 0x00, 0x0F,
	0x0F, 0xFC, 0x00, 0x03, 0x35, 0x5C, 0x00, 0x0D, 0xD7, 0xD7, 0x00, 0x35, 0x3D, 0x57, 0xC0, 0x0F,
	0x35, 0xD7, 0xC0, 0x0D, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF, 0xC0, 0x03,
	0x03, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x0C, 0x37, 0x37, 0x00, 0x37, 0xD7,
	0xD7, 0xC0, 0x0D, 0x3F, 0xFF, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5, 0xD7,
	0xD7, 0x03, 0x5F, 0x3D, 0x57, 0xC0, 0xF5, 0x35, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC3, 0x5F, 0x35,
	0x57, 0xC0, 0xD5, 0x0F, 0xFF, 0xC0, 0x3F, 0x03, 0xFF, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x03, 0x00,
	0x00, 0x00, 0x0D, 0xF0, 0x00, 0x03, 0x03, 0x5C, 0x00, 0x0D, 0x00, 0xFF, 0x00, 0x03, 0x0F, 0xF0,
	0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0x3D, 0x57, 0xC0, 0x3D, 0x35, 0xD7,
	0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF,
	0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x00, 0x00, 0x0D, 0xDC, 0x00,
	0x00, 0x03, 0x7F, 0x00, 0x03, 0x0F, 0xFC, 0x00, 0x0D, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00,
	0x35, 0x3D, 0x57, 0xC0, 0x35, 0x35, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0,
	0x0D, 0x0F, 0xFF, 0xC0, 0x03, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0D, 0x0F, 0xF0, 0x00, 0x03, 0x35, 0x5C, 0x00, 0x03,
	0xD7, 0xD7, 0x00, 0x0D, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xCF, 0x00, 0x35, 0xD7, 0xFC, 0x00, 0x35,
	0xD7, 0xD7, 0x00, 0x35, 0x35, 0x5F, 0xC0, 0x0D, 0x0D, 0xFF, 0x00, 0x03, 0x0F, 0x7C, 0x00, 0x00,
	0x07, 0x7C, 0x00, 0x00, 0x0D, 0xF0, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x03,
	0xC0, 0x00, 0x0C, 0x0D, 0x70, 0x00, 0x37, 0x37, 0xDC, 0x00, 0xD7, 0x0F, 0xFF, 0x00, 0x3F, 0x0F,
	0xFC, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD5, 0x57, 0xC0, 0xD5, 0xD7,
	0xFF, 0xC0, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03,
	0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x03, 0x37, 0x37, 0x00, 0x0D, 0xD7, 0xD7,
	0xC0, 0x03, 0x3F, 0xFF, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x03, 0x35, 0x5C, 0x00, 0x0D, 0xD7, 0xD7,
	0x00, 0x35, 0xD5, 0x57, 0xC0, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xD7, 0x00, 0x35, 0x35, 0x5F,
	0xC0, 0x0D, 0x0F, 0xFF, 0x00, 0x03, 0x03, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x0C, 0x00, 0x00,
	0x03, 0x37, 0xC0, 0x00, 0x0D, 0x0D, 0x70, 0x00, 0x35, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00,
	0x03, 0x35, 0x5C, 0x00, 0x03, 0xD7, 0xD7, 0x00, 0x03, 0xD5, 0x57, 0xC0, 0x03, 0xD7, 0xFF, 0xC0,
	0x03, 0xD7, 0xD7, 0x00, 0x03, 0x35, 0x5F, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00,
	0x00, 0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x03, 0x37, 0x37, 0x00, 0x0D, 0xD7, 0xD7, 0xC0, 0x37,
	0x3F, 0xFF, 0xC0, 0x0F, 0x0F, 0xCF, 0x00, 0x0F, 0x0D, 0x70, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D,
	0x0D, 0x7C, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D,
	0x03, 0xFC, 0x00, 0x03, 0x00, 0xF0, 0x00, 0x00, 0x01, 0x0D, 0x07, 0x0F, 0x00, 0x35, 0xC0, 0xDF,
	0x70, 0x3F, 0xFC, 0x3F, 0x30, 0x35, 0xC0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35,
	0xF0, 0x0F, 0xF0, 0x03, 0xC0, 0x01, 0x0D, 0x06, 0x30, 0x00, 0xDF, 0x00, 0x35, 0xC0, 0x0F, 0xF0,
	0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0,
	0x0F, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0x03, 0x00, 0x03, 0x0D, 0xCD, 0xC0, 0x0D, 0x35, 0xF5, 0xF0,
	0x0D, 0x0F, 0xFF, 0xF0, 0x03, 0x03, 0x5F, 0x00, 0x00, 0x0D, 0x57, 0xC0, 0x00, 0x0D, 0xF7, 0xC0,
	0x00, 0x35, 0xF5, 0xC0, 0x00, 0x35, 0x55, 0xF0, 0x00, 0xD7, 0xFD, 0x70, 0x00, 0xD7, 0xFD, 0x7C,
	0x00, 0xFF, 0xFF, 0xFC, 0x00, 0x3F, 0xC3, 0xFC, 0x00, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00,
	0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D, 0x0A, 0x00, 0x30, 0x00, 0x00, 0x03, 0xDC, 0x00, 0x00, 0x0D,
	0x7F, 0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0xD5, 0x55, 0xC0, 0x00, 0xD7, 0xFF, 0xF0, 0x03, 0xD7,
	0xFF, 0xC0, 0x00, 0xD5, 0x57, 0x00, 0x00, 0xD7, 0xFF, 0xC0, 0x03, 0xD7, 0xFF, 0x00, 0x03, 0xD5,
	0x55, 0xC0, 0x00, 0x3F, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x02, 0x0D, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x3F, 0xC0, 0x35, 0x5C,
	0xD5, 0x70, 0xD7, 0xD7, 0x5F, 0x5C, 0x3D, 0x57, 0x55, 0x5F, 0x35, 0xD7, 0x5F, 0xFF, 0xD7, 0xD7,
	0x5F, 0xFC, 0xD7, 0xD7, 0x5F, 0x5C, 0x35, 0x55, 0x55, 0x7F, 0x0F, 0xFF, 0xFF, 0xFC, 0x03, 0xFF,
	0xFF, 0xF0, 0x02, 0x0D, 0x10, 0x00, 0x03, 0xFF, 0xF0, 0x00, 0x0D, 0x55, 0x5C, 0x00, 0x35, 0x7F,
	0xFF, 0x00, 0xD5, 0x7F, 0xFC, 0x00, 0xD5, 0x7F, 0xC0, 0x03, 0x5D, 0x55, 0x70, 0x0D, 0x7D, 0x7F,
	0xFC, 0x0D, 0x7D, 0x7F, 0xF0, 0x35, 0x55, 0x7C, 0x00, 0xD7, 0xFD, 0x7F, 0xF0, 0xD7, 0xFD, 0x55,
	0x5C, 0xFF, 0x0F, 0xFF, 0xFF, 0x3C, 0x03, 0xFF, 0xFC, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00, 0x30,
	0x0D, 0x70, 0x00, 0xDC, 0x37, 0xDC, 0x03, 0x5F, 0x0F, 0xFF, 0x00, 0xFF, 0x0F, 0xFC, 0x00, 0x3F,
	0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x03, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F,
	0xD7, 0xD7, 0xC3, 0x5F, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F,
	0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x0C, 0x37, 0x37, 0x00, 0x37, 0xD7, 0xD7, 0xC0, 0x0D, 0x3F,
	0xFF, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F,
	0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0C, 0x00, 0x00, 0x03, 0x37, 0xC0,
	0x00, 0x0D, 0x0D, 0x70, 0x00, 0x37, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C,
	0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7,
	0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D,
	0x09, 0x03, 0xC0, 0x00, 0x0C, 0x0D, 0x70, 0x00, 0x37, 0x37, 0xDC, 0x00, 0x0D, 0x0F, 0xFF, 0x00,
	0x03, 0x3F, 0x3C, 0x00, 0x3C, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0,
	0x0F, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0C, 0x00, 0x00, 0x03, 0x37, 0xC0, 0x00, 0x0D,
	0x0D, 0x70, 0x00, 0x0D, 0x03, 0xFC, 0x00, 0x03, 0x3C, 0x3C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00,
	0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00,
	0x35, 0x57, 0xC0, 0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x01, 0x04, 0x03, 0x30,
	0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0x03, 0x00, 0x00, 0x0D, 0xCD,
	0xC0, 0x00, 0x35, 0xF5, 0xF0, 0x00, 0x0F, 0xFF, 0xF0, 0x00, 0x0D, 0x57, 0xC0, 0x00, 0x35, 0xF5,
	0xC0, 0x00, 0xD7, 0xFD, 0x70, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0x35, 0xF5,
	0xFC, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0xFF, 0xC0, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x02, 0x0D,
	0x0B, 0x03, 0x03, 0x00, 0x00, 0x0D, 0xCD, 0xC0, 0x00, 0x35, 0xF5, 0xF0, 0x00, 0x3F, 0xFF, 0xF0,
	0x00, 0xD7, 0xCD, 0x70, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C,
	0x00, 0xD7, 0xFD, 0x7C, 0x00, 0xD5, 0x55, 0x7C, 0x00, 0x35, 0x55, 0xFC, 0x00, 0x0F, 0xFF, 0xF0,
	0x00, 0x03, 0xFF, 0xC0, 0x00, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x03, 0xDC, 0x03, 0x30, 0x00,
	0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x02, 0x0D, 0x0E, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF3, 0xFC, 0x00, 0x35, 0x5D,
	0x57, 0x00, 0xD7, 0xD5, 0xF5, 0xC0, 0xD7, 0xD5, 0x55, 0xF0, 0xD7, 0xD5, 0xFF, 0xF0, 0xD7, 0xD5,
	0xFF, 0xC0, 0xD7, 0xD5, 0xF5, 0xC0, 0x35, 0x5D, 0x57, 0xF0, 0x3F, 0xFF, 0xFF, 0xC0, 0x0F, 0xFF,
	0xFF, 0x00, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x00, 0x03,
	0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x03, 0x03, 0xDC, 0x00, 0x3D, 0x0D, 0x7F, 0x00, 0xD7, 0x03,
	0xFC, 0x00, 0x3F, 0x0F, 0xF0, 0x00, 0x3C, 0x35, 0x5C, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0x3D,
	0x57, 0xC0, 0xD7, 0x35, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD7, 0x0F,
	0xFF, 0xC0, 0x3F, 0x03, 0xFF, 0x00, 0x0F, 0x01, 0x0D, 0x06, 0x03, 0x00, 0x3D, 0xC0, 0xD7, 0xF0,
	0x3F, 0xC0, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0,
	0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x00, 0x03, 0xDC, 0x00, 0x0F, 0x0D,
	0x7F, 0x00, 0x35, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00, 0xF0, 0x35, 0x5C, 0x03, 0x5F, 0xD7,
	0xD7, 0x03, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0x35,
	0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x00, 0x30,
	0x00, 0x03, 0x03, 0xDC, 0x00, 0x0D, 0x0D, 0x7F, 0x00, 0x37, 0x03, 0xFC, 0x00, 0x0F, 0x3C, 0x3C,
	0x00, 0x0F, 0xD7, 0xD7, 0x00, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7,
	0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF,
	0x00, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0x0C, 0x00, 0x00, 0x35, 0xF7, 0x00, 0x00, 0xDF, 0x5F, 0xC0,
	0x00, 0x3F, 0xFF, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0xD5, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00,
	0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0,
	0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x0F, 0x0F, 0x00, 0x00, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC,
	0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01,
	0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00,
	0x00, 0x0D, 0x70, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x0D, 0x70, 0x00,
	0x00, 0x0D, 0x7C, 0x00, 0x00, 0x35, 0xFC, 0x00, 0x00, 0xD7, 0xFC, 0x00, 0x00, 0xD7, 0xD7, 0x00,
	0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x35, 0x5F, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00,
	0x00, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30,
	0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC,
	0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x03, 0xDC, 0x0D, 0xDC, 0x0D, 0x30, 0x03, 0x01, 0x0D, 0x05,
	0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0x3F, 0xC0, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0A, 0x09, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0C, 0x00, 0x00, 0x0D, 0xF7, 0x00, 0x00, 0x37, 0xDF, 0xC0,
	0x00, 0xDF, 0x7F, 0x00, 0x00, 0x37, 0xDC, 0x00, 0x00, 0x0D, 0xF7, 0x00, 0x00, 0x03, 0xFF, 0xC0,
	0x00, 0x00, 0xC3, 0x00, 0x00, 0x02, 0x0A, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x30, 0xC0, 0x00, 0x00, 0xDF, 0x70, 0x00, 0x00, 0x37, 0xDC, 0x00, 0x00, 0x0D, 0xF7, 0x00, 0x00,
	0x37, 0xDF, 0xC0, 0x00, 0xDF, 0x7F, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x0C, 0x30, 0x00, 0x00,
	0x02, 0x10, 0x0B, 0x00, 0xFF, 0x00, 0x00, 0x03, 0x55, 0xC0, 0x00, 0x0D, 0x7D, 0x70, 0x00, 0x0D,
	0x7D, 0x7C, 0x00, 0x0D, 0x7D, 0x7C, 0x00, 0x0D, 0x75, 0xFC, 0x00, 0x0D, 0x75, 0x70, 0x00, 0x0D,
	0x7D, 0x7C, 0x00, 0x0D, 0x7D, 0x7C, 0x00, 0x0D, 0x7D, 0x7C, 0x00, 0x0D, 0x55, 0xFC, 0x00, 0x0D,
	0x7F, 0xF0, 0x00, 0x35, 0xFF, 0xC0, 0x00, 0x35, 0xF0, 0x00, 0x00, 0xD7, 0xF0, 0x00, 0x00, 0x3F,
	0xC0, 0x00, 0x00,
};

const uint16 Graphics::_spaFontOffs[] = {
	0x0000, 0x0007, 0x0024, 0x0043, 0x0072, 0x00AD, 0x00E0, 0x0113, 0x0124, 0x0141,
	0x015E, 0x0191, 0x01C4, 0x01E3, 0x01F8, 0x0215, 0x0232, 0x0269, 0x0286, 0x02BD,
	0x02F4, 0x032B, 0x0362, 0x0399, 0x03D0, 0x0407, 0x043E, 0x045B, 0x047C, 0x0495,
	0x04C0, 0x04D9, 0x0510, 0x054B, 0x0582, 0x05B9, 0x05F0, 0x0627, 0x065E, 0x0695,
	0x06CC, 0x0703, 0x0720, 0x0757, 0x078E, 0x07C5, 0x07FC, 0x0833, 0x086A, 0x08A1,
	0x08D8, 0x090F, 0x0946, 0x097D, 0x09B4, 0x09EB, 0x0A3C, 0x0A73, 0x0AAA, 0x0AE1,
	0x0B00, 0x0B1D, 0x0B3C, 0x0B77, 0x0BAE, 0x0BBF, 0x0BF6, 0x0C2D, 0x0C64, 0x0C9B,
	0x0CD2, 0x0CEF, 0x0D32, 0x0D69, 0x0D86, 0x0DA9, 0x0DE0, 0x0DFD, 0x0E34, 0x0E6B,
	0x0EA2, 0x0EE5, 0x0F28, 0x0F45, 0x0F7C, 0x0F99, 0x0FD0, 0x1007, 0x103E, 0x1075,
	0x10B8, 0x10EF, 0x110E, 0x112F, 0x114E, 0x1171, 0x117C, 0x11BF, 0x11F6, 0x122D,
	0x1264, 0x129B, 0x12D2, 0x1309, 0x134C, 0x1383, 0x13BA, 0x13F1, 0x1428, 0x1445,
	0x1462, 0x1499, 0x14A4, 0x14DB, 0x1512, 0x1549, 0x1580, 0x15B7, 0x15EE, 0x1625,
	0x165C, 0x1667, 0x169E, 0x16D5, 0x16E0, 0x16EB, 0x1722, 0x172D, 0x1738, 0x176F,
	0x178C, 0x17C3, 0x17FA, 0x1831, 0x1868, 0x1873, 0x187E, 0x18B5, 0x18C0, 0x18CB,
	0x18D6, 0x18E1, 0x18FE, 0x1929, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x1954
};

const int Graphics::_spaFontSize = ARRAYSIZE(Graphics::_spaFontOffs);

const uint8 Graphics::_spaFontData[] = {
	0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0D, 0x05, 0x3C, 0x03, 0xD7, 0x0D, 0xD7, 0xCD,
	0xD7, 0xCD, 0xD7, 0xCD, 0xD7, 0xC3, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0xD7, 0x00, 0xD7, 0xC0,
	0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x07, 0x09, 0x3C, 0x3C, 0x00, 0x0C, 0xD7, 0xD7, 0x00, 0x37, 0xD7,
	0xD7, 0xC0, 0xF7, 0xD7, 0xD7, 0xC3, 0x55, 0xD7, 0xD7, 0xC0, 0xDF, 0x3F, 0xFF, 0xC3, 0xDF, 0x0F,
	0x0F, 0x0D, 0x55, 0x02, 0x0B, 0x0B, 0x00, 0xC3, 0x00, 0x03, 0x03, 0x7D, 0xC0, 0x0D, 0x0F, 0x7D,
	0xF0, 0x0D, 0x35, 0x55, 0x70, 0x35, 0x0D, 0xF7, 0xFC, 0xDD, 0x3D, 0xF7, 0xF0, 0xDD, 0xD5, 0x55,
	0xC0, 0x35, 0x37, 0xDF, 0xF0, 0x3D, 0x37, 0xDF, 0xC0, 0xDD, 0x0F, 0xFF, 0x00, 0x35, 0x03, 0x0C,
	0x00, 0x0D, 0x02, 0x0E, 0x09, 0x03, 0x00, 0x00, 0xF0, 0x0D, 0xC0, 0x03, 0x5C, 0x0D, 0xF0, 0x0D,
	0xF7, 0x35, 0x5C, 0x0D, 0xF7, 0xDD, 0xF7, 0x03, 0x5F, 0xDD, 0xFF, 0xC0, 0xFD, 0x35, 0x5F, 0x00,
	0x37, 0x3D, 0xF7, 0x00, 0xDF, 0xDD, 0xF7, 0xC3, 0x7F, 0x35, 0x5F, 0xC0, 0xFC, 0x0D, 0xFF, 0x00,
	0x30, 0x0D, 0xFC, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x02, 0x0C, 0x0C,
	0x0F, 0x00, 0x00, 0x00, 0x35, 0xC0, 0xC0, 0x00, 0xDF, 0x73, 0x70, 0x03, 0xDF, 0x7D, 0xFC, 0x0D,
	0x35, 0xF7, 0xF0, 0x37, 0x0F, 0xDF, 0xC0, 0x37, 0x03, 0x7D, 0x70, 0x0D, 0x0D, 0xF7, 0xDC, 0x37,
	0x37, 0xF7, 0xDF, 0x37, 0x0F, 0xCD, 0x7F, 0x0D, 0x03, 0x03, 0xFC, 0x03, 0x00, 0x00, 0xF0, 0x00,
	0x02, 0x0C, 0x0B, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xC0, 0x00, 0xD7, 0x35,
	0x70, 0x00, 0xD7, 0xDF, 0xDC, 0x00, 0xD7, 0xDF, 0xFF, 0xC0, 0xFF, 0x35, 0x7D, 0x70, 0x3F, 0xDF,
	0xF7, 0xFC, 0x00, 0xDF, 0xDF, 0xF0, 0x00, 0x35, 0x7F, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x03,
	0xF0, 0x00, 0x00, 0x01, 0x07, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC3, 0xD7, 0xC3, 0xD7, 0xCD,
	0xFF, 0xCD, 0x3F, 0x0D, 0x01, 0x0D, 0x06, 0x03, 0x00, 0x0D, 0xC3, 0x37, 0xF0, 0x37, 0xC0, 0xDF,
	0xC0, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC3, 0x03, 0xF0, 0x00,
	0xC0, 0x01, 0x0D, 0x06, 0x30, 0x00, 0xDC, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC0, 0x0D, 0xF0,
	0x0D, 0xF3, 0x0D, 0xF0, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x02, 0x0C,
	0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x03, 0x0F, 0x7C, 0x00,
	0x0D, 0x37, 0x77, 0x00, 0x0D, 0x3D, 0x5F, 0xC0, 0xFD, 0xD5, 0xD5, 0xC3, 0x55, 0x3D, 0x5F, 0xF0,
	0xFD, 0x37, 0x77, 0xC0, 0x3D, 0x0F, 0x7F, 0xC0, 0x0D, 0x03, 0xFF, 0x00, 0x03, 0x00, 0x30, 0x00,
	0x00, 0x02, 0x0C, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00,
	0x03, 0x70, 0x00, 0x00, 0x03, 0x7C, 0x00, 0x00, 0x3F, 0x7F, 0x00, 0x00, 0xD5, 0x55, 0xC0, 0x00,
	0x3F, 0x7F, 0xF0, 0x00, 0x0F, 0x7F, 0xC0, 0x3C, 0x03, 0x7C, 0x00, 0xD7, 0x00, 0xFC, 0x00, 0xD7,
	0x00, 0x30, 0x03, 0x5F, 0x01, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x0F, 0x00, 0x35, 0xC0, 0x35, 0xF0, 0xD7, 0xF0, 0x3F,
	0xC0, 0x0F, 0x00, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3F, 0xC0, 0xD5, 0x70, 0x3F, 0xFC, 0x0F, 0xF0, 0x01, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3C, 0x03, 0xD7, 0x0D, 0xD7,
	0xCD, 0x3F, 0xC3, 0x0F, 0x00, 0x01, 0x0D, 0x08, 0x00, 0x00, 0x00, 0x30, 0x00, 0xDC, 0x03, 0x7F,
	0x03, 0x7C, 0x0D, 0xFC, 0x0D, 0xF0, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0, 0xDF, 0x00, 0x3F, 0x00,
	0x0C, 0x00, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0xF5, 0xD7, 0xD7, 0x03,
	0x55, 0xD7, 0xD7, 0xC0, 0xF5, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0,
	0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x5F, 0xC0,
	0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x01, 0x0D, 0x07, 0x03, 0xC0, 0x3D, 0x70,
	0xD5, 0x7C, 0x3D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C,
	0x0D, 0x7C, 0x03, 0xFC, 0x00, 0xF0, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00,
	0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0x3F, 0xD7, 0xC0, 0x0F, 0x0F, 0x5F, 0xC0,
	0x0D, 0x0D, 0x7F, 0x00, 0x03, 0x35, 0xFC, 0x00, 0x00, 0xD7, 0xF0, 0x00, 0x3C, 0xD7, 0xFC, 0x00,
	0xD7, 0xD5, 0x57, 0x00, 0x35, 0x3F, 0xFF, 0xC0, 0x0F, 0x0F, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09,
	0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x03, 0x3F, 0xD7, 0xC0, 0x0D,
	0x0F, 0xD7, 0xC0, 0x0D, 0x0D, 0x5F, 0xC0, 0x35, 0x03, 0xD7, 0x00, 0x35, 0x00, 0xD7, 0xC0, 0xD7,
	0x3C, 0xD7, 0xC0, 0xD5, 0xD7, 0xD7, 0xC0, 0x3F, 0x35, 0x5F, 0xC0, 0x0F, 0x0F, 0xFF, 0x00, 0x00,
	0x03, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x3F, 0x00, 0xD7, 0x00, 0xD5, 0x03,
	0x57, 0xC0, 0xD7, 0x0D, 0x57, 0xC0, 0xD7, 0x0D, 0x57, 0xC0, 0xD7, 0x35, 0xD7, 0xC0, 0xD5, 0x35,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xD5, 0x57, 0xC0, 0x3F, 0x3F, 0xD7, 0xC0, 0xD7, 0x0F,
	0xD7, 0xC0, 0x35, 0x00, 0x3F, 0xC0, 0x0F, 0x00, 0x0F, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x3F, 0xFC,
	0x00, 0x0F, 0xD5, 0x57, 0x00, 0x35, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF, 0x00, 0xD7, 0xD7, 0xF0,
	0x00, 0xD7, 0xD5, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x00, 0xD7, 0x3F, 0xD7, 0xC0, 0xD7, 0x3F, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC,
	0x00, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x00,
	0x3F, 0xD7, 0xFF, 0xC0, 0x0F, 0xD7, 0xFF, 0x00, 0x03, 0xD5, 0x5C, 0x00, 0x0D, 0xD7, 0xD7, 0x00,
	0x0D, 0xD7, 0xD7, 0xC0, 0x0D, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x5F, 0xC0,
	0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x3F, 0xFC, 0x00, 0x0F,
	0xD5, 0x57, 0x00, 0x35, 0x3F, 0xD7, 0xC0, 0xD7, 0x0F, 0x5F, 0xC0, 0xD7, 0x03, 0x5F, 0x00, 0xD7,
	0x0D, 0x7F, 0x00, 0x35, 0x0D, 0x7C, 0x00, 0xD7, 0x0D, 0x7C, 0x00, 0xD7, 0x35, 0xFC, 0x00, 0xD7,
	0x35, 0xF0, 0x00, 0xD7, 0x35, 0xF0, 0x00, 0x35, 0x0F, 0xF0, 0x00, 0x0F, 0x03, 0xC0, 0x00, 0x03,
	0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0xD7, 0xD7, 0x00, 0x35, 0xD7,
	0xD7, 0xC0, 0x0F, 0xD7, 0xD7, 0xC0, 0x3F, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F,
	0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C,
	0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0xF0, 0xD7, 0xD7,
	0xC3, 0x5C, 0x35, 0x57, 0xC3, 0x5F, 0x0F, 0xD7, 0xC0, 0xFF, 0x3F, 0xD7, 0xC0, 0xFC, 0xD7, 0xD7,
	0xC3, 0x5C, 0x35, 0x5F, 0xC3, 0x5F, 0x0F, 0xFF, 0x00, 0xFF, 0x03, 0xFC, 0x00, 0x3C, 0x01, 0x0D,
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0xD7, 0x03, 0xD7, 0xC3, 0x3F,
	0xC0, 0x3F, 0x00, 0xD7, 0x03, 0xD7, 0xC3, 0x3F, 0xC0, 0x0F, 0x03, 0x01, 0x0F, 0x05, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0x3F, 0xC0, 0x3F, 0x00,
	0xD7, 0x00, 0xD7, 0xC0, 0x37, 0xC0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x01, 0x0B, 0x07, 0x00,
	0x00, 0x00, 0xC0, 0x03, 0x70, 0x0D, 0xFC, 0x37, 0xF0, 0xDF, 0xC0, 0x37, 0x00, 0x0D, 0xC0, 0x03,
	0x70, 0x00, 0xFC, 0x00, 0x30, 0x02, 0x0A, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0,
	0x00, 0x00, 0x03, 0x70, 0x3F, 0xFC, 0x00, 0xDC, 0xD5, 0x57, 0x00, 0x37, 0x3F, 0xFF, 0xC0, 0x0D,
	0x3F, 0xFF, 0x00, 0x37, 0xD5, 0x57, 0x00, 0xDF, 0x3F, 0xFF, 0xC3, 0x7F, 0x0F, 0xFF, 0x00, 0xFC,
	0x01, 0x0B, 0x07, 0x00, 0x00, 0x30, 0x00, 0xDC, 0x00, 0x37, 0x00, 0x0D, 0xC0, 0x03, 0x70, 0x0D,
	0xFC, 0x37, 0xF0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x00,
	0x35, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x3F, 0xD7, 0xC0, 0x00,
	0x0F, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00,
	0x0D, 0x70, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00,
	0x02, 0x0E, 0x0D, 0x03, 0xFF, 0xC0, 0x00, 0x0D, 0x55, 0x70, 0x00, 0x37, 0xFF, 0xDC, 0x00, 0xDF,
	0xFF, 0xF7, 0x00, 0xDF, 0xD5, 0xF7, 0xC0, 0xDF, 0x7D, 0xF7, 0xC0, 0xDF, 0x7D, 0xF7, 0xC0, 0xDF,
	0x7D, 0xF7, 0xC0, 0xDF, 0x75, 0xDF, 0xC0, 0xDF, 0xDD, 0x7F, 0x00, 0x37, 0xFF, 0xFC, 0x00, 0x0D,
	0x5C, 0xF0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x00, 0xF0,
	0x00, 0x3F, 0x03, 0x5C, 0x00, 0xD5, 0x03, 0x5F, 0x00, 0xD7, 0x0D, 0x57, 0x00, 0xD7, 0x0D, 0x57,
	0xC0, 0xD7, 0x0D, 0xF7, 0xC0, 0xD5, 0x35, 0xF5, 0xC0, 0xD7, 0x35, 0xF5, 0xF0, 0xD7, 0x35, 0x55,
	0xF0, 0xD7, 0xD7, 0xFD, 0x70, 0xD7, 0xD7, 0xFD, 0x7C, 0xD5, 0x3F, 0xC3, 0xFC, 0x3F, 0x0F, 0x00,
	0xF0, 0x0F, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0x00, 0x03, 0xD5, 0x55, 0xC0, 0x0D, 0xD7, 0xFD, 0x70,
	0x35, 0xD7, 0xFD, 0x7C, 0xD7, 0xD7, 0xFD, 0x7C, 0xD7, 0xD5, 0x55, 0xFC, 0xD7, 0xD7, 0xFD, 0x70,
	0xD7, 0xD7, 0xFD, 0x7C, 0xD7, 0xD7, 0xCD, 0x7C, 0xD7, 0xD7, 0xFD, 0x7C, 0x35, 0xD5, 0x55, 0xFC,
	0x0D, 0x3F, 0xFF, 0xF0, 0x03, 0x0F, 0xFF, 0xC0, 0x00, 0x02, 0x0D, 0x0A, 0x03, 0xFC, 0x00, 0x0F,
	0x0D, 0x57, 0x00, 0x35, 0x35, 0xF5, 0xC0, 0x35, 0xD7, 0xFD, 0xF0, 0x35, 0xD7, 0xC3, 0xF0, 0x35,
	0xD7, 0xC0, 0xC0, 0x35, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xC3, 0x00, 0x35, 0xD7, 0xCD, 0xC0, 0x35,
	0x35, 0xF5, 0xF0, 0x35, 0x0D, 0x57, 0xF0, 0x35, 0x03, 0xFF, 0xC0, 0x0F, 0x00, 0xFF, 0x00, 0x03,
	0x02, 0x0D, 0x0B, 0x3F, 0xFC, 0x00, 0x03, 0xD5, 0x57, 0x00, 0x0D, 0xD7, 0xF5, 0xC0, 0x0D, 0xD7,
	0xFD, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xF5, 0xFC, 0x0D, 0xD5, 0x57, 0xF0, 0x0D, 0x3F,
	0xFF, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0A, 0x3F, 0xFF, 0x00, 0x0F, 0xD5, 0x55,
	0xC0, 0x35, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xFC, 0x00, 0x35, 0xD5, 0x57,
	0x00, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xFF, 0x00, 0x35, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xFF,
	0x00, 0x35, 0xD5, 0x55, 0xC0, 0x35, 0x3F, 0xFF, 0xF0, 0x0F, 0x0F, 0xFF, 0xC0, 0x03, 0x02, 0x0D,
	0x0A, 0x3F, 0xFF, 0x00, 0x03, 0xD5, 0x55, 0xC0, 0x0D, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0,
	0xD7, 0xD7, 0xFC, 0x00, 0xD7, 0xD5, 0x57, 0x00, 0xD7, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF, 0x00,
	0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xC0, 0x00, 0x0D, 0x3F, 0xC0, 0x00,
	0x03, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFF, 0x00, 0x03, 0x0D, 0x55, 0xC0, 0x0D,
	0x35, 0xFD, 0x70, 0x0D, 0xD7, 0xFF, 0x7C, 0x0D, 0xD7, 0xC0, 0xFC, 0x0D, 0xD7, 0xFF, 0xF0, 0x0D,
	0xD7, 0xD5, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x35, 0xFD, 0x7C, 0x0D,
	0x0D, 0x57, 0x7C, 0x0D, 0x03, 0xFF, 0xFC, 0x03, 0x00, 0xFF, 0x30, 0x00, 0x02, 0x0D, 0x0B, 0x3C,
	0x03, 0xC0, 0x03, 0xD7, 0x0D, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xFD, 0x7C, 0x0D, 0xD5, 0x55, 0x7C, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x3F, 0xC3, 0xFC, 0x03, 0x0F,
	0x00, 0xF0, 0x00, 0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC3, 0xD7, 0xC3, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00,
	0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0x00,
	0xD7, 0xC0, 0xD7, 0x00, 0xD7, 0xC0, 0xD5, 0x00, 0xD7, 0xC0, 0xD5, 0x00, 0xD7, 0xC0, 0xD5, 0x3C,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0x0F,
	0xFF, 0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x0B, 0x3C, 0x0F, 0x00, 0x0F, 0xD7, 0x35,
	0xC0, 0x35, 0xD7, 0xD7, 0xF0, 0x35, 0xD7, 0x5F, 0xC0, 0x35, 0xD5, 0x7F, 0x00, 0x35, 0xD5, 0xFC,
	0x00, 0x35, 0xD5, 0x70, 0x00, 0x35, 0xD7, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0x35, 0xD7, 0xF5,
	0xC0, 0x35, 0xD7, 0xCD, 0x70, 0x35, 0x3F, 0xC3, 0xFC, 0x0F, 0x0F, 0x00, 0xF0, 0x03, 0x02, 0x0D,
	0x0A, 0x3C, 0x00, 0x00, 0x3C, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00,
	0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00,
	0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xFF, 0x00, 0xD7, 0xD5, 0x55, 0xC0, 0xD7, 0x3F, 0xFF, 0xF0,
	0x3F, 0x0F, 0xFF, 0xC0, 0x0F, 0x02, 0x0D, 0x0D, 0x3C, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0x00,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD5, 0xC3, 0x57, 0xC0, 0xD5, 0xF3, 0x57, 0xC0, 0xD5, 0x7D, 0x57, 0xC0,
	0xD5, 0x7D, 0x57, 0xC0, 0xD7, 0x55, 0xD7, 0xC0, 0xD7, 0x55, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xFF, 0xFF, 0xC0, 0x0F, 0x0F, 0x0F, 0x00, 0x02, 0x0D, 0x0B, 0x3C,
	0x03, 0xC0, 0x00, 0xD7, 0x0D, 0x70, 0x00, 0xD5, 0xCD, 0x7C, 0x03, 0xD5, 0x7D, 0x7C, 0x0D, 0xD5,
	0x7D, 0x7C, 0x0D, 0xD7, 0x5D, 0x7C, 0x0D, 0xD7, 0x5D, 0x7C, 0x0D, 0xD7, 0xD5, 0x7C, 0x0D, 0xD7,
	0xD5, 0x7C, 0x0D, 0xD7, 0xF5, 0x7C, 0x03, 0xD7, 0xCD, 0x7C, 0x00, 0x3F, 0xC3, 0xFC, 0x00, 0x0F,
	0x00, 0xF0, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFC, 0x00, 0x03, 0x0D, 0x57, 0x00, 0x0D, 0x35, 0xF5,
	0xC0, 0x0D, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD,
	0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x35, 0xF5, 0xFC, 0x0D, 0x0D, 0x57,
	0xF0, 0x0D, 0x03, 0xFF, 0xC0, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0x00,
	0x00, 0xD5, 0x55, 0xC0, 0x03, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x35, 0xD7, 0xCD, 0x7C,
	0x35, 0xD7, 0xFD, 0x7C, 0x35, 0xD5, 0x55, 0xFC, 0x35, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0,
	0x35, 0xD7, 0xC0, 0x00, 0x0D, 0xD7, 0xC0, 0x00, 0x03, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00, 0x00,
	0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFC, 0x00, 0x00, 0x0D, 0x57, 0x00, 0x00, 0x35, 0xF5, 0xC0, 0x00,
	0xD7, 0xFD, 0x70, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00,
	0xD7, 0xFD, 0x7C, 0x00, 0xD7, 0xD5, 0x7C, 0x00, 0x35, 0xF5, 0xFC, 0x00, 0x0D, 0x55, 0x70, 0x00,
	0x03, 0xFF, 0xFC, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x02, 0x0D, 0x0C, 0x3F, 0xFF, 0x00, 0x00, 0xD5,
	0x55, 0xC0, 0x03, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xFD, 0x7C, 0x03, 0xD5, 0x55, 0xFC, 0x00, 0xD7, 0xFD, 0x70, 0x03, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xC3, 0x5C, 0x03, 0x3F, 0xC0, 0xFF, 0x00, 0x0F, 0x00, 0x3C, 0x00, 0x02,
	0x0D, 0x0A, 0x0F, 0xFC, 0x00, 0x3F, 0x35, 0x57, 0x00, 0xD5, 0xD7, 0xF5, 0xC0, 0x3F, 0xD7, 0xF5,
	0xF0, 0x0F, 0xD7, 0xCF, 0xF0, 0x03, 0x35, 0x7F, 0xC0, 0x03, 0x0F, 0x57, 0x00, 0x03, 0x3F, 0xF5,
	0xC0, 0x03, 0xD7, 0x35, 0xF0, 0x03, 0xD7, 0xF5, 0xF0, 0x03, 0x35, 0x57, 0xF0, 0x03, 0x0F, 0xFF,
	0xC0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0xC0, 0x0F, 0xD5, 0x55, 0x70,
	0x35, 0x3F, 0x5F, 0xFC, 0x35, 0x0F, 0x5F, 0xF0, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00,
	0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00,
	0x0D, 0x03, 0x5F, 0x00, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x02, 0x0D, 0x0B,
	0x3C, 0x03, 0xC0, 0x0F, 0xD7, 0x0D, 0x70, 0x35, 0xD7, 0xCD, 0x7C, 0x35, 0xD7, 0xCD, 0x7C, 0x0D,
	0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x03, 0xD7, 0xCD, 0x7C, 0x03,
	0xD7, 0xCD, 0x7C, 0x03, 0x35, 0xF5, 0xFC, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0xFF, 0xC0, 0x00,
	0x00, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3C, 0x03, 0xC0, 0x3C, 0xD7, 0x0D, 0x70, 0xD7, 0xD7,
	0xCD, 0x7C, 0xD7, 0x35, 0xF5, 0xFC, 0xD7, 0x35, 0xF5, 0xF0, 0x35, 0x35, 0xF5, 0xF0, 0x35, 0x0D,
	0xF7, 0xF0, 0x0D, 0x0D, 0x57, 0xC0, 0x0D, 0x0D, 0x57, 0xC0, 0x03, 0x03, 0x5F, 0xC0, 0x03, 0x03,
	0x5F, 0x00, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x03, 0x0D, 0x11, 0x3C, 0x03,
	0xC0, 0x3C, 0x03, 0xC0, 0xD7, 0x0D, 0x70, 0xD7, 0x0D, 0x70, 0xD7, 0xCD, 0x7C, 0xD7, 0xCD, 0x7C,
	0xD7, 0xCD, 0x7C, 0xD7, 0xC3, 0x5C, 0x35, 0xF5, 0x5F, 0x5F, 0xC0, 0xD7, 0x35, 0xF5, 0x5F, 0x5F,
	0x00, 0x35, 0x0D, 0x77, 0xDD, 0x7F, 0x00, 0x35, 0x0D, 0x57, 0xD5, 0x7C, 0x00, 0xD7, 0x03, 0x5F,
	0xF5, 0xFC, 0x03, 0x5F, 0x03, 0x5F, 0x35, 0xF0, 0x0D, 0x7F, 0x03, 0x5F, 0x35, 0xF0, 0x0D, 0x7C,
	0x00, 0xFF, 0x0F, 0xF0, 0x03, 0xFC, 0x00, 0x3C, 0x03, 0xC0, 0x00, 0xF0, 0x02, 0x0D, 0x0C, 0x3C,
	0x00, 0xF0, 0x0F, 0xD7, 0x03, 0x5C, 0x35, 0xD7, 0xC3, 0x5F, 0x35, 0x35, 0xCD, 0x7F, 0x0D, 0x0D,
	0x75, 0xFC, 0x03, 0x03, 0x57, 0xF0, 0x00, 0x03, 0x57, 0xC0, 0x00, 0x0D, 0x75, 0xC0, 0x00, 0x35,
	0xFD, 0x70, 0x00, 0xD7, 0xF3, 0x5C, 0x00, 0xD7, 0xC3, 0x5F, 0x00, 0x3F, 0xC0, 0xFF, 0x00, 0x0F,
	0x00, 0x3C, 0x00, 0x02, 0x0D, 0x0D, 0x3C, 0x00, 0x3C, 0x03, 0xD7, 0x00, 0xD7, 0x0D, 0xD7, 0xC0,
	0xD7, 0xC3, 0x35, 0xC3, 0x5F, 0xC0, 0x0D, 0x7D, 0x7F, 0x00, 0x03, 0x55, 0xFC, 0x00, 0x00, 0xD7,
	0xF0, 0x00, 0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xC0, 0x03, 0x00, 0xD7, 0xC0, 0x0D, 0x00, 0xD7,
	0xC0, 0x0D, 0x00, 0x3F, 0xC0, 0x03, 0x00, 0x0F, 0x00, 0x00, 0x02, 0x0D, 0x0C, 0x3F, 0xFF, 0xF0,
	0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0x5F, 0x00, 0x0F, 0xFD, 0x7F, 0x00, 0x00, 0x35, 0xFC,
	0x00, 0x00, 0xD7, 0xF0, 0x00, 0x03, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x35, 0xFC, 0x00,
	0x00, 0xD7, 0xFF, 0xF0, 0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFC,
	0x00, 0x01, 0x0E, 0x06, 0x3F, 0x00, 0xD5, 0xC3, 0xDF, 0xF3, 0xDF, 0xC0, 0xDF, 0x00, 0xDF, 0x00,
	0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xD5, 0xC0, 0x3F, 0xF0, 0x0F, 0xC0,
	0x01, 0x0D, 0x08, 0x30, 0x00, 0xDC, 0x00, 0xDF, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC0, 0x0D,
	0xF0, 0x03, 0x70, 0x03, 0x7C, 0x00, 0xDC, 0x00, 0xDF, 0x00, 0x3F, 0x00, 0x0C, 0x01, 0x0E, 0x06,
	0x3F, 0x00, 0xD5, 0xC0, 0x3D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0,
	0x0D, 0xF0, 0x0D, 0xF0, 0x3D, 0xF0, 0xD5, 0xF0, 0x3F, 0xF0, 0x0F, 0xC0, 0x02, 0x0E, 0x0A, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x00, 0x00, 0x0D,
	0x5C, 0x00, 0x00, 0x37, 0x77, 0x00, 0x00, 0xDF, 0x7D, 0xC0, 0x00, 0x3F, 0x7F, 0xF0, 0x00, 0x0F,
	0x7C, 0xC0, 0x00, 0x03, 0x7C, 0x00, 0x03, 0x03, 0x7C, 0x00, 0x0D, 0x03, 0x7C, 0x00, 0x03, 0x00,
	0xFC, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x02, 0x0D, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF,
	0xF0, 0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x01, 0x07,
	0x04, 0x0C, 0x00, 0x37, 0x00, 0xD7, 0x00, 0xD7, 0x00, 0xD7, 0x03, 0xDC, 0x0D, 0x30, 0x03, 0x02,
	0x0D, 0x09, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xF0,
	0x00, 0xD7, 0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x00, 0xD7, 0x3D, 0x57, 0xC0, 0xD7, 0x35, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD5, 0x0F, 0xFF,
	0xC0, 0x3F, 0x03, 0xFF, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00,
	0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xF0, 0x00, 0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD5, 0x5F, 0xC0, 0x35, 0x3F, 0xFF, 0x00, 0x0F, 0x0F, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x0F, 0xF0, 0x00, 0x3F,
	0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x03, 0x5F, 0xD7, 0xFF, 0xC3, 0x5F, 0xD7, 0xCF, 0x03, 0x5F,
	0xD7, 0xFC, 0x03, 0x5F, 0xD7, 0xD7, 0x03, 0x5F, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0x3F,
	0x03, 0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00,
	0xD7, 0xC0, 0x00, 0x0F, 0xD7, 0xC0, 0x0F, 0x35, 0x57, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD5, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35,
	0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0x00,
	0x00, 0x0F, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xF0, 0x00, 0xD7, 0x35, 0x5C,
	0x03, 0x55, 0xD7, 0xD7, 0x00, 0xD7, 0xD5, 0x57, 0xC0, 0xD7, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF,
	0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0x0F, 0xFF, 0x00, 0x3F, 0x03, 0xFC,
	0x00, 0x0F, 0x01, 0x0D, 0x07, 0x03, 0xC0, 0x0D, 0x70, 0x35, 0xFC, 0x35, 0xF0, 0xD5, 0x70, 0x35,
	0xFC, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x0F, 0xF0, 0x03, 0xC0, 0x02,
	0x10, 0x09, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xFC,
	0x00, 0xD7, 0x35, 0x57, 0x00, 0xD5, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD7, 0x3F, 0xD7,
	0xC0, 0x3F, 0xD7, 0xD7, 0xC0, 0x0F, 0x35, 0x5F, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC,
	0x00, 0x00, 0x02, 0x0D, 0x09, 0x3C, 0x00, 0x00, 0x3C, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00,
	0xD7, 0xD7, 0xF0, 0x00, 0x3F, 0xD5, 0x5C, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0x3F, 0xFF, 0xC0, 0x3F, 0x0F, 0x0F, 0x00, 0x0F, 0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00,
	0xD7, 0xC0, 0x3F, 0xC0, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0,
	0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x01, 0x10, 0x06, 0x0F, 0x00, 0x35, 0xC0, 0x35, 0xF0, 0x0F,
	0xF0, 0x35, 0xC0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35,
	0xF0, 0x35, 0xF0, 0xD7, 0xF0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x3C, 0x00, 0x00, 0xF0,
	0xD7, 0x00, 0x03, 0x5C, 0xD7, 0xC0, 0x03, 0x5F, 0xD7, 0xFC, 0x03, 0x5F, 0xD7, 0xD7, 0x03, 0x5F,
	0xD7, 0x5F, 0xC3, 0x5F, 0xD5, 0x7F, 0x03, 0x5F, 0xD5, 0xFC, 0x03, 0x5F, 0xD5, 0x70, 0x03, 0x5F,
	0xD7, 0x5C, 0x03, 0x5F, 0xD7, 0xD7, 0x03, 0x5F, 0x3F, 0xFF, 0xC0, 0xFF, 0x0F, 0x0F, 0x00, 0x3C,
	0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7,
	0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x0D,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, 0x00,
	0xD5, 0x55, 0x5C, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xFF, 0xFF, 0xC0,
	0x0F, 0x0F, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, 0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7,
	0xD7, 0xC0, 0x35, 0x3F, 0xFF, 0xC0, 0x0F, 0x0F, 0x0F, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C,
	0x00, 0xD5, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0xD7, 0x03, 0xFC,
	0x00, 0xD7, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3F, 0xF0, 0x00, 0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD5, 0x5F, 0xC0,
	0x35, 0xD7, 0xFF, 0x00, 0x0F, 0xD7, 0xFC, 0x00, 0x03, 0xD7, 0xC0, 0x00, 0x00, 0x3F, 0xC0, 0x00,
	0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x3F, 0x35, 0x57, 0x00, 0xD5, 0xD7, 0xD7, 0xC0, 0xD5,
	0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7,
	0x35, 0x57, 0xC0, 0xD7, 0x0F, 0xD7, 0xC0, 0x3F, 0x03, 0xD7, 0xC0, 0x0F, 0x00, 0xD7, 0xC0, 0x00,
	0x00, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x01, 0x0D, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3F, 0xC0, 0xD5, 0x70, 0xD5, 0xFC, 0xD7, 0xF0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7,
	0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C,
	0x00, 0x00, 0x00, 0xD7, 0x0F, 0xF0, 0x00, 0xD7, 0x35, 0x5C, 0x03, 0x55, 0xD7, 0xD7, 0x00, 0xD7,
	0xD7, 0xFF, 0xC0, 0xD7, 0x35, 0x5F, 0x00, 0xD7, 0x3F, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7,
	0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x01, 0x0D, 0x07, 0x00,
	0x00, 0x0F, 0x00, 0x35, 0xC0, 0x35, 0xF0, 0xD5, 0x70, 0x35, 0xFC, 0x35, 0xF0, 0x35, 0xF0, 0x35,
	0xF0, 0x35, 0xF0, 0x0D, 0x70, 0x03, 0xFC, 0x00, 0xF0, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0xF0, 0xD7, 0xD7, 0x03, 0x5C,
	0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x35,
	0xD7, 0xD7, 0xC0, 0x0D, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF, 0xC0, 0x03, 0x03, 0xFF, 0x00, 0x00,
	0x02, 0x0D, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C,
	0x03, 0xC0, 0x3C, 0xD7, 0x0D, 0x70, 0xD7, 0xD7, 0xCD, 0x7C, 0xD7, 0x35, 0xF5, 0xFC, 0x35, 0x35,
	0xF5, 0xF0, 0x35, 0x0D, 0x57, 0xF0, 0x35, 0x03, 0x5F, 0xC0, 0x0D, 0x03, 0x5F, 0x00, 0x0D, 0x00,
	0xFF, 0x00, 0x03, 0x00, 0x3C, 0x00, 0x00, 0x02, 0x0D, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x3C, 0x03, 0xD7, 0x3C, 0xD7, 0x0D, 0xD7, 0xD7,
	0xD7, 0xC3, 0x35, 0xD7, 0x5F, 0xC0, 0x35, 0xD7, 0x5F, 0x00, 0x35, 0x55, 0x5F, 0x00, 0x0D, 0x7D,
	0x7F, 0x03, 0x0D, 0x7D, 0x7C, 0x0D, 0x03, 0xFF, 0xFC, 0x03, 0x00, 0xF0, 0xF0, 0x00, 0x02, 0x0D,
	0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x03, 0xC0,
	0x3C, 0xD7, 0x0D, 0x70, 0xD7, 0x35, 0xF5, 0xFC, 0xD7, 0x0D, 0x57, 0xF0, 0x35, 0x03, 0x5F, 0xC0,
	0x35, 0x0D, 0x57, 0x00, 0x0D, 0x35, 0xF5, 0xC0, 0x0D, 0xD7, 0xFD, 0x70, 0x03, 0x3F, 0xC3, 0xFC,
	0x03, 0x0F, 0x00, 0xF0, 0x0D, 0x02, 0x10, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3C, 0x03, 0xC0, 0x0F, 0xD7, 0x0D, 0x70, 0x35, 0xD7, 0xCD, 0x7C, 0x0F,
	0x35, 0xF5, 0xFC, 0x03, 0x35, 0xF5, 0xF0, 0x03, 0x0D, 0x57, 0xF0, 0x0D, 0x0D, 0x57, 0xC0, 0x35,
	0x03, 0x5F, 0xC0, 0x35, 0x03, 0x5F, 0x00, 0x0F, 0x0D, 0x7F, 0x00, 0x03, 0x35, 0xFC, 0x00, 0x00,
	0x0F, 0xF0, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0xD5, 0x57, 0x00, 0x00, 0x3F,
	0xD7, 0xC0, 0x00, 0x0F, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x35, 0xFC, 0x00, 0x00, 0xD7,
	0xFC, 0x00, 0x00, 0xD5, 0x57, 0x00, 0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x01,
	0x0E, 0x07, 0x00, 0x00, 0x03, 0xC0, 0x0D, 0x70, 0x37, 0xFC, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0,
	0xDF, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x37, 0xC0, 0x0D, 0x70, 0x03, 0xFC, 0x00, 0xF0, 0x01, 0x0F,
	0x04, 0x30, 0x00, 0xDC, 0x0F, 0xDF, 0x35, 0xDF, 0x0F, 0xDF, 0x03, 0xDF, 0x03, 0xDF, 0x00, 0xDF,
	0x00, 0xDF, 0x03, 0xDF, 0x03, 0xDF, 0x0F, 0xDF, 0x35, 0xDF, 0x0F, 0x3F, 0x03, 0x0C, 0x00, 0x01,
	0x0E, 0x07, 0x00, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0x3D, 0xC0, 0x0D, 0xF0, 0x0D, 0xF0, 0x03, 0x70,
	0x03, 0x7C, 0x0D, 0xFC, 0x0D, 0xF0, 0x3D, 0xF0, 0xD7, 0xF0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x08,
	0x0A, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x0F, 0x00, 0x03, 0x70, 0x35, 0xC3, 0x00,
	0xC0, 0xDF, 0x7D, 0xC0, 0x00, 0x3F, 0xD7, 0xF0, 0x00, 0x0C, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00,
	0x00, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x10, 0x0A, 0x03,
	0xFC, 0x00, 0x00, 0x0D, 0x57, 0x00, 0x00, 0x35, 0xF5, 0xC0, 0x00, 0xD7, 0xFD, 0xF0, 0x00, 0xD7,
	0xC3, 0xF0, 0x00, 0xD7, 0xC0, 0xC0, 0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xC3, 0x00, 0x00, 0xD7,
	0xCD, 0xC0, 0x00, 0x35, 0xF5, 0xF0, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0x7F, 0xC0, 0x00, 0x03,
	0xDF, 0x00, 0x00, 0x01, 0xDF, 0x00, 0x00, 0x03, 0x7C, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x02,
	0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x00, 0x37, 0x37, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x03, 0x3F, 0xFF,
	0xC0, 0x00, 0x3F, 0x3F, 0x00, 0x03, 0xD7, 0xD7, 0x00, 0x0D, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7,
	0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF,
	0xC0, 0x03, 0x03, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x03, 0x03, 0xDC, 0x00,
	0x0D, 0x0D, 0x7F, 0x00, 0x37, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00,
	0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD5, 0x57, 0xC0, 0x3D, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xD7, 0x00,
	0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09,
	0x03, 0xC0, 0x00, 0x03, 0x0D, 0x70, 0x00, 0x0D, 0x37, 0xDC, 0x00, 0x35, 0x0F, 0xFF, 0x00, 0x0F,
	0x0F, 0xFC, 0x00, 0x03, 0x35, 0x5C, 0x00, 0x0D, 0xD7, 0xD7, 0x00, 0x35, 0x3D, 0x57, 0xC0, 0x0F,
	0x35, 0xD7, 0xC0, 0x0D, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF, 0xC0, 0x03,
	0x03, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x0C, 0x37, 0x37, 0x00, 0x37, 0xD7,
	0xD7, 0xC0, 0x0D, 0x3F, 0xFF, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5, 0xD7,
	0xD7, 0x03, 0x5F, 0x3D, 0x57, 0xC0, 0xF5, 0x35, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC3, 0x5F, 0x35,
	0x57, 0xC0, 0xD5, 0x0F, 0xFF, 0xC0, 0x3F, 0x03, 0xFF, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x03, 0x00,
	0x00, 0x00, 0x0D, 0xF0, 0x00, 0x03, 0x03, 0x5C, 0x00, 0x0D, 0x00, 0xFF, 0x00, 0x03, 0x0F, 0xF0,
	0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0x3D, 0x57, 0xC0, 0x3D, 0x35, 0xD7,
	0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF,
	0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x00, 0x00, 0x0D, 0xDC, 0x00,
	0x00, 0x03, 0x7F, 0x00, 0x03, 0x0F, 0xFC, 0x00, 0x0D, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00,
	0x35, 0x3D, 0x57, 0xC0, 0x35, 0x35, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0,
	0x0D, 0x0F, 0xFF, 0xC0, 0x03, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0D, 0x0F, 0xF0, 0x00, 0x03, 0x35, 0x5C, 0x00, 0x03,
	0xD7, 0xD7, 0x00, 0x0D, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xCF, 0x00, 0x35, 0xD7, 0xFC, 0x00, 0x35,
	0xD7, 0xD7, 0x00, 0x35, 0x35, 0x5F, 0xC0, 0x0D, 0x0D, 0xFF, 0x00, 0x03, 0x0F, 0x7C, 0x00, 0x00,
	0x07, 0x7C, 0x00, 0x00, 0x0D, 0xF0, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x03,
	0xC0, 0x00, 0x0C, 0x0D, 0x70, 0x00, 0x37, 0x37, 0xDC, 0x00, 0xD7, 0x0F, 0xFF, 0x00, 0x3F, 0x0F,
	0xFC, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD5, 0x57, 0xC0, 0xD5, 0xD7,
	0xFF, 0xC0, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03,
	0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x03, 0x37, 0x37, 0x00, 0x0D, 0xD7, 0xD7,
	0xC0, 0x03, 0x3F, 0xFF, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x03, 0x35, 0x5C, 0x00, 0x0D, 0xD7, 0xD7,
	0x00, 0x35, 0xD5, 0x57, 0xC0, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xD7, 0x00, 0x35, 0x35, 0x5F,
	0xC0, 0x0D, 0x0F, 0xFF, 0x00, 0x03, 0x03, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x0C, 0x00, 0x00,
	0x03, 0x37, 0xC0, 0x00, 0x0D, 0x0D, 0x70, 0x00, 0x35, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00,
	0x03, 0x35, 0x5C, 0x00, 0x03, 0xD7, 0xD7, 0x00, 0x03, 0xD5, 0x57, 0xC0, 0x03, 0xD7, 0xFF, 0xC0,
	0x03, 0xD7, 0xD7, 0x00, 0x03, 0x35, 0x5F, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00,
	0x00, 0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x03, 0x37, 0x37, 0x00, 0x0D, 0xD7, 0xD7, 0xC0, 0x37,
	0x3F, 0xFF, 0xC0, 0x0F, 0x0F, 0xCF, 0x00, 0x0F, 0x0D, 0x70, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D,
	0x0D, 0x7C, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D, 0x0D, 0x7C, 0x00, 0x0D,
	0x03, 0xFC, 0x00, 0x03, 0x00, 0xF0, 0x00, 0x00, 0x01, 0x0D, 0x07, 0x0F, 0x00, 0x35, 0xC0, 0xDF,
	0x70, 0x3F, 0xFC, 0x3F, 0x30, 0x35, 0xC0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35,
	0xF0, 0x0F, 0xF0, 0x03, 0xC0, 0x01, 0x0D, 0x06, 0x30, 0x00, 0xDF, 0x00, 0x35, 0xC0, 0x0F, 0xF0,
	0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0,
	0x0F, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0x03, 0x00, 0x03, 0x0D, 0xCD, 0xC0, 0x0D, 0x35, 0xF5, 0xF0,
	0x0D, 0x0F, 0xFF, 0xF0, 0x03, 0x03, 0x5F, 0x00, 0x00, 0x0D, 0x57, 0xC0, 0x00, 0x0D, 0xF7, 0xC0,
	0x00, 0x35, 0xF5, 0xC0, 0x00, 0x35, 0x55, 0xF0, 0x00, 0xD7, 0xFD, 0x70, 0x00, 0xD7, 0xFD, 0x7C,
	0x00, 0xFF, 0xFF, 0xFC, 0x00, 0x3F, 0xC3, 0xFC, 0x00, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00,
	0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D, 0x0A, 0x00, 0x30, 0x00, 0x00, 0x03, 0xDC, 0x00, 0x00, 0x0D,
	0x7F, 0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0xD5, 0x55, 0xC0, 0x00, 0xD7, 0xFF, 0xF0, 0x03, 0xD7,
	0xFF, 0xC0, 0x00, 0xD5, 0x57, 0x00, 0x00, 0xD7, 0xFF, 0xC0, 0x03, 0xD7, 0xFF, 0x00, 0x03, 0xD5,
	0x55, 0xC0, 0x00, 0x3F, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x02, 0x0D, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x3F, 0xC0, 0x35, 0x5C,
	0xD5, 0x70, 0xD7, 0xD7, 0x5F, 0x5C, 0x3D, 0x57, 0x55, 0x5F, 0x35, 0xD7, 0x5F, 0xFF, 0xD7, 0xD7,
	0x5F, 0xFC, 0xD7, 0xD7, 0x5F, 0x5C, 0x35, 0x55, 0x55, 0x7F, 0x0F, 0xFF, 0xFF, 0xFC, 0x03, 0xFF,
	0xFF, 0xF0, 0x02, 0x0D, 0x10, 0x00, 0x03, 0xFF, 0xF0, 0x00, 0x0D, 0x55, 0x5C, 0x00, 0x35, 0x7F,
	0xFF, 0x00, 0xD5, 0x7F, 0xFC, 0x00, 0xD5, 0x7F, 0xC0, 0x03, 0x5D, 0x55, 0x70, 0x0D, 0x7D, 0x7F,
	0xFC, 0x0D, 0x7D, 0x7F, 0xF0, 0x35, 0x55, 0x7C, 0x00, 0xD7, 0xFD, 0x7F, 0xF0, 0xD7, 0xFD, 0x55,
	0x5C, 0xFF, 0x0F, 0xFF, 0xFF, 0x3C, 0x03, 0xFF, 0xFC, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00, 0x30,
	0x0D, 0x70, 0x00, 0xDC, 0x37, 0xDC, 0x03, 0x5F, 0x0F, 0xFF, 0x00, 0xFF, 0x0F, 0xFC, 0x00, 0x3F,
	0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x03, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F,
	0xD7, 0xD7, 0xC3, 0x5F, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F,
	0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x0C, 0x37, 0x37, 0x00, 0x37, 0xD7, 0xD7, 0xC0, 0x0D, 0x3F,
	0xFF, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F,
	0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0C, 0x00, 0x00, 0x03, 0x37, 0xC0,
	0x00, 0x0D, 0x0D, 0x70, 0x00, 0x37, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C,
	0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7,
	0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D,
	0x09, 0x03, 0xC0, 0x00, 0x0C, 0x0D, 0x70, 0x00, 0x37, 0x37, 0xDC, 0x00, 0x0D, 0x0F, 0xFF, 0x00,
	0x03, 0x3F, 0x3C, 0x00, 0x3C, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0,
	0x0F, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0C, 0x00, 0x00, 0x03, 0x37, 0xC0, 0x00, 0x0D,
	0x0D, 0x70, 0x00, 0x0D, 0x03, 0xFC, 0x00, 0x03, 0x3C, 0x3C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00,
	0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00,
	0x35, 0x57, 0xC0, 0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x01, 0x04, 0x03, 0x30,
	0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0x03, 0x00, 0x00, 0x0D, 0xCD,
	0xC0, 0x00, 0x35, 0xF5, 0xF0, 0x00, 0x0F, 0xFF, 0xF0, 0x00, 0x0D, 0x57, 0xC0, 0x00, 0x35, 0xF5,
	0xC0, 0x00, 0xD7, 0xFD, 0x70, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0x35, 0xF5,
	0xFC, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0xFF, 0xC0, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x02, 0x0D,
	0x0B, 0x03, 0x03, 0x00, 0x00, 0x0D, 0xCD, 0xC0, 0x00, 0x35, 0xF5, 0xF0, 0x00, 0x3F, 0xFF, 0xF0,
	0x00, 0xD7, 0xCD, 0x70, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C,
	0x00, 0xD7, 0xFD, 0x7C, 0x00, 0xD5, 0x55, 0x7C, 0x00, 0x35, 0x55, 0xFC, 0x00, 0x0F, 0xFF, 0xF0,
	0x00, 0x03, 0xFF, 0xC0, 0x00, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x03, 0xDC, 0x03, 0x30, 0x00,
	0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D, 0x0E, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF3, 0xFC, 0x00, 0x35, 0x5D,
	0x57, 0x00, 0xD7, 0xD5, 0xF5, 0xC0, 0xD7, 0xD5, 0x55, 0xF0, 0xD7, 0xD5, 0xFF, 0xF0, 0xD7, 0xD5,
	0xFF, 0xC0, 0xD7, 0xD5, 0xF5, 0xC0, 0x35, 0x5D, 0x57, 0xF0, 0x3F, 0xFF, 0xFF, 0xC0, 0x0F, 0xFF,
	0xFF, 0x00, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03,
	0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x03, 0x03,
	0xDC, 0x00, 0x3D, 0x0D, 0x7F, 0x00, 0xD7, 0x03, 0xFC, 0x00, 0x3F, 0x0F, 0xF0, 0x00, 0x3C, 0x35,
	0x5C, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0x3D, 0x57, 0xC0, 0xD7, 0x35, 0xD7, 0xC0, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD7, 0x0F, 0xFF, 0xC0, 0x3F, 0x03, 0xFF, 0x00, 0x0F, 0x01,
	0x0D, 0x06, 0x03, 0x00, 0x3D, 0xC0, 0xD7, 0xF0, 0x3F, 0xC0, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x00,
	0x30, 0x00, 0x00, 0x03, 0xDC, 0x00, 0x0F, 0x0D, 0x7F, 0x00, 0x35, 0x03, 0xFC, 0x00, 0x0F, 0x0F,
	0xF0, 0x00, 0xF0, 0x35, 0x5C, 0x03, 0x5F, 0xD7, 0xD7, 0x03, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0xD7,
	0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0x3F, 0x03,
	0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x03, 0x03, 0xDC, 0x00, 0x0D, 0x0D, 0x7F,
	0x00, 0x37, 0x03, 0xFC, 0x00, 0x0F, 0x3C, 0x3C, 0x00, 0x0F, 0xD7, 0xD7, 0x00, 0x35, 0xD7, 0xD7,
	0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57,
	0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0x0C, 0x00,
	0x0F, 0x35, 0xF7, 0x00, 0x35, 0xDF, 0x5F, 0xC0, 0xDF, 0x3F, 0xFF, 0x00, 0xFF, 0x3F, 0xFC, 0x03,
	0x5C, 0xD5, 0x5C, 0x03, 0x57, 0xD7, 0xD7, 0x03, 0x55, 0xD7, 0xD7, 0xC3, 0x5D, 0xD7, 0xD7, 0xC3,
	0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0x3F, 0xFF, 0xC0, 0xFF, 0x0F, 0x0F, 0x00,
	0x3C, 0x02, 0x0D, 0x0B, 0x03, 0xC3, 0x00, 0x00, 0x0D, 0x7D, 0xC0, 0x00, 0x37, 0xD7, 0xF0, 0x00,
	0x3F, 0xFF, 0xC0, 0x00, 0xD7, 0x0D, 0x70, 0x00, 0xD5, 0xCD, 0x7C, 0x00, 0xD5, 0x7D, 0x7C, 0x00,
	0xD7, 0x5D, 0x7C, 0x00, 0xD7, 0xD5, 0x7C, 0x00, 0xD7, 0xF5, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00,
	0x3F, 0xC3, 0xFC, 0x00, 0x0F, 0x00, 0xF0, 0x00, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC,
	0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D,
	0x09, 0x03, 0xC0, 0x00, 0x00, 0x0D, 0x70, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00,
	0x00, 0x0D, 0x70, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x35, 0xFC, 0x00, 0x00, 0xD7, 0xFC, 0x00,
	0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x35, 0x5F, 0xC0, 0x00, 0x0F, 0xFF, 0x00,
	0x00, 0x03, 0xFC, 0x00, 0x00, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30,
	0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x30,
	0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x03, 0xDC, 0x0D, 0xDC, 0x0D, 0x30,
	0x03, 0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0x3F, 0xC0, 0xD7, 0x00, 0xD7, 0xC0,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0A,
	0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0C, 0x00, 0x00, 0x0D, 0xF7, 0x00,
	0x00, 0x37, 0xDF, 0xC0, 0x00, 0xDF, 0x7F, 0x00, 0x00, 0x37, 0xDC, 0x00, 0x00, 0x0D, 0xF7, 0x00,
	0x00, 0x03, 0xFF, 0xC0, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x02, 0x0A, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x30, 0xC0, 0x00, 0x00, 0xDF, 0x70, 0x00, 0x00, 0x37, 0xDC, 0x00, 0x00,
	0x0D, 0xF7, 0x00, 0x00, 0x37, 0xDF, 0xC0, 0x00, 0xDF, 0x7F, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00,
	0x0C, 0x30, 0x00, 0x00, 0x02, 0x10, 0x0B, 0x00, 0xFF, 0x00, 0x00, 0x03, 0x55, 0xC0, 0x00, 0x0D,
	0x7D, 0x70, 0x00, 0x0D, 0x7D, 0x7C, 0x00, 0x0D, 0x7D, 0x7C, 0x00, 0x0D, 0x75, 0xFC, 0x00, 0x0D,
	0x75, 0x70, 0x00, 0x0D, 0x7D, 0x7C, 0x00, 0x0D, 0x7D, 0x7C, 0x00, 0x0D, 0x7D, 0x7C, 0x00, 0x0D,
	0x55, 0xFC, 0x00, 0x0D, 0x7F, 0xF0, 0x00, 0x35, 0xFF, 0xC0, 0x00, 0x35, 0xF0, 0x00, 0x00, 0xD7,
	0xF0, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00
};

const uint16 Graphics::_polFontOffs[] = {
	0x0000, 0x0007, 0x0024, 0x0043, 0x0072, 0x00AD, 0x00E0, 0x0113, 0x0124, 0x0141,
	0x015E, 0x0191, 0x01C4, 0x01E3, 0x01F8, 0x0215, 0x0232, 0x0269, 0x0286, 0x02BD,
	0x02F4, 0x032B, 0x0362, 0x0399, 0x03D0, 0x0407, 0x043E, 0x045B, 0x047C, 0x0495,
	0x04C0, 0x04D9, 0x0510, 0x054B, 0x0582, 0x05B9, 0x05F0, 0x0627, 0x065E, 0x0695,
	0x06CC, 0x0703, 0x0720, 0x0757, 0x078E, 0x07C5, 0x07FC, 0x0833, 0x086A, 0x08A1,
	0x08D8, 0x090F, 0x0946, 0x097D, 0x09B4, 0x09EB, 0x0A3C, 0x0A73, 0x0AAA, 0x0AE1,
	0x0B00, 0x0B1D, 0x0B3C, 0x0B77, 0x0BAE, 0x0BBF, 0x0BF6, 0x0C2D, 0x0C64, 0x0C9B,
	0x0CD2, 0x0CEF, 0x0D32, 0x0D69, 0x0D86, 0x0DA9, 0x0DE0, 0x0DFD, 0x0E34, 0x0E6B,
	0x0EA2, 0x0EE5, 0x0F28, 0x0F45, 0x0F7C, 0x0F99, 0x0FD0, 0x1007, 0x103E, 0x1075,
	0x10B8, 0x10EF, 0x110E, 0x112F, 0x114E, 0x1171, 0x117C, 0x11BF, 0x11F6, 0x122D,
	0x1264, 0x129B, 0x12D2, 0x1309, 0x134C, 0x1383, 0x13BA, 0x13F1, 0x1428, 0x145F,
	0x147C, 0x14B3, 0x14EA, 0x1521, 0x1558, 0x158F, 0x15C6, 0x15FD, 0x1634, 0x166B,
	0x16A2, 0x16AD, 0x16E4, 0x171B, 0x1726, 0x175D, 0x1794, 0x179F, 0x17D6, 0x180D,
	0x182A, 0x1861, 0x1898, 0x18CF, 0x1912, 0x191D, 0x1928, 0x195F, 0x196A, 0x1975,
	0x1980, 0x198B, 0x19A8, 0x19D3, 0x0000, 0x0000, 0x0000, 0x1A0A, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x1A41, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1A84,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ABB, 0x0000, 0x0000, 0x0000,
	0x1AF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1B35, 0x0000, 0x1B6C,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1BA3, 0x0000,
	0x0000, 0x0000, 0x1BDA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1C1D,
	0x0000, 0x1C54, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000
};

const int Graphics::_polFontSize = ARRAYSIZE(Graphics::_polFontOffs);

const uint8 Graphics::_polFontData[] = {
	0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0D, 0x05, 0x3C, 0x03, 0xD7, 0x0D, 0xD7, 0xCD,
	0xD7, 0xCD, 0xD7, 0xCD, 0xD7, 0xC3, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0xD7, 0x00, 0xD7, 0xC0,
	0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x07, 0x09, 0x3C, 0x3C, 0x00, 0x0C, 0xD7, 0xD7, 0x00, 0x37, 0xD7,
	0xD7, 0xC0, 0xF7, 0xD7, 0xD7, 0xC3, 0x55, 0xD7, 0xD7, 0xC0, 0xDF, 0x3F, 0xFF, 0xC3, 0xDF, 0x0F,
	0x0F, 0x0D, 0x55, 0x02, 0x0B, 0x0B, 0x00, 0xC3, 0x00, 0x03, 0x03, 0x7D, 0xC0, 0x0D, 0x0F, 0x7D,
	0xF0, 0x0D, 0x35, 0x55, 0x70, 0x35, 0x0D, 0xF7, 0xFC, 0xDD, 0x3D, 0xF7, 0xF0, 0xDD, 0xD5, 0x55,
	0xC0, 0x35, 0x37, 0xDF, 0xF0, 0x3D, 0x37, 0xDF, 0xC0, 0xDD, 0x0F, 0xFF, 0x00, 0x35, 0x03, 0x0C,
	0x00, 0x0D, 0x02, 0x0E, 0x09, 0x03, 0x00, 0x00, 0xF0, 0x0D, 0xC0, 0x03, 0x5C, 0x0D, 0xF0, 0x0D,
	0xF7, 0x35, 0x5C, 0x0D, 0xF7, 0xDD, 0xF7, 0x03, 0x5F, 0xDD, 0xFF, 0xC0, 0xFD, 0x35, 0x5F, 0x00,
	0x37, 0x3D, 0xF7, 0x00, 0xDF, 0xDD, 0xF7, 0xC3, 0x7F, 0x35, 0x5F, 0xC0, 0xFC, 0x0D, 0xFF, 0x00,
	0x30, 0x0D, 0xFC, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x02, 0x0C, 0x0C,
	0x0F, 0x00, 0x00, 0x00, 0x35, 0xC0, 0xC0, 0x00, 0xDF, 0x73, 0x70, 0x03, 0xDF, 0x7D, 0xFC, 0x0D,
	0x35, 0xF7, 0xF0, 0x37, 0x0F, 0xDF, 0xC0, 0x37, 0x03, 0x7D, 0x70, 0x0D, 0x0D, 0xF7, 0xDC, 0x37,
	0x37, 0xF7, 0xDF, 0x37, 0x0F, 0xCD, 0x7F, 0x0D, 0x03, 0x03, 0xFC, 0x03, 0x00, 0x00, 0xF0, 0x00,
	0x02, 0x0C, 0x0B, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xC0, 0x00, 0xD7, 0x35,
	0x70, 0x00, 0xD7, 0xDF, 0xDC, 0x00, 0xD7, 0xDF, 0xFF, 0xC0, 0xFF, 0x35, 0x7D, 0x70, 0x3F, 0xDF,
	0xF7, 0xFC, 0x00, 0xDF, 0xDF, 0xF0, 0x00, 0x35, 0x7F, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x03,
	0xF0, 0x00, 0x00, 0x01, 0x07, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC3, 0xD7, 0xC3, 0xD7, 0xCD,
	0xFF, 0xCD, 0x3F, 0x0D, 0x01, 0x0D, 0x06, 0x03, 0x00, 0x0D, 0xC3, 0x37, 0xF0, 0x37, 0xC0, 0xDF,
	0xC0, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC3, 0x03, 0xF0, 0x00,
	0xC0, 0x01, 0x0D, 0x06, 0x30, 0x00, 0xDC, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC0, 0x0D, 0xF0,
	0x0D, 0xF3, 0x0D, 0xF0, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x02, 0x0C,
	0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x03, 0x0F, 0x7C, 0x00,
	0x0D, 0x37, 0x77, 0x00, 0x0D, 0x3D, 0x5F, 0xC0, 0xFD, 0xD5, 0xD5, 0xC3, 0x55, 0x3D, 0x5F, 0xF0,
	0xFD, 0x37, 0x77, 0xC0, 0x3D, 0x0F, 0x7F, 0xC0, 0x0D, 0x03, 0xFF, 0x00, 0x03, 0x00, 0x30, 0x00,
	0x00, 0x02, 0x0C, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00,
	0x03, 0x70, 0x00, 0x00, 0x03, 0x7C, 0x00, 0x00, 0x3F, 0x7F, 0x00, 0x00, 0xD5, 0x55, 0xC0, 0x00,
	0x3F, 0x7F, 0xF0, 0x00, 0x0F, 0x7F, 0xC0, 0x3C, 0x03, 0x7C, 0x00, 0xD7, 0x00, 0xFC, 0x00, 0xD7,
	0x00, 0x30, 0x03, 0x5F, 0x01, 0x0E, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x0F, 0x00, 0x35, 0xC0, 0x35, 0xF0, 0xD7, 0xF0, 0x3F,
	0xC0, 0x0F, 0x00, 0x01, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3F, 0xC0, 0xD5, 0x70, 0x3F, 0xFC, 0x0F, 0xF0, 0x01, 0x0D, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3C, 0x03, 0xD7, 0x0D, 0xD7,
	0xCD, 0x3F, 0xC3, 0x0F, 0x00, 0x01, 0x0D, 0x08, 0x00, 0x00, 0x00, 0x30, 0x00, 0xDC, 0x03, 0x7F,
	0x03, 0x7C, 0x0D, 0xFC, 0x0D, 0xF0, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0, 0xDF, 0x00, 0x3F, 0x00,
	0x0C, 0x00, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0xF5, 0xD7, 0xD7, 0x03,
	0x55, 0xD7, 0xD7, 0xC0, 0xF5, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0,
	0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x5F, 0xC0,
	0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x01, 0x0D, 0x07, 0x03, 0xC0, 0x3D, 0x70,
	0xD5, 0x7C, 0x3D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C, 0x0D, 0x7C,
	0x0D, 0x7C, 0x03, 0xFC, 0x00, 0xF0, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00,
	0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0x3F, 0xD7, 0xC0, 0x0F, 0x0F, 0x5F, 0xC0,
	0x0D, 0x0D, 0x7F, 0x00, 0x03, 0x35, 0xFC, 0x00, 0x00, 0xD7, 0xF0, 0x00, 0x3C, 0xD7, 0xFC, 0x00,
	0xD7, 0xD5, 0x57, 0x00, 0x35, 0x3F, 0xFF, 0xC0, 0x0F, 0x0F, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09,
	0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x03, 0x3F, 0xD7, 0xC0, 0x0D,
	0x0F, 0xD7, 0xC0, 0x0D, 0x0D, 0x5F, 0xC0, 0x35, 0x03, 0xD7, 0x00, 0x35, 0x00, 0xD7, 0xC0, 0xD7,
	0x3C, 0xD7, 0xC0, 0xD5, 0xD7, 0xD7, 0xC0, 0x3F, 0x35, 0x5F, 0xC0, 0x0F, 0x0F, 0xFF, 0x00, 0x00,
	0x03, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x3F, 0x00, 0xD7, 0x00, 0xD5, 0x03,
	0x57, 0xC0, 0xD7, 0x0D, 0x57, 0xC0, 0xD7, 0x0D, 0x57, 0xC0, 0xD7, 0x35, 0xD7, 0xC0, 0xD5, 0x35,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xD5, 0x57, 0xC0, 0x3F, 0x3F, 0xD7, 0xC0, 0xD7, 0x0F,
	0xD7, 0xC0, 0x35, 0x00, 0x3F, 0xC0, 0x0F, 0x00, 0x0F, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x3F, 0xFC,
	0x00, 0x0F, 0xD5, 0x57, 0x00, 0x35, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF, 0x00, 0xD7, 0xD7, 0xF0,
	0x00, 0xD7, 0xD5, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x00, 0xD7, 0x3F, 0xD7, 0xC0, 0xD7, 0x3F, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC,
	0x00, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x00,
	0x3F, 0xD7, 0xFF, 0xC0, 0x0F, 0xD7, 0xFF, 0x00, 0x03, 0xD5, 0x5C, 0x00, 0x0D, 0xD7, 0xD7, 0x00,
	0x0D, 0xD7, 0xD7, 0xC0, 0x0D, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x5F, 0xC0,
	0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x3F, 0xFC, 0x00, 0x0F,
	0xD5, 0x57, 0x00, 0x35, 0x3F, 0xD7, 0xC0, 0xD7, 0x0F, 0x5F, 0xC0, 0xD7, 0x03, 0x5F, 0x00, 0xD7,
	0x0D, 0x7F, 0x00, 0x35, 0x0D, 0x7C, 0x00, 0xD7, 0x0D, 0x7C, 0x00, 0xD7, 0x35, 0xFC, 0x00, 0xD7,
	0x35, 0xF0, 0x00, 0xD7, 0x35, 0xF0, 0x00, 0x35, 0x0F, 0xF0, 0x00, 0x0F, 0x03, 0xC0, 0x00, 0x03,
	0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0xD7, 0xD7, 0x00, 0x35, 0xD7,
	0xD7, 0xC0, 0x0F, 0xD7, 0xD7, 0xC0, 0x3F, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F,
	0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C,
	0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0xF0, 0xD7, 0xD7,
	0xC3, 0x5C, 0x35, 0x57, 0xC3, 0x5F, 0x0F, 0xD7, 0xC0, 0xFF, 0x3F, 0xD7, 0xC0, 0xFC, 0xD7, 0xD7,
	0xC3, 0x5C, 0x35, 0x5F, 0xC3, 0x5F, 0x0F, 0xFF, 0x00, 0xFF, 0x03, 0xFC, 0x00, 0x3C, 0x01, 0x0D,
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0xD7, 0x03, 0xD7, 0xC3, 0x3F,
	0xC0, 0x3F, 0x00, 0xD7, 0x03, 0xD7, 0xC3, 0x3F, 0xC0, 0x0F, 0x03, 0x01, 0x0F, 0x05, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0x3F, 0xC0, 0x3F, 0x00,
	0xD7, 0x00, 0xD7, 0xC0, 0x37, 0xC0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x01, 0x0B, 0x07, 0x00,
	0x00, 0x00, 0xC0, 0x03, 0x70, 0x0D, 0xFC, 0x37, 0xF0, 0xDF, 0xC0, 0x37, 0x00, 0x0D, 0xC0, 0x03,
	0x70, 0x00, 0xFC, 0x00, 0x30, 0x02, 0x0A, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0,
	0x00, 0x00, 0x03, 0x70, 0x3F, 0xFC, 0x00, 0xDC, 0xD5, 0x57, 0x00, 0x37, 0x3F, 0xFF, 0xC0, 0x0D,
	0x3F, 0xFF, 0x00, 0x37, 0xD5, 0x57, 0x00, 0xDF, 0x3F, 0xFF, 0xC3, 0x7F, 0x0F, 0xFF, 0x00, 0xFC,
	0x01, 0x0B, 0x07, 0x00, 0x00, 0x30, 0x00, 0xDC, 0x00, 0x37, 0x00, 0x0D, 0xC0, 0x03, 0x70, 0x0D,
	0xFC, 0x37, 0xF0, 0xDF, 0xC0, 0x3F, 0x00, 0x0C, 0x00, 0x02, 0x0D, 0x09, 0x0F, 0xF0, 0x00, 0x00,
	0x35, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x3F, 0xD7, 0xC0, 0x00,
	0x0F, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00,
	0x0D, 0x70, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00,
	0x02, 0x0E, 0x0D, 0x03, 0xFF, 0xC0, 0x00, 0x0D, 0x55, 0x70, 0x00, 0x37, 0xFF, 0xDC, 0x00, 0xDF,
	0xFF, 0xF7, 0x00, 0xDF, 0xD5, 0xF7, 0xC0, 0xDF, 0x7D, 0xF7, 0xC0, 0xDF, 0x7D, 0xF7, 0xC0, 0xDF,
	0x7D, 0xF7, 0xC0, 0xDF, 0x75, 0xDF, 0xC0, 0xDF, 0xDD, 0x7F, 0x00, 0x37, 0xFF, 0xFC, 0x00, 0x0D,
	0x5C, 0xF0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x00, 0xF0,
	0x00, 0x3F, 0x03, 0x5C, 0x00, 0xD5, 0x03, 0x5F, 0x00, 0xD7, 0x0D, 0x57, 0x00, 0xD7, 0x0D, 0x57,
	0xC0, 0xD7, 0x0D, 0xF7, 0xC0, 0xD5, 0x35, 0xF5, 0xC0, 0xD7, 0x35, 0xF5, 0xF0, 0xD7, 0x35, 0x55,
	0xF0, 0xD7, 0xD7, 0xFD, 0x70, 0xD7, 0xD7, 0xFD, 0x7C, 0xD5, 0x3F, 0xC3, 0xFC, 0x3F, 0x0F, 0x00,
	0xF0, 0x0F, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0x00, 0x03, 0xD5, 0x55, 0xC0, 0x0D, 0xD7, 0xFD, 0x70,
	0x35, 0xD7, 0xFD, 0x7C, 0xD7, 0xD7, 0xFD, 0x7C, 0xD7, 0xD5, 0x55, 0xFC, 0xD7, 0xD7, 0xFD, 0x70,
	0xD7, 0xD7, 0xFD, 0x7C, 0xD7, 0xD7, 0xCD, 0x7C, 0xD7, 0xD7, 0xFD, 0x7C, 0x35, 0xD5, 0x55, 0xFC,
	0x0D, 0x3F, 0xFF, 0xF0, 0x03, 0x0F, 0xFF, 0xC0, 0x00, 0x02, 0x0D, 0x0A, 0x03, 0xFC, 0x00, 0x0F,
	0x0D, 0x57, 0x00, 0x35, 0x35, 0xF5, 0xC0, 0x35, 0xD7, 0xFD, 0xF0, 0x35, 0xD7, 0xC3, 0xF0, 0x35,
	0xD7, 0xC0, 0xC0, 0x35, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xC3, 0x00, 0x35, 0xD7, 0xCD, 0xC0, 0x35,
	0x35, 0xF5, 0xF0, 0x35, 0x0D, 0x57, 0xF0, 0x35, 0x03, 0xFF, 0xC0, 0x0F, 0x00, 0xFF, 0x00, 0x03,
	0x02, 0x0D, 0x0B, 0x3F, 0xFC, 0x00, 0x03, 0xD5, 0x57, 0x00, 0x0D, 0xD7, 0xF5, 0xC0, 0x0D, 0xD7,
	0xFD, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xF5, 0xFC, 0x0D, 0xD5, 0x57, 0xF0, 0x0D, 0x3F,
	0xFF, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0A, 0x3F, 0xFF, 0x00, 0x0F, 0xD5, 0x55,
	0xC0, 0x35, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xFC, 0x00, 0x35, 0xD5, 0x57,
	0x00, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xFF, 0x00, 0x35, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xFF,
	0x00, 0x35, 0xD5, 0x55, 0xC0, 0x35, 0x3F, 0xFF, 0xF0, 0x0F, 0x0F, 0xFF, 0xC0, 0x03, 0x02, 0x0D,
	0x0A, 0x3F, 0xFF, 0x00, 0x03, 0xD5, 0x55, 0xC0, 0x0D, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0,
	0xD7, 0xD7, 0xFC, 0x00, 0xD7, 0xD5, 0x57, 0x00, 0xD7, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF, 0x00,
	0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x35, 0xD7, 0xC0, 0x00, 0x0D, 0x3F, 0xC0, 0x00,
	0x03, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFF, 0x00, 0x03, 0x0D, 0x55, 0xC0, 0x0D,
	0x35, 0xFD, 0x70, 0x0D, 0xD7, 0xFF, 0x7C, 0x0D, 0xD7, 0xC0, 0xFC, 0x0D, 0xD7, 0xFF, 0xF0, 0x0D,
	0xD7, 0xD5, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x35, 0xFD, 0x7C, 0x0D,
	0x0D, 0x57, 0x7C, 0x0D, 0x03, 0xFF, 0xFC, 0x03, 0x00, 0xFF, 0x30, 0x00, 0x02, 0x0D, 0x0B, 0x3C,
	0x03, 0xC0, 0x03, 0xD7, 0x0D, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xFD, 0x7C, 0x0D, 0xD5, 0x55, 0x7C, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x3F, 0xC3, 0xFC, 0x03, 0x0F,
	0x00, 0xF0, 0x00, 0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC3, 0xD7, 0xC3, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00,
	0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0x00,
	0xD7, 0xC0, 0xD7, 0x00, 0xD7, 0xC0, 0xD5, 0x00, 0xD7, 0xC0, 0xD5, 0x00, 0xD7, 0xC0, 0xD5, 0x3C,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0x0F,
	0xFF, 0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x0B, 0x3C, 0x0F, 0x00, 0x0F, 0xD7, 0x35,
	0xC0, 0x35, 0xD7, 0xD7, 0xF0, 0x35, 0xD7, 0x5F, 0xC0, 0x35, 0xD5, 0x7F, 0x00, 0x35, 0xD5, 0xFC,
	0x00, 0x35, 0xD5, 0x70, 0x00, 0x35, 0xD7, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0x35, 0xD7, 0xF5,
	0xC0, 0x35, 0xD7, 0xCD, 0x70, 0x35, 0x3F, 0xC3, 0xFC, 0x0F, 0x0F, 0x00, 0xF0, 0x03, 0x02, 0x0D,
	0x0A, 0x3C, 0x00, 0x00, 0x3C, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00,
	0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00, 0xD5, 0xD7, 0xC0, 0x00,
	0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xFF, 0x00, 0xD7, 0xD5, 0x55, 0xC0, 0xD7, 0x3F, 0xFF, 0xF0,
	0x3F, 0x0F, 0xFF, 0xC0, 0x0F, 0x02, 0x0D, 0x0D, 0x3C, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0x00,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD5, 0xC3, 0x57, 0xC0, 0xD5, 0xF3, 0x57, 0xC0, 0xD5, 0x7D, 0x57, 0xC0,
	0xD5, 0x7D, 0x57, 0xC0, 0xD7, 0x55, 0xD7, 0xC0, 0xD7, 0x55, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xFF, 0xFF, 0xC0, 0x0F, 0x0F, 0x0F, 0x00, 0x02, 0x0D, 0x0B, 0x3C,
	0x03, 0xC0, 0x00, 0xD7, 0x0D, 0x70, 0x00, 0xD5, 0xCD, 0x7C, 0x03, 0xD5, 0x7D, 0x7C, 0x0D, 0xD5,
	0x7D, 0x7C, 0x0D, 0xD7, 0x5D, 0x7C, 0x0D, 0xD7, 0x5D, 0x7C, 0x0D, 0xD7, 0xD5, 0x7C, 0x0D, 0xD7,
	0xD5, 0x7C, 0x0D, 0xD7, 0xF5, 0x7C, 0x03, 0xD7, 0xCD, 0x7C, 0x00, 0x3F, 0xC3, 0xFC, 0x00, 0x0F,
	0x00, 0xF0, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFC, 0x00, 0x03, 0x0D, 0x57, 0x00, 0x0D, 0x35, 0xF5,
	0xC0, 0x0D, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD,
	0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0x35, 0xF5, 0xFC, 0x0D, 0x0D, 0x57,
	0xF0, 0x0D, 0x03, 0xFF, 0xC0, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0x00,
	0x00, 0xD5, 0x55, 0xC0, 0x03, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x35, 0xD7, 0xCD, 0x7C,
	0x35, 0xD7, 0xFD, 0x7C, 0x35, 0xD5, 0x55, 0xFC, 0x35, 0xD7, 0xFF, 0xF0, 0x35, 0xD7, 0xFF, 0xC0,
	0x35, 0xD7, 0xC0, 0x00, 0x0D, 0xD7, 0xC0, 0x00, 0x03, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00, 0x00,
	0x00, 0x02, 0x0D, 0x0B, 0x03, 0xFC, 0x00, 0x00, 0x0D, 0x57, 0x00, 0x00, 0x35, 0xF5, 0xC0, 0x00,
	0xD7, 0xFD, 0x70, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00,
	0xD7, 0xFD, 0x7C, 0x00, 0xD7, 0xD5, 0x7C, 0x00, 0x35, 0xF5, 0xFC, 0x00, 0x0D, 0x55, 0x70, 0x00,
	0x03, 0xFF, 0xFC, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x02, 0x0D, 0x0C, 0x3F, 0xFF, 0x00, 0x00, 0xD5,
	0x55, 0xC0, 0x03, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7,
	0xFD, 0x7C, 0x03, 0xD5, 0x55, 0xFC, 0x00, 0xD7, 0xFD, 0x70, 0x03, 0xD7, 0xFD, 0x7C, 0x0D, 0xD7,
	0xCD, 0x7C, 0x0D, 0xD7, 0xC3, 0x5C, 0x03, 0x3F, 0xC0, 0xFF, 0x00, 0x0F, 0x00, 0x3C, 0x00, 0x02,
	0x0D, 0x0A, 0x0F, 0xFC, 0x00, 0x3F, 0x35, 0x57, 0x00, 0xD5, 0xD7, 0xF5, 0xC0, 0x3F, 0xD7, 0xF5,
	0xF0, 0x0F, 0xD7, 0xCF, 0xF0, 0x03, 0x35, 0x7F, 0xC0, 0x03, 0x0F, 0x57, 0x00, 0x03, 0x3F, 0xF5,
	0xC0, 0x03, 0xD7, 0x35, 0xF0, 0x03, 0xD7, 0xF5, 0xF0, 0x03, 0x35, 0x57, 0xF0, 0x03, 0x0F, 0xFF,
	0xC0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3F, 0xFF, 0xC0, 0x0F, 0xD5, 0x55, 0x70,
	0x35, 0x3F, 0x5F, 0xFC, 0x35, 0x0F, 0x5F, 0xF0, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00,
	0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00, 0x35, 0x03, 0x5F, 0x00,
	0x0D, 0x03, 0x5F, 0x00, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x02, 0x0D, 0x0B,
	0x3C, 0x03, 0xC0, 0x0F, 0xD7, 0x0D, 0x70, 0x35, 0xD7, 0xCD, 0x7C, 0x35, 0xD7, 0xCD, 0x7C, 0x0D,
	0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x0D, 0xD7, 0xCD, 0x7C, 0x03, 0xD7, 0xCD, 0x7C, 0x03,
	0xD7, 0xCD, 0x7C, 0x03, 0x35, 0xF5, 0xFC, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0xFF, 0xC0, 0x00,
	0x00, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x3C, 0x03, 0xC0, 0x3C, 0xD7, 0x0D, 0x70, 0xD7, 0xD7,
	0xCD, 0x7C, 0xD7, 0x35, 0xF5, 0xFC, 0xD7, 0x35, 0xF5, 0xF0, 0x35, 0x35, 0xF5, 0xF0, 0x35, 0x0D,
	0xF7, 0xF0, 0x0D, 0x0D, 0x57, 0xC0, 0x0D, 0x0D, 0x57, 0xC0, 0x03, 0x03, 0x5F, 0xC0, 0x03, 0x03,
	0x5F, 0x00, 0x03, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x03, 0x0D, 0x11, 0x3C, 0x03,
	0xC0, 0x3C, 0x03, 0xC0, 0xD7, 0x0D, 0x70, 0xD7, 0x0D, 0x70, 0xD7, 0xCD, 0x7C, 0xD7, 0xCD, 0x7C,
	0xD7, 0xCD, 0x7C, 0xD7, 0xC3, 0x5C, 0x35, 0xF5, 0x5F, 0x5F, 0xC0, 0xD7, 0x35, 0xF5, 0x5F, 0x5F,
	0x00, 0x35, 0x0D, 0x77, 0xDD, 0x7F, 0x00, 0x35, 0x0D, 0x57, 0xD5, 0x7C, 0x00, 0xD7, 0x03, 0x5F,
	0xF5, 0xFC, 0x03, 0x5F, 0x03, 0x5F, 0x35, 0xF0, 0x0D, 0x7F, 0x03, 0x5F, 0x35, 0xF0, 0x0D, 0x7C,
	0x00, 0xFF, 0x0F, 0xF0, 0x03, 0xFC, 0x00, 0x3C, 0x03, 0xC0, 0x00, 0xF0, 0x02, 0x0D, 0x0C, 0x3C,
	0x00, 0xF0, 0x0F, 0xD7, 0x03, 0x5C, 0x35, 0xD7, 0xC3, 0x5F, 0x35, 0x35, 0xCD, 0x7F, 0x0D, 0x0D,
	0x75, 0xFC, 0x03, 0x03, 0x57, 0xF0, 0x00, 0x03, 0x57, 0xC0, 0x00, 0x0D, 0x75, 0xC0, 0x00, 0x35,
	0xFD, 0x70, 0x00, 0xD7, 0xF3, 0x5C, 0x00, 0xD7, 0xC3, 0x5F, 0x00, 0x3F, 0xC0, 0xFF, 0x00, 0x0F,
	0x00, 0x3C, 0x00, 0x02, 0x0D, 0x0D, 0x3C, 0x00, 0x3C, 0x03, 0xD7, 0x00, 0xD7, 0x0D, 0xD7, 0xC0,
	0xD7, 0xC3, 0x35, 0xC3, 0x5F, 0xC0, 0x0D, 0x7D, 0x7F, 0x00, 0x03, 0x55, 0xFC, 0x00, 0x00, 0xD7,
	0xF0, 0x00, 0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xC0, 0x03, 0x00, 0xD7, 0xC0, 0x0D, 0x00, 0xD7,
	0xC0, 0x0D, 0x00, 0x3F, 0xC0, 0x03, 0x00, 0x0F, 0x00, 0x00, 0x02, 0x0D, 0x0C, 0x3F, 0xFF, 0xF0,
	0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0x5F, 0x00, 0x0F, 0xFD, 0x7F, 0x00, 0x00, 0x35, 0xFC,
	0x00, 0x00, 0xD7, 0xF0, 0x00, 0x03, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x35, 0xFC, 0x00,
	0x00, 0xD7, 0xFF, 0xF0, 0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFC,
	0x00, 0x01, 0x0E, 0x06, 0x3F, 0x00, 0xD5, 0xC3, 0xDF, 0xF3, 0xDF, 0xC0, 0xDF, 0x00, 0xDF, 0x00,
	0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xDF, 0x00, 0xD5, 0xC0, 0x3F, 0xF0, 0x0F, 0xC0,
	0x01, 0x0D, 0x08, 0x30, 0x00, 0xDC, 0x00, 0xDF, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x0D, 0xC0, 0x0D,
	0xF0, 0x03, 0x70, 0x03, 0x7C, 0x00, 0xDC, 0x00, 0xDF, 0x00, 0x3F, 0x00, 0x0C, 0x01, 0x0E, 0x06,
	0x3F, 0x00, 0xD5, 0xC0, 0x3D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0, 0x0D, 0xF0,
	0x0D, 0xF0, 0x0D, 0xF0, 0x3D, 0xF0, 0xD5, 0xF0, 0x3F, 0xF0, 0x0F, 0xC0, 0x02, 0x0E, 0x0A, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x00, 0x00, 0x0D,
	0x5C, 0x00, 0x00, 0x37, 0x77, 0x00, 0x00, 0xDF, 0x7D, 0xC0, 0x00, 0x3F, 0x7F, 0xF0, 0x00, 0x0F,
	0x7C, 0xC0, 0x00, 0x03, 0x7C, 0x00, 0x03, 0x03, 0x7C, 0x00, 0x0D, 0x03, 0x7C, 0x00, 0x03, 0x00,
	0xFC, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x02, 0x0D, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF,
	0xF0, 0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x01, 0x07,
	0x04, 0x0C, 0x00, 0x37, 0x00, 0xD7, 0x00, 0xD7, 0x00, 0xD7, 0x03, 0xDC, 0x0D, 0x30, 0x03, 0x02,
	0x0D, 0x09, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xF0,
	0x00, 0xD7, 0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x00, 0xD7, 0x3D, 0x57, 0xC0, 0xD7, 0x35, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD5, 0x0F, 0xFF,
	0xC0, 0x3F, 0x03, 0xFF, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00,
	0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xF0, 0x00, 0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD5, 0x5F, 0xC0, 0x35, 0x3F, 0xFF, 0x00, 0x0F, 0x0F, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x0F, 0xF0, 0x00, 0x3F,
	0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x03, 0x5F, 0xD7, 0xFF, 0xC3, 0x5F, 0xD7, 0xCF, 0x03, 0x5F,
	0xD7, 0xFC, 0x03, 0x5F, 0xD7, 0xD7, 0x03, 0x5F, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0x3F,
	0x03, 0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00,
	0xD7, 0xC0, 0x00, 0x0F, 0xD7, 0xC0, 0x0F, 0x35, 0x57, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD5, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35,
	0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0x00,
	0x00, 0x0F, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xF0, 0x00, 0xD7, 0x35, 0x5C,
	0x03, 0x55, 0xD7, 0xD7, 0x00, 0xD7, 0xD5, 0x57, 0xC0, 0xD7, 0xD7, 0xFF, 0xC0, 0xD7, 0xD7, 0xFF,
	0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0x35, 0x5F, 0xC0, 0xD7, 0x0F, 0xFF, 0x00, 0x3F, 0x03, 0xFC,
	0x00, 0x0F, 0x01, 0x0D, 0x07, 0x03, 0xC0, 0x0D, 0x70, 0x35, 0xFC, 0x35, 0xF0, 0xD5, 0x70, 0x35,
	0xFC, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x0F, 0xF0, 0x03, 0xC0, 0x02,
	0x10, 0x09, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD7, 0x0F, 0xFC,
	0x00, 0xD7, 0x35, 0x57, 0x00, 0xD5, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0xD7, 0x3F, 0xD7,
	0xC0, 0x3F, 0xD7, 0xD7, 0xC0, 0x0F, 0x35, 0x5F, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC,
	0x00, 0x00, 0x02, 0x0D, 0x09, 0x3C, 0x00, 0x00, 0x3C, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00,
	0xD7, 0xD7, 0xF0, 0x00, 0x3F, 0xD5, 0x5C, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0x3F, 0xFF, 0xC0, 0x3F, 0x0F, 0x0F, 0x00, 0x0F, 0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00,
	0xD7, 0xC0, 0x3F, 0xC0, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0,
	0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x01, 0x10, 0x06, 0x0F, 0x00, 0x35, 0xC0, 0x35, 0xF0, 0x0F,
	0xF0, 0x35, 0xC0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35, 0xF0, 0x35,
	0xF0, 0x35, 0xF0, 0xD7, 0xF0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x3C, 0x00, 0x00, 0xF0,
	0xD7, 0x00, 0x03, 0x5C, 0xD7, 0xC0, 0x03, 0x5F, 0xD7, 0xFC, 0x03, 0x5F, 0xD7, 0xD7, 0x03, 0x5F,
	0xD7, 0x5F, 0xC3, 0x5F, 0xD5, 0x7F, 0x03, 0x5F, 0xD5, 0xFC, 0x03, 0x5F, 0xD5, 0x70, 0x03, 0x5F,
	0xD7, 0x5C, 0x03, 0x5F, 0xD7, 0xD7, 0x03, 0x5F, 0x3F, 0xFF, 0xC0, 0xFF, 0x0F, 0x0F, 0x00, 0x3C,
	0x01, 0x0D, 0x05, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7,
	0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x0D,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, 0x00,
	0xD5, 0x55, 0x5C, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x3F, 0xFF, 0xFF, 0xC0,
	0x0F, 0x0F, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, 0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7,
	0xD7, 0xC0, 0x35, 0x3F, 0xFF, 0xC0, 0x0F, 0x0F, 0x0F, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C,
	0x00, 0xD5, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7,
	0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF, 0x00, 0xD7, 0x03, 0xFC,
	0x00, 0xD7, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3F, 0xF0, 0x00, 0x0F, 0xD5, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD5, 0x5F, 0xC0,
	0x35, 0xD7, 0xFF, 0x00, 0x0F, 0xD7, 0xFC, 0x00, 0x03, 0xD7, 0xC0, 0x00, 0x00, 0x3F, 0xC0, 0x00,
	0x00, 0x0F, 0x00, 0x00, 0x00, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x3F, 0x35, 0x57, 0x00, 0xD5, 0xD7, 0xD7, 0xC0, 0xD5,
	0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7,
	0x35, 0x57, 0xC0, 0xD7, 0x0F, 0xD7, 0xC0, 0x3F, 0x03, 0xD7, 0xC0, 0x0F, 0x00, 0xD7, 0xC0, 0x00,
	0x00, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x01, 0x0D, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3F, 0xC0, 0xD5, 0x70, 0xD5, 0xFC, 0xD7, 0xF0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7,
	0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C,
	0x00, 0x00, 0x00, 0xD7, 0x0F, 0xF0, 0x00, 0xD7, 0x35, 0x5C, 0x03, 0x55, 0xD7, 0xD7, 0x00, 0xD7,
	0xD7, 0xFF, 0xC0, 0xD7, 0x35, 0x5F, 0x00, 0xD7, 0x3F, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7,
	0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x01, 0x0D, 0x07, 0x00,
	0x00, 0x0F, 0x00, 0x35, 0xC0, 0x35, 0xF0, 0xD5, 0x70, 0x35, 0xFC, 0x35, 0xF0, 0x35, 0xF0, 0x35,
	0xF0, 0x35, 0xF0, 0x0D, 0x70, 0x03, 0xFC, 0x00, 0xF0, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0xF0, 0xD7, 0xD7, 0x03, 0x5C,
	0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0x35,
	0xD7, 0xD7, 0xC0, 0x0D, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF, 0xC0, 0x03, 0x03, 0xFF, 0x00, 0x00,
	0x02, 0x0D, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C,
	0x03, 0xC0, 0x3C, 0xD7, 0x0D, 0x70, 0xD7, 0xD7, 0xCD, 0x7C, 0xD7, 0x35, 0xF5, 0xFC, 0x35, 0x35,
	0xF5, 0xF0, 0x35, 0x0D, 0x57, 0xF0, 0x35, 0x03, 0x5F, 0xC0, 0x0D, 0x03, 0x5F, 0x00, 0x0D, 0x00,
	0xFF, 0x00, 0x03, 0x00, 0x3C, 0x00, 0x00, 0x02, 0x0D, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x3C, 0x03, 0xD7, 0x3C, 0xD7, 0x0D, 0xD7, 0xD7,
	0xD7, 0xC3, 0x35, 0xD7, 0x5F, 0xC0, 0x35, 0xD7, 0x5F, 0x00, 0x35, 0x55, 0x5F, 0x00, 0x0D, 0x7D,
	0x7F, 0x03, 0x0D, 0x7D, 0x7C, 0x0D, 0x03, 0xFF, 0xFC, 0x03, 0x00, 0xF0, 0xF0, 0x00, 0x02, 0x0D,
	0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x03, 0xC0,
	0x3C, 0xD7, 0x0D, 0x70, 0xD7, 0x35, 0xF5, 0xFC, 0xD7, 0x0D, 0x57, 0xF0, 0x35, 0x03, 0x5F, 0xC0,
	0x35, 0x0D, 0x57, 0x00, 0x0D, 0x35, 0xF5, 0xC0, 0x0D, 0xD7, 0xFD, 0x70, 0x03, 0x3F, 0xC3, 0xFC,
	0x03, 0x0F, 0x00, 0xF0, 0x0D, 0x02, 0x10, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3C, 0x03, 0xC0, 0x0F, 0xD7, 0x0D, 0x70, 0x35, 0xD7, 0xCD, 0x7C, 0x0F,
	0x35, 0xF5, 0xFC, 0x03, 0x35, 0xF5, 0xF0, 0x03, 0x0D, 0x57, 0xF0, 0x0D, 0x0D, 0x57, 0xC0, 0x35,
	0x03, 0x5F, 0xC0, 0x35, 0x03, 0x5F, 0x00, 0x0F, 0x0D, 0x7F, 0x00, 0x03, 0x35, 0xFC, 0x00, 0x00,
	0x0F, 0xF0, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0xD5, 0x57, 0x00, 0x00, 0x3F,
	0xD7, 0xC0, 0x00, 0x0F, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x35, 0xFC, 0x00, 0x00, 0xD7,
	0xFC, 0x00, 0x00, 0xD5, 0x57, 0x00, 0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x01,
	0x0E, 0x07, 0x00, 0x00, 0x03, 0xC0, 0x0D, 0x70, 0x37, 0xFC, 0x37, 0xF0, 0x37, 0xC0, 0xDF, 0xC0,
	0xDF, 0x00, 0x37, 0x00, 0x37, 0xC0, 0x37, 0xC0, 0x0D, 0x70, 0x03, 0xFC, 0x00, 0xF0, 0x01, 0x0F,
	0x04, 0x30, 0x00, 0xDC, 0x0F, 0xDF, 0x35, 0xDF, 0x0F, 0xDF, 0x03, 0xDF, 0x03, 0xDF, 0x00, 0xDF,
	0x00, 0xDF, 0x03, 0xDF, 0x03, 0xDF, 0x0F, 0xDF, 0x35, 0xDF, 0x0F, 0x3F, 0x03, 0x0C, 0x00, 0x01,
	0x0E, 0x07, 0x00, 0x00, 0x3C, 0x00, 0xD7, 0x00, 0x3D, 0xC0, 0x0D, 0xF0, 0x0D, 0xF0, 0x03, 0x70,
	0x03, 0x7C, 0x0D, 0xFC, 0x0D, 0xF0, 0x3D, 0xF0, 0xD7, 0xF0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x08,
	0x0A, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x0F, 0x00, 0x03, 0x70, 0x35, 0xC3, 0x00,
	0xC0, 0xDF, 0x7D, 0xC0, 0x00, 0x3F, 0xD7, 0xF0, 0x00, 0x0C, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00,
	0x00, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x10, 0x0A, 0x03,
	0xFC, 0x00, 0x00, 0x0D, 0x57, 0x00, 0x00, 0x35, 0xF5, 0xC0, 0x00, 0xD7, 0xFD, 0xF0, 0x00, 0xD7,
	0xC3, 0xF0, 0x00, 0xD7, 0xC0, 0xC0, 0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xC3, 0x00, 0x00, 0xD7,
	0xCD, 0xC0, 0x00, 0x35, 0xF5, 0xF0, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0x7F, 0xC0, 0x00, 0x03,
	0xDF, 0x00, 0x00, 0x01, 0xDF, 0x00, 0x00, 0x03, 0x7C, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x02,
	0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x00, 0x37, 0x37, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x03, 0x3F, 0xFF,
	0xC0, 0x00, 0x3F, 0x3F, 0x00, 0x03, 0xD7, 0xD7, 0x00, 0x0D, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7,
	0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF,
	0xC0, 0x03, 0x03, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x03, 0x03, 0xDC, 0x00,
	0x0D, 0x0D, 0x7F, 0x00, 0x37, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00, 0x0F, 0x35, 0x5C, 0x00,
	0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD5, 0x57, 0xC0, 0x3D, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xD7, 0x00,
	0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09,
	0x03, 0xC0, 0x00, 0x03, 0x0D, 0x70, 0x00, 0x0D, 0x37, 0xDC, 0x00, 0x35, 0x0F, 0xFF, 0x00, 0x0F,
	0x0F, 0xFC, 0x00, 0x03, 0x35, 0x5C, 0x00, 0x0D, 0xD7, 0xD7, 0x00, 0x35, 0x3D, 0x57, 0xC0, 0x0F,
	0x35, 0xD7, 0xC0, 0x0D, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0, 0x0D, 0x0F, 0xFF, 0xC0, 0x03,
	0x03, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x0C, 0x37, 0x37, 0x00, 0x37, 0xD7,
	0xD7, 0xC0, 0x0D, 0x3F, 0xFF, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5, 0xD7,
	0xD7, 0x03, 0x5F, 0x3D, 0x57, 0xC0, 0xF5, 0x35, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC3, 0x5F, 0x35,
	0x57, 0xC0, 0xD5, 0x0F, 0xFF, 0xC0, 0x3F, 0x03, 0xFF, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x03, 0x00,
	0x00, 0x00, 0x0D, 0xF0, 0x00, 0x03, 0x03, 0x5C, 0x00, 0x0D, 0x00, 0xFF, 0x00, 0x03, 0x0F, 0xF0,
	0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0x3D, 0x57, 0xC0, 0x3D, 0x35, 0xD7,
	0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF,
	0x00, 0x03, 0x02, 0x0D, 0x09, 0x00, 0xC0, 0x00, 0x00, 0x03, 0x70, 0x00, 0x00, 0x0D, 0xDC, 0x00,
	0x00, 0x03, 0x7F, 0x00, 0x03, 0x0F, 0xFC, 0x00, 0x0D, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00,
	0x35, 0x3D, 0x57, 0xC0, 0x35, 0x35, 0xD7, 0xC0, 0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x57, 0xC0,
	0x0D, 0x0F, 0xFF, 0xC0, 0x03, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0D, 0x0F, 0xF0, 0x00, 0x03, 0x35, 0x5C, 0x00, 0x03,
	0xD7, 0xD7, 0x00, 0x0D, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xCF, 0x00, 0x35, 0xD7, 0xFC, 0x00, 0x35,
	0xD7, 0xD7, 0x00, 0x35, 0x35, 0x5F, 0xC0, 0x0D, 0x0D, 0xFF, 0x00, 0x03, 0x0F, 0x7C, 0x00, 0x00,
	0x07, 0x7C, 0x00, 0x00, 0x0D, 0xF0, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x03,
	0xC0, 0x00, 0x0C, 0x0D, 0x70, 0x00, 0x37, 0x37, 0xDC, 0x00, 0xD7, 0x0F, 0xFF, 0x00, 0x3F, 0x0F,
	0xFC, 0x00, 0x0F, 0x35, 0x5C, 0x00, 0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD5, 0x57, 0xC0, 0xD5, 0xD7,
	0xFF, 0xC0, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03,
	0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x03, 0x37, 0x37, 0x00, 0x0D, 0xD7, 0xD7,
	0xC0, 0x03, 0x3F, 0xFF, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x03, 0x35, 0x5C, 0x00, 0x0D, 0xD7, 0xD7,
	0x00, 0x35, 0xD5, 0x57, 0xC0, 0x35, 0xD7, 0xFF, 0xC0, 0x35, 0xD7, 0xD7, 0x00, 0x35, 0x35, 0x5F,
	0xC0, 0x0D, 0x0F, 0xFF, 0x00, 0x03, 0x03, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x0C, 0x00, 0x00,
	0x03, 0x37, 0xC0, 0x00, 0x0D, 0x0D, 0x70, 0x00, 0x35, 0x03, 0xFC, 0x00, 0x0F, 0x0F, 0xF0, 0x00,
	0x03, 0x35, 0x5C, 0x00, 0x03, 0xD7, 0xD7, 0x00, 0x03, 0xD5, 0x57, 0xC0, 0x03, 0xD7, 0xFF, 0xC0,
	0x03, 0xD7, 0xD7, 0x00, 0x03, 0x35, 0x5F, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00,
	0x00, 0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x03, 0x37, 0x37, 0x00, 0x0D, 0xD7, 0xD7, 0xC0, 0x0F,
	0x3F, 0xFF, 0xC0, 0x35, 0x0F, 0xCF, 0x00, 0xD7, 0x0D, 0x70, 0x00, 0xD7, 0x0D, 0x7C, 0x00, 0x35,
	0x0D, 0x7C, 0x00, 0x3F, 0x0D, 0x7C, 0x00, 0xD7, 0x0D, 0x7C, 0x00, 0xD7, 0x0D, 0x7C, 0x00, 0x35,
	0x03, 0xFC, 0x00, 0x0F, 0x00, 0xF0, 0x00, 0x03, 0x02, 0x0D, 0x0A, 0x03, 0xDC, 0x00, 0x0C, 0x0D,
	0x7F, 0x00, 0x37, 0x0F, 0xFC, 0x00, 0x0D, 0x35, 0x57, 0x00, 0x03, 0xD7, 0xF5, 0xC0, 0x0F, 0xD7,
	0xF5, 0xF0, 0x35, 0x35, 0x7F, 0xF0, 0x35, 0x3F, 0x57, 0xC0, 0x35, 0xD7, 0xF5, 0xC0, 0x35, 0xD7,
	0xF5, 0xF0, 0x35, 0x35, 0x57, 0xF0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF, 0x00, 0x03, 0x01,
	0x0D, 0x06, 0x30, 0x00, 0xDF, 0x00, 0x35, 0xC0, 0x0F, 0xF0, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x0B, 0x03,
	0x03, 0x00, 0x00, 0x0D, 0xCD, 0xC0, 0x00, 0x35, 0xF5, 0xF0, 0x00, 0x0F, 0xFF, 0xF0, 0x03, 0x03,
	0x5F, 0x00, 0x0D, 0x0D, 0x57, 0xC0, 0x03, 0x0D, 0xF7, 0xC0, 0x00, 0x35, 0xF5, 0xC0, 0x00, 0x35,
	0x55, 0xF0, 0x03, 0xD7, 0xFD, 0x70, 0x0D, 0xD7, 0xFD, 0x7C, 0x0D, 0xFF, 0xFF, 0xFC, 0x03, 0x3F,
	0xC3, 0xFC, 0x00, 0x02, 0x0D, 0x0C, 0x00, 0x0C, 0x00, 0x00, 0x00, 0xF7, 0x00, 0x00, 0x03, 0x5F,
	0xC0, 0x00, 0x3F, 0xFF, 0xF0, 0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0x5F, 0x00, 0x0F, 0xFD,
	0x7F, 0x00, 0x03, 0xD7, 0xFC, 0x00, 0x3D, 0x7F, 0xF0, 0x00, 0xD7, 0xFF, 0xF0, 0x00, 0xD5, 0x55,
	0x5C, 0x00, 0x3F, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x02, 0x0D, 0x0A, 0x00, 0x30, 0x00,
	0x00, 0x03, 0xDC, 0x00, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0xD5, 0x55, 0xC0,
	0x00, 0xD7, 0xFF, 0xF0, 0x03, 0xD7, 0xFF, 0xC0, 0x00, 0xD5, 0x57, 0x00, 0x00, 0xD7, 0xFF, 0xC0,
	0x03, 0xD7, 0xFF, 0x00, 0x03, 0xD5, 0x55, 0xC0, 0x00, 0x3F, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xC0,
	0x00, 0x02, 0x0D, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xF0, 0x3F, 0xC0, 0x35, 0x5C, 0xD5, 0x70, 0xD7, 0xD7, 0x5F, 0x5C, 0x3D, 0x57, 0x55, 0x5F,
	0x35, 0xD7, 0x5F, 0xFF, 0xD7, 0xD7, 0x5F, 0xFC, 0xD7, 0xD7, 0x5F, 0x5C, 0x35, 0x55, 0x55, 0x7F,
	0x0F, 0xFF, 0xFF, 0xFC, 0x03, 0xFF, 0xFF, 0xF0, 0x02, 0x0D, 0x10, 0x00, 0x03, 0xFF, 0xF0, 0x00,
	0x0D, 0x55, 0x5C, 0x00, 0x35, 0x7F, 0xFF, 0x00, 0xD5, 0x7F, 0xFC, 0x00, 0xD5, 0x7F, 0xC0, 0x03,
	0x5D, 0x55, 0x70, 0x0D, 0x7D, 0x7F, 0xFC, 0x0D, 0x7D, 0x7F, 0xF0, 0x35, 0x55, 0x7C, 0x00, 0xD7,
	0xFD, 0x7F, 0xF0, 0xD7, 0xFD, 0x55, 0x5C, 0xFF, 0x0F, 0xFF, 0xFF, 0x3C, 0x03, 0xFF, 0xFC, 0x02,
	0x0D, 0x09, 0x03, 0xC0, 0x00, 0x30, 0x0D, 0x70, 0x00, 0xDC, 0x37, 0xDC, 0x03, 0x5F, 0x0F, 0xFF,
	0x00, 0xFF, 0x0F, 0xFC, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x03, 0x5F, 0xD7, 0xD7,
	0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0x35, 0x5F, 0xC0, 0xD5, 0x0F, 0xFF,
	0x00, 0x3F, 0x03, 0xFC, 0x00, 0x0F, 0x02, 0x0D, 0x09, 0x0C, 0x0C, 0x00, 0x0C, 0x37, 0x37, 0x00,
	0x37, 0xD7, 0xD7, 0xC0, 0x0D, 0x3F, 0xFF, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x0F, 0x35, 0x5C, 0x00,
	0x35, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09,
	0x0C, 0x00, 0x00, 0x03, 0x37, 0xC0, 0x00, 0x0D, 0x0D, 0x70, 0x00, 0x37, 0x03, 0xFC, 0x00, 0x0F,
	0x0F, 0xF0, 0x00, 0x3F, 0x35, 0x5C, 0x00, 0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7,
	0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F,
	0x03, 0xFC, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00, 0x0C, 0x0D, 0x70, 0x00, 0x37, 0x37,
	0xDC, 0x00, 0x0D, 0x0F, 0xFF, 0x00, 0x03, 0x3F, 0x3C, 0x00, 0x3C, 0xD7, 0xD7, 0x00, 0xD7, 0xD7,
	0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0x35,
	0x57, 0xC0, 0x35, 0x0F, 0xFF, 0xC0, 0x0F, 0x03, 0xFF, 0x00, 0x03, 0x02, 0x0D, 0x09, 0x0C, 0x00,
	0x00, 0x03, 0x37, 0xC0, 0x00, 0x0D, 0x0D, 0x70, 0x00, 0x0D, 0x03, 0xFC, 0x00, 0x03, 0x3C, 0x3C,
	0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7,
	0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x35, 0x57, 0xC0, 0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x03, 0xFF,
	0x00, 0x00, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D, 0x0B,
	0x03, 0x03, 0x00, 0x00, 0x0D, 0xCD, 0xC0, 0x00, 0x35, 0xF5, 0xF0, 0x00, 0x0F, 0xFF, 0xF0, 0x00,
	0x0D, 0x57, 0xC0, 0x00, 0x35, 0xF5, 0xC0, 0x00, 0xD7, 0xFD, 0x70, 0x00, 0xD7, 0xCD, 0x7C, 0x00,
	0xD7, 0xCD, 0x7C, 0x00, 0x35, 0xF5, 0xFC, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0xFF, 0xC0, 0x00,
	0x00, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0x03, 0x00, 0x03, 0x0D, 0xCD, 0xC0, 0x0D, 0x35,
	0xF5, 0xF0, 0x0D, 0x3F, 0xFF, 0xF0, 0x03, 0xD7, 0xCD, 0x70, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7,
	0xCD, 0x7C, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7, 0xFD, 0x7C, 0x00, 0xD5, 0x55, 0x7C, 0x00, 0x35,
	0x55, 0xFC, 0x00, 0x0F, 0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xC0, 0x00, 0x01, 0x04, 0x03, 0x30, 0x00,
	0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x00, 0x03, 0xDC, 0x00,
	0x00, 0x0D, 0x7F, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x35, 0x5C, 0x00, 0x03, 0xD7, 0xD7, 0x00,
	0x0D, 0xD7, 0xFF, 0xC0, 0x0D, 0x35, 0x5F, 0x00, 0x0D, 0x3F, 0xD7, 0x00, 0x0D, 0xD7, 0xD7, 0xC0,
	0x0D, 0x35, 0x5F, 0xC0, 0x03, 0x0F, 0xFF, 0x00, 0x03, 0x03, 0xFC, 0x00, 0x00, 0x02, 0x0D, 0x0E,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF3, 0xFC, 0x00,
	0x35, 0x5D, 0x57, 0x00, 0xD7, 0xD5, 0xF5, 0xC0, 0xD7, 0xD5, 0x55, 0xF0, 0xD7, 0xD5, 0xFF, 0xF0,
	0xD7, 0xD5, 0xFF, 0xC0, 0xD7, 0xD5, 0xF5, 0xC0, 0x35, 0x5D, 0x57, 0xF0, 0x3F, 0xFF, 0xFF, 0xC0,
	0x0F, 0xFF, 0xFF, 0x00, 0x01, 0x04, 0x03, 0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02,
	0x0D, 0x09, 0x00, 0x30, 0x00, 0x00, 0x03, 0xDC, 0x00, 0x00, 0x0D, 0x7F, 0x00, 0x00, 0x3F, 0xFC,
	0x00, 0x00, 0xD5, 0x57, 0x00, 0x00, 0x3F, 0xD7, 0xC0, 0x00, 0x0F, 0x5F, 0xC0, 0x00, 0x0D, 0x7F,
	0x00, 0x00, 0x35, 0xFC, 0x00, 0x00, 0xD7, 0xFC, 0x00, 0x00, 0xD5, 0x57, 0x00, 0x00, 0x3F, 0xFF,
	0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x03, 0x03, 0xDC, 0x00,
	0x3D, 0x0D, 0x7F, 0x00, 0xD7, 0x03, 0xFC, 0x00, 0x3F, 0x0F, 0xF0, 0x00, 0x3C, 0x35, 0x5C, 0x00,
	0xD7, 0xD7, 0xD7, 0x00, 0xD7, 0x3D, 0x57, 0xC0, 0xD7, 0x35, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0,
	0xD7, 0x35, 0x57, 0xC0, 0xD7, 0x0F, 0xFF, 0xC0, 0x3F, 0x03, 0xFF, 0x00, 0x0F, 0x01, 0x0D, 0x06,
	0x03, 0x00, 0x3D, 0xC0, 0xD7, 0xF0, 0x3F, 0xC0, 0x3C, 0x00, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0,
	0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00,
	0x0F, 0x03, 0xDC, 0x00, 0x35, 0x0D, 0x7F, 0x00, 0x35, 0x03, 0xFC, 0x00, 0x35, 0x0F, 0xF0, 0x00,
	0x35, 0x35, 0x5C, 0x00, 0xD5, 0xD7, 0xD7, 0x03, 0x75, 0xD7, 0xD7, 0xC0, 0xF5, 0xD7, 0xD7, 0xC0,
	0x35, 0xD7, 0xD7, 0xC0, 0x35, 0x35, 0x5F, 0xC0, 0x35, 0x0F, 0xFF, 0x00, 0x0F, 0x03, 0xFC, 0x00,
	0x03, 0x02, 0x0D, 0x0C, 0x03, 0xC0, 0x00, 0x03, 0x0D, 0x7C, 0x00, 0x0D, 0x0D, 0x77, 0x00, 0x37,
	0x0D, 0x5F, 0x00, 0x0F, 0x0D, 0x7C, 0x00, 0x0F, 0x35, 0x7C, 0x00, 0x35, 0xDD, 0x7C, 0x00, 0x35,
	0x3D, 0x7C, 0x00, 0x35, 0x0D, 0x7C, 0x00, 0x35, 0x0D, 0x7F, 0xF0, 0x35, 0x0D, 0x55, 0x5C, 0x35,
	0x03, 0xFF, 0xFF, 0x0F, 0x00, 0xFF, 0xFC, 0x03, 0x02, 0x0D, 0x09, 0x0F, 0x0C, 0x00, 0x03, 0x35,
	0xF7, 0x00, 0x0D, 0xDF, 0x5F, 0xC0, 0x0D, 0x3F, 0xFF, 0x00, 0x35, 0x3F, 0xFC, 0x00, 0x35, 0xD5,
	0x5C, 0x00, 0x37, 0xD7, 0xD7, 0x00, 0xD7, 0xD7, 0xD7, 0xC0, 0xD7, 0xD7, 0xD7, 0xC0, 0xD5, 0xD7,
	0xD7, 0xC3, 0x5F, 0xD7, 0xD7, 0xC3, 0x5F, 0x3F, 0xFF, 0xC0, 0xFF, 0x0F, 0x0F, 0x00, 0x3C, 0x02,
	0x10, 0x0D, 0x00, 0xF0, 0x00, 0x00, 0x03, 0x5C, 0x00, 0x00, 0x03, 0x5F, 0x00, 0x00, 0x0D, 0x57,
	0x00, 0x00, 0x0D, 0x57, 0xC0, 0x00, 0x0D, 0xF7, 0xC0, 0x00, 0x35, 0xF5, 0xC0, 0x00, 0x35, 0xF5,
	0xF0, 0x00, 0x35, 0x55, 0xF0, 0x00, 0xD7, 0xFD, 0x70, 0x00, 0xD7, 0xFD, 0x7C, 0x00, 0x3F, 0xC3,
	0xDC, 0x00, 0x0F, 0x03, 0x7F, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00,
	0x0F, 0x00, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03,
	0x30, 0x00, 0xDC, 0x00, 0xDC, 0x00, 0x30, 0x00, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00, 0x00, 0x0D,
	0x70, 0x00, 0x00, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x0D, 0x70, 0x00, 0x00, 0x0D,
	0x7C, 0x00, 0x00, 0x35, 0xFC, 0x00, 0x00, 0xD7, 0xFC, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD7,
	0xD7, 0xC0, 0x00, 0x35, 0x5F, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x01,
	0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC,
	0xDC, 0xDC, 0xDC, 0x30, 0x30, 0x01, 0x04, 0x03, 0x30, 0x30, 0xDC, 0xDC, 0xDC, 0xDC, 0x30, 0x30,
	0x01, 0x04, 0x03, 0x30, 0x03, 0xDC, 0x0D, 0xDC, 0x0D, 0x30, 0x03, 0x01, 0x0D, 0x05, 0x3C, 0x00,
	0xD7, 0x00, 0xD7, 0xC0, 0x3F, 0xC0, 0xD7, 0x00, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0, 0xD7, 0xC0,
	0xD7, 0xC0, 0xD7, 0xC0, 0x3F, 0xC0, 0x0F, 0x00, 0x02, 0x0A, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x0C, 0x00, 0x00, 0x0D, 0xF7, 0x00, 0x00, 0x37, 0xDF, 0xC0, 0x03, 0xDF,
	0x7F, 0x00, 0x00, 0x37, 0xDC, 0x00, 0x00, 0x0D, 0xF7, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x00, 0x00,
	0xC3, 0x00, 0x03, 0x02, 0x0D, 0x0C, 0x00, 0x3C, 0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0xD7,
	0xC0, 0x00, 0x3F, 0xFF, 0xF0, 0x00, 0xD5, 0x55, 0x5C, 0x00, 0x3F, 0xFF, 0x5F, 0x00, 0x0F, 0xFD,
	0x7F, 0x00, 0x03, 0xD7, 0xFC, 0x00, 0x3D, 0x7F, 0xF0, 0x00, 0xD7, 0xFF, 0xF0, 0x00, 0xD5, 0x55,
	0x5C, 0x00, 0x3F, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00,
	0x00, 0x0D, 0x7C, 0x00, 0x00, 0x0D, 0x77, 0x00, 0x00, 0x0D, 0x5F, 0xC0, 0x00, 0x0D, 0x7F, 0x00,
	0x00, 0x35, 0x7C, 0x00, 0x03, 0xDD, 0x7C, 0x00, 0x00, 0x3D, 0x7C, 0x00, 0x00, 0x0D, 0x7C, 0x00,
	0x03, 0x0D, 0x7C, 0x00, 0x03, 0x0D, 0x7C, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, 0xF0, 0x00,
	0x00, 0x02, 0x10, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0x3D, 0x57, 0xC0, 0x00,
	0x35, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x35, 0x57, 0xC0, 0x00,
	0x0F, 0xF7, 0xC0, 0x00, 0x03, 0xDF, 0xC0, 0x00, 0x00, 0x35, 0xC0, 0x00, 0x00, 0x0F, 0xF0, 0x00,
	0x00, 0x03, 0xC0, 0x00, 0x02, 0x0D, 0x09, 0x03, 0xC0, 0x00, 0x00, 0x0D, 0x70, 0x00, 0x00, 0x0D,
	0x7C, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0xD5, 0x57, 0x00, 0x00, 0x3F, 0xD7, 0xC0, 0x00, 0x0F,
	0x5F, 0xC0, 0x03, 0x0D, 0x7F, 0x00, 0x03, 0x35, 0xFC, 0x00, 0x03, 0xD7, 0xFC, 0x00, 0x03, 0xD5,
	0x57, 0x00, 0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30,
	0x00, 0x03, 0x03, 0xDC, 0x00, 0x0D, 0x0D, 0x7F, 0x00, 0x0D, 0x03, 0xFC, 0x00, 0x0D, 0x0F, 0xF0,
	0x00, 0x0D, 0x35, 0x5C, 0x00, 0x0D, 0xD7, 0xD7, 0x00, 0x0D, 0xD7, 0xFF, 0xC0, 0x0D, 0xD7, 0xFC,
	0x00, 0x0D, 0xD7, 0xD7, 0x00, 0x0D, 0x35, 0x5F, 0xC0, 0x0D, 0x0F, 0xFF, 0x00, 0x03, 0x03, 0xFC,
	0x00, 0x00, 0x02, 0x10, 0x0B, 0x3F, 0xFF, 0x00, 0x00, 0xD5, 0x55, 0xC0, 0x00, 0xD7, 0xFF, 0xF0,
	0x00, 0xD7, 0xFF, 0xC0, 0x00, 0xD7, 0xFC, 0x00, 0x00, 0xD5, 0x57, 0x00, 0x00, 0xD7, 0xFF, 0xC0,
	0x00, 0xD7, 0xFF, 0x00, 0x00, 0xD7, 0xC0, 0x00, 0x00, 0xD7, 0xFF, 0x00, 0x00, 0xD5, 0x55, 0xC0,
	0x00, 0x3F, 0xFD, 0xF0, 0x00, 0x0F, 0xF7, 0xF0, 0x00, 0x00, 0x0D, 0x70, 0x00, 0x00, 0x03, 0xFC,
	0x00, 0x00, 0x00, 0xF0, 0x00, 0x02, 0x0D, 0x0B, 0x03, 0xDC, 0x00, 0x00, 0x0D, 0x7F, 0x00, 0x00,
	0x03, 0xFC, 0x00, 0x00, 0x3F, 0x0F, 0xC0, 0x00, 0xD7, 0x0D, 0x70, 0x00, 0xD5, 0xCD, 0x7C, 0x00,
	0xD5, 0x7D, 0x7C, 0x00, 0xD7, 0x5D, 0x7C, 0x00, 0xD7, 0xD5, 0x7C, 0x00, 0xD7, 0xF5, 0x7C, 0x00,
	0xD7, 0xCD, 0x7C, 0x00, 0x3F, 0xC3, 0xFC, 0x00, 0x0F, 0x00, 0xF0, 0x00, 0x02, 0x0D, 0x0B, 0x00,
	0x0C, 0x00, 0x00, 0x00, 0xF7, 0x00, 0x00, 0x03, 0x5F, 0xC0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x0D,
	0x57, 0x00, 0x00, 0x35, 0xF5, 0xC0, 0x00, 0xD7, 0xFD, 0x70, 0x00, 0xD7, 0xCD, 0x7C, 0x00, 0xD7,
	0xCD, 0x7C, 0x00, 0x35, 0xF5, 0xFC, 0x00, 0x0D, 0x57, 0xF0, 0x00, 0x03, 0xFF, 0xC0, 0x00, 0x00,
	0xFF, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x00, 0x03, 0xDC, 0x00, 0x00, 0x0D, 0x7F,
	0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C, 0x00, 0x00, 0xD7, 0xD7,
	0x00, 0x00, 0xD7, 0xFF, 0xC0, 0x00, 0xD7, 0xFC, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x00, 0x35, 0x5F,
	0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x02, 0x10, 0x09, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C, 0x00,
	0x00, 0xD7, 0xD7, 0x00, 0x00, 0xD5, 0x57, 0xC0, 0x00, 0xD7, 0xFF, 0xC0, 0x00, 0xD7, 0xFF, 0x00,
	0x00, 0xD7, 0xD7, 0x00, 0x00, 0x35, 0x5F, 0xC0, 0x00, 0x0F, 0xDF, 0x00, 0x00, 0x03, 0x7F, 0x00,
	0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x02, 0x0D, 0x09,
	0x00, 0xC0, 0x00, 0x00, 0x0F, 0x70, 0x00, 0x00, 0x35, 0xFC, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
	0x3F, 0xFC, 0x00, 0x00, 0xD5, 0x5C, 0x00, 0x00, 0xD7, 0xD7, 0x00, 0x03, 0xD7, 0xD7, 0xC0, 0x03,
	0xD7, 0xD7, 0xC0, 0x03, 0xD7, 0xD7, 0xC0, 0x03, 0xD7, 0xD7, 0xC0, 0x00, 0x3F, 0xFF, 0xC0, 0x00,
	0x0F, 0x0F, 0x00, 0x00, 0x02, 0x0D, 0x09, 0x00, 0x30, 0x00, 0x00, 0x03, 0xDC, 0x00, 0x00, 0x0D,
	0x7F, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x35, 0x5C, 0x00, 0x00, 0xD7,
	0xD7, 0x00, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0xD7, 0xD7, 0xC0, 0x00, 0x35,
	0x5F, 0xC0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00, 0x00
};

const uint16 *Graphics::_fontOffs = Graphics::_engFontOffs;

int Graphics::_fontSize = Graphics::_engFontSize;

const uint8 *Graphics::_fontData = Graphics::_engFontData;

const uint8 MidiPlayer::_gmToRol[] = {
	0x01, 0x02, 0x03, 0x08, 0x04, 0x05, 0x11, 0x14, 0x66, 0x66, 0x66, 0x62, 0x69, 0x68, 0x67, 0x26,
	0x09, 0x0A, 0x0B, 0x0E, 0x0F, 0x10, 0x10, 0x10, 0x3C, 0x3D, 0x3D, 0x3D, 0x3D, 0x3E, 0x3F, 0x3F,
	0x47, 0x41, 0x42, 0x48, 0x45, 0x46, 0x1D, 0x1E, 0x35, 0x36, 0x37, 0x39, 0x33, 0x34, 0x3A, 0x71,
	0x31, 0x32, 0x31, 0x32, 0x23, 0x23, 0x23, 0x7B, 0x59, 0x5B, 0x5F, 0x5A, 0x5D, 0x60, 0x19, 0x1A,
	0x4F, 0x50, 0x51, 0x52, 0x55, 0x56, 0x57, 0x53, 0x4B, 0x49, 0x4D, 0x4E, 0x6F, 0x6C, 0x6D, 0x6E,
	0x30, 0x19, 0x4E, 0x2B, 0x28, 0x23, 0x19, 0x30, 0x21, 0x25, 0x1C, 0x21, 0x24, 0x22, 0x21, 0x22,
	0x2A, 0x25, 0x24, 0x26, 0x2E, 0x22, 0x29, 0x21, 0x40, 0x40, 0x6A, 0x6A, 0x68, 0x10, 0x35, 0x10,
	0x7F, 0x6B, 0x69, 0x75, 0x76, 0x72, 0x74, 0x01, 0x01, 0x70, 0x01, 0x7D, 0x7C, 0x01, 0x01, 0x01
};

} // namespace Touche
