/* Convert between a lo24/hi integer-pair bitset and a sigset_t value.
** These macros are OS-dependent, and must be defined per-OS.
*/
#include <sys/param.h>
#if defined __FreeBSD_version && __FreeBSD_version > 400000
#define make_sigset(maskp, hi, lo)(*maskp.__bits[0] = ((hi)<<24)|(lo))

/* Not a procedure: */
#define split_sigset(mask, hip, lop) \
	((*(hip)=(mask.__bits[0]>>24)&0xff), \
	 (*(lop)=(mask.__bits[0]&0xffffff)))
#else
#define make_sigset(maskp, hi, lo) (*maskp=((hi)<<24)|(lo))

/* Not a procedure: */
#define split_sigset(mask, hip, lop) \
	((*(hip)=(mask>>24)&0xff), \
	 (*(lop)=(mask&0xffffff)))
#endif
