/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//help on SMS PDU encoding can be found at
//http://www.dreamfabric.com/sms/ (english) or
//http://www.nobbi.com/sms_pdu.htm (german)
//the Siemens manuals are no help at all (when it comes to the UD) :-(

#ifndef SMSPDU_H
#define SMSPDU_H

#define SMS_INCOMING 0
#define SMS_DELIVER        0 //type SMS_INCOMING
#define SMS_SUBMIT_REPORT  1 //type SMS_INCOMING
#define SMS_STATUS_REPORT  2 //type SMS_INCOMING
#define SMS_OUTGOING 1
#define SMS_DELIVER_REPORT 0 //type SMS_OUTGOING
#define SMS_SUBMIT         1 //type SMS_OUTGOING
#define SMS_COMMAND        2 //type SMS_OUTGOING

struct smsopts {
  char flash;
  char srr;
  char unicode;
};

struct sms_number {
  unsigned int length;
  unsigned int type;
  unsigned char number[17];
};
typedef struct sms_number sms_number_t;

struct sms_data {
  int slot; //>0 for true values
  int type; //SMS_INCOMING or SMS_OUTGOING
  char tpdu[361]; //not really minimum but enough
};
typedef struct sms_data sms_data_t;

void create_smssubmit_pdu(char *pdu, char* smstext, char* smsnumber, struct smsopts mysmsopts);
void decode_smsdeliver_pdu(unsigned char* pdu, int status);

#endif
