/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "depincludes.h"
#include "common.h"
#include "charsets.h"
#include "helpers.h"
#include "pbmaskgsm.h"
#include <errno.h>
#include <string.h>
#include <stdlib.h>

void pbook_s35(int action, char* file, char* phonebook){
  char at_command[11];
  char* ack;
  char* temp;

  memset(at_command,0,sizeof(at_command));
	
  //selecting phonebook
  temp=get_vendor();
  if (temp!=NULL && !strcmp(temp,"SIEMENS")) {
    new_at_command(at_command,"^SPBS=");
  } else {
    new_at_command(at_command,"+CPBS=");
  }
  mem_realloc(temp,0);
  add_at_command(at_command,phonebook);
  ack=tty_write_read(at_command);
  if (strcmp(ack,"OK")) {
    errexit("%s, cannot select phonebook %s\n",ack,phonebook);
  }
  mem_realloc(ack,0);
	
  switch (action) {
  default:
    errexit("You must specify exactly one operation.\n");
    break;
		
  case 2: //deleting
    delete_pb_s35(phonebook);
    break;
	
  case 4: //sending
    send_pb_s35(file,phonebook);
    break;
		
  case 8: //getting
    get_pb_s35(file,phonebook);
    break;
  }
}

void delete_pb_s35 (char* phonebook) {
  char at_command[BUFSIZ];
  char* ausgabe;
  char* ack;
  int i,first_entry,last_entry;

  memset(at_command,0,sizeof(at_command));

  if ((!strcasecmp(phonebook,"DC"))
      || (!strcasecmp(phonebook,"MD"))
      || (!strcasecmp(phonebook,"LD"))) {
    new_at_command(at_command,"^SDLD");
    ack=tty_write_read(at_command);
    if (!strcmp(ack,"OK")) {
      myprintf(0,"%s deleted.\n",phonebook);
    } else {
      errexit("\n%s\nAn ERROR occured. Possible data corruption!\n",ack);
    }
    mem_realloc(ack,0);
  } else {
    new_at_command(at_command,"+CPBW=?");
    ausgabe=tty_write_read(at_command);
    if (!strcmp(ausgabe,"+CME ERROR: OPERATION NOT SUPPORTED")) {
      errexit("You cannot delete the content of %s\n",phonebook);
    } else {
      mem_realloc(tty_read(at_command),0);
    }
    first_entry=atoi((char *)strtok(ausgabe+7,"(-),"));
    last_entry=atoi((char *)strtok(NULL,"(-),"));
    mem_realloc(ausgabe,0);
    myprintf(0,"Preparing to delete %d entries\n",last_entry-first_entry+1);
    myprintf(0,"Deleting: ");
    for (i=first_entry;i<=last_entry;i++) {
      new_at_command(at_command,"+CPBW=");
      add_at_command(at_command,"%d",i);
      ack=tty_write_read(at_command);
      if (!strcmp(ack,"OK")) {
	myprintf(0,"%d ",i);
	mem_realloc(ack,0);
      } else {
	errexit("\n%s\nAn ERROR occured. Possible data corruption!\n",ack);
      }				
    }
    myprintf(0,"\n");
  }
}

void send_pb_s35 (char* file, char* phonebook) {
  char at_command[BUFSIZ];
  char* ausgabe;
  char temp[BUFSIZ];
  unsigned char *token=NULL;
  unsigned char buffer;
  int myfd;
  int i;
  int first_entry;
  int current_entry;
  int last_entry;
  int nr_length;
  int text_length;
  int bytecount;
  wchar_t* wide_str;
  char* buf_str;

  memset(at_command,0,sizeof(at_command));
  memset(temp,0,sizeof(temp));

  new_at_command(at_command,"+CPBW=?");
  ausgabe=tty_write_read(at_command);
  if (!strcmp(ausgabe,"+CME ERROR: OPERATION NOT SUPPORTED")) {
    errexit("You cannot write to %s\n",phonebook);
  }
  mem_realloc(tty_read(at_command),0);
  first_entry=atoi((char *)strtok(ausgabe+7,"(-),"));
  last_entry=atoi((char *)strtok(NULL,"(-),"));
  nr_length=atoi((char *)strtok(NULL,"(-),"));
  strtok(NULL,","); //not needed (we know the type numbers)
  text_length=atoi((char *)strtok(NULL,"(-),"));
  mem_realloc(ausgabe,0);

  myfd=open_myFile_ro(file);

  myprintf(0,"Preparing to send %d entries\n",last_entry);
  myprintf(0,"Sending: ");
  for (i=first_entry;i<=last_entry;i++) {
    //reading the entries from the file
    memset(temp,0,sizeof(temp));
    bytecount=0;
    do {
      if (read(myfd,&buffer,1)!=1) {
	close(myfd);
	if (bytecount==0) {
	  myprintf(0,"\nIncomplete phonebook sent.\n");
	  return;
	} else {
	  errexit("\nError reading %s or unexpected end of file.\n",file);
	}
      }
      if (buffer!='\n') {
	temp[bytecount]=buffer;
      }
      if (bytecount+1<sizeof(temp)) {
	bytecount++;
      } else {
	close(myfd);
	errexit("\nBuffer overflow, aborting\n");
      }
    } while (buffer!='\n');
	
    //checking string
    ausgabe=str_dup(temp);
    if (atoi(ausgabe)==0 || atoi(ausgabe)>last_entry) {//the line must begin with a valid number
      close(myfd);
      errexit("\nError, invalid entry.\n");
    }
    if (strstr(ausgabe,",\"")==NULL) {
      close(myfd);
      errexit("\nError, invalid entry.\n");
    } else {
      token=strstr(ausgabe,",\"")+2;
    }
    if (strstr(ausgabe,"\",\"")==NULL) {
      close(myfd);
      errexit("\nError, invalid entry.\n");
    } else {
      token=strstr(ausgabe,"\",\"")+3;
    }
    buffer=token[strlen(token)-1];
    if (buffer!='"') {
      close(myfd);
      errexit("\nError, invalid entry.\n");
    }
    mem_realloc(ausgabe,0);
    //end of checking string
				
    new_at_command(at_command,"+CPBW=");
    current_entry=atoi(temp);
    strtok(temp,",");
    add_at_command(at_command,"%d",current_entry);
    //analyse token 2
    token=(char *)strtok(NULL,",");
    if (strlen(token)>nr_length+2) {
      close(myfd);
      errexit("\nError, number of entry %d is too long (max. %d)\nAlready sent entries are o.k.\n",i,nr_length);
    } else if (2<(strlen(token)) && (strlen(token)<=nr_length+2)) {
      //add token 2
      add_at_command(at_command,",");
      add_at_command(at_command,token);
      //add token 3
      buffer=token[1];
      if (buffer=='+') {
	add_at_command(at_command,",145,");
      } else {
	add_at_command(at_command,",129,");
      }
      //convert, test and add token 4
      token=(char *)strtok(NULL,"");
      if (*token=='"') {
	++token;
      }
      if (token[strlen(token)-1]=='"') {
	token[strlen(token)-1]=0;
      }
      wide_str=convert_to_internal(nl_langinfo(CODESET),token,strlen(token));
      token=convert_to_gsm(wide_str);
      mem_realloc(wide_str,0);
      if (strlen(token)>text_length+2) {
	close(myfd);
	errexit("\nError, text of entry %d is too long (max. %d)\nAlready sent entries are o.k.\n",i,text_length);
      }
      buf_str=pb_mask_chars(token);
      mem_realloc(token,0);
      add_at_command(at_command,"\"%s\"",buf_str);
      mem_realloc(buf_str,0);
    } else if(strlen(token)<=2) {
    }
    ausgabe=tty_write_read(at_command);
    if (!strcmp(ausgabe,"OK")) {
      mem_realloc(ausgabe,0);
      myprintf(0,"%d ",current_entry);
    } else {
      close(myfd);
      errexit("\n%s\nAn ERROR occured. Possible data corruption!\n",ausgabe);
    }
  }
  myprintf(0,"\n");
  close(myfd);
}

void get_pb_s35 (char* file, char* phonebook) {
  char at_command[BUFSIZ];
  char* ausgabe;
  char temp[BUFSIZ];
  unsigned char *token=NULL;
  int myfd=-1,
    i,
    first_entry=-1,
    current_entry=-1,
    last_entry=-1;
  wchar_t* wide_str;

  memset(at_command,0,sizeof(at_command));
  memset(temp,0,sizeof(temp));

  //reading available indexes
  new_at_command(at_command,"+CPBR=?");
  ausgabe=tty_write_read(at_command);
  if (strstr(ausgabe,"ERROR")==NULL) {
    mem_realloc(tty_read(at_command),0);
  } else {
    errexit("Error: Could not get phonebook index list\n");
  }
  if (!strncmp(ausgabe,"+CPBR: ",7)) {
    first_entry=atoi((char *)strtok(ausgabe+7,"(-)"));
    last_entry=atoi((char *)strtok(NULL,"(-)"));
  } else {
    errexit("Error: Invalid phonebook index list\n");
  }
  mem_realloc(ausgabe,0);
					
  //accessing file
  if (strlen(file)) {
    myfd=open_myFile_rw(file);
  }
  //getting the data
  memset(ausgabe,0,sizeof(ausgabe));
  if ((!strcasecmp(phonebook,"RD"))||(!strcasecmp(phonebook,"CS"))) {
    new_at_command(at_command,"^SPBG=");
  } else {
    new_at_command(at_command,"+CPBR=");
  }
  sprintf(temp,"%d,%d",first_entry,last_entry);
  add_at_command(at_command,temp);
  ausgabe=tty_write_read(at_command);
  if (strstr(ausgabe,"ERROR")!=NULL) {
    errexit("Error on selecting phonebook\n");
  }
  current_entry=first_entry;
  myprintf(0,"Receiving:");
  if (!strcmp(file,"-")) {
    myprintf(0,"\n");
  }
  //read until OK or ERROR or Invalid Index
  while (strcmp(ausgabe,"OK")
         && strcmp(ausgabe,"ERROR")
	 && strcasecmp(ausgabe,"+CME ERROR: INVALID INDEX")) {
    //use only token 1,2 and 4, write tokens 1 and 2 as-is
    //1st token
    token=(char *)strtok(&ausgabe[7],",");
    //anlysing token number and write all empty string to file, too
    if (atoi(token)!=current_entry) {
      for (i=current_entry;i<atoi(token);i++) {
	sprintf(temp,"%d,\"\",\"\"\n",i);
	if (strlen(file)) {
	  if (write(myfd,temp,strlen(temp)) == -1) {
	    close(myfd);
	    errexit("\nERROR on writing to %s: %s\n",file, strerror(errno));
	  }
	}
	if (strcmp(file,"-")) {
	  myprintf(0," (%d)",i);
	}
      }
      current_entry=atoi(token);
    }
    if (strlen(file)) {
      if ((write(myfd,token,strlen(token)) == -1)
	  ||(write(myfd,",",1) == -1)){
	close(myfd);
	errexit("\nERROR on writing to %s: %s\n",file, strerror(errno));			
      }
    }
    if (strcmp(file,"-")) {
      myprintf(0," %s",token);
    }

    //2nd token
    token=(char *)strtok(NULL,",");
    if (strlen(file)) {
      if ((write(myfd,token,strlen(token)) == -1)
	  ||(write(myfd,",",1) == -1)){
	close(myfd);
	errexit("\nERROR on writing to %s: %s\n",file, strerror(errno));			
      }
    }

    //3rd token, not saved, has to be recontructed on writing to phone
    strtok(NULL,",");

    //4th token, the description string may contain , and "
    token=(char *)strtok(NULL,"");
    //character conversion on token 4
    wide_str=convert_from_gsm(token);
    token=convert_from_internal(nl_langinfo(CODESET),wide_str,2);
    mem_realloc(wide_str,0);
    //write converted token 4, also write a newline to make the file readable
    if (strlen(file)) {
      if ((write(myfd,token,strlen(token)) == -1)
	  ||(write(myfd,"\n",1) == -1)){
	close(myfd);
	errexit("\nERROR on writing to %s: %s\n",file, strerror(errno));			
      }
    }
    mem_realloc(token,0);
				
    //reading next entry
    mem_realloc(ausgabe,0);
    ausgabe=tty_read(at_command);
    current_entry++;
  }
  for (i=current_entry;i<=last_entry;i++) {
    sprintf(temp,"%d,\"\",\"\"\n",i);
    if (strlen(file)) {
      if (write(myfd,temp,strlen(temp)) == -1) {
	close(myfd);
	errexit("\nERROR on writing to %s: %s\n",file, strerror(errno));			
      }
    }
    if (strcmp(file,"-")) {
      myprintf(0," (%d)",i);
    }
  }
  close(myfd);
  myprintf(0,"\n");
  if (!strcmp(ausgabe,"OK")
      ||!strcasecmp(ausgabe,"+CME ERROR: INVALID INDEX")){
    myprintf(0,"Received all gettable entries\n");
  } else if(!strcmp(ausgabe,"ERROR")) {
    errexit("An ERROR occured. Possible data corruption!\n");
  }
  mem_realloc(ausgabe,0);
}
