/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"
#include "helpers.h"
#include <stdlib.h>
#include <string.h>
#include <errno.h>

void transfer_s35 (int   action,
		   char* file, char* ftype,
		   int   slot, int   minimum, int   maximum,
		   char* pipe) {
  int i,j,
    k=1,
    fnlength=1;
  static int current_min;
  char* filename;
  char* slotstring;
    
  switch(action){
  default:
  case 0:
    errexit("You must specify exactly one operation.\n");
    break;
			
  case 2: //deleting
    if (slot == -2) {
      for (i=minimum;i<=maximum;i++) {
	slot=i;
	delete_file_s35(ftype, slot);
      }
    } else if (slot < 0) {
      errexit ("You must select a slot.\n");
    } else {
      delete_file_s35(ftype, slot);
    }
    break;
			
  case 4: //sending
    //initializing the below used current_min
    if (current_min<minimum) {
      current_min=minimum;
    }
    if (slot < -2) {
      errexit("Specify a slot or use auto-detection.\n");
    } else if (slot == -2) {
      myprintf(0,"Using slot %d\n",current_min);
      send_file_s35(file,ftype,current_min);
      ++current_min;
    } else if (slot == -1 || (slot>=0 && slot<current_min)) {
      slot=detect_free_s35(ftype,current_min,maximum);
      if (slot  >= 0) {
	myprintf(0,"Detected empty slot %d\n",slot);
	current_min=slot+1;
	send_file_s35(file,ftype,slot);
      } else {
	errexit("No free slot found.\n");
      }
    } else {
      myprintf(0,"Using slot %d\n",slot);
      current_min=slot+1;
      send_file_s35(file,ftype,slot);
    }
    break;
			
  case 8: //getting
    if (slot == -2) {
      while (maximum>k*10) {
	fnlength++;
	k*=10;
      }
      for (i=minimum;i<=maximum;i++) {
	slot=i;
	if (!strcmp(file,"-")) {
	  get_file_s35(file,ftype,slot,pipe);
	} else {
	  slotstring=malloc(fnlength+1);
	  memset(slotstring,0,fnlength+1);
	  filename=malloc(strlen(file)+fnlength+1+strlen(ftype)+1);
	  memset(filename,0,strlen(file)+fnlength+1+strlen(ftype)+1);
	  sprintf(slotstring,"%d",slot);
	  strcpy(filename,file);
	  for (j=0;j<fnlength-strlen(slotstring);j++) {
	    filename[strlen(filename)]='0';
	  }
	  strcpy(&filename[strlen(filename)],slotstring);
	  filename[strlen(filename)]='.';
	  strcpy(&filename[strlen(filename)],ftype);
	  get_file_s35(filename,ftype,slot,pipe);
	  free(filename);
	  free(slotstring);
	}
      }
    } else if (slot < 0) {
      errexit ("You must select a slot (either a number or \"all\").\n");
    } else {
      get_file_s35(file,ftype,slot,pipe);
    }
    break;
  }
}

void delete_file_s35 (char* ftype, int slot) {
  char at_command[128];
  char* ausgabe;

  memset(at_command,0,sizeof(at_command));

  new_at_command(at_command,"^SBNW");
  add_at_command(at_command,"=\"%s\",%d,0",ftype,slot);
  ausgabe=tty_write_read(at_command);
  if (!strcmp(ausgabe,"OK")) {
    myprintf(0,"%s %d deleted.\n",ftype,slot);
  } else {
    errexit("%s %d NOT deleted, something went wrong(%s).\n",ftype,slot,ausgabe);
  }
  mem_realloc(ausgabe,0);
}

int detect_free_s35 (char* ftype, int minimum, int maximum) {
  char at_command[128];
  char* ausgabe;
  int i;
    
  memset(at_command,0,sizeof(at_command));
     
  myprintf(0,"Trying to find an empty slot...\n");
  i=minimum;
  while (i<=maximum) {
    new_at_command(at_command,"^SBNR");
    add_at_command(at_command,"=\"%s\",%d",ftype,i);
    ausgabe=tty_write_read(at_command);
    if (strcmp(ausgabe,"OK")) {
      if (strstr(ausgabe,"ERROR")!=NULL) {
	errexit("\n\"%s\"\n",ausgabe);
      } else {
	do {
	  mem_realloc(ausgabe,0);
	  ausgabe=tty_read(at_command);
	} while (strcmp(ausgabe,"OK"));
	mem_realloc(ausgabe,0);
      }
    } else {
      return i;
    }
    i++;
  }
  return -1;
}

void send_file_s35 (char* file, char* ftype, int slot) {
  char at_command[128];
  char* ack;
  int pdusize=175; //max is 176 (175 for SL4x v23)
  char buffer[(2*pdusize)+1];
  char transfer[(2*pdusize)+1];
  int packetnum=1,myfd,i,lastsent=0;
  unsigned char data;
  char datastr[3];

  memset(at_command,0,sizeof(at_command));
  memset(transfer,0,sizeof(transfer));
  memset(buffer,0,sizeof(buffer));
  memset(datastr,0,sizeof(datastr));

  //trying to open the file
  myfd=open_myFile_ro(file);
    
  //reading for first time
  //read one char more then pdusize to see if there is more than one package
  for(i=0;i<pdusize;i++){
    if (read(myfd,&data,1)!=1) {
      break;
    }
    sprintf(transfer+(i*2),"%02x",data);
  }
  if (strlen(transfer)==sizeof(transfer)-1) {
    for(i=0;i<pdusize;i++){
      if (read(myfd,&data,1)!=1) {
	break;
      }
      sprintf(buffer+(i*2),"%02x",data);
    }
  }
  myprintf(0,"File transfer...\n");
  while (strlen(transfer)!=0) {
    new_at_command(at_command,"^SBNW");
    if (strlen(buffer)>0) {
      add_at_command(at_command,"=\"%s\",%d,%d,%d",ftype,slot,packetnum,packetnum+1);
    } else {
      add_at_command(at_command,"=\"%s\",%d,%d,%d",ftype,slot,packetnum,packetnum);
    }
    tty_write_command(at_command);
    myprintf(0,"Waiting for data request... ");
    //	tty_read_limited(at_command,ack,2);
    ack=tty_read(at_command);
    if (!strncmp(ack,"> ",2)) {
      mem_realloc(ack,0);
      myprintf(0,"Sending data... ");
      //sending hex data
      // \x1a represents Ctrl-Z (represents end of data stream)
      if (strlen(buffer)==2*pdusize || strlen(buffer)==0) {
	lastsent=strlen(transfer)/2;
      } else {
	lastsent=(strlen(transfer)+strlen(buffer))/4;
      }
      myprintf(1,"\nBuffer1 content: %s (%d)\n",transfer,strlen(transfer));
      myprintf(1,"\nBuffer2 content: %s (%d)\n",buffer,strlen(buffer));
      myprintf(1,"Sending %d Bytes in Paket %d\n",lastsent,packetnum);
      if (tty_write_data(transfer,2*lastsent) == -1) {
	close(myfd);
	errexit("Error on sending data: %s\nAborting.", strerror(errno));
      }
      ack=tty_read(at_command);
      if (!strcmp(ack,"OK")) {
	myprintf(0,"Packet %d sent\n",packetnum);
      } else if (!strcmp(ack,"+CME ERROR: INV CHAR IN TEXT")) {
	close(myfd);
	errexit("ERROR: Wrong data format\n");
      } else {
	close(myfd);
	errexit("\n\"%s\"\n",ack);
      }
      mem_realloc(ack,0);
      //now enter the loop if we have to
      if (strlen(buffer)==2*pdusize) {
	strcpy(transfer,buffer);
	for (i=0;i<pdusize;i++) {
	  if (read(myfd,&data,1)!=1) {
	    break;
	  }
	  sprintf(&buffer[i*2],"%02x",data);
	}
	packetnum++;
      } else if (strlen(buffer)>0) {
	strcpy(transfer,&transfer[2*lastsent]);
	strcpy(&transfer[strlen(transfer)],buffer);
	memset(buffer,0,sizeof(buffer));
	packetnum++;
      } else {
	memset(transfer,0,1);
      }
    } else {
      //tty_read_limited(at_command,&ack[2],sizeof(ack)-3);
      if (!strcmp(ack,"+CME ERROR: INVALID INDEX")) {
	mem_realloc(ack,0);
	myprintf(0,"ERROR\nPacket buffer seems to be filled with something else, clearing...\n");
	new_at_command(at_command,"^SBNW");
	add_at_command(at_command,"=\"%s\",%d",ftype,slot);
	ack=tty_write_read(at_command);
	if (strcmp(ack,"OK")) {
	  errexit("%s, aborting\n",ack);
	}
	mem_realloc(ack,0);
      } else {
	close(myfd);
	errexit("\n\"%s\"\n",ack);
      }
    }
  }
  if (packetnum) {
    myprintf(0,"File transfer complete.\n");
  } else {
    myprintf(0,"Nothing to transfer.\n");
  }
  close(myfd);
}

void get_file_s35 (char* file, char* ftype, int slot, char* pipe) {
  char at_command[128];
  char* ausgabe;
  int packetnum=0;
  int maxpackets=0;
  int myfd=-1;
  int i;
  unsigned char data;
  char datastr[3];
  FILE* pipefd = NULL;

  memset(at_command,0,sizeof(at_command));
  memset(datastr,0,sizeof(datastr));

  //creating at command
  new_at_command(at_command,"^SBNR");
  add_at_command(at_command,"=\"%s\",%d",ftype,slot);

  //sending at command (parsing the answer)
  tty_write_command(at_command);
  myprintf(0,"Slot %d...\n",slot);
  do{
    ausgabe=tty_read(at_command);
    if (!(strcmp(ausgabe,"OK"))) {
      mem_realloc(ausgabe,0);
      myprintf(0,"Empty slot: nothing to get\n");
      close_myFile(myfd);
      return;
    } else if (strstr(ausgabe,"ERROR")!=NULL) {
      close_myFile(myfd);
      errexit("%s, aborting\n",ausgabe);			
    } else {
      strtok(ausgabe,",");
      strtok(NULL,",");
      packetnum=atoi((char *)strtok(NULL,","));
      maxpackets=atoi((char *)strtok(NULL,","));
      if (strlen(file) && myfd==-1) {
	myfd=open_myFile_rw(file);
      }
      if (strlen(pipe) && pipefd==NULL) {
	pipefd=popen(pipe,"w");
      }
      myprintf(0,"Receiving packet %d of %d...\n",packetnum,maxpackets);
      mem_realloc(ausgabe,0);
      ausgabe=tty_read(at_command);
      for (i=0;i<strlen(ausgabe);i+=2) {	
	data=hexstr2int(ausgabe+i,2);
	if (myfd!=-1) {
	  if (write(myfd,&data,1) == -1) {
	    close_myFile(myfd);
	    if (strlen(pipe) && pipefd!=NULL) {
	      pclose(pipefd);
	    }
	    errexit("ERROR on writing to %s: %s\n",file, strerror(errno));			
	  }
	}
	if (strlen(pipe) && pipefd!=NULL) {
	  if (fwrite(&data,1,1,pipefd)!=1) {
	    close_myFile(myfd);
	    pclose(pipefd);
	    errexit("ERROR on writing to pipe \"%s\".\n",pipe);					    
	  }
	}
      }
      mem_realloc(ausgabe,0);
    }
  } while (packetnum!=maxpackets);
  close_myFile(myfd);
  if (strlen(pipe) && pipefd!=NULL && pclose(pipefd)==-1) {
    close(myfd);
    errexit("ERROR on closing pipe \"%s\".\n",pipe);			
  }
  ausgabe=tty_read(at_command);
  if (!(strcmp(ausgabe,"OK"))) {
    mem_realloc(ausgabe,0);
    myprintf(0,"File transfer complete.\n");
  } else {
    errexit("%s, aborting\n",ausgabe);
  }
}

